/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree;

import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.LazyParseableElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.RecursiveTreeElementWalkingVisitor;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IStrongWhitespaceHolderElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TreeUtil {
    private static final Key<String> UNCLOSED_ELEMENT_PROPERTY = Key.create("UNCLOSED_ELEMENT_PROPERTY");
    public static final Key<FileElement> CONTAINING_FILE_KEY_AFTER_REPARSE = Key.create("CONTAINING_FILE_KEY_AFTER_REPARSE");

    public static void ensureParsed(ASTNode node) {
        if (node != null) {
            node.getFirstChildNode();
        }
    }

    public static boolean isCollapsedChameleon(ASTNode node) {
        return node instanceof LazyParseableElement && !((LazyParseableElement)node).isParsed();
    }

    @Nullable
    public static ASTNode findChildBackward(ASTNode parent2, IElementType type2) {
        if (DebugUtil.CHECK_INSIDE_ATOMIC_ACTION_ENABLED && parent2 instanceof TreeElement) {
            ((TreeElement)parent2).assertReadAccessAllowed();
        }
        for (ASTNode element2 = parent2.getLastChildNode(); element2 != null; element2 = element2.getTreePrev()) {
            if (element2.getElementType() != type2) continue;
            return element2;
        }
        return null;
    }

    @Nullable
    public static ASTNode skipElements(@Nullable ASTNode element2, @NotNull TokenSet types2) {
        ASTNode candidate;
        if (types2 == null) {
            TreeUtil.$$$reportNull$$$0(0);
        }
        for (candidate = element2; candidate != null && types2.contains(candidate.getElementType()); candidate = candidate.getTreeNext()) {
        }
        return candidate;
    }

    @Nullable
    public static ASTNode skipElementsBack(@Nullable ASTNode element2, @NotNull TokenSet types2) {
        ASTNode candidate;
        if (types2 == null) {
            TreeUtil.$$$reportNull$$$0(1);
        }
        for (candidate = element2; candidate != null && types2.contains(candidate.getElementType()); candidate = candidate.getTreePrev()) {
        }
        return candidate;
    }

    @Nullable
    public static ASTNode findParent(ASTNode element2, IElementType type2) {
        for (ASTNode parent2 = element2.getTreeParent(); parent2 != null; parent2 = parent2.getTreeParent()) {
            if (parent2.getElementType() != type2) continue;
            return parent2;
        }
        return null;
    }

    @Nullable
    public static ASTNode findParent(ASTNode element2, TokenSet types2) {
        for (ASTNode parent2 = element2.getTreeParent(); parent2 != null; parent2 = parent2.getTreeParent()) {
            if (!types2.contains(parent2.getElementType())) continue;
            return parent2;
        }
        return null;
    }

    @Nullable
    public static ASTNode findParent(@NotNull ASTNode element2, @NotNull TokenSet types2, @Nullable TokenSet stopAt) {
        if (element2 == null) {
            TreeUtil.$$$reportNull$$$0(2);
        }
        if (types2 == null) {
            TreeUtil.$$$reportNull$$$0(3);
        }
        for (ASTNode parent2 = element2.getTreeParent(); parent2 != null; parent2 = parent2.getTreeParent()) {
            if (types2.contains(parent2.getElementType())) {
                return parent2;
            }
            if (stopAt == null || !stopAt.contains(parent2.getElementType())) continue;
            return null;
        }
        return null;
    }

    @Nullable
    public static LeafElement findFirstLeaf(ASTNode element2) {
        return (LeafElement)TreeUtil.findFirstLeaf(element2, true);
    }

    public static ASTNode findFirstLeaf(ASTNode element2, boolean expandChameleons) {
        if (element2 instanceof LeafElement || !expandChameleons && TreeUtil.isCollapsedChameleon(element2)) {
            return element2;
        }
        for (ASTNode child = element2.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            ASTNode leaf = TreeUtil.findFirstLeaf(child, expandChameleons);
            if (leaf == null) continue;
            return leaf;
        }
        return null;
    }

    @Nullable
    public static ASTNode findLastLeaf(ASTNode element2) {
        return TreeUtil.findLastLeaf(element2, true);
    }

    public static ASTNode findLastLeaf(ASTNode element2, boolean expandChameleons) {
        if (element2 instanceof LeafElement || !expandChameleons && TreeUtil.isCollapsedChameleon(element2)) {
            return element2;
        }
        for (ASTNode child = element2.getLastChildNode(); child != null; child = child.getTreePrev()) {
            ASTNode leaf = TreeUtil.findLastLeaf(child);
            if (leaf == null) continue;
            return leaf;
        }
        return null;
    }

    @Nullable
    public static ASTNode findSibling(ASTNode start, IElementType elementType) {
        ASTNode child = start;
        while (child != null) {
            if (child.getElementType() == elementType) {
                return child;
            }
            child = child.getTreeNext();
        }
        return null;
    }

    @Nullable
    public static ASTNode findSibling(ASTNode start, TokenSet types2) {
        ASTNode child = start;
        while (child != null) {
            if (types2.contains(child.getElementType())) {
                return child;
            }
            child = child.getTreeNext();
        }
        return null;
    }

    @Nullable
    public static ASTNode findSiblingBackward(ASTNode start, IElementType elementType) {
        ASTNode child = start;
        while (child != null) {
            if (child.getElementType() == elementType) {
                return child;
            }
            child = child.getTreePrev();
        }
        return null;
    }

    @Nullable
    public static ASTNode findSiblingBackward(ASTNode start, TokenSet types2) {
        ASTNode child = start;
        while (child != null) {
            if (types2.contains(child.getElementType())) {
                return child;
            }
            child = child.getTreePrev();
        }
        return null;
    }

    @Nullable
    public static ASTNode findCommonParent(ASTNode one, ASTNode two) {
        if (one == two) {
            return one;
        }
        HashSet<ASTNode> parents2 = new HashSet<ASTNode>(20);
        while (one != null) {
            parents2.add(one);
            one = one.getTreeParent();
        }
        while (two != null) {
            if (parents2.contains(two)) {
                return two;
            }
            two = two.getTreeParent();
        }
        return null;
    }

    public static Couple<ASTNode> findTopmostSiblingParents(ASTNode one, ASTNode two) {
        if (one == two) {
            return Couple.of(null, null);
        }
        LinkedList<ASTNode> oneParents = new LinkedList<ASTNode>();
        while (one != null) {
            oneParents.add(one);
            one = one.getTreeParent();
        }
        LinkedList<ASTNode> twoParents = new LinkedList<ASTNode>();
        while (two != null) {
            twoParents.add(two);
            two = two.getTreeParent();
        }
        while ((one = (ASTNode)oneParents.pollLast()) == (two = (ASTNode)twoParents.pollLast()) && one != null) {
        }
        return Couple.of(one, two);
    }

    public static void clearCaches(@NotNull TreeElement tree) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(4);
        }
        tree.acceptTree(new RecursiveTreeElementWalkingVisitor(false){

            @Override
            protected void visitNode(TreeElement element2) {
                element2.clearCaches();
                super.visitNode(element2);
            }
        });
    }

    @Nullable
    public static ASTNode nextLeaf(@NotNull ASTNode node) {
        if (node == null) {
            TreeUtil.$$$reportNull$$$0(5);
        }
        return TreeUtil.nextLeaf((TreeElement)node, null);
    }

    @Nullable
    public static LeafElement nextLeaf(@NotNull LeafElement node) {
        if (node == null) {
            TreeUtil.$$$reportNull$$$0(6);
        }
        return TreeUtil.nextLeaf(node, null);
    }

    public static FileElement getFileElement(@NotNull TreeElement element2) {
        TreeElement parent2;
        if (element2 == null) {
            TreeUtil.$$$reportNull$$$0(7);
        }
        for (parent2 = element2; parent2 != null && !(parent2 instanceof FileElement); parent2 = parent2.getTreeParent()) {
        }
        if (parent2 == null) {
            parent2 = element2.getUserData(CONTAINING_FILE_KEY_AFTER_REPARSE);
        }
        return (FileElement)parent2;
    }

    public static FileASTNode getFileElement(@NotNull ASTNode element2) {
        ASTNode parent2;
        if (element2 == null) {
            TreeUtil.$$$reportNull$$$0(8);
        }
        for (parent2 = element2; parent2 != null && !(parent2 instanceof FileASTNode); parent2 = parent2.getTreeParent()) {
        }
        if (parent2 == null) {
            parent2 = element2.getUserData(CONTAINING_FILE_KEY_AFTER_REPARSE);
        }
        return (FileASTNode)parent2;
    }

    @Nullable
    public static ASTNode prevLeaf(ASTNode node) {
        return TreeUtil.prevLeaf((TreeElement)node, null);
    }

    public static boolean isStrongWhitespaceHolder(IElementType type2) {
        return type2 instanceof IStrongWhitespaceHolderElementType;
    }

    public static String getTokenText(Lexer lexer) {
        return lexer.getBufferSequence().subSequence(lexer.getTokenStart(), lexer.getTokenEnd()).toString();
    }

    @Nullable
    public static LeafElement nextLeaf(@NotNull TreeElement start, CommonParentState commonParent) {
        if (start == null) {
            TreeUtil.$$$reportNull$$$0(9);
        }
        return (LeafElement)TreeUtil.nextLeaf(start, commonParent, null, true);
    }

    @Nullable
    public static TreeElement nextLeaf(@NotNull TreeElement start, CommonParentState commonParent, IElementType searchedType, boolean expandChameleons) {
        if (start == null) {
            TreeUtil.$$$reportNull$$$0(10);
        }
        for (TreeElement element2 = start; element2 != null; element2 = element2.getTreeParent()) {
            if (commonParent != null) {
                commonParent.startLeafBranchStart = element2;
                TreeUtil.initStrongWhitespaceHolder(commonParent, element2, true);
            }
            TreeElement nextTree = element2;
            TreeElement next2 = null;
            while (next2 == null && (nextTree = nextTree.getTreeNext()) != null) {
                if (nextTree.getElementType() == searchedType) {
                    return nextTree;
                }
                next2 = TreeUtil.findFirstLeafOrType(nextTree, searchedType, commonParent, expandChameleons);
            }
            if (next2 == null) continue;
            if (commonParent != null) {
                commonParent.nextLeafBranchStart = nextTree;
            }
            return next2;
        }
        return null;
    }

    private static void initStrongWhitespaceHolder(CommonParentState commonParent, ASTNode start, boolean slopeSide) {
        if (start instanceof CompositeElement && (TreeUtil.isStrongWhitespaceHolder(start.getElementType()) || slopeSide && start.getUserData(UNCLOSED_ELEMENT_PROPERTY) != null)) {
            commonParent.strongWhiteSpaceHolder = (CompositeElement)start;
            commonParent.isStrongElementOnRisingSlope = slopeSide;
        }
    }

    @Nullable
    private static TreeElement findFirstLeafOrType(@NotNull TreeElement element2, final IElementType searchedType, final CommonParentState commonParent, final boolean expandChameleons) {
        if (element2 == null) {
            TreeUtil.$$$reportNull$$$0(11);
        }
        final class MyVisitor
        extends RecursiveTreeElementWalkingVisitor {
            private TreeElement result;

            MyVisitor(boolean doTransform2) {
                super(doTransform2);
            }

            @Override
            protected void visitNode(TreeElement node) {
                if (this.result != null) {
                    return;
                }
                if (commonParent != null) {
                    TreeUtil.initStrongWhitespaceHolder(commonParent, node, false);
                }
                if (!expandChameleons && TreeUtil.isCollapsedChameleon(node) || node instanceof LeafElement || node.getElementType() == searchedType) {
                    this.result = node;
                    return;
                }
                super.visitNode(node);
            }
        }
        MyVisitor visitor2 = new MyVisitor(expandChameleons);
        element2.acceptTree(visitor2);
        return visitor2.result;
    }

    @Nullable
    public static ASTNode prevLeaf(TreeElement start, @Nullable CommonParentState commonParent) {
        while (start != null) {
            if (commonParent != null) {
                if (commonParent.strongWhiteSpaceHolder != null && start.getUserData(UNCLOSED_ELEMENT_PROPERTY) != null) {
                    commonParent.strongWhiteSpaceHolder = (CompositeElement)start;
                }
                commonParent.nextLeafBranchStart = start;
            }
            ASTNode prevTree = start;
            ASTNode prev = null;
            while (prev == null && (prevTree = prevTree.getTreePrev()) != null) {
                prev = TreeUtil.findLastLeaf(prevTree);
            }
            if (prev != null) {
                if (commonParent != null) {
                    commonParent.startLeafBranchStart = prevTree;
                }
                return prev;
            }
            start = start.getTreeParent();
        }
        return null;
    }

    @Nullable
    public static ASTNode nextLeaf(@Nullable ASTNode start, boolean expandChameleons) {
        while (start != null) {
            for (ASTNode each = start.getTreeNext(); each != null; each = each.getTreeNext()) {
                ASTNode leaf = TreeUtil.findFirstLeaf(each, expandChameleons);
                if (leaf == null) continue;
                return leaf;
            }
            start = start.getTreeParent();
        }
        return null;
    }

    @Nullable
    public static ASTNode prevLeaf(@Nullable ASTNode start, boolean expandChameleons) {
        while (start != null) {
            for (ASTNode each = start.getTreePrev(); each != null; each = each.getTreePrev()) {
                ASTNode leaf = TreeUtil.findLastLeaf(each, expandChameleons);
                if (leaf == null) continue;
                return leaf;
            }
            start = start.getTreeParent();
        }
        return null;
    }

    @Nullable
    public static ASTNode getLastChild(ASTNode element2) {
        ASTNode child = element2;
        while (child != null) {
            element2 = child;
            child = element2.getLastChildNode();
        }
        return element2;
    }

    public static boolean containsOuterLanguageElements(@NotNull ASTNode node) {
        if (node == null) {
            TreeUtil.$$$reportNull$$$0(12);
        }
        final AtomicBoolean result2 = new AtomicBoolean(false);
        ((TreeElement)node).acceptTree(new RecursiveTreeElementWalkingVisitor(){

            @Override
            protected void visitNode(TreeElement element2) {
                if (element2 instanceof OuterLanguageElement) {
                    result2.set(true);
                    this.stopWalking();
                    return;
                }
                super.visitNode(element2);
            }
        });
        return result2.get();
    }

    @Nullable
    public static ASTNode skipWhitespaceAndComments(@Nullable ASTNode node, boolean forward) {
        return TreeUtil.skipWhitespaceCommentsAndTokens(node, TokenSet.EMPTY, forward);
    }

    @Nullable
    public static ASTNode skipWhitespaceCommentsAndTokens(@Nullable ASTNode node, @NotNull TokenSet alsoSkip, boolean forward) {
        if (alsoSkip == null) {
            TreeUtil.$$$reportNull$$$0(13);
        }
        ASTNode element2 = node;
        while (true) {
            if (element2 == null) {
                return null;
            }
            if (!TreeUtil.isWhitespaceOrComment(element2) && !alsoSkip.contains(element2.getElementType())) break;
            element2 = forward ? element2.getTreeNext() : element2.getTreePrev();
        }
        return element2;
    }

    public static boolean isWhitespaceOrComment(@NotNull ASTNode element2) {
        if (element2 == null) {
            TreeUtil.$$$reportNull$$$0(14);
        }
        return element2.getPsi() instanceof PsiWhiteSpace || element2.getPsi() instanceof PsiComment;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 5: 
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "start";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alsoSkip";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/source/tree/TreeUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "skipElements";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "skipElementsBack";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findParent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "clearCaches";
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "nextLeaf";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getFileElement";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "findFirstLeafOrType";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "containsOuterLanguageElements";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "skipWhitespaceCommentsAndTokens";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "isWhitespaceOrComment";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class CommonParentState {
        TreeElement startLeafBranchStart;
        public ASTNode nextLeafBranchStart;
        CompositeElement strongWhiteSpaceHolder;
        boolean isStrongElementOnRisingSlope = true;
    }
}

