/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.AnnotationCacheOwnerNormalizer;
import com.intellij.codeInsight.AnnotationInvocationHandler;
import com.intellij.codeInsight.AnnotationTargetUtil;
import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.codeInsight.InferredAnnotationsManager;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.BitUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processors;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Stream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.NonExtendable
public class AnnotationUtil {
    public static final String NULLABLE = "org.jetbrains.annotations.Nullable";
    public static final String UNKNOWN_NULLABILITY = "org.jetbrains.annotations.UnknownNullability";
    public static final String NOT_NULL = "org.jetbrains.annotations.NotNull";
    public static final String NON_NLS = "org.jetbrains.annotations.NonNls";
    public static final String NLS = "org.jetbrains.annotations.Nls";
    public static final String PROPERTY_KEY = "org.jetbrains.annotations.PropertyKey";
    public static final String PROPERTY_KEY_RESOURCE_BUNDLE_PARAMETER = "resourceBundle";
    public static final String TEST_ONLY = "org.jetbrains.annotations.TestOnly";
    public static final String LANGUAGE = "org.intellij.lang.annotations.Language";
    private static final ParameterizedCachedValueProvider<Map<Collection<String>, List<PsiAnnotation>>, PsiModifierListOwner> NON_CODE_ANNOTATIONS_PROVIDER = listOwner -> {
        ConcurrentMap<Collection, List> value2 = ConcurrentFactoryMap.createMap(annotationNames1 -> {
            PsiUtilCore.ensureValid(listOwner);
            Project project = listOwner.getProject();
            SmartList<PsiAnnotation> annotations2 = null;
            ExternalAnnotationsManager externalAnnotationsManager = ExternalAnnotationsManager.getInstance(project);
            for (String annotationName : annotationNames1) {
                List<PsiAnnotation> externalAnnotations = externalAnnotationsManager.findExternalAnnotations((PsiModifierListOwner)listOwner, annotationName);
                if (externalAnnotations.isEmpty()) continue;
                if (annotations2 == null) {
                    annotations2 = new SmartList<PsiAnnotation>();
                }
                annotations2.addAll(externalAnnotations);
            }
            InferredAnnotationsManager inferredAnnotationsManager = InferredAnnotationsManager.getInstance(project);
            for (String annotationName : annotationNames1) {
                PsiAnnotation annotation = inferredAnnotationsManager.findInferredAnnotation((PsiModifierListOwner)listOwner, annotationName);
                if (annotation == null) continue;
                if (annotations2 == null) {
                    annotations2 = new SmartList();
                }
                annotations2.add(annotation);
            }
            return annotations2;
        });
        return CachedValueProvider.Result.create(value2, PsiModificationTracker.MODIFICATION_COUNT);
    };
    private static final Key<ParameterizedCachedValue<Map<Collection<String>, List<PsiAnnotation>>, PsiModifierListOwner>> NON_CODE_ANNOTATIONS_KEY = Key.create("NON_CODE_ANNOTATIONS");
    public static final int CHECK_HIERARCHY = 1;
    public static final int CHECK_EXTERNAL = 2;
    public static final int CHECK_INFERRED = 4;
    public static final int CHECK_TYPE = 8;
    private static final String[] SIMPLE_NAMES = new String[]{"NotNull", "Nullable", "NonNls", "PropertyKey", "TestOnly", "Language", "Identifier", "Pattern", "PrintFormat", "RegExp", "Subst"};

    @Nullable
    public static PsiAnnotation findAnnotation(@Nullable PsiModifierListOwner listOwner, String ... annotationNames) {
        if (annotationNames == null) {
            AnnotationUtil.$$$reportNull$$$0(0);
        }
        return AnnotationUtil.findAnnotation(listOwner, false, annotationNames);
    }

    @Nullable
    public static PsiAnnotation findAnnotation(@Nullable PsiModifierListOwner listOwner, boolean skipExternal, String ... annotationNames) {
        if (annotationNames == null) {
            AnnotationUtil.$$$reportNull$$$0(1);
        }
        if (annotationNames.length == 0) {
            return null;
        }
        HashSet<String> set = annotationNames.length == 1 ? Collections.singleton(annotationNames[0]) : ContainerUtil.newHashSet(annotationNames);
        return AnnotationUtil.findAnnotation(listOwner, set, skipExternal);
    }

    @Nullable
    public static PsiAnnotation findAnnotation(@Nullable PsiModifierListOwner listOwner, @NotNull Set<String> annotationNames) {
        if (annotationNames == null) {
            AnnotationUtil.$$$reportNull$$$0(2);
        }
        return AnnotationUtil.findAnnotation(listOwner, annotationNames);
    }

    @Nullable
    public static PsiAnnotation findAnnotation(@Nullable PsiModifierListOwner listOwner, @NotNull Collection<String> annotationNames) {
        if (annotationNames == null) {
            AnnotationUtil.$$$reportNull$$$0(3);
        }
        return AnnotationUtil.findAnnotation(listOwner, annotationNames, false);
    }

    @Nullable
    public static PsiAnnotation findAnnotation(@Nullable PsiModifierListOwner listOwner, @NotNull Collection<String> annotationNames, boolean skipExternal) {
        if (annotationNames == null) {
            AnnotationUtil.$$$reportNull$$$0(4);
        }
        if (listOwner == null) {
            return null;
        }
        List<PsiAnnotation> result2 = AnnotationUtil.findAllAnnotations(listOwner, annotationNames, skipExternal);
        return result2.isEmpty() ? null : result2.get(0);
    }

    @NotNull
    public static List<PsiAnnotation> findAllAnnotations(@NotNull PsiModifierListOwner listOwner, @NotNull Collection<String> annotationNames, boolean skipExternal) {
        if (listOwner == null) {
            AnnotationUtil.$$$reportNull$$$0(5);
        }
        if (annotationNames == null) {
            AnnotationUtil.$$$reportNull$$$0(6);
        }
        List<PsiAnnotation> ownAnnotations = AnnotationUtil.findOwnAnnotations(listOwner, annotationNames);
        List<PsiAnnotation> nonCodeAnnotations = skipExternal ? null : AnnotationUtil.findNonCodeAnnotations(listOwner, annotationNames);
        SmartList annotations2 = null;
        if (ownAnnotations != null || nonCodeAnnotations != null) {
            annotations2 = new SmartList();
            if (ownAnnotations != null) {
                annotations2.addAll(ownAnnotations);
            }
            if (nonCodeAnnotations != null) {
                annotations2.addAll(nonCodeAnnotations);
            }
        }
        List<PsiAnnotation> list = annotations2 == null ? Collections.emptyList() : annotations2;
        if (list == null) {
            AnnotationUtil.$$$reportNull$$$0(7);
        }
        return list;
    }

    @Nullable
    private static List<PsiAnnotation> findOwnAnnotations(@NotNull PsiModifierListOwner listOwner, @NotNull Iterable<String> annotationNames) {
        PsiModifierList list;
        if (listOwner == null) {
            AnnotationUtil.$$$reportNull$$$0(8);
        }
        if (annotationNames == null) {
            AnnotationUtil.$$$reportNull$$$0(9);
        }
        if ((list = listOwner.getModifierList()) == null) {
            return null;
        }
        SmartList<PsiAnnotation> result2 = null;
        for (PsiAnnotation annotation : list.getAnnotations()) {
            if (!ContainerUtil.exists(annotationNames, annotation::hasQualifiedName) || !AnnotationUtil.isApplicableToDeclaration(annotation, list)) continue;
            if (result2 == null) {
                result2 = new SmartList<PsiAnnotation>();
            }
            result2.add(annotation);
        }
        return result2;
    }

    private static boolean isApplicableToDeclaration(PsiAnnotation annotation, PsiModifierList list) {
        PsiAnnotation.TargetType[] allTargets = AnnotationTargetUtil.getTargetsForLocation(list);
        if (allTargets.length == 0) {
            return true;
        }
        PsiAnnotation.TargetType[] nonTypeUse = (PsiAnnotation.TargetType[])Stream.of(allTargets).filter(t -> t != PsiAnnotation.TargetType.TYPE_USE).toArray(PsiAnnotation.TargetType[]::new);
        return AnnotationTargetUtil.findAnnotationTarget(annotation, nonTypeUse) != null;
    }

    @Nullable
    private static List<PsiAnnotation> findNonCodeAnnotations(@NotNull PsiModifierListOwner element2, @NotNull Collection<String> annotationNames) {
        if (element2 == null) {
            AnnotationUtil.$$$reportNull$$$0(10);
        }
        if (annotationNames == null) {
            AnnotationUtil.$$$reportNull$$$0(11);
        }
        if (element2 instanceof PsiLocalVariable) {
            return null;
        }
        PsiModifierListOwner listOwner = AnnotationCacheOwnerNormalizer.normalize(element2);
        Map<Collection<String>, List<PsiAnnotation>> map = CachedValuesManager.getManager(element2.getProject()).getParameterizedCachedValue(listOwner, NON_CODE_ANNOTATIONS_KEY, NON_CODE_ANNOTATIONS_PROVIDER, false, listOwner);
        return map.get(annotationNames);
    }

    public static PsiAnnotation @NotNull [] findAnnotations(@Nullable PsiModifierListOwner modifierListOwner, @NotNull Collection<String> annotationNames) {
        if (annotationNames == null) {
            AnnotationUtil.$$$reportNull$$$0(12);
        }
        if (modifierListOwner == null) {
            if (PsiAnnotation.EMPTY_ARRAY == null) {
                AnnotationUtil.$$$reportNull$$$0(13);
            }
            return PsiAnnotation.EMPTY_ARRAY;
        }
        PsiModifierList modifierList2 = modifierListOwner.getModifierList();
        if (modifierList2 == null) {
            if (PsiAnnotation.EMPTY_ARRAY == null) {
                AnnotationUtil.$$$reportNull$$$0(14);
            }
            return PsiAnnotation.EMPTY_ARRAY;
        }
        PsiAnnotation[] annotations2 = modifierList2.getAnnotations();
        ArrayList<PsiAnnotation> result2 = null;
        for (PsiAnnotation psiAnnotation : annotations2) {
            String qualifiedName2 = psiAnnotation.getQualifiedName();
            if (qualifiedName2 == null || !annotationNames.contains(qualifiedName2)) continue;
            if (result2 == null) {
                result2 = new ArrayList<PsiAnnotation>();
            }
            result2.add(psiAnnotation);
        }
        PsiAnnotation[] psiAnnotationArray = result2 == null ? PsiAnnotation.EMPTY_ARRAY : result2.toArray(PsiAnnotation.EMPTY_ARRAY);
        if (psiAnnotationArray == null) {
            AnnotationUtil.$$$reportNull$$$0(15);
        }
        return psiAnnotationArray;
    }

    @NotNull
    public static <T extends PsiModifierListOwner> List<T> getSuperAnnotationOwners(@NotNull T element2) {
        if (element2 == null) {
            AnnotationUtil.$$$reportNull$$$0(16);
        }
        PsiModifierListOwner listOwner = AnnotationCacheOwnerNormalizer.normalize(element2);
        List list = (List)CachedValuesManager.getCachedValue(listOwner, () -> {
            List<Object> list;
            LinkedHashSet result2 = new LinkedHashSet();
            if (listOwner instanceof PsiMethod) {
                if (!listOwner.hasModifierProperty("static")) {
                    AnnotationUtil.collectSuperMethods(result2, ((PsiMethod)listOwner).getHierarchicalMethodSignature(), listOwner, JavaPsiFacade.getInstance(listOwner.getProject()).getResolveHelper());
                }
            } else if (listOwner instanceof PsiClass) {
                InheritanceUtil.processSupers((PsiClass)listOwner, false, Processors.cancelableCollectProcessor(result2));
            } else if (listOwner instanceof PsiParameter) {
                AnnotationUtil.collectSuperParameters(result2, (PsiParameter)listOwner);
            }
            if (result2.isEmpty()) {
                list = Collections.emptyList();
            } else {
                PsiModifierListOwner[] array = result2.toArray(new PsiModifierListOwner[0]);
                list = Arrays.asList(array);
            }
            return CachedValueProvider.Result.create(list, PsiModificationTracker.MODIFICATION_COUNT);
        });
        if (list == null) {
            AnnotationUtil.$$$reportNull$$$0(17);
        }
        return list;
    }

    @Nullable
    public static PsiAnnotation findAnnotationInHierarchy(@NotNull PsiModifierListOwner listOwner, @NotNull Set<String> annotationNames) {
        if (listOwner == null) {
            AnnotationUtil.$$$reportNull$$$0(18);
        }
        if (annotationNames == null) {
            AnnotationUtil.$$$reportNull$$$0(19);
        }
        return AnnotationUtil.findAnnotationInHierarchy(listOwner, annotationNames, false);
    }

    @Nullable
    public static PsiAnnotation findAnnotationInHierarchy(@NotNull PsiModifierListOwner listOwner, @NotNull Set<String> annotationNames, boolean skipExternal) {
        AnnotationAndOwner result2;
        if (listOwner == null) {
            AnnotationUtil.$$$reportNull$$$0(20);
        }
        if (annotationNames == null) {
            AnnotationUtil.$$$reportNull$$$0(21);
        }
        return (result2 = AnnotationUtil.findAnnotationAndOwnerInHierarchy(listOwner, annotationNames, skipExternal)) == null ? null : result2.annotation;
    }

    @Nullable
    static AnnotationAndOwner findAnnotationAndOwnerInHierarchy(@NotNull PsiModifierListOwner listOwner, @NotNull Set<String> annotationNames, boolean skipExternal) {
        PsiAnnotation directAnnotation;
        if (listOwner == null) {
            AnnotationUtil.$$$reportNull$$$0(22);
        }
        if (annotationNames == null) {
            AnnotationUtil.$$$reportNull$$$0(23);
        }
        if ((directAnnotation = AnnotationUtil.findAnnotation(listOwner, annotationNames, skipExternal)) != null) {
            return new AnnotationAndOwner(listOwner, directAnnotation);
        }
        for (PsiModifierListOwner superOwner : AnnotationUtil.getSuperAnnotationOwners(listOwner)) {
            PsiAnnotation annotation = AnnotationUtil.findAnnotation(superOwner, annotationNames, skipExternal);
            if (annotation == null) continue;
            return new AnnotationAndOwner(superOwner, annotation);
        }
        return null;
    }

    private static void collectSuperParameters(@NotNull Set<? super PsiModifierListOwner> result2, @NotNull PsiParameter parameter2) {
        block7: {
            PsiElement scope;
            Consumer<PsiMethod> forEachSuperMethod;
            block6: {
                PsiElement parent2;
                if (result2 == null) {
                    AnnotationUtil.$$$reportNull$$$0(24);
                }
                if (parameter2 == null) {
                    AnnotationUtil.$$$reportNull$$$0(25);
                }
                if (!((parent2 = parameter2.getParent()) instanceof PsiParameterList)) {
                    return;
                }
                int index = ((PsiParameterList)parent2).getParameterIndex(parameter2);
                forEachSuperMethod = method -> {
                    PsiParameter[] superParameters = method.getParameterList().getParameters();
                    if (index < superParameters.length) {
                        result2.add(superParameters[index]);
                    }
                };
                scope = parent2.getParent();
                if (!(scope instanceof PsiLambdaExpression)) break block6;
                PsiMethod method2 = LambdaUtil.getFunctionalInterfaceMethod(((PsiLambdaExpression)scope).getFunctionalInterfaceType());
                if (method2 == null) break block7;
                forEachSuperMethod.consume(method2);
                for (PsiMethod superMethod : AnnotationUtil.getSuperAnnotationOwners(method2)) {
                    forEachSuperMethod.consume(superMethod);
                }
                break block7;
            }
            if (scope instanceof PsiMethod) {
                for (PsiMethod superMethod : AnnotationUtil.getSuperAnnotationOwners((PsiMethod)scope)) {
                    forEachSuperMethod.consume(superMethod);
                }
            }
        }
    }

    private static void collectSuperMethods(@NotNull Set<? super PsiModifierListOwner> result2, @NotNull HierarchicalMethodSignature signature, @NotNull PsiElement place, @NotNull PsiResolveHelper resolveHelper) {
        if (result2 == null) {
            AnnotationUtil.$$$reportNull$$$0(26);
        }
        if (signature == null) {
            AnnotationUtil.$$$reportNull$$$0(27);
        }
        if (place == null) {
            AnnotationUtil.$$$reportNull$$$0(28);
        }
        if (resolveHelper == null) {
            AnnotationUtil.$$$reportNull$$$0(29);
        }
        for (HierarchicalMethodSignature superSignature : signature.getSuperSignatures()) {
            PsiMethod superMethod = superSignature.getMethod();
            if (!resolveHelper.isAccessible(superMethod, place, null) || !result2.add(superMethod)) continue;
            AnnotationUtil.collectSuperMethods(result2, superSignature, place, resolveHelper);
        }
    }

    public static boolean isAnnotated(@NotNull PsiModifierListOwner listOwner, @NotNull Collection<String> annotations2, @Flags int flags) {
        if (listOwner == null) {
            AnnotationUtil.$$$reportNull$$$0(30);
        }
        if (annotations2 == null) {
            AnnotationUtil.$$$reportNull$$$0(31);
        }
        return ContainerUtil.exists(annotations2, annotation -> AnnotationUtil.isAnnotated(listOwner, annotation, flags, null));
    }

    public static boolean isAnnotated(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFqn, @Flags int flags) {
        if (listOwner == null) {
            AnnotationUtil.$$$reportNull$$$0(32);
        }
        if (annotationFqn == null) {
            AnnotationUtil.$$$reportNull$$$0(33);
        }
        return AnnotationUtil.isAnnotated(listOwner, annotationFqn, flags, null);
    }

    private static boolean isAnnotated(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQN, @Flags int flags, @Nullable Set<? super PsiMember> processed) {
        block20: {
            block21: {
                Project project;
                PsiModifierList modifierList2;
                if (listOwner == null) {
                    AnnotationUtil.$$$reportNull$$$0(34);
                }
                if (annotationFQN == null) {
                    AnnotationUtil.$$$reportNull$$$0(35);
                }
                if ((modifierList2 = listOwner.getModifierList()) == null) {
                    return false;
                }
                PsiAnnotation annotation = modifierList2.findAnnotation(annotationFQN);
                if (annotation != null) {
                    return true;
                }
                if (BitUtil.isSet(flags, 8)) {
                    PsiType type2 = null;
                    if (listOwner instanceof PsiMethod) {
                        type2 = ((PsiMethod)listOwner).getReturnType();
                    } else if (listOwner instanceof PsiParameter && listOwner.getParent() instanceof PsiParameterList && listOwner.getParent().getParent() instanceof PsiLambdaExpression) {
                        if (((PsiParameter)listOwner).getTypeElement() != null) {
                            type2 = ((PsiParameter)listOwner).getType();
                        }
                    } else if (listOwner instanceof PsiVariable) {
                        type2 = ((PsiVariable)listOwner).getType();
                    }
                    if (type2 != null && type2.hasAnnotation(annotationFQN)) {
                        return true;
                    }
                }
                if (BitUtil.isSet(flags, 2) && ExternalAnnotationsManager.getInstance(project = listOwner.getProject()).findExternalAnnotation(listOwner, annotationFQN) != null) {
                    return true;
                }
                if (BitUtil.isSet(flags, 4) && InferredAnnotationsManager.getInstance(project = listOwner.getProject()).findInferredAnnotation(listOwner, annotationFQN) != null) {
                    return true;
                }
                if (!BitUtil.isSet(flags, 1)) break block20;
                if (!(listOwner instanceof PsiMethod)) break block21;
                PsiMethod method = (PsiMethod)listOwner;
                if (processed == null) {
                    processed = new HashSet<PsiMember>();
                }
                if (!processed.add(method)) {
                    return false;
                }
                for (PsiMethod superMethod : method.findSuperMethods()) {
                    if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)superMethod, annotationFQN, flags, processed)) continue;
                    return true;
                }
                break block20;
            }
            if (!(listOwner instanceof PsiClass)) break block20;
            PsiClass clazz = (PsiClass)listOwner;
            if (processed == null) {
                processed = new HashSet<PsiMember>();
            }
            if (!processed.add(clazz)) {
                return false;
            }
            for (PsiClass superClass : clazz.getSupers()) {
                if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)superClass, annotationFQN, flags, processed)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isAnnotatingApplicable(@NotNull PsiElement elt) {
        if (elt == null) {
            AnnotationUtil.$$$reportNull$$$0(36);
        }
        return AnnotationUtil.isAnnotatingApplicable(elt, NullableNotNullManager.getInstance(elt.getProject()).getDefaultNullable());
    }

    public static boolean isAnnotatingApplicable(@NotNull PsiElement elt, @NotNull String annotationFQN) {
        if (elt == null) {
            AnnotationUtil.$$$reportNull$$$0(37);
        }
        if (annotationFQN == null) {
            AnnotationUtil.$$$reportNull$$$0(38);
        }
        Project project = elt.getProject();
        return PsiUtil.isLanguageLevel5OrHigher(elt) && JavaPsiFacade.getInstance(project).findClass(annotationFQN, elt.getResolveScope()) != null;
    }

    @Contract(value="null,_ -> false")
    public static boolean checkAnnotatedUsingPatterns(@Nullable PsiModifierListOwner owner, @NotNull Collection<String> annotations2) {
        PsiModifierList modList;
        if (annotations2 == null) {
            AnnotationUtil.$$$reportNull$$$0(39);
        }
        if (owner == null || (modList = owner.getModifierList()) == null) {
            return false;
        }
        ArrayList<String> fqns = null;
        for (String fqn : annotations2) {
            boolean isPattern = fqn.endsWith("*");
            if (!isPattern && AnnotationUtil.isAnnotated(owner, fqn, 0)) {
                return true;
            }
            if (!isPattern) continue;
            if (fqns == null) {
                PsiAnnotation[] ownAnnotations;
                fqns = new ArrayList<String>();
                for (PsiAnnotation anno : ownAnnotations = modList.getAnnotations()) {
                    String qName = anno.getQualifiedName();
                    if (qName == null) continue;
                    fqns.add(qName);
                }
                if (fqns.isEmpty()) {
                    return false;
                }
            }
            fqn = fqn.substring(0, fqn.length() - 2);
            for (String annoFQN : fqns) {
                if (!annoFQN.startsWith(fqn)) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static PsiMethod getAnnotationMethod(@NotNull PsiNameValuePair pair) {
        if (pair == null) {
            AnnotationUtil.$$$reportNull$$$0(40);
        }
        PsiAnnotation annotation = PsiTreeUtil.getParentOfType(pair.getParent(), PsiAnnotation.class);
        assert (annotation != null);
        String fqn = annotation.getQualifiedName();
        if (fqn == null) {
            return null;
        }
        PsiClass psiClass = JavaPsiFacade.getInstance(pair.getProject()).findClass(fqn, pair.getResolveScope());
        if (psiClass != null && psiClass.isAnnotationType()) {
            String name2 = pair.getName();
            return ArrayUtil.getFirstElement(psiClass.findMethodsByName(name2 != null ? name2 : "value", false));
        }
        return null;
    }

    public static PsiAnnotation @NotNull [] getAllAnnotations(@NotNull PsiModifierListOwner owner, boolean inHierarchy, @Nullable Set<? super PsiModifierListOwner> visited2) {
        if (owner == null) {
            AnnotationUtil.$$$reportNull$$$0(41);
        }
        return AnnotationUtil.getAllAnnotations(owner, inHierarchy, visited2, true);
    }

    public static PsiAnnotation @NotNull [] getAllAnnotations(@NotNull PsiModifierListOwner owner, boolean inHierarchy, @Nullable Set<? super PsiModifierListOwner> visited2, boolean withInferred) {
        Project project;
        PsiAnnotation[] externalAnnotations;
        if (owner == null) {
            AnnotationUtil.$$$reportNull$$$0(42);
        }
        PsiModifierList list = owner.getModifierList();
        PsiAnnotation[] annotations2 = PsiAnnotation.EMPTY_ARRAY;
        if (list != null) {
            annotations2 = list.getAnnotations();
        }
        if ((externalAnnotations = ExternalAnnotationsManager.getInstance(project = owner.getProject()).findExternalAnnotations(owner)) != null) {
            annotations2 = ArrayUtil.mergeArrays(annotations2, externalAnnotations, PsiAnnotation.ARRAY_FACTORY);
        }
        if (withInferred) {
            PsiElement[] inferredAnnotations = InferredAnnotationsManager.getInstance(project).findInferredAnnotations(owner);
            annotations2 = ArrayUtil.mergeArrays(annotations2, inferredAnnotations, PsiAnnotation.ARRAY_FACTORY);
        }
        if (inHierarchy) {
            PsiParameter parameter2;
            PsiElement scope;
            if (owner instanceof PsiClass) {
                for (PsiElement psiElement : ((PsiClass)owner).getSupers()) {
                    if (visited2 == null) {
                        visited2 = new HashSet<PsiModifierListOwner>();
                    }
                    if (!visited2.add((PsiModifierListOwner)psiElement)) continue;
                    annotations2 = ArrayUtil.mergeArrays(annotations2, AnnotationUtil.getAllAnnotations((PsiModifierListOwner)psiElement, true, visited2, withInferred));
                }
            } else if (owner instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)owner;
                PsiClass aClass = method.getContainingClass();
                if (aClass != null) {
                    HierarchicalMethodSignature methodSignature = method.getHierarchicalMethodSignature();
                    List<HierarchicalMethodSignature> list2 = methodSignature.getSuperSignatures();
                    PsiResolveHelper resolveHelper = PsiResolveHelper.getInstance(aClass.getProject());
                    for (HierarchicalMethodSignature superSignature : list2) {
                        PsiMethod superMethod = superSignature.getMethod();
                        if (visited2 == null) {
                            visited2 = new HashSet<PsiModifierListOwner>();
                        }
                        if (!visited2.add(superMethod) || !resolveHelper.isAccessible(superMethod, owner, null)) continue;
                        annotations2 = ArrayUtil.mergeArrays(annotations2, AnnotationUtil.getAllAnnotations(superMethod, true, visited2, withInferred));
                    }
                }
            } else if (owner instanceof PsiParameter && (scope = (parameter2 = (PsiParameter)owner).getDeclarationScope()) instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)scope;
                PsiClass psiClass = method.getContainingClass();
                PsiElement parent2 = parameter2.getParent();
                if (psiClass != null && parent2 instanceof PsiParameterList) {
                    int index = ((PsiParameterList)parent2).getParameterIndex(parameter2);
                    HierarchicalMethodSignature methodSignature = method.getHierarchicalMethodSignature();
                    List<HierarchicalMethodSignature> superSignatures = methodSignature.getSuperSignatures();
                    PsiResolveHelper resolveHelper = PsiResolveHelper.getInstance(psiClass.getProject());
                    for (HierarchicalMethodSignature superSignature : superSignatures) {
                        PsiParameter[] superParameters;
                        PsiMethod superMethod = superSignature.getMethod();
                        if (visited2 == null) {
                            visited2 = new HashSet<PsiModifierListOwner>();
                        }
                        if (!visited2.add(superMethod) || !resolveHelper.isAccessible(superMethod, owner, null) || index >= (superParameters = superMethod.getParameterList().getParameters()).length) continue;
                        annotations2 = ArrayUtil.mergeArrays(annotations2, AnnotationUtil.getAllAnnotations(superParameters[index], true, visited2, withInferred));
                    }
                }
            }
        }
        if (annotations2 == null) {
            AnnotationUtil.$$$reportNull$$$0(43);
        }
        return annotations2;
    }

    public static boolean isInsideAnnotation(@NotNull PsiElement element2) {
        if (element2 == null) {
            AnnotationUtil.$$$reportNull$$$0(44);
        }
        for (int level = 0; level < 4; ++level) {
            if (element2 instanceof PsiNameValuePair) {
                return true;
            }
            if ((element2 = element2.getParent()) != null) continue;
            return false;
        }
        return false;
    }

    public static boolean isInferredAnnotation(@NotNull PsiAnnotation annotation) {
        if (annotation == null) {
            AnnotationUtil.$$$reportNull$$$0(45);
        }
        return InferredAnnotationsManager.getInstance(annotation.getProject()).isInferredAnnotation(annotation);
    }

    public static boolean isExternalAnnotation(@NotNull PsiAnnotation annotation) {
        if (annotation == null) {
            AnnotationUtil.$$$reportNull$$$0(46);
        }
        return ExternalAnnotationsManager.getInstance(annotation.getProject()).isExternalAnnotation(annotation);
    }

    @Nullable
    @NlsSafe
    public static String getStringAttributeValue(@NotNull PsiAnnotation anno, @Nullable String attributeName) {
        PsiAnnotationMemberValue attrValue;
        if (anno == null) {
            AnnotationUtil.$$$reportNull$$$0(47);
        }
        return (attrValue = anno.findAttributeValue(attributeName)) == null ? null : AnnotationUtil.getStringAttributeValue(attrValue);
    }

    @Nullable
    public static Boolean getBooleanAttributeValue(@NotNull PsiAnnotation anno, @Nullable String attributeName) {
        if (anno == null) {
            AnnotationUtil.$$$reportNull$$$0(48);
        }
        PsiAnnotationMemberValue attrValue = anno.findAttributeValue(attributeName);
        Object constValue = JavaPsiFacade.getInstance(anno.getProject()).getConstantEvaluationHelper().computeConstantExpression(attrValue);
        return constValue instanceof Boolean ? (Boolean)constValue : null;
    }

    @Nullable
    public static Long getLongAttributeValue(@NotNull PsiAnnotation anno, @Nullable String attributeName) {
        if (anno == null) {
            AnnotationUtil.$$$reportNull$$$0(49);
        }
        PsiAnnotationMemberValue attrValue = anno.findAttributeValue(attributeName);
        Object constValue = JavaPsiFacade.getInstance(anno.getProject()).getConstantEvaluationHelper().computeConstantExpression(attrValue);
        return constValue instanceof Number ? Long.valueOf(((Number)constValue).longValue()) : null;
    }

    @Nullable
    public static String getDeclaredStringAttributeValue(@NotNull PsiAnnotation anno, @Nullable String attributeName) {
        PsiAnnotationMemberValue attrValue;
        if (anno == null) {
            AnnotationUtil.$$$reportNull$$$0(50);
        }
        return (attrValue = anno.findDeclaredAttributeValue(attributeName)) == null ? null : AnnotationUtil.getStringAttributeValue(attrValue);
    }

    @Nullable
    public static String getStringAttributeValue(@NotNull PsiAnnotationMemberValue attrValue) {
        PsiConstantEvaluationHelper evaluationHelper;
        Object constValue;
        if (attrValue == null) {
            AnnotationUtil.$$$reportNull$$$0(51);
        }
        return (constValue = (evaluationHelper = JavaPsiFacade.getInstance(attrValue.getProject()).getConstantEvaluationHelper()).computeConstantExpression(attrValue)) instanceof String ? (String)constValue : null;
    }

    @Nullable
    public static <T extends Annotation> T findAnnotationInHierarchy(@NotNull PsiModifierListOwner listOwner, @NotNull Class<T> annotationClass) {
        PsiAnnotation annotation;
        if (listOwner == null) {
            AnnotationUtil.$$$reportNull$$$0(52);
        }
        if (annotationClass == null) {
            AnnotationUtil.$$$reportNull$$$0(53);
        }
        if ((annotation = AnnotationUtil.findAnnotationInHierarchy(listOwner, Collections.singleton(annotationClass.getName()))) == null) {
            return null;
        }
        AnnotationInvocationHandler handler2 = new AnnotationInvocationHandler(annotationClass, annotation);
        return (T)((Annotation)ReflectionUtil.proxy(annotationClass, handler2));
    }

    @Contract(pure=true)
    @Nullable
    public static PsiNameValuePair findDeclaredAttribute(@NotNull PsiAnnotation annotation, @Nullable(value="null means 'value'") @NonNls @Nullable(value="null means 'value'") @NonNls String attributeName) {
        if (annotation == null) {
            AnnotationUtil.$$$reportNull$$$0(54);
        }
        if ("value".equals(attributeName)) {
            attributeName = null;
        }
        for (PsiNameValuePair attribute : annotation.getParameterList().getAttributes()) {
            String name2 = attribute.getName();
            if (!Objects.equals(name2, attributeName) && (attributeName != null || !"value".equals(name2))) continue;
            return attribute;
        }
        return null;
    }

    public static boolean equal(@Nullable PsiAnnotation a, @Nullable PsiAnnotation b) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return false;
        }
        String name2 = a.getQualifiedName();
        if (name2 == null || !name2.equals(b.getQualifiedName())) {
            return false;
        }
        HashMap<String, PsiAnnotationMemberValue> valueMap1 = new HashMap<String, PsiAnnotationMemberValue>(2);
        HashMap<String, PsiAnnotationMemberValue> valueMap2 = new HashMap<String, PsiAnnotationMemberValue>(2);
        if (!AnnotationUtil.fillValueMap(a.getParameterList(), valueMap1) || !AnnotationUtil.fillValueMap(b.getParameterList(), valueMap2) || valueMap1.size() != valueMap2.size()) {
            return false;
        }
        for (Map.Entry entry : valueMap1.entrySet()) {
            if (AnnotationUtil.equal((PsiAnnotationMemberValue)entry.getValue(), (PsiAnnotationMemberValue)valueMap2.get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    private static boolean fillValueMap(@NotNull PsiAnnotationParameterList parameterList2, @NotNull Map<String, PsiAnnotationMemberValue> valueMap) {
        PsiNameValuePair[] attributes1;
        if (parameterList2 == null) {
            AnnotationUtil.$$$reportNull$$$0(55);
        }
        if (valueMap == null) {
            AnnotationUtil.$$$reportNull$$$0(56);
        }
        for (PsiNameValuePair attribute : attributes1 = parameterList2.getAttributes()) {
            PsiReference reference2 = attribute.getReference();
            if (reference2 == null) {
                return false;
            }
            PsiElement target = reference2.resolve();
            if (!(target instanceof PsiAnnotationMethod)) {
                return false;
            }
            PsiAnnotationMethod annotationMethod = (PsiAnnotationMethod)target;
            PsiAnnotationMemberValue defaultValue = annotationMethod.getDefaultValue();
            PsiAnnotationMemberValue value2 = attribute.getValue();
            if (AnnotationUtil.equal(value2, defaultValue)) continue;
            String name1 = attribute.getName();
            valueMap.put(name1 == null ? "value" : name1, value2);
        }
        return true;
    }

    public static boolean equal(@Nullable PsiAnnotationMemberValue value1, @Nullable PsiAnnotationMemberValue value2) {
        if (value1 instanceof PsiArrayInitializerMemberValue && value2 instanceof PsiArrayInitializerMemberValue) {
            PsiAnnotationMemberValue[] initializers2;
            PsiAnnotationMemberValue[] initializers1 = ((PsiArrayInitializerMemberValue)value1).getInitializers();
            if (initializers1.length != (initializers2 = ((PsiArrayInitializerMemberValue)value2).getInitializers()).length) {
                return false;
            }
            return ArrayUtil.areEqual(initializers1, initializers2, AnnotationUtil::equal);
        }
        if (value1 != null && value2 != null) {
            PsiConstantEvaluationHelper constantEvaluationHelper = JavaPsiFacade.getInstance(value1.getProject()).getConstantEvaluationHelper();
            Object const1 = constantEvaluationHelper.computeConstantExpression(value1);
            Object const2 = constantEvaluationHelper.computeConstantExpression(value2);
            return const1 != null && const1.equals(const2);
        }
        return false;
    }

    public static boolean equal(PsiAnnotation @NotNull [] annotations1, PsiAnnotation @NotNull [] annotations2) {
        if (annotations1 == null) {
            AnnotationUtil.$$$reportNull$$$0(57);
        }
        if (annotations2 == null) {
            AnnotationUtil.$$$reportNull$$$0(58);
        }
        Map<String, PsiAnnotation> map1 = AnnotationUtil.buildAnnotationMap(annotations1);
        Map<String, PsiAnnotation> map2 = AnnotationUtil.buildAnnotationMap(annotations2);
        if (map1.size() != map2.size()) {
            return false;
        }
        for (Map.Entry<String, PsiAnnotation> entry : map1.entrySet()) {
            if (AnnotationUtil.equal(entry.getValue(), map2.get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private static Map<String, PsiAnnotation> buildAnnotationMap(PsiAnnotation @NotNull [] annotations2) {
        if (annotations2 == null) {
            AnnotationUtil.$$$reportNull$$$0(59);
        }
        HashMap<String, PsiAnnotation> map = new HashMap<String, PsiAnnotation>();
        for (PsiAnnotation annotation : annotations2) {
            map.put(annotation.getQualifiedName(), annotation);
        }
        map.remove("java.lang.Override");
        map.remove("java.lang.SuppressWarnings");
        HashMap<String, PsiAnnotation> hashMap = map;
        if (hashMap == null) {
            AnnotationUtil.$$$reportNull$$$0(60);
        }
        return hashMap;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static boolean isJetbrainsAnnotation(@NotNull String simpleName2) {
        if (simpleName2 == null) {
            AnnotationUtil.$$$reportNull$$$0(61);
        }
        return ArrayUtil.find(SIMPLE_NAMES, simpleName2) != -1;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static boolean isAnnotated(@NotNull PsiModifierListOwner listOwner, @NotNull Collection<String> annotations2) {
        if (listOwner == null) {
            AnnotationUtil.$$$reportNull$$$0(62);
        }
        if (annotations2 == null) {
            AnnotationUtil.$$$reportNull$$$0(63);
        }
        return AnnotationUtil.isAnnotated(listOwner, annotations2, 8);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static boolean isAnnotated(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQN, boolean checkHierarchy) {
        if (listOwner == null) {
            AnnotationUtil.$$$reportNull$$$0(64);
        }
        if (annotationFQN == null) {
            AnnotationUtil.$$$reportNull$$$0(65);
        }
        return AnnotationUtil.isAnnotated(listOwner, annotationFQN, AnnotationUtil.flags(checkHierarchy, true, true));
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static boolean isAnnotated(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQN, boolean checkHierarchy, boolean skipExternal) {
        if (listOwner == null) {
            AnnotationUtil.$$$reportNull$$$0(66);
        }
        if (annotationFQN == null) {
            AnnotationUtil.$$$reportNull$$$0(67);
        }
        return AnnotationUtil.isAnnotated(listOwner, annotationFQN, AnnotationUtil.flags(checkHierarchy, skipExternal, skipExternal));
    }

    @Flags
    private static int flags(boolean checkHierarchy, boolean skipExternal, boolean skipInferred) {
        int flags = 8;
        if (checkHierarchy) {
            flags |= 1;
        }
        if (!skipExternal) {
            flags |= 2;
        }
        if (!skipInferred) {
            flags |= 4;
        }
        return flags;
    }

    @NotNull
    public static List<PsiAnnotationMemberValue> arrayAttributeValues(@Nullable PsiAnnotationMemberValue attributeValue) {
        if (attributeValue instanceof PsiArrayInitializerMemberValue) {
            List<PsiAnnotationMemberValue> list = Arrays.asList(((PsiArrayInitializerMemberValue)attributeValue).getInitializers());
            if (list == null) {
                AnnotationUtil.$$$reportNull$$$0(68);
            }
            return list;
        }
        List<PsiAnnotationMemberValue> list = ContainerUtil.createMaybeSingletonList(attributeValue);
        if (list == null) {
            AnnotationUtil.$$$reportNull$$$0(69);
        }
        return list;
    }

    @Nullable
    public static PsiType getRelatedType(PsiAnnotation annotation) {
        PsiAnnotationOwner owner = annotation.getOwner();
        if (owner instanceof PsiType) {
            return (PsiType)owner;
        }
        PsiType type2 = null;
        if (owner instanceof PsiModifierList) {
            PsiElement parent2 = ((PsiModifierList)owner).getParent();
            PsiTypeElement typeElement = null;
            if (parent2 instanceof PsiVariable) {
                type2 = ((PsiVariable)parent2).getType();
                typeElement = ((PsiVariable)parent2).getTypeElement();
            }
            if (parent2 instanceof PsiMethod) {
                type2 = ((PsiMethod)parent2).getReturnType();
                typeElement = ((PsiMethod)parent2).getReturnTypeElement();
            }
            if (type2 != null) {
                Set<PsiAnnotation.TargetType> targets;
                PsiClass annoClass = annotation.resolveAnnotationType();
                if (annoClass != null && (targets = AnnotationTargetUtil.getAnnotationTargets(annoClass)) != null && targets.contains((Object)PsiAnnotation.TargetType.TYPE_USE) && PsiUtil.isLanguageLevel8OrHigher(parent2)) {
                    if (typeElement != null && targets.size() == 1) {
                        PsiJavaCodeReferenceElement ref = typeElement.getInnermostComponentReferenceElement();
                        while (ref != null && ref.isQualified()) {
                            ref = ObjectUtils.tryCast(ref.getQualifier(), PsiJavaCodeReferenceElement.class);
                        }
                        if (ref != null) {
                            return JavaPsiFacade.getElementFactory(annotation.getProject()).createType(ref);
                        }
                    }
                    return type2.getDeepComponentType();
                }
                return type2;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 43: 
            case 60: 
            case 68: 
            case 69: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 43: 
            case 60: 
            case 68: 
            case 69: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationNames";
                break;
            }
            case 5: 
            case 8: 
            case 18: 
            case 20: 
            case 22: 
            case 30: 
            case 32: 
            case 34: 
            case 52: 
            case 62: 
            case 64: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listOwner";
                break;
            }
            case 7: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 43: 
            case 60: 
            case 68: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/AnnotationUtil";
                break;
            }
            case 10: 
            case 16: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveHelper";
                break;
            }
            case 31: 
            case 39: 
            case 59: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationFqn";
                break;
            }
            case 35: 
            case 38: 
            case 65: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationFQN";
                break;
            }
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elt";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pair";
                break;
            }
            case 41: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 45: 
            case 46: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anno";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrValue";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationClass";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterList";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueMap";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations1";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations2";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "simpleName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/AnnotationUtil";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllAnnotations";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "findAnnotations";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperAnnotationOwners";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllAnnotations";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "buildAnnotationMap";
                break;
            }
            case 68: 
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "arrayAttributeValues";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findAnnotation";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findAllAnnotations";
                break;
            }
            case 7: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 43: 
            case 60: 
            case 68: 
            case 69: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findOwnAnnotations";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findNonCodeAnnotations";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findAnnotations";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getSuperAnnotationOwners";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "findAnnotationInHierarchy";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "findAnnotationAndOwnerInHierarchy";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "collectSuperParameters";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "collectSuperMethods";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "isAnnotated";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "isAnnotatingApplicable";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "checkAnnotatedUsingPatterns";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationMethod";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getAllAnnotations";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "isInsideAnnotation";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "isInferredAnnotation";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "isExternalAnnotation";
                break;
            }
            case 47: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getStringAttributeValue";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getBooleanAttributeValue";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getLongAttributeValue";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getDeclaredStringAttributeValue";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "findDeclaredAttribute";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "fillValueMap";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "equal";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "buildAnnotationMap";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "isJetbrainsAnnotation";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 7: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 43: 
            case 60: 
            case 68: 
            case 69: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    static final class AnnotationAndOwner {
        @NotNull
        final PsiModifierListOwner owner;
        @NotNull
        final PsiAnnotation annotation;

        AnnotationAndOwner(@NotNull PsiModifierListOwner owner, @NotNull PsiAnnotation annotation) {
            if (owner == null) {
                AnnotationAndOwner.$$$reportNull$$$0(0);
            }
            if (annotation == null) {
                AnnotationAndOwner.$$$reportNull$$$0(1);
            }
            this.owner = owner;
            this.annotation = annotation;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "owner";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "annotation";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInsight/AnnotationUtil$AnnotationAndOwner";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    @Target(value={ElementType.PARAMETER, ElementType.METHOD})
    private static @interface Flags {
    }
}

