/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeTypeParameterInQualifiedAccess;
import org.jetbrains.kotlin.fir.scopes.impl.FirNestedClassifierScopeKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeInferenceContext;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeStarProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjectionKt;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.InferenceUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0014\u0010\r\u001a\u00020\u000e*\u00020\u000f2\u0006\u0010\t\u001a\u00020\u0010H\u0002R\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u0012*\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirKClassWithIncorrectTypeArgumentChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirCallableDeclarationChecker;", "<init>", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "isKClassTypeWithErrorOrNullableArgument", "", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "Lorg/jetbrains/kotlin/fir/types/ConeInferenceContext;", "typeParameterFromError", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirTypeParameterSymbol;", "getTypeParameterFromError", "(Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;)Lorg/jetbrains/kotlin/fir/symbols/impl/FirTypeParameterSymbol;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirKClassWithIncorrectTypeArgumentChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirKClassWithIncorrectTypeArgumentChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirKClassWithIncorrectTypeArgumentChecker\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,71:1\n13409#2,2:72\n1863#3,2:74\n*S KotlinDebug\n*F\n+ 1 FirKClassWithIncorrectTypeArgumentChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirKClassWithIncorrectTypeArgumentChecker\n*L\n38#1:72,2\n45#1:74,2\n*E\n"})
public final class FirKClassWithIncorrectTypeArgumentChecker
extends FirDeclarationChecker<FirCallableDeclaration> {
    @NotNull
    public static final FirKClassWithIncorrectTypeArgumentChecker INSTANCE = new FirKClassWithIncorrectTypeArgumentChecker();

    private FirKClassWithIncorrectTypeArgumentChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirCallableDeclaration declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (context2.getContainingDeclarations().size() > 1) {
            return;
        }
        KtSourceElement ktSourceElement = declaration2.getSource();
        if (ktSourceElement == null) {
            return;
        }
        KtSourceElement source = ktSourceElement;
        if (source.getKind() instanceof KtFakeSourceElementKind) {
            return;
        }
        List typeArgumentsWithWrongType = new ArrayList();
        ConeKotlinType returnType2 = FirTypeUtilsKt.getConeType(declaration2.getReturnTypeRef());
        if (this.isKClassTypeWithErrorOrNullableArgument(returnType2, TypeComponentsKt.getTypeContext(context2.getSession()))) {
            typeArgumentsWithWrongType.add(returnType2);
        }
        Object $this$forEach$iv = returnType2.getTypeArguments();
        boolean $i$f$forEach = false;
        int n = ((ConeTypeProjection[])$this$forEach$iv).length;
        for (int i = 0; i < n; ++i) {
            ConeKotlinType type2;
            ConeTypeProjection element$iv;
            ConeTypeProjection it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            if (ConeTypeProjectionKt.getType(it) == null || !INSTANCE.isKClassTypeWithErrorOrNullableArgument(type2, TypeComponentsKt.getTypeContext(context2.getSession()))) continue;
            typeArgumentsWithWrongType.add(type2);
        }
        if (typeArgumentsWithWrongType.isEmpty()) {
            return;
        }
        $this$forEach$iv = typeArgumentsWithWrongType;
        $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv = iterator2.next();
            ConeKotlinType it = (ConeKotlinType)element$iv;
            boolean bl = false;
            ConeTypeProjection coneTypeProjection = it.getTypeArguments()[0];
            Object object = coneTypeProjection instanceof ConeKotlinTypeProjection ? (ConeKotlinTypeProjection)coneTypeProjection : null;
            if (object == null || (object = ((ConeKotlinTypeProjection)object).getType()) == null || (object = INSTANCE.getTypeParameterFromError((ConeKotlinType)object)) == null) continue;
            Object typeParameterFromError = object;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getKCLASS_WITH_NULLABLE_TYPE_PARAMETER_IN_SIGNATURE(), typeParameterFromError, (DiagnosticContext)context2, null, 16, null);
        }
    }

    private final boolean isKClassTypeWithErrorOrNullableArgument(ConeKotlinType $this$isKClassTypeWithErrorOrNullableArgument, ConeInferenceContext context2) {
        ConeTypeProjection coneTypeProjection;
        block10: {
            block9: {
                ConeKotlinType coneKotlinType;
                if (!InferenceUtilsKt.isKClassType($this$isKClassTypeWithErrorOrNullableArgument)) {
                    return false;
                }
                coneTypeProjection = (ConeTypeProjection)CollectionsKt.singleOrNull((List)ArraysKt.toList((Object[])$this$isKClassTypeWithErrorOrNullableArgument.getTypeArguments()));
                if (coneTypeProjection == null) break block9;
                ConeTypeProjection it = coneTypeProjection;
                boolean bl = false;
                ConeTypeProjection coneTypeProjection2 = it;
                if (coneTypeProjection2 instanceof ConeStarProjection) {
                    coneKotlinType = null;
                } else if (coneTypeProjection2 instanceof ConeKotlinTypeProjection) {
                    coneKotlinType = ((ConeKotlinTypeProjection)it).getType();
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                coneTypeProjection = coneKotlinType;
                if (coneKotlinType != null) break block10;
            }
            return false;
        }
        ConeTypeProjection argumentType = coneTypeProjection;
        ConeInferenceContext $this$isKClassTypeWithErrorOrNullableArgument_u24lambda_u244 = context2;
        boolean bl = false;
        FirTypeParameterSymbol firTypeParameterSymbol = INSTANCE.getTypeParameterFromError((ConeKotlinType)argumentType);
        if (firTypeParameterSymbol != null) {
            FirTypeParameterSymbol typeParameterSymbol = firTypeParameterSymbol;
            boolean bl2 = false;
            return $this$isKClassTypeWithErrorOrNullableArgument_u24lambda_u244.isNullableType(FirNestedClassifierScopeKt.toConeType(typeParameterSymbol));
        }
        return argumentType instanceof ConeErrorType || $this$isKClassTypeWithErrorOrNullableArgument_u24lambda_u244.isNullableType((KotlinTypeMarker)((Object)argumentType));
    }

    private final FirTypeParameterSymbol getTypeParameterFromError(ConeKotlinType $this$typeParameterFromError) {
        ConeErrorType coneErrorType = $this$typeParameterFromError instanceof ConeErrorType ? (ConeErrorType)$this$typeParameterFromError : null;
        ConeDiagnostic coneDiagnostic = coneErrorType != null ? coneErrorType.getDiagnostic() : null;
        ConeTypeParameterInQualifiedAccess coneTypeParameterInQualifiedAccess = coneDiagnostic instanceof ConeTypeParameterInQualifiedAccess ? (ConeTypeParameterInQualifiedAccess)coneDiagnostic : null;
        return coneTypeParameterInQualifiedAccess != null ? coneTypeParameterInQualifiedAccess.getSymbol() : null;
    }
}

