/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.dfa;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlinx.collections.immutable.ExtensionsKt;
import kotlinx.collections.immutable.PersistentList;
import kotlinx.collections.immutable.PersistentSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.resolve.dfa.DataFlowVariable;
import org.jetbrains.kotlin.fir.resolve.dfa.Implication;
import org.jetbrains.kotlin.fir.resolve.dfa.LogicSystemKt;
import org.jetbrains.kotlin.fir.resolve.dfa.ModelKt;
import org.jetbrains.kotlin.fir.resolve.dfa.MutableFlow;
import org.jetbrains.kotlin.fir.resolve.dfa.MutableTypeStatement;
import org.jetbrains.kotlin.fir.resolve.dfa.Operation;
import org.jetbrains.kotlin.fir.resolve.dfa.OperationStatement;
import org.jetbrains.kotlin.fir.resolve.dfa.PersistentFlow;
import org.jetbrains.kotlin.fir.resolve.dfa.PersistentTypeStatement;
import org.jetbrains.kotlin.fir.resolve.dfa.RealVariable;
import org.jetbrains.kotlin.fir.resolve.dfa.Statement;
import org.jetbrains.kotlin.fir.resolve.dfa.SyntheticVariable;
import org.jetbrains.kotlin.fir.resolve.dfa.TypeStatement;
import org.jetbrains.kotlin.fir.resolve.dfa.VariableStorage;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeInferenceContext;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeIntersector;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.types.AbstractTypeChecker;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\f\u0010\u0011\u001a\u00020\u0012*\u00020\u0013H\u0014J*\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u001a\u001a\u00020\u0012J\u001e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001fJ\u0018\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010\u001d\u001a\u00020\u00152\u0006\u0010#\u001a\u00020\"J,\u0010$\u001a\b\u0012\u0004\u0012\u00020\"0%2\u0006\u0010\u001d\u001a\u00020\u00152\u0016\u0010&\u001a\u0012\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\"0'j\u0002`(J\u0016\u0010)\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00152\u0006\u0010*\u001a\u00020+J6\u0010,\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00152\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020.2\u0016\b\u0002\u00100\u001a\u0010\u0012\u0004\u0012\u00020+\u0012\u0006\u0012\u0004\u0018\u00010+01J&\u00102\u001a\u0012\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\"0'j\u0002`(2\u0006\u0010\u001d\u001a\u00020\u00182\u0006\u0010#\u001a\u000203J.\u00102\u001a\u0012\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\"0'j\u0002`(2\u0006\u0010\u001d\u001a\u00020\u00152\u0006\u0010#\u001a\u0002032\u0006\u00104\u001a\u00020\u0012J\u001e\u00105\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00152\u0006\u00106\u001a\u00020\u001f2\u0006\u00107\u001a\u000208J\u001e\u00109\u001a\u00020\u00122\u0006\u0010:\u001a\u00020\u00182\u0006\u0010;\u001a\u00020\u00182\u0006\u00106\u001a\u00020\u001fJ\u001e\u00109\u001a\u00020\u00122\u0006\u0010:\u001a\u00020\u00182\u0006\u0010;\u001a\u00020\u00152\u0006\u00106\u001a\u00020\u001fJ\u001a\u0010<\u001a\u00020\u001c*\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0002J\u001a\u0010=\u001a\u00020\u001c*\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0002J\"\u0010>\u001a\u00020\u001c*\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010?\u001a\u00020\u0018H\u0002J*\u0010@\u001a\u00020\u001c*\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010?\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u0012H\u0002J\u001a\u0010A\u001a\u00020\u001c*\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0002J\u001e\u0010B\u001a\u00020\u001c*\u00020\u00152\u0006\u00106\u001a\u00020\u001f2\b\u0010C\u001a\u0004\u0018\u00010\u001fH\u0002JB\u00102\u001a\u0012\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\"0'j\u0002`(2\u0018\u0010D\u001a\u0014\u0012\u0004\u0012\u00020.\u0012\n\u0012\b\u0012\u0004\u0012\u00020+0E0'2\u0006\u0010F\u001a\u0002032\u0006\u00104\u001a\u00020\u0012H\u0002JF\u0010G\u001a\u0012\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\"0'j\u0002`(2\u0016\u0010H\u001a\u0012\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\"0'j\u0002`(2\u0016\u0010I\u001a\u0012\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\"0'j\u0002`(JF\u0010J\u001a\u0012\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\"0'j\u0002`(2\u0016\u0010H\u001a\u0012\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\"0'j\u0002`(2\u0016\u0010I\u001a\u0012\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\"0'j\u0002`(J\u0015\u0010K\u001a\u00020\u001c*\u00020L2\u0006\u0010M\u001a\u00020\"H\u0082\u0002J\u0018\u0010N\u001a\u00020\"2\b\u0010:\u001a\u0004\u0018\u00010\"2\u0006\u0010;\u001a\u00020\"J\u0016\u0010N\u001a\u0004\u0018\u00010\"2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\"0\u0017J\u0016\u0010O\u001a\u0004\u0018\u00010\"2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\"0\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u00020\u000eX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006P"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/dfa/LogicSystem;", "", "context", "Lorg/jetbrains/kotlin/fir/types/ConeInferenceContext;", "<init>", "(Lorg/jetbrains/kotlin/fir/types/ConeInferenceContext;)V", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "nullableNothingType", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "anyType", "variableStorage", "Lorg/jetbrains/kotlin/fir/resolve/dfa/VariableStorage;", "getVariableStorage", "()Lorg/jetbrains/kotlin/fir/resolve/dfa/VariableStorage;", "isAcceptableForSmartcast", "", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "joinFlow", "Lorg/jetbrains/kotlin/fir/resolve/dfa/MutableFlow;", "flows", "", "Lorg/jetbrains/kotlin/fir/resolve/dfa/PersistentFlow;", "statementFlows", "union", "addLocalVariableAlias", "", "flow", "alias", "Lorg/jetbrains/kotlin/fir/resolve/dfa/RealVariable;", "underlyingVariable", "addTypeStatement", "Lorg/jetbrains/kotlin/fir/resolve/dfa/TypeStatement;", "statement", "addTypeStatements", "", "statements", "", "Lorg/jetbrains/kotlin/fir/resolve/dfa/TypeStatements;", "addImplication", "implication", "Lorg/jetbrains/kotlin/fir/resolve/dfa/Implication;", "translateVariableFromConditionInStatements", "originalVariable", "Lorg/jetbrains/kotlin/fir/resolve/dfa/DataFlowVariable;", "newVariable", "transform", "Lkotlin/Function1;", "approveOperationStatement", "Lorg/jetbrains/kotlin/fir/resolve/dfa/OperationStatement;", "removeApprovedOrImpossible", "recordNewAssignment", "variable", "index", "", "isSameValueIn", "a", "b", "mergeAssignments", "copyCommonAliases", "copyNonConflictingAliases", "commonFlow", "copyStatements", "copyImplications", "replaceVariable", "replacement", "logicStatements", "Lkotlinx/collections/immutable/PersistentList;", "approvedStatement", "orForTypeStatements", "left", "right", "andForTypeStatements", "plusAssign", "Lorg/jetbrains/kotlin/fir/resolve/dfa/MutableTypeStatement;", "other", "and", "or", "semantics"})
@SourceDebugExtension(value={"SMAP\nLogicSystem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LogicSystem.kt\norg/jetbrains/kotlin/fir/resolve/dfa/LogicSystem\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 extensions.kt\nkotlinx/collections/immutable/ExtensionsKt\n*L\n1#1,425:1\n2669#2,7:426\n1611#2,9:434\n1863#2:443\n1864#2:445\n1620#2:446\n1619#2:447\n1863#2:448\n1864#2:450\n1620#2:451\n1734#2,3:452\n1454#2,5:455\n1863#2:460\n1628#2,3:461\n1619#2:464\n1863#2:465\n1864#2:467\n1620#2:468\n1528#2,3:469\n1531#2,3:479\n1628#2,3:482\n1864#2:485\n1293#2,4:487\n1734#2,3:498\n1755#2,3:501\n1557#2:504\n1628#2,3:505\n1#3:433\n1#3:444\n1#3:449\n1#3:466\n381#4,7:472\n381#4,7:491\n381#4,7:508\n231#5:486\n*S KotlinDebug\n*F\n+ 1 LogicSystem.kt\norg/jetbrains/kotlin/fir/resolve/dfa/LogicSystem\n*L\n43#1:426,7\n72#1:434,9\n72#1:443\n72#1:445\n72#1:446\n101#1:447\n101#1:448\n101#1:450\n101#1:451\n153#1:452,3\n181#1:455,5\n181#1:460\n186#1:461,3\n189#1:464\n189#1:465\n189#1:467\n189#1:468\n193#1:469,3\n193#1:479,3\n202#1:482,3\n181#1:485\n247#1:487,4\n346#1:498,3\n347#1:501,3\n348#1:504\n348#1:505,3\n72#1:444\n101#1:449\n189#1:466\n193#1:472,7\n271#1:491,7\n281#1:508,7\n245#1:486\n*E\n"})
public abstract class LogicSystem {
    @NotNull
    private final ConeInferenceContext context;
    @NotNull
    private final ConeClassLikeType nullableNothingType;
    @NotNull
    private final ConeClassLikeType anyType;

    public LogicSystem(@NotNull ConeInferenceContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
        this.nullableNothingType = this.getSession().getBuiltinTypes().getNullableNothingType().getConeType();
        this.anyType = this.getSession().getBuiltinTypes().getAnyType().getConeType();
    }

    @NotNull
    public final FirSession getSession() {
        return this.context.getSession();
    }

    @NotNull
    public abstract VariableStorage getVariableStorage();

    protected boolean isAcceptableForSmartcast(@NotNull ConeKotlinType $this$isAcceptableForSmartcast) {
        Intrinsics.checkNotNullParameter((Object)$this$isAcceptableForSmartcast, (String)"<this>");
        return !ConeBuiltinTypeUtilsKt.isNullableNothing($this$isAcceptableForSmartcast);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final MutableFlow joinFlow(@NotNull Collection<PersistentFlow> flows, @NotNull Collection<PersistentFlow> statementFlows, boolean union) {
        Intrinsics.checkNotNullParameter(flows, (String)"flows");
        Intrinsics.checkNotNullParameter(statementFlows, (String)"statementFlows");
        switch (flows.size()) {
            case 0: {
                return new MutableFlow();
            }
            case 1: {
                return ((PersistentFlow)CollectionsKt.first((Iterable)flows)).fork();
            }
        }
        Iterable $this$reduce$iv = flows;
        boolean $i$f$reduce = false;
        Iterator iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void b;
            PersistentFlow persistentFlow = (PersistentFlow)iterator$iv.next();
            PersistentFlow a = (PersistentFlow)accumulator$iv;
            boolean bl = false;
            if (a.lowestCommonAncestor((PersistentFlow)b) != null) continue;
            throw new IllegalStateException(("no common ancestor in " + a + ", " + b).toString());
        }
        PersistentFlow commonFlow = (PersistentFlow)accumulator$iv;
        MutableFlow result2 = commonFlow.fork();
        this.mergeAssignments(result2, flows);
        if (union) {
            this.copyNonConflictingAliases(result2, flows, commonFlow);
        } else {
            this.copyCommonAliases(result2, flows);
        }
        this.copyStatements(result2, statementFlows, commonFlow, union);
        this.copyImplications(result2, statementFlows);
        return result2;
    }

    public final void addLocalVariableAlias(@NotNull MutableFlow flow, @NotNull RealVariable alias, @NotNull RealVariable underlyingVariable) {
        Intrinsics.checkNotNullParameter((Object)flow, (String)"flow");
        Intrinsics.checkNotNullParameter((Object)alias, (String)"alias");
        Intrinsics.checkNotNullParameter((Object)underlyingVariable, (String)"underlyingVariable");
        if (Intrinsics.areEqual((Object)underlyingVariable, (Object)alias)) {
            return;
        }
        ((Map)flow.getDirectAliasMap$semantics()).put(alias, underlyingVariable);
        Map map = flow.getBackwardsAliasMap$semantics();
        PersistentSet<RealVariable> persistentSet = (PersistentSet<RealVariable>)flow.getBackwardsAliasMap$semantics().get(underlyingVariable);
        if (persistentSet == null || (persistentSet = persistentSet.add(alias)) == null) {
            RealVariable[] realVariableArray = new RealVariable[]{alias};
            persistentSet = ExtensionsKt.persistentSetOf(realVariableArray);
        }
        PersistentSet<RealVariable> persistentSet2 = persistentSet;
        map.put(underlyingVariable, persistentSet2);
    }

    @Nullable
    public final TypeStatement addTypeStatement(@NotNull MutableFlow flow, @NotNull TypeStatement statement) {
        PersistentTypeStatement persistentTypeStatement;
        PersistentSet newExactType;
        Intrinsics.checkNotNullParameter((Object)flow, (String)"flow");
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        if (statement.getExactType().isEmpty()) {
            return null;
        }
        RealVariable variable = statement.getVariable();
        PersistentTypeStatement persistentTypeStatement2 = (PersistentTypeStatement)flow.getApprovedTypeStatements$semantics().get(variable);
        PersistentSet oldExactType = persistentTypeStatement2 != null ? persistentTypeStatement2.getExactType() : null;
        PersistentSet persistentSet = oldExactType;
        if (persistentSet == null || (persistentSet = persistentSet.addAll(statement.getExactType())) == null) {
            persistentSet = ExtensionsKt.toPersistentSet((Iterable)statement.getExactType());
        }
        if ((newExactType = persistentSet) == oldExactType) {
            return null;
        }
        PersistentTypeStatement it = persistentTypeStatement = new PersistentTypeStatement(variable, newExactType);
        boolean bl = false;
        ((Map)flow.getApprovedTypeStatements$semantics()).put(variable, it);
        return persistentTypeStatement;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<TypeStatement> addTypeStatements(@NotNull MutableFlow flow, @NotNull Map<RealVariable, ? extends TypeStatement> statements) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)flow, (String)"flow");
        Intrinsics.checkNotNullParameter(statements, (String)"statements");
        Iterable $this$mapNotNull$iv = statements.values();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            TypeStatement it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            TypeStatement it = (TypeStatement)element$iv$iv;
            boolean bl2 = false;
            if (this.addTypeStatement(flow, it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void addImplication(@NotNull MutableFlow flow, @NotNull Implication implication) {
        boolean redundant;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)flow, (String)"flow");
        Intrinsics.checkNotNullParameter((Object)implication, (String)"implication");
        Statement effect = implication.getEffect();
        if (Intrinsics.areEqual((Object)effect, (Object)implication.getCondition())) return;
        if (effect instanceof TypeStatement) {
            boolean bl2;
            if (((TypeStatement)effect).isEmpty()) return;
            Object object = (PersistentTypeStatement)flow.getApprovedTypeStatements$semantics().get(((TypeStatement)effect).getVariable());
            if (object != null && (object = ((PersistentTypeStatement)object).getExactType()) != null) {
                if (object.containsAll((Collection)((TypeStatement)effect).getExactType())) {
                    return;
                }
                bl2 = false;
            } else {
                bl2 = false;
            }
            if (bl2) {
                return;
            }
            bl = false;
        } else {
            if (effect.getVariable() instanceof SyntheticVariable && !((Map)flow.getImplications$semantics()).containsKey(effect.getVariable())) {
                return;
            }
            bl = false;
        }
        if (bl) {
            return;
        }
        boolean bl3 = redundant = false;
        if (redundant) {
            return;
        }
        DataFlowVariable variable = implication.getCondition().getVariable();
        Map map = flow.getImplications$semantics();
        PersistentList<Implication> persistentList = (PersistentList<Implication>)flow.getImplications$semantics().get(variable);
        if (persistentList == null || (persistentList = persistentList.add(implication)) == null) {
            Implication[] implicationArray = new Implication[]{implication};
            persistentList = ExtensionsKt.persistentListOf(implicationArray);
        }
        PersistentList<Implication> persistentList2 = persistentList;
        map.put(variable, persistentList2);
    }

    /*
     * WARNING - void declaration
     */
    public final void translateVariableFromConditionInStatements(@NotNull MutableFlow flow, @NotNull DataFlowVariable originalVariable, @NotNull DataFlowVariable newVariable, @NotNull Function1<? super Implication, Implication> transform2) {
        void $this$mapNotNullTo$iv;
        Intrinsics.checkNotNullParameter((Object)flow, (String)"flow");
        Intrinsics.checkNotNullParameter((Object)originalVariable, (String)"originalVariable");
        Intrinsics.checkNotNullParameter((Object)newVariable, (String)"newVariable");
        Intrinsics.checkNotNullParameter(transform2, (String)"transform");
        PersistentList statements = ModelKt.isSynthetic(originalVariable) ? (PersistentList)flow.getImplications$semantics().remove(originalVariable) : (PersistentList)flow.getImplications$semantics().get(originalVariable);
        Collection collection = statements;
        if (collection == null || collection.isEmpty()) {
            return;
        }
        PersistentList persistentList = (PersistentList)flow.getImplications$semantics().get(newVariable);
        if (persistentList == null) {
            persistentList = ExtensionsKt.persistentListOf();
        }
        PersistentList existing = persistentList;
        Map map = flow.getImplications$semantics();
        PersistentList persistentList2 = statements;
        Collection destination$iv = existing.builder();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Implication it$iv;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator2.next();
            boolean bl = false;
            Implication it = (Implication)element$iv;
            boolean bl2 = false;
            if ((Implication)transform2.invoke((Object)ModelKt.implies(new OperationStatement(newVariable, it.getCondition().getOperation()), it.getEffect())) == null) continue;
            boolean bl3 = false;
            destination$iv.add(it$iv);
        }
        persistentList2 = ((PersistentList.Builder)destination$iv).build();
        map.put(newVariable, persistentList2);
    }

    public static /* synthetic */ void translateVariableFromConditionInStatements$default(LogicSystem logicSystem2, MutableFlow mutableFlow, DataFlowVariable dataFlowVariable, DataFlowVariable dataFlowVariable2, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: translateVariableFromConditionInStatements");
        }
        if ((n & 8) != 0) {
            function1 = LogicSystem::translateVariableFromConditionInStatements$lambda$3;
        }
        logicSystem2.translateVariableFromConditionInStatements(mutableFlow, dataFlowVariable, dataFlowVariable2, (Function1<? super Implication, Implication>)function1);
    }

    @NotNull
    public final Map<RealVariable, TypeStatement> approveOperationStatement(@NotNull PersistentFlow flow, @NotNull OperationStatement statement) {
        Intrinsics.checkNotNullParameter((Object)flow, (String)"flow");
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        return this.approveOperationStatement(MapsKt.toMutableMap((Map)flow.getImplications$semantics()), statement, false);
    }

    @NotNull
    public final Map<RealVariable, TypeStatement> approveOperationStatement(@NotNull MutableFlow flow, @NotNull OperationStatement statement, boolean removeApprovedOrImpossible) {
        Intrinsics.checkNotNullParameter((Object)flow, (String)"flow");
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        return this.approveOperationStatement((Map<DataFlowVariable, ? extends PersistentList<Implication>>)flow.getImplications$semantics(), statement, removeApprovedOrImpossible);
    }

    public final void recordNewAssignment(@NotNull MutableFlow flow, @NotNull RealVariable variable, int index) {
        Intrinsics.checkNotNullParameter((Object)flow, (String)"flow");
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        this.replaceVariable(flow, variable, null);
        Integer n = index;
        ((Map)flow.getAssignmentIndex$semantics()).put(variable, n);
    }

    public final boolean isSameValueIn(@NotNull PersistentFlow a, @NotNull PersistentFlow b, @NotNull RealVariable variable) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        return Intrinsics.areEqual(a.getAssignmentIndex$semantics().get(variable), b.getAssignmentIndex$semantics().get(variable));
    }

    public final boolean isSameValueIn(@NotNull PersistentFlow a, @NotNull MutableFlow b, @NotNull RealVariable variable) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        return Intrinsics.areEqual(a.getAssignmentIndex$semantics().get(variable), b.getAssignmentIndex$semantics().get(variable));
    }

    private final void mergeAssignments(MutableFlow $this$mergeAssignments, Collection<PersistentFlow> flows) {
        Map reassignedVariables = new LinkedHashMap();
        for (PersistentFlow entry : flows) {
            for (Map.Entry entry2 : ((Map)entry.getAssignmentIndex$semantics()).entrySet()) {
                RealVariable variable = (RealVariable)entry2.getKey();
                int index = ((Number)entry2.getValue()).intValue();
                Integer n = (Integer)$this$mergeAssignments.getAssignmentIndex$semantics().get(variable);
                int n2 = index;
                if (n != null && n == n2) continue;
                Map map = reassignedVariables;
                Integer n3 = (Integer)reassignedVariables.get(variable);
                int n4 = n3 != null ? n3 : 0;
                Integer n5 = Math.max(index, n4);
                map.put(variable, n5);
            }
        }
        for (Map.Entry entry : reassignedVariables.entrySet()) {
            RealVariable variable = (RealVariable)entry.getKey();
            int index = ((Number)entry.getValue()).intValue();
            this.recordNewAssignment($this$mergeAssignments, variable, index);
        }
    }

    private final void copyCommonAliases(MutableFlow $this$copyCommonAliases, Collection<PersistentFlow> flows) {
        for (Map.Entry entry : ((Map)((PersistentFlow)CollectionsKt.first((Iterable)flows)).getDirectAliasMap$semantics()).entrySet()) {
            boolean bl;
            RealVariable to;
            RealVariable from2;
            block4: {
                from2 = (RealVariable)entry.getKey();
                to = (RealVariable)entry.getValue();
                if (Intrinsics.areEqual($this$copyCommonAliases.getDirectAliasMap$semantics().get(from2), (Object)to)) continue;
                Iterable $this$all$iv = flows;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        PersistentFlow it = (PersistentFlow)element$iv;
                        boolean bl2 = false;
                        if (Intrinsics.areEqual((Object)it.unwrapVariable(from2), (Object)to)) continue;
                        bl = false;
                        break block4;
                    }
                    bl = true;
                }
            }
            if (!bl) continue;
            this.addLocalVariableAlias($this$copyCommonAliases, from2, to);
        }
    }

    private final void copyNonConflictingAliases(MutableFlow $this$copyNonConflictingAliases, Collection<PersistentFlow> flows, PersistentFlow commonFlow) {
        Map candidates2 = new LinkedHashMap();
        for (PersistentFlow entry : flows) {
            for (Map.Entry entry2 : ((Map)entry.getDirectAliasMap$semantics()).entrySet()) {
                RealVariable from2 = (RealVariable)entry2.getKey();
                RealVariable to = (RealVariable)entry2.getValue();
                Map map = candidates2;
                if (Intrinsics.areEqual(commonFlow.getAssignmentIndex$semantics().get(from2), entry.getAssignmentIndex$semantics().get(from2))) continue;
                RealVariable realVariable = candidates2.containsKey(from2) && !Intrinsics.areEqual(candidates2.get(from2), (Object)to) ? null : to;
                map.put(from2, realVariable);
            }
        }
        for (Map.Entry entry : candidates2.entrySet()) {
            RealVariable from3 = (RealVariable)entry.getKey();
            RealVariable to = (RealVariable)entry.getValue();
            RealVariable realVariable = to;
            if (realVariable == null) continue;
            this.addLocalVariableAlias($this$copyNonConflictingAliases, from3, realVariable);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void copyStatements(MutableFlow $this$copyStatements, Collection<PersistentFlow> flows, PersistentFlow commonFlow, boolean union) {
        void $this$forEach$iv;
        void destination$iv;
        Iterable $this$flatMapTo$iv;
        Iterable iterable = flows;
        Collection collection = new LinkedHashSet();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            PersistentFlow it = (PersistentFlow)element$iv;
            boolean bl2 = false;
            Iterable list$iv = it.getKnownVariables();
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        $this$flatMapTo$iv = (Iterable)destination$iv;
        boolean $i$f$forEach = false;
        block1: for (Object element$iv : $this$forEach$iv) {
            TypeStatement statement;
            TypeStatement typeStatement;
            Iterator it;
            Iterable iterable2;
            Iterable destination$iv2;
            Iterable $this$mapTo$iv;
            Object object;
            RealVariable variable = (RealVariable)element$iv;
            boolean bl = false;
            if (((Map)$this$copyStatements.getDirectAliasMap$semantics()).containsKey(variable)) continue;
            if (!union) {
                Iterable bl2 = flows;
                Collection collection2 = new LinkedHashSet();
                object = this;
                boolean $i$f$mapTo = false;
                for (Object item$iv : $this$mapTo$iv) {
                    PersistentFlow persistentFlow = (PersistentFlow)item$iv;
                    iterable2 = destination$iv2;
                    boolean bl3 = false;
                    TypeStatement typeStatement2 = ((PersistentFlow)((Object)it)).getTypeStatement(variable);
                    if (typeStatement2 == null) continue block1;
                    iterable2.add(typeStatement2);
                }
                typeStatement = ((LogicSystem)object).or((Collection<? extends TypeStatement>)destination$iv2);
            } else if (Intrinsics.areEqual($this$copyStatements.getAssignmentIndex$semantics().get(variable), commonFlow.getAssignmentIndex$semantics().get(variable))) {
                void $this$mapNotNullTo$iv;
                $this$mapTo$iv = flows;
                destination$iv2 = new LinkedHashSet();
                object = this;
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
                boolean $i$f$forEach2 = false;
                it = $this$forEach$iv$iv.iterator();
                while (it.hasNext()) {
                    TypeStatement it$iv;
                    Object element$iv$iv;
                    Object element$iv2 = element$iv$iv = it.next();
                    boolean bl4 = false;
                    PersistentFlow it2 = (PersistentFlow)element$iv2;
                    boolean bl5 = false;
                    if (it2.getTypeStatement(variable) == null) continue;
                    boolean bl6 = false;
                    destination$iv2.add(it$iv);
                }
                typeStatement = ((LogicSystem)object).and((Collection<? extends TypeStatement>)destination$iv2);
            } else {
                void $this$mapTo$iv2;
                Collection destination$iv3;
                Iterable $this$groupByTo$iv;
                destination$iv2 = flows;
                Map $i$f$mapNotNullTo = new LinkedHashMap();
                boolean $i$f$groupByTo = false;
                for (Object element$iv3 : $this$groupByTo$iv) {
                    Object object2;
                    PersistentFlow it3 = (PersistentFlow)element$iv3;
                    boolean bl7 = false;
                    Integer n = (Integer)it3.getAssignmentIndex$semantics().get(variable);
                    Integer key$iv = n != null ? n : -1;
                    void $this$getOrPut$iv$iv = destination$iv3;
                    boolean $i$f$getOrPut = false;
                    Object value$iv$iv = $this$getOrPut$iv$iv.get(key$iv);
                    if (value$iv$iv == null) {
                        boolean bl8 = false;
                        List answer$iv$iv = new ArrayList();
                        $this$getOrPut$iv$iv.put(key$iv, answer$iv$iv);
                        object2 = answer$iv$iv;
                    } else {
                        object2 = value$iv$iv;
                    }
                    List list$iv = (List)object2;
                    it3 = (PersistentFlow)element$iv3;
                    object = list$iv;
                    boolean bl9 = false;
                    object.add(it3.getTypeStatement(variable));
                }
                void byAssignment = destination$iv3;
                Integer n = (Integer)commonFlow.getAssignmentIndex$semantics().get(variable);
                byAssignment.remove(n != null ? n : -1);
                $this$groupByTo$iv = byAssignment.values();
                destination$iv3 = new LinkedHashSet();
                object = this;
                boolean $i$f$mapTo = false;
                for (Object item$iv : $this$mapTo$iv2) {
                    List it4 = (List)item$iv;
                    iterable2 = destination$iv3;
                    boolean bl10 = false;
                    TypeStatement typeStatement3 = this.and(CollectionsKt.filterNotNull((Iterable)it4));
                    if (typeStatement3 == null) continue block1;
                    iterable2.add(typeStatement3);
                }
                typeStatement = ((LogicSystem)object).or(destination$iv3);
            }
            TypeStatement typeStatement4 = statement = typeStatement;
            boolean bl11 = typeStatement4 != null ? typeStatement4.isNotEmpty() : false;
            if (!bl11) continue;
            ((Map)$this$copyStatements.getApprovedTypeStatements$semantics()).put(variable, LogicSystemKt.access$toPersistent(statement));
        }
    }

    private final void copyImplications(MutableFlow $this$copyImplications, Collection<PersistentFlow> flows) {
        switch (flows.size()) {
            case 0: {
                break;
            }
            case 1: {
                ((Map)$this$copyImplications.getImplications$semantics()).putAll((Map)((PersistentFlow)CollectionsKt.first((Iterable)flows)).getImplications$semantics());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void replaceVariable(MutableFlow $this$replaceVariable, RealVariable variable, RealVariable replacement) {
        RealVariable original = (RealVariable)$this$replaceVariable.getDirectAliasMap$semantics().remove(variable);
        if (original != null) {
            PersistentSet siblings2;
            if (AbstractTypeChecker.RUN_SLOW_ASSERTIONS) {
                boolean bl;
                boolean bl2 = bl = !((Map)$this$replaceVariable.getBackwardsAliasMap$semantics()).containsKey(variable);
                if (_Assertions.ENABLED && !bl) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                boolean bl3 = bl = !((Map)$this$replaceVariable.getImplications$semantics()).containsKey(variable);
                if (_Assertions.ENABLED && !bl) {
                    String string3 = "Assertion failed";
                    throw new AssertionError((Object)string3);
                }
                boolean bl4 = bl = !((Map)$this$replaceVariable.getApprovedTypeStatements$semantics()).containsKey(variable);
                if (_Assertions.ENABLED && !bl) {
                    String string4 = "Assertion failed";
                    throw new AssertionError((Object)string4);
                }
            }
            if ((siblings2 = (PersistentSet)MapsKt.getValue((Map)$this$replaceVariable.getBackwardsAliasMap$semantics(), (Object)original)).size() > 1) {
                ((Map)$this$replaceVariable.getBackwardsAliasMap$semantics()).put(original, siblings2.remove(variable));
            } else {
                $this$replaceVariable.getBackwardsAliasMap$semantics().remove(original);
            }
            if (replacement != null) {
                this.addLocalVariableAlias($this$replaceVariable, replacement, original);
            }
        } else {
            PersistentSet aliases = (PersistentSet)$this$replaceVariable.getBackwardsAliasMap$semantics().remove(variable);
            RealVariable realVariable = replacement;
            if (realVariable == null) {
                PersistentSet persistentSet = aliases;
                realVariable = persistentSet != null ? (RealVariable)CollectionsKt.first((Iterable)persistentSet) : null;
            }
            RealVariable replacementOrNext = realVariable;
            this.getVariableStorage().replaceReceiverReferencesInMembers(variable, replacementOrNext, (Function2<? super RealVariable, ? super RealVariable, Unit>)((Function2)(arg_0, arg_1) -> LogicSystem.replaceVariable$lambda$13(this, $this$replaceVariable, arg_0, arg_1)));
            LogicSystemKt.access$replaceVariableInImplications($this$replaceVariable.getImplications$semantics(), variable, replacementOrNext);
            LogicSystemKt.access$replaceVariableInStatements($this$replaceVariable.getApprovedTypeStatements$semantics(), variable, replacementOrNext);
            if (aliases != null && replacementOrNext != null) {
                ((Map)$this$replaceVariable.getDirectAliasMap$semantics()).remove(replacementOrNext);
                Iterable $this$minus$iv = aliases;
                boolean $i$f$minus = false;
                PersistentSet<RealVariable> withoutSelf = $this$minus$iv.remove(replacementOrNext);
                if (!((Collection)withoutSelf).isEmpty()) {
                    void $this$associateWithTo$iv;
                    $this$minus$iv = withoutSelf;
                    Map destination$iv = $this$replaceVariable.getDirectAliasMap$semantics();
                    boolean $i$f$associateWithTo = false;
                    for (Object element$iv : $this$associateWithTo$iv) {
                        RealVariable realVariable2 = (RealVariable)element$iv;
                        Object t = element$iv;
                        Map map = destination$iv;
                        boolean bl = false;
                        RealVariable realVariable3 = replacementOrNext;
                        map.put(t, realVariable3);
                    }
                    Map map = $this$replaceVariable.getBackwardsAliasMap$semantics();
                    PersistentSet<RealVariable> persistentSet = (PersistentSet<RealVariable>)$this$replaceVariable.getBackwardsAliasMap$semantics().get(replacementOrNext);
                    if (persistentSet == null || (persistentSet = persistentSet.addAll((Collection<RealVariable>)withoutSelf)) == null) {
                        persistentSet = withoutSelf;
                    }
                    PersistentSet<RealVariable> persistentSet2 = persistentSet;
                    map.put(replacementOrNext, persistentSet2);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Map<RealVariable, TypeStatement> approveOperationStatement(Map<DataFlowVariable, ? extends PersistentList<Implication>> logicStatements, OperationStatement approvedStatement, boolean removeApprovedOrImpossible) {
        LinkedList linkedList;
        Map result2 = new LinkedHashMap();
        LinkedList $this$approveOperationStatement_u24lambda_u2415 = linkedList = new LinkedList();
        boolean bl = false;
        ((Collection)$this$approveOperationStatement_u24lambda_u2415).add(approvedStatement);
        LinkedList queue = linkedList;
        Set approved = new LinkedHashSet();
        while (!((Collection)queue).isEmpty()) {
            PersistentList<Implication> statements;
            PersistentList<Implication> stillUnknown;
            OperationStatement next2 = (OperationStatement)queue.removeFirst();
            if (!removeApprovedOrImpossible) {
                Intrinsics.checkNotNull((Object)next2);
                if (!approved.add(next2)) continue;
            }
            Operation operation = next2.getOperation();
            DataFlowVariable variable = next2.getVariable();
            if (ModelKt.isReal(variable)) {
                Object object;
                void $this$getOrPut$iv;
                ConeClassLikeType impliedType = operation == Operation.EqNull ? this.nullableNothingType : this.anyType;
                Map map = result2;
                DataFlowVariable key$iv = variable;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl2 = false;
                    MutableTypeStatement answer$iv = new MutableTypeStatement((RealVariable)variable, null, 2, null);
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ((MutableTypeStatement)object).getExactType().add(impliedType);
            }
            if (logicStatements.get(variable) == null || Intrinsics.areEqual(stillUnknown = statements.removeAll((Function1<Implication, Boolean>)((Function1)arg_0 -> LogicSystem.approveOperationStatement$lambda$18(operation, queue, this, result2, removeApprovedOrImpossible, arg_0))), statements) || !TypeIntrinsics.isMutableMap(logicStatements)) continue;
            if (stillUnknown.isEmpty()) {
                logicStatements.remove(variable);
                continue;
            }
            logicStatements.put(variable, stillUnknown);
        }
        return result2;
    }

    @NotNull
    public final Map<RealVariable, TypeStatement> orForTypeStatements(@NotNull Map<RealVariable, ? extends TypeStatement> left, @NotNull Map<RealVariable, ? extends TypeStatement> right) {
        Map map;
        Intrinsics.checkNotNullParameter(left, (String)"left");
        Intrinsics.checkNotNullParameter(right, (String)"right");
        if (left.isEmpty()) {
            map = left;
        } else if (right.isEmpty()) {
            map = right;
        } else {
            Map map2;
            Map $this$orForTypeStatements_u24lambda_u2419 = map2 = MapsKt.createMapBuilder();
            boolean bl = false;
            for (Map.Entry<RealVariable, TypeStatement> entry : left.entrySet()) {
                RealVariable variable = entry.getKey();
                TypeStatement leftStatement = entry.getValue();
                Object[] objectArray = new TypeStatement[2];
                objectArray[0] = leftStatement;
                if (right.get(variable) == null) continue;
                objectArray[1] = objectArray[1];
                TypeStatement typeStatement = this.or(CollectionsKt.listOf((Object[])objectArray));
                if (typeStatement == null) continue;
                $this$orForTypeStatements_u24lambda_u2419.put(variable, typeStatement);
            }
            map = MapsKt.build((Map)map2);
        }
        return map;
    }

    @NotNull
    public final Map<RealVariable, TypeStatement> andForTypeStatements(@NotNull Map<RealVariable, ? extends TypeStatement> left, @NotNull Map<RealVariable, ? extends TypeStatement> right) {
        Map map;
        Intrinsics.checkNotNullParameter(left, (String)"left");
        Intrinsics.checkNotNullParameter(right, (String)"right");
        if (left.isEmpty()) {
            map = right;
        } else if (right.isEmpty()) {
            map = left;
        } else {
            Map map2;
            Map $this$andForTypeStatements_u24lambda_u2420 = map2 = MapsKt.toMutableMap(left);
            boolean bl = false;
            for (Map.Entry<RealVariable, TypeStatement> entry : right.entrySet()) {
                RealVariable variable = entry.getKey();
                TypeStatement rightStatement = entry.getValue();
                $this$andForTypeStatements_u24lambda_u2420.put(variable, this.and((TypeStatement)$this$andForTypeStatements_u24lambda_u2420.get(variable), rightStatement));
            }
            map = map2;
        }
        return map;
    }

    private final void plusAssign(MutableTypeStatement $this$plusAssign, TypeStatement other) {
        Intrinsics.checkNotNullParameter((Object)$this$plusAssign, (String)"<this>");
        CollectionsKt.addAll((Collection)$this$plusAssign.getExactType(), (Iterable)other.getExactType());
    }

    @NotNull
    public final TypeStatement and(@Nullable TypeStatement a, @NotNull TypeStatement b) {
        TypeStatement typeStatement;
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        TypeStatement typeStatement2 = a;
        if (typeStatement2 != null && (typeStatement2 = LogicSystemKt.access$toMutable(typeStatement2)) != null) {
            TypeStatement typeStatement3;
            TypeStatement $this$and_u24lambda_u2421 = typeStatement3 = typeStatement2;
            boolean bl = false;
            this.plusAssign((MutableTypeStatement)$this$and_u24lambda_u2421, b);
            typeStatement = typeStatement3;
        } else {
            typeStatement = b;
        }
        return typeStatement;
    }

    @Nullable
    public final TypeStatement and(@NotNull Collection<? extends TypeStatement> statements) {
        Intrinsics.checkNotNullParameter(statements, (String)"statements");
        switch (statements.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (TypeStatement)CollectionsKt.first((Iterable)statements);
            }
        }
        Iterator<? extends TypeStatement> iterator2 = statements.iterator();
        MutableTypeStatement result2 = LogicSystemKt.access$toMutable(iterator2.next());
        while (iterator2.hasNext()) {
            this.plusAssign(result2, iterator2.next());
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final TypeStatement or(@NotNull Collection<? extends TypeStatement> statements) {
        ConeKotlinType coneKotlinType;
        void $this$mapTo$iv$iv;
        boolean bl;
        Object element$iv2;
        RealVariable variable;
        block19: {
            boolean $this$all$iv2;
            TypeStatement it;
            block18: {
                boolean bl2;
                Intrinsics.checkNotNullParameter(statements, (String)"statements");
                switch (statements.size()) {
                    case 0: {
                        return null;
                    }
                    case 1: {
                        return (TypeStatement)CollectionsKt.first((Iterable)statements);
                    }
                }
                variable = ((TypeStatement)CollectionsKt.first((Iterable)statements)).getVariable();
                Iterable $this$all$iv2 = statements;
                boolean $i$f$all = false;
                if (((Collection)$this$all$iv2).isEmpty()) {
                    bl2 = true;
                } else {
                    for (Object element$iv2 : $this$all$iv2) {
                        it = (TypeStatement)element$iv2;
                        boolean bl3 = false;
                        if (Intrinsics.areEqual((Object)it.getVariable(), (Object)variable)) continue;
                        bl2 = false;
                        break block18;
                    }
                    bl2 = $this$all$iv2 = true;
                }
            }
            if (_Assertions.ENABLED && !$this$all$iv2) {
                boolean $i$a$-assert-LogicSystem$or$32 = false;
                String $i$a$-assert-LogicSystem$or$32 = "folding statements for different variables";
                throw new AssertionError((Object)$i$a$-assert-LogicSystem$or$32);
            }
            Iterable $this$any$iv = statements;
            boolean $i$f$any = false;
            if (((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv2 : $this$any$iv) {
                    it = (TypeStatement)element$iv2;
                    boolean bl4 = false;
                    if (!it.isEmpty()) continue;
                    bl = true;
                    break block19;
                }
                bl = false;
            }
        }
        if (bl) {
            return null;
        }
        Iterable $this$map$iv = statements;
        boolean $i$f$map = false;
        element$iv2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TypeStatement typeStatement = (TypeStatement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl5 = false;
            collection.add(ConeTypeIntersector.INSTANCE.intersectTypes(this.context, CollectionsKt.toList((Iterable)it.getExactType())));
        }
        List intersected = (List)destination$iv$iv;
        ConeKotlinType coneKotlinType2 = TypeUtilsKt.commonSuperTypeOrNull(this.context, intersected);
        if (coneKotlinType2 == null) {
            return null;
        }
        ConeKotlinType unified = coneKotlinType2;
        if (ConeBuiltinTypeUtilsKt.isNullableAny(unified)) {
            return null;
        }
        if (this.isAcceptableForSmartcast(unified)) {
            coneKotlinType = unified;
        } else {
            if (TypeUtilsKt.canBeNull(unified, this.context.getSession())) {
                return null;
            }
            coneKotlinType = this.context.anyType();
        }
        ConeKotlinType result2 = coneKotlinType;
        ConeKotlinType[] coneKotlinTypeArray = new ConeKotlinType[]{result2};
        return new PersistentTypeStatement(variable, ExtensionsKt.persistentSetOf(coneKotlinTypeArray));
    }

    private static final Implication translateVariableFromConditionInStatements$lambda$3(Implication it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it;
    }

    private static final Unit replaceVariable$lambda$13(LogicSystem this$0, MutableFlow $this_replaceVariable, RealVariable old, RealVariable realVariable) {
        Intrinsics.checkNotNullParameter((Object)old, (String)"old");
        this$0.replaceVariable($this_replaceVariable, old, realVariable);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean approveOperationStatement$lambda$18(Operation $operation, LinkedList $queue, LogicSystem this$0, Map $result, boolean $removeApprovedOrImpossible, Implication it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Boolean knownValue = it.getCondition().getOperation().valueIfKnown($operation);
        if (Intrinsics.areEqual((Object)knownValue, (Object)true)) {
            Statement effect = it.getEffect();
            if (effect instanceof OperationStatement) {
                ((Collection)$queue).add(effect);
            } else if (effect instanceof TypeStatement) {
                Object object;
                void $this$getOrPut$iv;
                LogicSystem logicSystem2 = this$0;
                Map map = $result;
                RealVariable key$iv = ((TypeStatement)effect).getVariable();
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    LogicSystem logicSystem3 = logicSystem2;
                    boolean bl = false;
                    logicSystem2 = logicSystem3;
                    MutableTypeStatement answer$iv = new MutableTypeStatement(((TypeStatement)effect).getVariable(), null, 2, null);
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                logicSystem2.plusAssign((MutableTypeStatement)object, (TypeStatement)effect);
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return $removeApprovedOrImpossible && knownValue != null;
    }
}

