/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.extended;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKt;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.expressions.FirLiteralExpression;
import org.jetbrains.kotlin.types.ConstantValueKind;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/extended/RedundantInterpolationPrefixCheckerLiteral;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirLiteralExpression;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirLiteralExpressionChecker;", "<init>", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
public final class RedundantInterpolationPrefixCheckerLiteral
extends FirExpressionChecker<FirLiteralExpression> {
    @NotNull
    public static final RedundantInterpolationPrefixCheckerLiteral INSTANCE = new RedundantInterpolationPrefixCheckerLiteral();

    private RedundantInterpolationPrefixCheckerLiteral() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirLiteralExpression expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        String prefix = expression2.getPrefix();
        if (Intrinsics.areEqual((Object)expression2.getKind(), (Object)ConstantValueKind.String.INSTANCE) && !((charSequence = (CharSequence)prefix) == null || charSequence.length() == 0)) {
            CharSequence charSequence2 = KtSourceElementKt.getText(expression2.getSource());
            if (charSequence2 == null || (charSequence2 = StringsKt.drop((CharSequence)charSequence2, (int)prefix.length())) == null) {
                return;
            }
            CharSequence value2 = charSequence2;
            if (!new Regex("[^\\\\]\\$(\\w|\\{|`[^`])").containsMatchIn(value2)) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getREDUNDANT_INTERPOLATION_PREFIX(), (DiagnosticContext)context2, null, 8, null);
            }
        }
    }
}

