/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.core.CoreBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginLoadingError;
import com.intellij.ide.plugins.PluginLoadingResultKt;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.util.PlatformUtils;
import com.intellij.util.text.VersionComparatorUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010$\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0016\u0010 \u001a\u00020\u001b2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\t0\u000bH\u0007J$\u0010 \u001a\u00020\u001b2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\t0\"2\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u001fJ\u001a\u0010#\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020\t2\b\u0010%\u001a\u0004\u0018\u00010\u0017H\u0002J\u0018\u0010&\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\t2\u0006\u0010'\u001a\u00020\u0007H\u0002J\u0019\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00170\u0006H\u0000\u00a2\u0006\u0002\b)J\u0012\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\t0+J\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\t0+R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0005\u001a\u0016\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b\u0018\u00010\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000b8G\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR,\u0010\u000e\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\t0\u000fj\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\t`\u00108\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u00038G\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R*\u0010\u0014\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\t0\u000fj\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\t`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0015\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\t0\u000fj\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\t`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0016\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00170\u000fj\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0017`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00070\u00198\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/intellij/ide/plugins/PluginLoadingResult;", "", "checkModuleDependencies", "", "(Z)V", "duplicateModuleMap", "", "Lcom/intellij/openapi/extensions/PluginId;", "", "Lcom/intellij/ide/plugins/IdeaPluginDescriptorImpl;", "enabledPlugins", "", "getEnabledPlugins", "()Ljava/util/List;", "enabledPluginsById", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "hasPluginErrors", "getHasPluginErrors", "()Z", "idMap", "incompletePlugins", "pluginErrors", "Lcom/intellij/ide/plugins/PluginLoadingError;", "shadowedBundledIds", "", "add", "", "descriptor", "overrideUseIfCompatible", "productBuildNumber", "Lcom/intellij/openapi/util/BuildNumber;", "addAll", "descriptors", "Lkotlin/sequences/Sequence;", "addIncompletePlugin", "plugin", "error", "checkAndAdd", "id", "copyPluginErrors", "copyPluginErrors$intellij_platform_core_impl", "getIdMap", "", "getIncompleteIdMap", "intellij.platform.core.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nPluginLoadingResult.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PluginLoadingResult.kt\ncom/intellij/ide/plugins/PluginLoadingResult\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,165:1\n1045#2:166\n1549#2:167\n1620#2,3:168\n1#3:171\n*S KotlinDebug\n*F\n+ 1 PluginLoadingResult.kt\ncom/intellij/ide/plugins/PluginLoadingResult\n*L\n37#1:166\n37#1:167\n37#1:168,3\n*E\n"})
public final class PluginLoadingResult {
    private final boolean checkModuleDependencies;
    @NotNull
    private final HashMap<PluginId, IdeaPluginDescriptorImpl> incompletePlugins;
    @JvmField
    @NotNull
    public final HashMap<PluginId, IdeaPluginDescriptorImpl> enabledPluginsById;
    @NotNull
    private final HashMap<PluginId, IdeaPluginDescriptorImpl> idMap;
    @JvmField
    @Nullable
    public Map<PluginId, List<IdeaPluginDescriptorImpl>> duplicateModuleMap;
    @NotNull
    private final HashMap<PluginId, PluginLoadingError> pluginErrors;
    @VisibleForTesting
    @JvmField
    @NotNull
    public final Set<PluginId> shadowedBundledIds;

    public PluginLoadingResult(boolean checkModuleDependencies) {
        this.checkModuleDependencies = checkModuleDependencies;
        this.incompletePlugins = new HashMap();
        this.enabledPluginsById = new HashMap();
        this.idMap = new HashMap();
        this.pluginErrors = new HashMap();
        this.shadowedBundledIds = new HashSet();
    }

    public /* synthetic */ PluginLoadingResult(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = !PlatformUtils.isIntelliJ();
        }
        this(bl);
    }

    @TestOnly
    public final boolean getHasPluginErrors() {
        return !this.pluginErrors.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    @TestOnly
    @NotNull
    public final List<IdeaPluginDescriptorImpl> getEnabledPlugins() {
        void $this$mapTo$iv$iv;
        Set<Map.Entry<PluginId, IdeaPluginDescriptorImpl>> set = this.enabledPluginsById.entrySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-entries>(...)");
        Iterable $this$sortedBy$iv = set;
        boolean $i$f$sortedBy = false;
        Iterable $this$map$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)a;
                boolean bl = false;
                Comparable comparable = (PluginId)it.getKey();
                it = (Map.Entry)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((PluginId)it.getKey()));
            }
        });
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Map.Entry entry = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((IdeaPluginDescriptorImpl)it.getValue());
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final Map<PluginId, PluginLoadingError> copyPluginErrors$intellij_platform_core_impl() {
        return new HashMap(this.pluginErrors);
    }

    @NotNull
    public final Map<PluginId, IdeaPluginDescriptorImpl> getIncompleteIdMap() {
        return this.incompletePlugins;
    }

    @NotNull
    public final Map<PluginId, IdeaPluginDescriptorImpl> getIdMap() {
        return this.idMap;
    }

    private final void addIncompletePlugin(IdeaPluginDescriptorImpl plugin, PluginLoadingError error) {
        if (this.idMap.containsKey(plugin.getPluginId())) {
            return;
        }
        IdeaPluginDescriptorImpl existingIncompletePlugin = this.incompletePlugins.putIfAbsent(plugin.getPluginId(), plugin);
        if (existingIncompletePlugin != null && VersionComparatorUtil.compare(plugin.getVersion(), existingIncompletePlugin.getVersion()) > 0) {
            this.incompletePlugins.put(plugin.getPluginId(), plugin);
            if (error != null) {
                this.pluginErrors.put(plugin.getPluginId(), error);
            }
        } else if (error != null) {
            this.pluginErrors.putIfAbsent(plugin.getPluginId(), error);
        }
    }

    public final void addAll(@NotNull Sequence<IdeaPluginDescriptorImpl> descriptors, boolean overrideUseIfCompatible, @NotNull BuildNumber productBuildNumber) {
        Intrinsics.checkNotNullParameter(descriptors, (String)"descriptors");
        Intrinsics.checkNotNullParameter((Object)productBuildNumber, (String)"productBuildNumber");
        for (IdeaPluginDescriptorImpl descriptor2 : descriptors) {
            this.add(descriptor2, overrideUseIfCompatible, productBuildNumber);
        }
    }

    @TestOnly
    public final void addAll(@NotNull List<IdeaPluginDescriptorImpl> descriptors) {
        Intrinsics.checkNotNullParameter(descriptors, (String)"descriptors");
        BuildNumber buildNumber = BuildNumber.fromString("2042.42");
        Intrinsics.checkNotNull((Object)buildNumber);
        BuildNumber productBuildNumber = buildNumber;
        for (IdeaPluginDescriptorImpl descriptor2 : descriptors) {
            this.add(descriptor2, false, productBuildNumber);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void add(IdeaPluginDescriptorImpl descriptor2, boolean overrideUseIfCompatible, BuildNumber productBuildNumber) {
        PluginId pluginId = descriptor2.getPluginId();
        PluginLoadingError pluginLoadingError = descriptor2.isIncomplete;
        if (pluginLoadingError != null) {
            void it;
            PluginLoadingError pluginLoadingError2;
            PluginLoadingError error = pluginLoadingError;
            boolean bl = false;
            PluginLoadingError pluginLoadingError3 = pluginLoadingError2 = error;
            IdeaPluginDescriptorImpl ideaPluginDescriptorImpl = descriptor2;
            PluginLoadingResult pluginLoadingResult = this;
            boolean bl2 = false;
            boolean bl3 = !it.isDisabledError$intellij_platform_core_impl();
            pluginLoadingResult.addIncompletePlugin(ideaPluginDescriptorImpl, bl3 ? pluginLoadingError2 : null);
            return;
        }
        if (this.checkModuleDependencies && !descriptor2.isBundled() && descriptor2.packagePrefix == null && !PluginLoadingResultKt.hasModuleDependencies(descriptor2)) {
            this.addIncompletePlugin(descriptor2, new PluginLoadingError(descriptor2, () -> PluginLoadingResult.add$lambda$4(descriptor2), PluginLoadingResult::add$lambda$5, true, null, 16, null));
            return;
        }
        this.pluginErrors.remove(pluginId);
        this.incompletePlugins.remove(pluginId);
        IdeaPluginDescriptorImpl prevDescriptor = this.enabledPluginsById.put(pluginId, descriptor2);
        if (prevDescriptor == null) {
            this.idMap.put(pluginId, descriptor2);
            for (PluginId module2 : descriptor2.modules) {
                this.checkAndAdd(descriptor2, module2);
            }
            return;
        }
        if (prevDescriptor.isBundled() || descriptor2.isBundled()) {
            this.shadowedBundledIds.add(pluginId);
        }
        if (PluginManagerCore.checkBuildNumberCompatibility(descriptor2, productBuildNumber) == null && (overrideUseIfCompatible || VersionComparatorUtil.compare(descriptor2.getVersion(), prevDescriptor.getVersion()) > 0)) {
            PluginManagerCore.getLogger().info(descriptor2 + " overrides " + prevDescriptor);
            this.idMap.put(pluginId, descriptor2);
            return;
        }
        this.enabledPluginsById.put(pluginId, prevDescriptor);
    }

    private final void checkAndAdd(IdeaPluginDescriptorImpl descriptor2, PluginId id) {
        Map<PluginId, List<IdeaPluginDescriptorImpl>> map = this.duplicateModuleMap;
        if (map != null && (map = map.get(id)) != null) {
            Map<PluginId, List<IdeaPluginDescriptorImpl>> duplicates = map;
            boolean bl = false;
            duplicates.add(descriptor2);
            return;
        }
        IdeaPluginDescriptorImpl ideaPluginDescriptorImpl = this.idMap.put(id, descriptor2);
        if (ideaPluginDescriptorImpl == null) {
            return;
        }
        IdeaPluginDescriptorImpl existingDescriptor = ideaPluginDescriptorImpl;
        this.idMap.remove(id);
        if (this.duplicateModuleMap == null) {
            this.duplicateModuleMap = new LinkedHashMap();
        }
        ArrayList<IdeaPluginDescriptorImpl> list = new ArrayList<IdeaPluginDescriptorImpl>(2);
        list.add(existingDescriptor);
        list.add(descriptor2);
        Map<PluginId, List<IdeaPluginDescriptorImpl>> map2 = this.duplicateModuleMap;
        Intrinsics.checkNotNull(map2);
        map2.put(id, list);
    }

    private static final String add$lambda$4(IdeaPluginDescriptorImpl $descriptor) {
        Intrinsics.checkNotNullParameter((Object)$descriptor, (String)"$descriptor");
        Object[] objectArray = new Object[]{$descriptor.getName()};
        return CoreBundle.message("plugin.loading.error.long.compatible.with.intellij.idea.only", objectArray);
    }

    private static final String add$lambda$5() {
        return CoreBundle.message("plugin.loading.error.short.compatible.with.intellij.idea.only", new Object[0]);
    }

    public PluginLoadingResult() {
        this(false, 1, null);
    }
}

