/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.syntax;

import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.KtRealSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.config.AnalysisFlags;
import org.jetbrains.kotlin.config.ExplicitApiMode;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.EffectiveVisibility;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.FirSourceUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.syntax.FirDeclarationSyntaxChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirResolvedDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.impl.FirPrimaryConstructor;
import org.jetbrains.kotlin.fir.resolve.transformers.PublishedApiEffectiveVisibilityKt;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtDeclaration;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J0\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J(\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J0\u0010\u0017\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u001b\u001a\u00020\u00192\u0006\u0010\r\u001a\u00020\u001c2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u001c\u0010\u0005\u001a\u0010\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/syntax/FirExplicitApiDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/syntax/FirDeclarationSyntaxChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "()V", "codeFragmentTypes", "", "Lcom/intellij/psi/tree/IFileElementType;", "kotlin.jvm.PlatformType", "checkExplicitReturnType", "", "state", "Lorg/jetbrains/kotlin/config/ExplicitApiMode;", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkPsiOrLightTree", "element", "checkVisibilityModifier", "explicitVisibilityIsNotRequired", "", "returnTypeCheckIsApplicable", "returnTypeRequired", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirExplicitApiDeclarationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirExplicitApiDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/syntax/FirExplicitApiDeclarationChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,153:1\n28#2:154\n28#2:155\n68#2:156\n40#2:157\n*S KotlinDebug\n*F\n+ 1 FirExplicitApiDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/syntax/FirExplicitApiDeclarationChecker\n*L\n49#1:154\n51#1:155\n99#1:156\n105#1:157\n*E\n"})
public final class FirExplicitApiDeclarationChecker
extends FirDeclarationSyntaxChecker<FirDeclaration, KtDeclaration> {
    @NotNull
    public static final FirExplicitApiDeclarationChecker INSTANCE = new FirExplicitApiDeclarationChecker();
    @NotNull
    private static final Set<IFileElementType> codeFragmentTypes;

    private FirExplicitApiDeclarationChecker() {
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void checkPsiOrLightTree(@NotNull FirDeclaration element, @NotNull KtSourceElement source, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (!(source.getKind() instanceof KtRealSourceElementKind) && !Intrinsics.areEqual((Object)source.getKind(), (Object)KtFakeSourceElementKind.PropertyFromParameter.INSTANCE) || !(element instanceof FirMemberDeclaration)) {
            return;
        }
        state = context.getLanguageVersionSettings().getFlag(AnalysisFlags.getExplicitApiMode());
        if (state == ExplicitApiMode.DISABLED) {
            return;
        }
        if (element instanceof FirEnumEntry) {
            return;
        }
        $this$effectiveVisibility$iv = (FirMemberDeclaration)element;
        $i$f$getEffectiveVisibility = false;
        var8_8 = $this$effectiveVisibility$iv.getStatus();
        v0 = var8_8 instanceof FirResolvedDeclarationStatus != false ? (FirResolvedDeclarationStatus)var8_8 : null;
        if (v0 == null || (v0 = v0.getEffectiveVisibility()) == null) {
            v0 = EffectiveVisibility.Local.INSTANCE;
        }
        if (!v0.getPublicApi() && PublishedApiEffectiveVisibilityKt.getPublishedApiEffectiveVisibility(element) == null) {
            return;
        }
        lastContainingDeclaration = (FirDeclaration)CollectionsKt.lastOrNull(context.getContainingDeclarations());
        v1 = lastContainingDeclaration instanceof FirMemberDeclaration != false ? (FirMemberDeclaration)lastContainingDeclaration : null;
        if (v1 == null) ** GOTO lbl-1000
        $this$effectiveVisibility$iv = v1;
        $i$f$getEffectiveVisibility = false;
        var11_11 = $this$effectiveVisibility$iv.getStatus();
        v2 = var11_11 instanceof FirResolvedDeclarationStatus != false ? (FirResolvedDeclarationStatus)var11_11 : null;
        if (v2 == null || (v2 = v2.getEffectiveVisibility()) == null) {
            v2 = v1 = (EffectiveVisibility)EffectiveVisibility.Local.INSTANCE;
        }
        if (v2 != null) {
            v3 = !v1.getPublicApi();
        } else lbl-1000:
        // 2 sources

        {
            v3 = false;
        }
        if (v3) {
            return;
        }
        this.checkVisibilityModifier(state, (FirMemberDeclaration)element, source, context, reporter);
        this.checkExplicitReturnType(state, (FirMemberDeclaration)element, source, context, reporter);
    }

    private final void checkVisibilityModifier(ExplicitApiMode state, FirMemberDeclaration declaration2, KtSourceElement source, CheckerContext context2, DiagnosticReporter reporter) {
        KtSourceElement visibilityModifier;
        KtSourceElement ktSourceElement;
        IElementType iElementType = KtNodeTypes.MODIFIER_LIST;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"MODIFIER_LIST");
        KtSourceElement ktSourceElement2 = FirSourceUtilsKt.getChild$default(source, iElementType, 0, 1, false, 10, null);
        if (ktSourceElement2 != null) {
            TokenSet tokenSet = KtTokens.VISIBILITY_MODIFIERS;
            Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"VISIBILITY_MODIFIERS");
            ktSourceElement = FirSourceUtilsKt.getChild$default(ktSourceElement2, tokenSet, 0, 0, false, 14, null);
        } else {
            ktSourceElement = visibilityModifier = null;
        }
        if (visibilityModifier != null) {
            return;
        }
        if (this.explicitVisibilityIsNotRequired(declaration2, context2)) {
            return;
        }
        KtDiagnosticFactory0 factory2 = state == ExplicitApiMode.STRICT ? FirErrors.INSTANCE.getNO_EXPLICIT_VISIBILITY_IN_API_MODE() : FirErrors.INSTANCE.getNO_EXPLICIT_VISIBILITY_IN_API_MODE_WARNING();
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, factory2, (DiagnosticContext)context2, null, 8, null);
    }

    private final boolean explicitVisibilityIsNotRequired(FirMemberDeclaration declaration2, CheckerContext context2) {
        boolean bl;
        FirMemberDeclaration firMemberDeclaration = declaration2;
        if (((firMemberDeclaration instanceof FirPrimaryConstructor ? true : firMemberDeclaration instanceof FirPropertyAccessor) ? true : firMemberDeclaration instanceof FirValueParameter) ? true : firMemberDeclaration instanceof FirAnonymousFunction) {
            bl = true;
        } else if (firMemberDeclaration instanceof FirCallableDeclaration) {
            FirRegularClass containingClass;
            Object object = CollectionsKt.lastOrNull(context2.getContainingDeclarations());
            FirRegularClass firRegularClass = containingClass = object instanceof FirRegularClass ? (FirRegularClass)object : null;
            if (declaration2 instanceof FirProperty && containingClass != null) {
                FirRegularClass $this$isData$iv = containingClass;
                boolean $i$f$isData = false;
                if ($this$isData$iv.getStatus().isData() || containingClass.getClassKind() == ClassKind.ANNOTATION_CLASS) {
                    return true;
                }
            }
            FirMemberDeclaration $this$isOverride$iv = declaration2;
            boolean $i$f$isOverride = false;
            bl = $this$isOverride$iv.getStatus().isOverride() || DeclarationUtilsKt.isLocalMember(declaration2);
        } else {
            bl = false;
        }
        return bl;
    }

    private final void checkExplicitReturnType(ExplicitApiMode state, FirMemberDeclaration declaration2, KtSourceElement source, CheckerContext context2, DiagnosticReporter reporter) {
        if (!(declaration2 instanceof FirCallableDeclaration)) {
            return;
        }
        if (!this.returnTypeCheckIsApplicable(source, context2)) {
            return;
        }
        boolean shouldReport = this.returnTypeRequired((FirCallableDeclaration)declaration2, context2);
        if (shouldReport) {
            KtDiagnosticFactory0 factory2 = state == ExplicitApiMode.STRICT ? FirErrors.INSTANCE.getNO_EXPLICIT_RETURN_TYPE_IN_API_MODE() : FirErrors.INSTANCE.getNO_EXPLICIT_RETURN_TYPE_IN_API_MODE_WARNING();
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, factory2, (DiagnosticContext)context2, null, 8, null);
        }
    }

    private final boolean returnTypeCheckIsApplicable(KtSourceElement source, CheckerContext context2) {
        boolean bl;
        IElementType iElementType = KtNodeTypes.TYPE_REFERENCE;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"TYPE_REFERENCE");
        if (FirSourceUtilsKt.getChild$default(source, iElementType, 0, 1, false, 10, null) != null) {
            return false;
        }
        FirDeclaration containingFile2 = (FirDeclaration)CollectionsKt.first(context2.getContainingDeclarations());
        KtSourceElement ktSourceElement = containingFile2.getSource();
        if (CollectionsKt.contains((Iterable)codeFragmentTypes, (Object)(ktSourceElement != null ? ktSourceElement.getElementType() : null))) {
            return false;
        }
        IElementType iElementType2 = source.getElementType();
        if (Intrinsics.areEqual((Object)iElementType2, (Object)KtNodeTypes.FUN)) {
            KtSingleValueToken ktSingleValueToken = KtTokens.EQ;
            Intrinsics.checkNotNullExpressionValue((Object)ktSingleValueToken, (String)"EQ");
            bl = FirSourceUtilsKt.getChild$default(source, ktSingleValueToken, 0, 1, false, 10, null) != null;
        } else {
            bl = Intrinsics.areEqual((Object)iElementType2, (Object)KtNodeTypes.PROPERTY);
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean returnTypeRequired(FirCallableDeclaration declaration2, CheckerContext context2) {
        if (DeclarationUtilsKt.isLocalMember(declaration2)) return false;
        FirDeclaration firDeclaration = (FirDeclaration)CollectionsKt.lastOrNull(context2.getContainingDeclarations());
        if (firDeclaration == null) return true;
        if (!DeclarationUtilsKt.isLocalMember(firDeclaration)) return true;
        return false;
    }

    static {
        Object[] objectArray = new IFileElementType[]{KtNodeTypes.BLOCK_CODE_FRAGMENT, KtNodeTypes.EXPRESSION_CODE_FRAGMENT, KtNodeTypes.TYPE_CODE_FRAGMENT};
        codeFragmentTypes = SetsKt.setOf((Object[])objectArray);
    }
}

