/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.ConstantArgumentKind;
import org.jetbrains.kotlin.fir.analysis.checkers.FirConstCheckVisitor;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeSimpleKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u001a\u0010\u0006\u001a\u00020\u00072\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\n\u0010\b\u001a\u00020\u0001*\u00020\t\u00a8\u0006\n"}, d2={"canBeEvaluatedAtCompileTime", "", "expression", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "checkConstantArguments", "Lorg/jetbrains/kotlin/fir/analysis/checkers/ConstantArgumentKind;", "canBeUsedForConstVal", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirConstChecks.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirConstChecks.kt\norg/jetbrains/kotlin/fir/analysis/checkers/FirConstChecksKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,367:1\n1#2:368\n*E\n"})
public final class FirConstChecksKt {
    public static final boolean canBeUsedForConstVal(@NotNull ConeKotlinType $this$canBeUsedForConstVal) {
        Intrinsics.checkNotNullParameter((Object)$this$canBeUsedForConstVal, (String)"<this>");
        ConeSimpleKotlinType $this$canBeUsedForConstVal_u24lambda_u240 = ConeTypeUtilsKt.lowerBoundIfFlexible($this$canBeUsedForConstVal);
        boolean bl = false;
        return ConeBuiltinTypeUtilsKt.isPrimitive($this$canBeUsedForConstVal_u24lambda_u240) || ConeBuiltinTypeUtilsKt.isString($this$canBeUsedForConstVal_u24lambda_u240) || ConeBuiltinTypeUtilsKt.isUnsignedType($this$canBeUsedForConstVal_u24lambda_u240);
    }

    public static final boolean canBeEvaluatedAtCompileTime(@Nullable FirExpression expression2, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        return FirConstChecksKt.checkConstantArguments(expression2, session2) == ConstantArgumentKind.VALID_CONST;
    }

    @NotNull
    public static final ConstantArgumentKind checkConstantArguments(@Nullable FirExpression expression2, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        if (expression2 == null) {
            return ConstantArgumentKind.VALID_CONST;
        }
        return (ConstantArgumentKind)((Object)expression2.accept(new FirConstCheckVisitor(session2), null));
    }
}

