/*
 * Decompiled with CFR 0.152.
 */
package javaslang.collection;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import javaslang.Function1;
import javaslang.Kind1;
import javaslang.Tuple;
import javaslang.Tuple2;
import javaslang.Tuple3;
import javaslang.collection.AbstractIterator;
import javaslang.collection.Collections;
import javaslang.collection.HashArrayMappedTrie;
import javaslang.collection.IndexedSeq;
import javaslang.collection.Iterator;
import javaslang.collection.LinearSeq;
import javaslang.collection.List;
import javaslang.collection.Map;
import javaslang.collection.VectorModule;
import javaslang.control.Option;
import javaslang.\u03bb;

public final class Vector<T>
implements Kind1<Vector<?>, T>,
IndexedSeq<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Vector<?> EMPTY = new Vector(HashArrayMappedTrie.empty());
    private final HashArrayMappedTrie<Integer, T> trie;
    private final int indexShift;

    private Vector(HashArrayMappedTrie<Integer, T> trie) {
        this(0, trie);
    }

    private Vector(int indexShift, HashArrayMappedTrie<Integer, T> trie) {
        this.trie = trie;
        this.indexShift = indexShift;
    }

    public static <T> Vector<T> empty() {
        return EMPTY;
    }

    public static <T> Collector<T, ArrayList<T>, Vector<T>> collector() {
        Supplier<ArrayList> supplier = ArrayList::new;
        BiConsumer<ArrayList, Object> accumulator = ArrayList::add;
        BinaryOperator combiner = (left, right) -> {
            left.addAll(right);
            return left;
        };
        Function<ArrayList, Vector> finisher = Vector::ofAll;
        return Collector.of(supplier, accumulator, combiner, finisher, new Collector.Characteristics[0]);
    }

    public static <T> Vector<T> narrow(Vector<? extends T> vector) {
        return vector;
    }

    public static <T> Vector<T> of(T element2) {
        return new Vector(HashArrayMappedTrie.empty().put(0, element2));
    }

    @SafeVarargs
    public static <T> Vector<T> of(T ... elements) {
        Objects.requireNonNull(elements, "elements is null");
        HashArrayMappedTrie<Integer, Object> result2 = HashArrayMappedTrie.empty();
        for (T element2 : elements) {
            result2 = result2.put(result2.size(), element2);
        }
        return Vector.wrap(result2);
    }

    public static <T> Vector<T> tabulate(int n, Function<? super Integer, ? extends T> f) {
        Objects.requireNonNull(f, "f is null");
        return Collections.tabulate(n, f, Vector.empty(), Vector::of);
    }

    public static <T> Vector<T> fill(int n, Supplier<? extends T> s) {
        Objects.requireNonNull(s, "s is null");
        return Collections.fill(n, s, Vector.empty(), Vector::of);
    }

    public static <T> Vector<T> ofAll(Iterable<? extends T> elements) {
        Objects.requireNonNull(elements, "elements is null");
        if (elements instanceof Vector) {
            return (Vector)elements;
        }
        HashArrayMappedTrie<Integer, Object> trie = HashArrayMappedTrie.empty();
        for (T element2 : elements) {
            trie = trie.put(trie.size(), element2);
        }
        return Vector.wrap(trie);
    }

    public static Vector<Boolean> ofAll(boolean[] array) {
        Objects.requireNonNull(array, "array is null");
        return Vector.ofAll(Iterator.ofAll(array));
    }

    public static Vector<Byte> ofAll(byte[] array) {
        Objects.requireNonNull(array, "array is null");
        return Vector.ofAll(Iterator.ofAll(array));
    }

    public static Vector<Character> ofAll(char[] array) {
        Objects.requireNonNull(array, "array is null");
        return Vector.ofAll(Iterator.ofAll(array));
    }

    public static Vector<Double> ofAll(double[] array) {
        Objects.requireNonNull(array, "array is null");
        return Vector.ofAll(Iterator.ofAll(array));
    }

    public static Vector<Float> ofAll(float[] array) {
        Objects.requireNonNull(array, "array is null");
        return Vector.ofAll(Iterator.ofAll(array));
    }

    public static Vector<Integer> ofAll(int[] array) {
        Objects.requireNonNull(array, "array is null");
        return Vector.ofAll(Iterator.ofAll(array));
    }

    public static Vector<Long> ofAll(long[] array) {
        Objects.requireNonNull(array, "array is null");
        return Vector.ofAll(Iterator.ofAll(array));
    }

    public static Vector<Short> ofAll(short[] array) {
        Objects.requireNonNull(array, "array is null");
        return Vector.ofAll(Iterator.ofAll(array));
    }

    public static Vector<Character> range(char from2, char toExclusive) {
        return Vector.ofAll(Iterator.range(from2, toExclusive));
    }

    public static Vector<Character> rangeBy(char from2, char toExclusive, int step) {
        return Vector.ofAll(Iterator.rangeBy(from2, toExclusive, step));
    }

    public static Vector<Double> rangeBy(double from2, double toExclusive, double step) {
        return Vector.ofAll(Iterator.rangeBy(from2, toExclusive, step));
    }

    public static Vector<Integer> range(int from2, int toExclusive) {
        return Vector.ofAll(Iterator.range(from2, toExclusive));
    }

    public static Vector<Integer> rangeBy(int from2, int toExclusive, int step) {
        return Vector.ofAll(Iterator.rangeBy(from2, toExclusive, step));
    }

    public static Vector<Long> range(long from2, long toExclusive) {
        return Vector.ofAll(Iterator.range(from2, toExclusive));
    }

    public static Vector<Long> rangeBy(long from2, long toExclusive, long step) {
        return Vector.ofAll(Iterator.rangeBy(from2, toExclusive, step));
    }

    public static Vector<Character> rangeClosed(char from2, char toInclusive) {
        return Vector.ofAll(Iterator.rangeClosed(from2, toInclusive));
    }

    public static Vector<Character> rangeClosedBy(char from2, char toInclusive, int step) {
        return Vector.ofAll(Iterator.rangeClosedBy(from2, toInclusive, step));
    }

    public static Vector<Double> rangeClosedBy(double from2, double toInclusive, double step) {
        return Vector.ofAll(Iterator.rangeClosedBy(from2, toInclusive, step));
    }

    public static Vector<Integer> rangeClosed(int from2, int toInclusive) {
        return Vector.ofAll(Iterator.rangeClosed(from2, toInclusive));
    }

    public static Vector<Integer> rangeClosedBy(int from2, int toInclusive, int step) {
        return Vector.ofAll(Iterator.rangeClosedBy(from2, toInclusive, step));
    }

    public static Vector<Long> rangeClosed(long from2, long toInclusive) {
        return Vector.ofAll(Iterator.rangeClosed(from2, toInclusive));
    }

    public static Vector<Long> rangeClosedBy(long from2, long toInclusive, long step) {
        return Vector.ofAll(Iterator.rangeClosedBy(from2, toInclusive, step));
    }

    @Override
    public Vector<T> append(T element2) {
        return new Vector<T>(this.indexShift, this.trie.put(this.length() + this.indexShift, element2));
    }

    @Override
    public Vector<T> appendAll(Iterable<? extends T> elements) {
        HashArrayMappedTrie<Integer, T> result2 = this.trie;
        for (T element2 : elements) {
            result2 = result2.put(result2.size() + this.indexShift, element2);
        }
        return new Vector<T>(this.indexShift, result2);
    }

    @Override
    public Vector<Vector<T>> combinations() {
        return ((Vector)Vector.rangeClosed(0, this.length()).map((T n) -> this.combinations((int)n))).flatMap(Function.identity());
    }

    @Override
    public Vector<Vector<T>> combinations(int k) {
        return VectorModule.Combinations.apply(this, Math.max(k, 0));
    }

    @Override
    public Iterator<Vector<T>> crossProduct(int power) {
        return Collections.crossProduct(Vector.empty(), this, power);
    }

    @Override
    public Vector<T> distinct() {
        return this.distinctBy(Function.identity());
    }

    @Override
    public Vector<T> distinctBy(Comparator<? super T> comparator) {
        Objects.requireNonNull(comparator, "comparator is null");
        TreeSet<? super T> seen = new TreeSet<T>(comparator);
        return this.filter(seen::add);
    }

    @Override
    public <U> Vector<T> distinctBy(Function<? super T, ? extends U> keyExtractor) {
        Objects.requireNonNull(keyExtractor, "keyExtractor is null");
        HashSet seen = new HashSet();
        return this.filter((T t) -> seen.add(keyExtractor.apply(t)));
    }

    @Override
    public Vector<T> drop(long n) {
        if (n <= 0L) {
            return this;
        }
        if (n >= (long)this.length()) {
            return Vector.empty();
        }
        HashArrayMappedTrie<Integer, Object> trie = HashArrayMappedTrie.empty();
        for (int i = (int)n; i < this.length(); ++i) {
            trie = trie.put(i - (int)n, this.get(i));
        }
        return Vector.wrap(trie);
    }

    @Override
    public Vector<T> dropRight(long n) {
        if (n <= 0L) {
            return this;
        }
        if (n >= (long)this.length()) {
            return Vector.empty();
        }
        HashArrayMappedTrie<Integer, Object> trie = HashArrayMappedTrie.empty();
        int i = 0;
        while ((long)i < (long)this.length() - n) {
            trie = trie.put(trie.size(), this.get(i));
            ++i;
        }
        return Vector.wrap(trie);
    }

    @Override
    public Vector<T> dropUntil(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        return this.dropWhile((Predicate)predicate.negate());
    }

    @Override
    public Vector<T> dropWhile(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        for (int i = 0; i < this.length(); ++i) {
            if (predicate.test(this.get(i))) continue;
            return this.drop(i);
        }
        return Vector.empty();
    }

    @Override
    public Vector<T> filter(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        HashArrayMappedTrie<Integer, Object> trie = HashArrayMappedTrie.empty();
        for (Object t : this) {
            if (!predicate.test(t)) continue;
            trie = trie.put(trie.size(), t);
        }
        if (trie.size() == this.length()) {
            return this;
        }
        return Vector.wrap(trie);
    }

    @Override
    public <U> Vector<U> flatMap(Function<? super T, ? extends Iterable<? extends U>> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        if (this.isEmpty()) {
            return Vector.empty();
        }
        HashArrayMappedTrie<Integer, Object> trie = HashArrayMappedTrie.empty();
        for (int i = 0; i < this.length(); ++i) {
            for (U u : mapper.apply(this.get(i))) {
                trie = trie.put(trie.size(), u);
            }
        }
        return Vector.wrap(trie);
    }

    @Override
    public T get(int index2) {
        if (index2 < 0 || index2 >= this.length()) {
            throw new IndexOutOfBoundsException("get(" + index2 + ")");
        }
        return this.trie.get(index2 + this.indexShift).get();
    }

    @Override
    public T head() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("head of empty vector");
        }
        return this.get(0);
    }

    @Override
    public <C> Map<C, Vector<T>> groupBy(Function<? super T, ? extends C> classifier) {
        Objects.requireNonNull(classifier, "classifier is null");
        return this.iterator().groupBy(classifier).map((? super K c, ? super V it) -> Tuple.of(c, Vector.ofAll(it)));
    }

    @Override
    public Iterator<Vector<T>> grouped(long size) {
        return this.sliding(size, size);
    }

    @Override
    public boolean hasDefiniteSize() {
        return true;
    }

    @Override
    public int indexOf(T element2, int from2) {
        for (int i = from2; i < this.length(); ++i) {
            if (!Objects.equals(this.get(i), element2)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Vector<T> init() {
        if (this.isEmpty()) {
            throw new UnsupportedOperationException("init of empty vector");
        }
        return new Vector<T>(this.indexShift, this.trie.remove(this.length() + this.indexShift - 1));
    }

    @Override
    public Option<? extends Vector<T>> initOption() {
        return this.isEmpty() ? Option.none() : Option.some(this.init());
    }

    @Override
    public Vector<T> insert(int index2, T element2) {
        if (index2 < 0) {
            throw new IndexOutOfBoundsException("insert(" + index2 + ", e)");
        }
        if (index2 > this.length()) {
            throw new IndexOutOfBoundsException("insert(" + index2 + ", e) on Vector of length " + this.length());
        }
        HashArrayMappedTrie<Integer, Object> trie = HashArrayMappedTrie.empty();
        for (int i = 0; i <= this.length(); ++i) {
            if (i == index2) {
                trie = trie.put(trie.size(), element2);
            }
            if (i >= this.length()) continue;
            trie = trie.put(trie.size(), this.get(i));
        }
        return new Vector(trie);
    }

    @Override
    public Vector<T> insertAll(int index2, Iterable<? extends T> elements) {
        if (index2 < 0) {
            throw new IndexOutOfBoundsException("insert(" + index2 + ", e)");
        }
        if (index2 > this.length()) {
            throw new IndexOutOfBoundsException("insert(" + index2 + ", e) on Vector of length " + this.length());
        }
        HashArrayMappedTrie<Integer, Object> trie = HashArrayMappedTrie.empty();
        for (int i = 0; i <= this.length(); ++i) {
            if (i == index2) {
                for (T element2 : elements) {
                    trie = trie.put(trie.size(), element2);
                }
            }
            if (i >= this.length()) continue;
            trie = trie.put(trie.size(), this.get(i));
        }
        return new Vector(trie);
    }

    @Override
    public Vector<T> intersperse(T element2) {
        HashArrayMappedTrie<Integer, Object> trie = HashArrayMappedTrie.empty();
        for (int i = 0; i < this.length(); ++i) {
            if (i > 0) {
                trie = trie.put(trie.size(), element2);
            }
            trie = trie.put(trie.size(), this.get(i));
        }
        return Vector.wrap(trie);
    }

    @Override
    public boolean isEmpty() {
        return this.trie.isEmpty();
    }

    @Override
    public boolean isTraversableAgain() {
        return true;
    }

    @Override
    public Iterator<T> iterator() {
        return new AbstractIterator<T>(){
            private int index;
            private final int size;
            {
                this.index = Vector.this.indexShift;
                this.size = Vector.this.trie.size() + Vector.this.indexShift;
            }

            @Override
            public boolean hasNext() {
                return this.index < this.size;
            }

            @Override
            public T getNext() {
                return Vector.this.trie.get(this.index++).get();
            }
        };
    }

    @Override
    public int lastIndexOf(T element2, int end) {
        for (int i = Math.min(end, this.length() - 1); i >= 0; --i) {
            if (!Objects.equals(this.get(i), element2)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int length() {
        return this.trie.size();
    }

    @Override
    public <U> Vector<U> map(Function<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        HashArrayMappedTrie<Integer, Object> trie = HashArrayMappedTrie.empty();
        for (int i = 0; i < this.length(); ++i) {
            trie = trie.put(i, mapper.apply(this.get(i)));
        }
        return Vector.wrap(trie);
    }

    @Override
    public Vector<T> padTo(int length, T element2) {
        if (length <= this.length()) {
            return this;
        }
        return this.appendAll((Iterable)Iterator.continually(element2).take(length - this.length()));
    }

    @Override
    public Vector<T> patch(int from2, Iterable<? extends T> that, int replaced) {
        from2 = from2 < 0 ? 0 : from2;
        replaced = replaced < 0 ? 0 : replaced;
        IndexedSeq result2 = ((Vector)this.take(from2)).appendAll((Iterable)that);
        result2 = ((Vector)result2).appendAll((Iterable)this.drop(from2 += replaced));
        return result2;
    }

    @Override
    public Tuple2<Vector<T>, Vector<T>> partition(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        ArrayList<T> left = new ArrayList<T>();
        ArrayList right = new ArrayList();
        for (int i = 0; i < this.length(); ++i) {
            T t = this.get(i);
            (predicate.test(t) ? left : right).add(t);
        }
        return Tuple.of(Vector.ofAll(left), Vector.ofAll(right));
    }

    @Override
    public Vector<T> peek(Consumer<? super T> action) {
        Objects.requireNonNull(action, "action is null");
        if (!this.isEmpty()) {
            action.accept(this.head());
        }
        return this;
    }

    @Override
    public Vector<Vector<T>> permutations() {
        if (this.isEmpty()) {
            return Vector.empty();
        }
        IndexedSeq tail = this.tail();
        if (((Vector)tail).isEmpty()) {
            return Vector.of(this);
        }
        Vector<T> zero = Vector.empty();
        return this.distinct().foldLeft(zero, (xs, x) -> {
            Function<Vector, Vector> prepend = l -> l.prepend(x);
            return xs.appendAll((Iterable)((Vector)((Vector)this.remove(x)).permutations()).map(prepend));
        });
    }

    @Override
    public Vector<T> prepend(T element2) {
        int newIndexShift = this.indexShift - 1;
        return new Vector<T>(newIndexShift, this.trie.put(newIndexShift, element2));
    }

    @Override
    public Vector<T> prependAll(Iterable<? extends T> elements) {
        LinearSeq<T> list2 = List.ofAll(elements);
        int newIndexShift = this.indexShift - list2.length();
        HashArrayMappedTrie<Integer, T> newTrie = this.trie;
        int i = newIndexShift;
        while (!list2.isEmpty()) {
            newTrie = newTrie.put(i, list2.head());
            list2 = list2.tail();
            ++i;
        }
        return new Vector<T>(newIndexShift, newTrie);
    }

    @Override
    public Vector<T> remove(T element2) {
        HashArrayMappedTrie<Integer, Object> trie = HashArrayMappedTrie.empty();
        boolean found = false;
        for (int i = 0; i < this.length(); ++i) {
            T value2 = this.get(i);
            if (found) {
                trie = trie.put(trie.size(), value2);
                continue;
            }
            if (element2.equals(value2)) {
                found = true;
                continue;
            }
            trie = trie.put(trie.size(), value2);
        }
        return trie.size() == this.length() ? this : Vector.wrap(trie);
    }

    @Override
    public Vector<T> removeFirst(Predicate<T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        HashArrayMappedTrie<Integer, Object> trie = HashArrayMappedTrie.empty();
        boolean found = false;
        for (int i = 0; i < this.length(); ++i) {
            T value2 = this.get(i);
            if (found) {
                trie = trie.put(trie.size(), value2);
                continue;
            }
            if (predicate.test(value2)) {
                found = true;
                continue;
            }
            trie = trie.put(trie.size(), value2);
        }
        return trie.size() == this.length() ? this : Vector.wrap(trie);
    }

    @Override
    public Vector<T> removeLast(Predicate<T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        for (int i = this.length() - 1; i >= 0; --i) {
            if (!predicate.test(this.get(i))) continue;
            return this.removeAt(i);
        }
        return this;
    }

    @Override
    public Vector<T> removeAt(int index2) {
        if (index2 < 0) {
            throw new IndexOutOfBoundsException("removeAt(" + index2 + ")");
        }
        if (index2 >= this.length()) {
            throw new IndexOutOfBoundsException("removeAt(" + index2 + ")");
        }
        HashArrayMappedTrie<Integer, Object> trie = HashArrayMappedTrie.empty();
        for (int i = 0; i < this.length(); ++i) {
            if (i == index2) continue;
            trie = trie.put(trie.size(), this.get(i));
        }
        return Vector.wrap(trie);
    }

    @Override
    public Vector<T> removeAll(T element2) {
        HashArrayMappedTrie<Integer, Object> result2 = HashArrayMappedTrie.empty();
        for (int i = 0; i < this.length(); ++i) {
            T value2 = this.get(i);
            if (element2.equals(value2)) continue;
            result2 = result2.put(result2.size(), value2);
        }
        return result2.size() == this.length() ? this : Vector.wrap(result2);
    }

    @Override
    public Vector<T> removeAll(Iterable<? extends T> elements) {
        Objects.requireNonNull(elements, "elements is null");
        HashArrayMappedTrie<T, T> removed = HashArrayMappedTrie.empty();
        for (T element2 : elements) {
            removed = removed.put(element2, element2);
        }
        HashArrayMappedTrie<Integer, Object> result2 = HashArrayMappedTrie.empty();
        boolean found = false;
        for (int i = 0; i < this.length(); ++i) {
            T element3 = this.get(i);
            if (removed.get(element3).isDefined()) {
                found = true;
                continue;
            }
            result2 = result2.put(result2.size(), element3);
        }
        return found ? Vector.wrap(result2) : this;
    }

    @Override
    public Vector<T> replace(T currentElement, T newElement) {
        HashArrayMappedTrie<Integer, Object> trie = HashArrayMappedTrie.empty();
        boolean found = false;
        for (int i = 0; i < this.length(); ++i) {
            T value2 = this.get(i);
            if (found) {
                trie = trie.put(trie.size(), value2);
                continue;
            }
            if (currentElement.equals(value2)) {
                trie = trie.put(trie.size(), newElement);
                found = true;
                continue;
            }
            trie = trie.put(trie.size(), value2);
        }
        return found ? new Vector(trie) : this;
    }

    @Override
    public Vector<T> replaceAll(T currentElement, T newElement) {
        HashArrayMappedTrie<Integer, Object> trie = HashArrayMappedTrie.empty();
        boolean changed = false;
        for (int i = 0; i < this.length(); ++i) {
            T value2 = this.get(i);
            if (currentElement.equals(value2)) {
                trie = trie.put(trie.size(), newElement);
                changed = true;
                continue;
            }
            trie = trie.put(trie.size(), value2);
        }
        return changed ? Vector.wrap(trie) : this;
    }

    @Override
    public Vector<T> retainAll(Iterable<? extends T> elements) {
        Objects.requireNonNull(elements, "elements is null");
        Vector kept = (Vector)Vector.ofAll(elements).distinct();
        HashArrayMappedTrie<Integer, Object> result2 = HashArrayMappedTrie.empty();
        for (Object element2 : this) {
            if (!kept.contains(element2)) continue;
            result2 = result2.put(result2.size(), element2);
        }
        return result2.size() == this.trie.size() ? this : Vector.wrap(result2);
    }

    @Override
    public Vector<T> reverse() {
        HashArrayMappedTrie<Integer, Object> trie = HashArrayMappedTrie.empty();
        for (int i = 0; i < this.length(); ++i) {
            trie = trie.put(i, this.get(this.length() - 1 - i));
        }
        return trie.isEmpty() ? Vector.empty() : new Vector(trie);
    }

    @Override
    public Vector<T> scan(T zero, BiFunction<? super T, ? super T, ? extends T> operation) {
        return this.scanLeft(zero, operation);
    }

    /*
     * Exception decompiling
     */
    @Override
    public <U> Vector<U> scanLeft(U zero, BiFunction<? super U, ? super T, ? extends U> operation) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IndexOutOfBoundsException: Index 1 out of bounds for length 1
         *     at java.base/jdk.internal.util.Preconditions.outOfBounds(Preconditions.java:100)
         *     at java.base/jdk.internal.util.Preconditions.outOfBoundsCheckIndex(Preconditions.java:106)
         *     at java.base/jdk.internal.util.Preconditions.checkIndex(Preconditions.java:302)
         *     at java.base/java.util.Objects.checkIndex(Objects.java:385)
         *     at java.base/java.util.ArrayList.get(ArrayList.java:427)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:368)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public <U> Vector<U> scanRight(U zero, BiFunction<? super T, ? super U, ? extends U> operation) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IndexOutOfBoundsException: Index 1 out of bounds for length 1
         *     at java.base/jdk.internal.util.Preconditions.outOfBounds(Preconditions.java:100)
         *     at java.base/jdk.internal.util.Preconditions.outOfBoundsCheckIndex(Preconditions.java:106)
         *     at java.base/jdk.internal.util.Preconditions.checkIndex(Preconditions.java:302)
         *     at java.base/java.util.Objects.checkIndex(Objects.java:385)
         *     at java.base/java.util.ArrayList.get(ArrayList.java:427)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:368)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public Vector<T> slice(long beginIndex, long endIndex) {
        if (beginIndex >= endIndex || beginIndex >= (long)this.length() || this.isEmpty()) {
            return Vector.empty();
        }
        if (beginIndex <= 0L && endIndex >= (long)this.length()) {
            return this;
        }
        long index2 = Math.max(beginIndex, 0L);
        long length = Math.min(endIndex, (long)this.length());
        HashArrayMappedTrie<Integer, Object> trie = HashArrayMappedTrie.empty();
        int i = (int)index2;
        while ((long)i < length) {
            trie = trie.put(trie.size(), this.get(i));
            ++i;
        }
        return Vector.wrap(trie);
    }

    @Override
    public Iterator<Vector<T>> sliding(long size) {
        return this.sliding(size, 1L);
    }

    @Override
    public Iterator<Vector<T>> sliding(long size, long step) {
        return this.iterator().sliding(size, step).map(Vector::ofAll);
    }

    @Override
    public Vector<T> sorted() {
        return this.isEmpty() ? this : this.toJavaStream().sorted().collect(Vector.collector());
    }

    @Override
    public Vector<T> sorted(Comparator<? super T> comparator) {
        Objects.requireNonNull(comparator, "comparator is null");
        return this.isEmpty() ? this : this.toJavaStream().sorted(comparator).collect(Vector.collector());
    }

    @Override
    public <U extends Comparable<? super U>> Vector<T> sortBy(Function<? super T, ? extends U> mapper) {
        return this.sortBy(Comparable::compareTo, (Function)mapper);
    }

    @Override
    public <U> Vector<T> sortBy(Comparator<? super U> comparator, Function<? super T, ? extends U> mapper) {
        Objects.requireNonNull(comparator, "comparator is null");
        Objects.requireNonNull(mapper, "mapper is null");
        \u03bb domain = Function1.of(mapper::apply).memoized();
        return this.toJavaStream().sorted((arg_0, arg_1) -> Vector.lambda$sortBy$5(comparator, (Function)((Object)domain), arg_0, arg_1)).collect(Vector.collector());
    }

    @Override
    public Tuple2<Vector<T>, Vector<T>> span(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        return Tuple.of(this.takeWhile((Predicate)predicate), this.dropWhile((Predicate)predicate));
    }

    @Override
    public Tuple2<Vector<T>, Vector<T>> splitAt(long n) {
        return Tuple.of(this.take(n), this.drop(n));
    }

    @Override
    public Tuple2<Vector<T>, Vector<T>> splitAt(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        IndexedSeq init = this.takeWhile((Predicate)predicate.negate());
        return Tuple.of(init, this.drop(((Vector)init).length()));
    }

    @Override
    public Tuple2<Vector<T>, Vector<T>> splitAtInclusive(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        HashArrayMappedTrie init = HashArrayMappedTrie.empty();
        for (Object t : this) {
            init = init.put(init.size(), t);
            if (!predicate.test(t)) continue;
            if (init.size() == this.length()) {
                Tuple.of(this, Vector.empty());
                continue;
            }
            return Tuple.of(new Vector(init), this.drop(init.size()));
        }
        return Tuple.of(this, Vector.empty());
    }

    @Override
    public Spliterator<T> spliterator() {
        return Spliterators.spliterator(this.iterator(), (long)this.length(), 1040);
    }

    @Override
    public Vector<T> subSequence(int beginIndex) {
        if (beginIndex < 0) {
            throw new IndexOutOfBoundsException("slice(" + beginIndex + ")");
        }
        if (beginIndex > this.length()) {
            throw new IndexOutOfBoundsException("slice(" + beginIndex + ")");
        }
        return this.drop(beginIndex);
    }

    @Override
    public Vector<T> subSequence(int beginIndex, int endIndex) {
        if (beginIndex < 0 || beginIndex > endIndex || endIndex > this.length()) {
            throw new IndexOutOfBoundsException(String.format("slice(%s, %s) on List of length %s", beginIndex, endIndex, this.length()));
        }
        if (beginIndex == endIndex) {
            return Vector.empty();
        }
        HashArrayMappedTrie<Integer, Object> trie = HashArrayMappedTrie.empty();
        for (int i = beginIndex; i < endIndex; ++i) {
            trie = trie.put(trie.size(), this.get(i));
        }
        return Vector.wrap(trie);
    }

    @Override
    public Vector<T> tail() {
        if (this.isEmpty()) {
            throw new UnsupportedOperationException("tail of empty vector");
        }
        if (this.length() == 1) {
            return Vector.empty();
        }
        int newIndexShift = this.indexShift + 1;
        return new Vector<T>(newIndexShift, this.trie.remove(this.indexShift));
    }

    @Override
    public Option<Vector<T>> tailOption() {
        return this.isEmpty() ? Option.none() : Option.some(this.tail());
    }

    @Override
    public Vector<T> take(long n) {
        if (n >= (long)this.length()) {
            return this;
        }
        if (n <= 0L) {
            return Vector.empty();
        }
        HashArrayMappedTrie<Integer, Object> trie = HashArrayMappedTrie.empty();
        int i = 0;
        while ((long)i < n) {
            trie = trie.put(i, this.get(i));
            ++i;
        }
        return new Vector(trie);
    }

    @Override
    public Vector<T> takeRight(long n) {
        if (n >= (long)this.length()) {
            return this;
        }
        if (n <= 0L) {
            return Vector.empty();
        }
        HashArrayMappedTrie<Integer, Object> trie = HashArrayMappedTrie.empty();
        int i = 0;
        while ((long)i < n) {
            trie = trie.put(i, this.get(this.length() - (int)n + i));
            ++i;
        }
        return new Vector(trie);
    }

    @Override
    public Vector<T> takeUntil(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        return this.takeWhile((Predicate)predicate.negate());
    }

    @Override
    public Vector<T> takeWhile(Predicate<? super T> predicate) {
        T value2;
        Objects.requireNonNull(predicate, "predicate is null");
        HashArrayMappedTrie trie = HashArrayMappedTrie.empty();
        for (int i = 0; i < this.length() && predicate.test(value2 = this.get(i)); ++i) {
            trie = trie.put(i, this.get(i));
        }
        return trie.size() == this.length() ? this : Vector.wrap(trie);
    }

    public <U> U transform(Function<? super Vector<T>, ? extends U> f) {
        Objects.requireNonNull(f, "f is null");
        return f.apply(this);
    }

    @Override
    public <U> Vector<U> unit(Iterable<? extends U> iterable) {
        return Vector.ofAll(iterable);
    }

    @Override
    public <T1, T2> Tuple2<Vector<T1>, Vector<T2>> unzip(Function<? super T, Tuple2<? extends T1, ? extends T2>> unzipper) {
        Objects.requireNonNull(unzipper, "unzipper is null");
        HashArrayMappedTrie<Integer, Object> xs = HashArrayMappedTrie.empty();
        HashArrayMappedTrie<Integer, Object> ys = HashArrayMappedTrie.empty();
        for (Object element2 : this) {
            Tuple2<? extends T1, ? extends T2> t = unzipper.apply(element2);
            xs = xs.put(xs.size(), t._1);
            ys = ys.put(ys.size(), t._2);
        }
        return Tuple.of(new Vector(xs), new Vector(ys));
    }

    @Override
    public <T1, T2, T3> Tuple3<Vector<T1>, Vector<T2>, Vector<T3>> unzip3(Function<? super T, Tuple3<? extends T1, ? extends T2, ? extends T3>> unzipper) {
        Objects.requireNonNull(unzipper, "unzipper is null");
        HashArrayMappedTrie<Integer, Object> xs = HashArrayMappedTrie.empty();
        HashArrayMappedTrie<Integer, Object> ys = HashArrayMappedTrie.empty();
        HashArrayMappedTrie<Integer, Object> zs = HashArrayMappedTrie.empty();
        for (Object element2 : this) {
            Tuple3<? extends T1, ? extends T2, ? extends T3> t = unzipper.apply(element2);
            xs = xs.put(xs.size(), t._1);
            ys = ys.put(ys.size(), t._2);
            zs = zs.put(zs.size(), t._3);
        }
        return Tuple.of(new Vector(xs), new Vector(ys), new Vector(zs));
    }

    @Override
    public Vector<T> update(int index2, T element2) {
        if (index2 < 0) {
            throw new IndexOutOfBoundsException("update(" + index2 + ")");
        }
        if (index2 >= this.length()) {
            throw new IndexOutOfBoundsException("update(" + index2 + ")");
        }
        return new Vector<T>(this.indexShift, this.trie.put(index2 + this.indexShift, element2));
    }

    @Override
    public <U> Vector<Tuple2<T, U>> zip(Iterable<? extends U> that) {
        Objects.requireNonNull(that, "that is null");
        return Vector.ofAll(this.iterator().zip(that));
    }

    @Override
    public <U> Vector<Tuple2<T, U>> zipAll(Iterable<? extends U> that, T thisElem, U thatElem) {
        Objects.requireNonNull(that, "that is null");
        return Vector.ofAll(this.iterator().zipAll(that, thisElem, thatElem));
    }

    @Override
    public Vector<Tuple2<T, Long>> zipWithIndex() {
        return Vector.ofAll(this.iterator().zipWithIndex());
    }

    private Object readResolve() {
        return this.isEmpty() ? EMPTY : this;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Vector) {
            Vector that = (Vector)o;
            return this.size() == that.size() && Collections.equals(this, that);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Collections.hash(this);
    }

    @Override
    public String stringPrefix() {
        return "Vector";
    }

    @Override
    public String toString() {
        return this.mkString(this.stringPrefix() + "(", ", ", ")");
    }

    private static <T> Vector<T> wrap(HashArrayMappedTrie<Integer, T> trie) {
        return trie.isEmpty() ? Vector.empty() : new Vector<T>(trie);
    }

    private static /* synthetic */ int lambda$sortBy$5(Comparator comparator, Function domain, Object e1, Object e2) {
        return comparator.compare(domain.apply(e1), domain.apply(e2));
    }
}

