/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

public class UnsafeWeakList<T>
extends AbstractCollection<T> {
    protected final List<MyReference<T>> myList;
    private final ReferenceQueue<T> myQueue = new ReferenceQueue();
    private int myAlive;
    private int modCount;

    public UnsafeWeakList() {
        this.myList = new ArrayList<MyReference<T>>();
    }

    public UnsafeWeakList(int capacity) {
        this.myList = new ArrayList<MyReference<T>>(capacity);
    }

    boolean processQueue() {
        MyReference reference2;
        boolean processed = false;
        while ((reference2 = (MyReference)this.myQueue.poll()) != null) {
            int index2 = reference2.index;
            if (index2 < this.myList.size() && reference2 == this.myList.get(index2)) {
                this.nullizeAt(index2);
            }
            processed = true;
        }
        if (this.myAlive < this.myList.size() / 2) {
            this.reduceCapacity();
        }
        return processed;
    }

    private void nullizeAt(int index2) {
        this.myList.set(index2, null);
        --this.myAlive;
    }

    private void reduceCapacity() {
        int toSaveAlive = 0;
        for (int i = 0; i < this.myList.size(); ++i) {
            MyReference<T> reference2 = this.myList.get(i);
            if (reference2 == null) continue;
            Object t = reference2.get();
            if (t == null) {
                --this.myAlive;
                continue;
            }
            if (toSaveAlive != i) {
                this.myList.set(toSaveAlive, new MyReference(toSaveAlive, t, this.myQueue));
            }
            ++toSaveAlive;
        }
        if (toSaveAlive != this.myList.size()) {
            this.myList.subList(toSaveAlive, this.myList.size()).clear();
            ++this.modCount;
        }
        this.myAlive = toSaveAlive;
    }

    private void append(@NotNull T element2) {
        if (element2 == null) {
            UnsafeWeakList.$$$reportNull$$$0(0);
        }
        this.myList.add(new MyReference(this.myList.size(), element2, this.myQueue));
        ++this.myAlive;
        ++this.modCount;
    }

    @Override
    public boolean add(@NotNull T element2) {
        if (element2 == null) {
            UnsafeWeakList.$$$reportNull$$$0(1);
        }
        this.processQueue();
        this.append(element2);
        return true;
    }

    public boolean addIfAbsent(@NotNull T element2) {
        if (element2 == null) {
            UnsafeWeakList.$$$reportNull$$$0(2);
        }
        this.processQueue();
        if (this.contains(element2)) {
            return false;
        }
        this.append(element2);
        return true;
    }

    @Override
    public void clear() {
        this.processQueue();
        this.myList.clear();
        this.myAlive = 0;
        ++this.modCount;
    }

    @TestOnly
    int listSize() {
        return this.myList.size();
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return new MyIterator();
    }

    @Override
    public boolean remove(@NotNull Object o) {
        if (o == null) {
            UnsafeWeakList.$$$reportNull$$$0(3);
        }
        this.processQueue();
        for (int i = 0; i < this.myList.size(); ++i) {
            Object t;
            Reference ref = this.myList.get(i);
            Object object = t = ref == null ? null : (Object)ref.get();
            if (t == null || !t.equals(o)) continue;
            this.nullizeAt(i);
            ++this.modCount;
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends T> c) {
        if (c == null) {
            UnsafeWeakList.$$$reportNull$$$0(4);
        }
        this.processQueue();
        return super.addAll(c);
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> c) {
        if (c == null) {
            UnsafeWeakList.$$$reportNull$$$0(5);
        }
        this.processQueue();
        return super.removeAll(c);
    }

    @NotNull
    public List<T> toStrongList() {
        if (this.myList.isEmpty()) {
            List list2 = Collections.emptyList();
            if (list2 == null) {
                UnsafeWeakList.$$$reportNull$$$0(6);
            }
            return list2;
        }
        ArrayList<Object> result2 = new ArrayList<Object>(this.myList.size());
        for (MyReference<T> t : this.myList) {
            Object o = t == null ? null : (Object)t.get();
            if (o == null) continue;
            result2.add(o);
        }
        ArrayList<Object> arrayList = result2;
        if (arrayList == null) {
            UnsafeWeakList.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @Override
    @Deprecated
    public int size() {
        UnsafeWeakList.throwNotAllowedException();
        return -1;
    }

    private static void throwNotAllowedException() {
        throw new UnsupportedOperationException("index/size-based operations in UnsafeWeakList are not supported because they don't make sense in the presence of weak references. Use .iterator() (which retains its elements to avoid sudden GC) instead.");
    }

    @Override
    public boolean isEmpty() {
        if (this.myList.isEmpty()) {
            return true;
        }
        for (MyReference<T> value2 : this.myList) {
            if (value2 == null || value2.get() == null) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public T get(int index2) {
        UnsafeWeakList.throwNotAllowedException();
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/containers/UnsafeWeakList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/containers/UnsafeWeakList";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "toStrongList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "append";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addIfAbsent";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addAll";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removeAll";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private final class MyIterator
    implements Iterator<T> {
        private final int startModCount;
        private int curIndex;
        private T curElement;
        private int nextIndex = -1;
        private T nextElement;
        private boolean modified;

        private MyIterator() {
            this.startModCount = UnsafeWeakList.this.modCount;
            this.findNext();
        }

        private void findNext() {
            if (UnsafeWeakList.this.modCount != this.startModCount) {
                throw new ConcurrentModificationException();
            }
            this.curIndex = this.nextIndex;
            this.curElement = this.nextElement;
            this.nextElement = null;
            this.nextIndex = -1;
            for (int i = this.curIndex + 1; i < UnsafeWeakList.this.myList.size(); ++i) {
                Object t;
                Reference ref = UnsafeWeakList.this.myList.get(i);
                Object v0 = t = ref == null ? null : ref.get();
                if (t == null) continue;
                this.nextElement = t;
                this.nextIndex = i;
                break;
            }
            if (this.nextIndex == -1 && this.modified) {
                UnsafeWeakList.this.modCount++;
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextElement != null;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.findNext();
            return this.curElement;
        }

        @Override
        public void remove() {
            if (this.curElement == null) {
                throw new NoSuchElementException();
            }
            int index2 = this.curIndex;
            UnsafeWeakList.this.nullizeAt(index2);
            this.modified = true;
        }
    }

    private static final class MyReference<T>
    extends WeakReference<T> {
        private final int index;

        private MyReference(int index2, T referent, ReferenceQueue<? super T> queue) {
            super(referent, queue);
            this.index = index2;
        }
    }
}

