/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.wasm.resolve.diagnostics;

import com.intellij.psi.PsiElement;
import java.util.Iterator;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.source.PsiSourceElementKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.wasm.resolve.diagnostics.ErrorsWasm;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001e\u0010\r\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016\u00b2\u0006\n\u0010\u0017\u001a\u00020\u0018X\u008a\u0084\u0002"}, d2={"Lorg/jetbrains/kotlin/wasm/resolve/diagnostics/WasmImportAnnotationChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "wasmImportFqName", "Lorg/jetbrains/kotlin/name/FqName;", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "checkSignatureIsPrimitive", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "isParameterTypeSupported", "", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "isReturnTypeSupported", "wasm.frontend", "valueParameterDeclaration", "Lcom/intellij/psi/PsiElement;"})
public final class WasmImportAnnotationChecker
implements DeclarationChecker {
    @NotNull
    public static final WasmImportAnnotationChecker INSTANCE = new WasmImportAnnotationChecker();
    @NotNull
    private static final FqName wasmImportFqName = new FqName("kotlin.wasm.WasmImport");

    private WasmImportAnnotationChecker() {
    }

    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        PsiElement wasmImportPsi;
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(context2, "context");
        AnnotationDescriptor annotationDescriptor = descriptor2.getAnnotations().findAnnotation(wasmImportFqName);
        if (annotationDescriptor == null) {
            return;
        }
        AnnotationDescriptor wasmImport = annotationDescriptor;
        BindingTrace trace = context2.getTrace();
        PsiElement psiElement = PsiSourceElementKt.getPsi(wasmImport.getSource());
        if (psiElement == null) {
            psiElement = wasmImportPsi = (PsiElement)declaration2;
        }
        if (!DescriptorUtils.isTopLevelDeclaration(descriptor2)) {
            trace.report(ErrorsWasm.NESTED_WASM_IMPORT.on(wasmImportPsi));
        }
        if (descriptor2 instanceof FunctionDescriptor) {
            if (!DescriptorUtilsKt.isEffectivelyExternal((MemberDescriptor)descriptor2)) {
                trace.report(ErrorsWasm.WASM_IMPORT_ON_NON_EXTERNAL_DECLARATION.on(wasmImportPsi));
            }
            this.checkSignatureIsPrimitive((FunctionDescriptor)descriptor2, trace, declaration2);
        }
    }

    private final boolean isParameterTypeSupported(KotlinType type2) {
        return TypeUtilsKt.isPrimitiveNumberType(type2) || TypeUtilsKt.isBoolean(type2);
    }

    private final boolean isReturnTypeSupported(KotlinType type2) {
        return this.isParameterTypeSupported(type2) || TypeUtilsKt.isUnit(type2);
    }

    public final void checkSignatureIsPrimitive(@NotNull FunctionDescriptor descriptor2, @NotNull BindingTrace trace, @NotNull KtDeclaration declaration2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(trace, "trace");
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Iterator<ValueParameterDescriptor> iterator2 = descriptor2.getValueParameters().iterator();
        while (iterator2.hasNext()) {
            ValueParameterDescriptor parameter2;
            Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
            Lazy valueParameterDeclaration$delegate = LazyKt.lazy((Function0)new Function0<PsiElement>(parameter2){
                final /* synthetic */ ValueParameterDescriptor $parameter;
                {
                    this.$parameter = $parameter;
                    super(0);
                }

                public final PsiElement invoke() {
                    PsiElement psiElement = DescriptorToSourceUtils.descriptorToDeclaration(this.$parameter);
                    Intrinsics.checkNotNull(psiElement);
                    return psiElement;
                }
            });
            if (parameter2.declaresDefaultValue()) {
                trace.report(ErrorsWasm.WASM_IMPORT_EXPORT_PARAMETER_DEFAULT_VALUE.on(WasmImportAnnotationChecker.checkSignatureIsPrimitive$lambda$0(valueParameterDeclaration$delegate)));
            }
            if (ArgumentsUtilsKt.isVararg(parameter2)) {
                trace.report(ErrorsWasm.WASM_IMPORT_EXPORT_VARARG_PARAMETER.on(WasmImportAnnotationChecker.checkSignatureIsPrimitive$lambda$0(valueParameterDeclaration$delegate)));
            }
            KotlinType kotlinType = parameter2.getType();
            Intrinsics.checkNotNullExpressionValue(kotlinType, "getType(...)");
            if (this.isParameterTypeSupported(kotlinType)) continue;
            trace.report(ErrorsWasm.WASM_IMPORT_EXPORT_UNSUPPORTED_PARAMETER_TYPE.on(WasmImportAnnotationChecker.checkSignatureIsPrimitive$lambda$0(valueParameterDeclaration$delegate), parameter2.getType()));
        }
        KotlinType returnType2 = descriptor2.getReturnType();
        if (returnType2 != null && !this.isReturnTypeSupported(returnType2)) {
            trace.report(ErrorsWasm.WASM_IMPORT_EXPORT_UNSUPPORTED_RETURN_TYPE.on(declaration2, returnType2));
        }
    }

    private static final PsiElement checkSignatureIsPrimitive$lambda$0(Lazy<? extends PsiElement> $valueParameterDeclaration$delegate) {
        Lazy<? extends PsiElement> lazy = $valueParameterDeclaration$delegate;
        return lazy.getValue();
    }
}

