/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import org.jetbrains.kotlin.fir.resolve.DoubleColonLHS;
import org.jetbrains.kotlin.fir.resolve.calls.AdaptedCallableReferenceIsUsedWithReflection;
import org.jetbrains.kotlin.fir.resolve.calls.CallInfo;
import org.jetbrains.kotlin.fir.resolve.calls.CallableReferenceAdaptation;
import org.jetbrains.kotlin.fir.resolve.calls.CallableReferenceResolutionKt;
import org.jetbrains.kotlin.fir.resolve.calls.Candidate;
import org.jetbrains.kotlin.fir.resolve.calls.CheckerSink;
import org.jetbrains.kotlin.fir.resolve.calls.CheckerStage;
import org.jetbrains.kotlin.fir.resolve.calls.InapplicableCandidate;
import org.jetbrains.kotlin.fir.resolve.calls.LowerPriorityToPreserveCompatibilityDiagnostic;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionContext;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionDiagnostic;
import org.jetbrains.kotlin.fir.resolve.inference.model.ConeArgumentConstraintPosition;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeTypeVariableType;
import org.jetbrains.kotlin.fir.types.FunctionalTypeUtilsKt;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemBuilder;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemOperation;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemTransaction;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0096@\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/CheckCallableReferenceExpectedType;", "Lorg/jetbrains/kotlin/fir/resolve/calls/CheckerStage;", "()V", "check", "", "candidate", "Lorg/jetbrains/kotlin/fir/resolve/calls/Candidate;", "callInfo", "Lorg/jetbrains/kotlin/fir/resolve/calls/CallInfo;", "sink", "Lorg/jetbrains/kotlin/fir/resolve/calls/CheckerSink;", "context", "Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;", "(Lorg/jetbrains/kotlin/fir/resolve/calls/Candidate;Lorg/jetbrains/kotlin/fir/resolve/calls/CallInfo;Lorg/jetbrains/kotlin/fir/resolve/calls/CheckerSink;Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "resolve"})
@SourceDebugExtension(value={"SMAP\nCallableReferenceResolution.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CallableReferenceResolution.kt\norg/jetbrains/kotlin/fir/resolve/calls/CheckCallableReferenceExpectedType\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ConstraintSystemBuilder.kt\norg/jetbrains/kotlin/resolve/calls/inference/ConstraintSystemBuilderKt\n+ 4 CheckerSink.kt\norg/jetbrains/kotlin/fir/resolve/calls/CheckerSinkKt\n*L\n1#1,492:1\n1#2:493\n68#3,10:494\n28#4,2:504\n22#4,9:506\n*S KotlinDebug\n*F\n+ 1 CallableReferenceResolution.kt\norg/jetbrains/kotlin/fir/resolve/calls/CheckCallableReferenceExpectedType\n*L\n96#1:494,10\n105#1:504,2\n105#1:506,9\n*E\n"})
public final class CheckCallableReferenceExpectedType
extends CheckerStage {
    @NotNull
    public static final CheckCallableReferenceExpectedType INSTANCE = new CheckCallableReferenceExpectedType();

    private CheckCallableReferenceExpectedType() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object check(@NotNull Candidate candidate2, @NotNull CallInfo callInfo, @NotNull CheckerSink sink, @NotNull ResolutionContext context2, @NotNull Continuation<? super Unit> $completion) {
        ConeKotlinType coneKotlinType;
        ConstraintSystemBuilder constraintSystemBuilder = callInfo.getOuterCSBuilder();
        if (constraintSystemBuilder == null) {
            return Unit.INSTANCE;
        }
        ConstraintSystemBuilder outerCsBuilder = constraintSystemBuilder;
        ConeKotlinType expectedType = callInfo.getExpectedType();
        if (!(candidate2.getSymbol() instanceof FirCallableSymbol)) {
            return Unit.INSTANCE;
        }
        if (callInfo.getLhs() instanceof DoubleColonLHS.Type) {
            ConeKotlinType coneKotlinType2;
            ConeKotlinType it = coneKotlinType2 = callInfo.getLhs().getType();
            boolean bl = false;
            coneKotlinType = !(callInfo.getExplicitReceiver() instanceof FirResolvedQualifier) ? coneKotlinType2 : null;
        } else {
            coneKotlinType = null;
        }
        ConeKotlinType resultingReceiverType = coneKotlinType;
        Object obj = candidate2.getSymbol().getFir();
        Intrinsics.checkNotNull(obj, "null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration");
        FirCallableDeclaration fir = (FirCallableDeclaration)obj;
        ConeKotlinType coneKotlinType3 = callInfo.getExpectedType();
        boolean isExpectedTypeReflectionType = coneKotlinType3 != null ? FunctionalTypeUtilsKt.isReflectFunctionType(coneKotlinType3, callInfo.getSession()) : false;
        Pair pair = CallableReferenceResolutionKt.access$buildResultingTypeAndAdaptation(fir, resultingReceiverType, candidate2, context2, isExpectedTypeReflectionType);
        ConeKotlinType rawResultingType = (ConeKotlinType)pair.component1();
        CallableReferenceAdaptation callableReferenceAdaptation = (CallableReferenceAdaptation)pair.component2();
        ConeKotlinType resultingType = candidate2.getSubstitutor().substituteOrSelf(rawResultingType);
        if (callableReferenceAdaptation != null) {
            if (!FirLanguageSettingsComponentKt.getLanguageVersionSettings(context2.getSession()).supportsFeature(LanguageFeature.DisableCompatibilityModeForNewInference)) {
                sink.reportDiagnostic(LowerPriorityToPreserveCompatibilityDiagnostic.INSTANCE);
            }
            if (isExpectedTypeReflectionType) {
                sink.reportDiagnostic(AdaptedCallableReferenceIsUsedWithReflection.INSTANCE);
            }
        }
        candidate2.setResultingTypeForCallableReference(resultingType);
        candidate2.setCallableReferenceAdaptation$resolve(callableReferenceAdaptation);
        candidate2.setOuterConstraintBuilderEffect((Function1<? super ConstraintSystemOperation, Unit>)new Function1<ConstraintSystemOperation, Unit>(candidate2, callInfo, expectedType, resultingType, outerCsBuilder){
            final /* synthetic */ Candidate $candidate;
            final /* synthetic */ CallInfo $callInfo;
            final /* synthetic */ ConeKotlinType $expectedType;
            final /* synthetic */ ConeKotlinType $resultingType;
            final /* synthetic */ ConstraintSystemBuilder $outerCsBuilder;
            {
                this.$candidate = $candidate;
                this.$callInfo = $callInfo;
                this.$expectedType = $expectedType;
                this.$resultingType = $resultingType;
                this.$outerCsBuilder = $outerCsBuilder;
                super(1);
            }

            public final void invoke(ConstraintSystemOperation constraintSystemOperation) {
                Intrinsics.checkNotNullParameter(constraintSystemOperation, "<this>");
                constraintSystemOperation.addOtherSystem(this.$candidate.getSystem().currentStorage());
                ConeArgumentConstraintPosition position = new ConeArgumentConstraintPosition(this.$callInfo.getCallSite());
                if (this.$expectedType != null && !ConeTypeUtilsKt.contains(this.$resultingType, (Function1<? super ConeKotlinType, Boolean>)new Function1<ConeKotlinType, Boolean>(this.$outerCsBuilder){
                    final /* synthetic */ ConstraintSystemBuilder $outerCsBuilder;
                    {
                        this.$outerCsBuilder = $outerCsBuilder;
                        super(1);
                    }

                    public final Boolean invoke(ConeKotlinType it) {
                        Intrinsics.checkNotNullParameter(it, "it");
                        return it instanceof ConeTypeVariableType && !this.$outerCsBuilder.currentStorage().getAllTypeVariables().containsKey(((ConeTypeVariableType)it).getTypeConstructor());
                    }
                })) {
                    constraintSystemOperation.addSubtypeConstraint(this.$resultingType, this.$expectedType, position);
                }
            }
        });
        boolean isApplicable = false;
        isApplicable = true;
        Object $this$runTransaction$iv = outerCsBuilder;
        boolean $i$f$runTransaction = false;
        ConstraintSystemTransaction transactionState$iv = $this$runTransaction$iv.prepareTransaction();
        ConstraintSystemOperation $this$check_u24lambda_u241 = (ConstraintSystemOperation)$this$runTransaction$iv;
        boolean bl = false;
        Function1<ConstraintSystemOperation, Unit> function1 = candidate2.getOuterConstraintBuilderEffect();
        Intrinsics.checkNotNull(function1);
        function1.invoke($this$check_u24lambda_u241);
        boolean bl2 = isApplicable = !$this$check_u24lambda_u241.getHasContradiction();
        if (false) {
            transactionState$iv.closeTransaction();
        } else {
            transactionState$iv.rollbackTransaction();
        }
        if (!isApplicable) {
            void $this$yieldDiagnostic$iv;
            $this$runTransaction$iv = sink;
            ResolutionDiagnostic diagnostic$iv = InapplicableCandidate.INSTANCE;
            boolean $i$f$yieldDiagnostic = false;
            $this$yieldDiagnostic$iv.reportDiagnostic(diagnostic$iv);
            void $this$yieldIfNeed$iv$iv = $this$yieldDiagnostic$iv;
            boolean $i$f$yieldIfNeed = false;
            if ($this$yieldIfNeed$iv$iv.getNeedYielding()) {
                Object object = $this$yieldIfNeed$iv$iv.yield($completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
            }
            return Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }
}

