/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.js.checkers.expression;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.js.FirJsErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.utils.FirWebCommonHelpersKt;
import org.jetbrains.kotlin.fir.expressions.FirArgumentList;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.impl.FirResolvedArgumentList;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeDynamicType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.name.JsStandardClassIds;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/js/checkers/expression/FirJsExternalArgumentCallChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirCall;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirCallChecker;", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers.js"})
@SourceDebugExtension(value={"SMAP\nFirJsExternalArgumentCallChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJsExternalArgumentCallChecker.kt\norg/jetbrains/kotlin/fir/analysis/js/checkers/expression/FirJsExternalArgumentCallChecker\n+ 2 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n*L\n1#1,43:1\n58#2,4:44\n*S KotlinDebug\n*F\n+ 1 FirJsExternalArgumentCallChecker.kt\norg/jetbrains/kotlin/fir/analysis/js/checkers/expression/FirJsExternalArgumentCallChecker\n*L\n25#1:44,4\n*E\n"})
public final class FirJsExternalArgumentCallChecker
extends FirExpressionChecker<FirCall> {
    @NotNull
    public static final FirJsExternalArgumentCallChecker INSTANCE = new FirJsExternalArgumentCallChecker();

    private FirJsExternalArgumentCallChecker() {
    }

    @Override
    public void check(@NotNull FirCall expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        FirCall $this$resolvedArgumentMapping$iv = expression2;
        boolean $i$f$getResolvedArgumentMapping = false;
        FirArgumentList argumentList$iv = $this$resolvedArgumentMapping$iv.getArgumentList();
        LinkedHashMap<FirExpression, FirValueParameter> linkedHashMap = argumentList$iv instanceof FirResolvedArgumentList ? ((FirResolvedArgumentList)argumentList$iv).getMapping() : null;
        if (linkedHashMap == null) {
            return;
        }
        LinkedHashMap<FirExpression, FirValueParameter> arguments2 = linkedHashMap;
        for (Map.Entry entry : ((Map)arguments2).entrySet()) {
            FirRegularClassSymbol symbol2;
            FirExpression argument2 = (FirExpression)entry.getKey();
            FirValueParameter parameter2 = (FirValueParameter)entry.getValue();
            if (!FirAnnotationUtilsKt.hasAnnotation((FirDeclaration)parameter2, JsStandardClassIds.Annotations.JsExternalArgument, context2.getSession())) continue;
            FirExpression unwrappedArg = FirExpressionUtilKt.unwrapArgument(argument2);
            ConeKotlinType type2 = FirTypeUtilsKt.getResolvedType(unwrappedArg);
            FirRegularClassSymbol firRegularClassSymbol = symbol2 = TypeUtilsKt.toRegularClassSymbol(type2, context2.getSession());
            boolean bl = firRegularClassSymbol != null ? !FirWebCommonHelpersKt.isEffectivelyExternal(firRegularClassSymbol, context2.getSession()) : false;
            if (!bl && !(type2 instanceof ConeDynamicType)) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)unwrappedArg.getSource(), FirJsErrors.INSTANCE.getJS_EXTERNAL_ARGUMENT(), (Object)type2, (DiagnosticContext)context2, null, 16, null);
        }
    }
}

