/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.UByte;
import kotlin.UInt;
import kotlin.ULong;
import kotlin.UShort;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstKind;
import org.jetbrains.kotlin.ir.expressions.IrConstantArray;
import org.jetbrains.kotlin.ir.expressions.IrConstantObject;
import org.jetbrains.kotlin.ir.expressions.IrConstantPrimitive;
import org.jetbrains.kotlin.ir.expressions.IrConstantValue;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrStringConcatenationImpl;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00172\u00020\u00012\u00020\u0002:\u0001\u0017B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0014\u0010\b\u001a\u00020\t2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u00112\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0016J\f\u0010\u0015\u001a\u00020\u0013*\u00020\u0016H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/FlattenStringConcatenationLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "constToString", "", "const", "Lorg/jetbrains/kotlin/ir/expressions/IrConst;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "normalizeUnsignedValue", "", "visitExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "tryToFold", "Lorg/jetbrains/kotlin/ir/expressions/IrStringConcatenation;", "Companion", "ir.backend.common"})
public final class FlattenStringConcatenationLowering
extends IrElementTransformerVoid
implements FileLoweringPass {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CommonBackendContext context;
    @NotNull
    private static final Set<FqName> PARENT_NAMES;

    public FlattenStringConcatenationLowering(@NotNull CommonBackendContext context2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        this.context = context2;
    }

    @NotNull
    public final CommonBackendContext getContext() {
        return this.context;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter(irFile, "irFile");
        IrElementTransformerVoidKt.transformChildrenVoid(irFile, this);
    }

    @Override
    @NotNull
    public IrExpression visitExpression(@NotNull IrExpression expression2) {
        IrExpression irExpression;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        if (FlattenStringConcatenationLowering.Companion.isStringConcatenationExpression(expression2) || expression2 instanceof IrCall && FlattenStringConcatenationLowering.Companion.isSpecialToStringCall((IrCall)expression2)) {
            IrExpression $this$visitExpression_u24lambda_u240 = expression2;
            boolean bl = false;
            irExpression = this.tryToFold(new IrStringConcatenationImpl($this$visitExpression_u24lambda_u240.getStartOffset(), $this$visitExpression_u24lambda_u240.getEndOffset(), $this$visitExpression_u24lambda_u240.getType(), FlattenStringConcatenationLowering.Companion.collectStringConcatenationArguments($this$visitExpression_u24lambda_u240)));
        } else {
            irExpression = expression2;
        }
        IrExpression transformedExpression = irExpression;
        IrElementTransformerVoidKt.transformChildrenVoid(transformedExpression, this);
        return transformedExpression;
    }

    private final IrExpression tryToFold(IrStringConcatenation $this$tryToFold) {
        List folded = new ArrayList();
        for (IrExpression next : $this$tryToFold.getArguments()) {
            IrExpression last = (IrExpression)CollectionsKt.lastOrNull(folded);
            if (!(next instanceof IrConst)) {
                ((Collection)folded).add(next);
                continue;
            }
            if (!(last instanceof IrConst)) {
                ((Collection)folded).add(IrConstImpl.Companion.string(next.getStartOffset(), next.getEndOffset(), this.context.getIrBuiltIns().getStringType(), this.constToString((IrConst)next)));
                continue;
            }
            folded.set(folded.size() - 1, IrConstImpl.Companion.string(Math.min(((IrConst)last).getStartOffset(), next.getStartOffset()), Math.max(((IrConst)last).getEndOffset(), next.getEndOffset()), this.context.getIrBuiltIns().getStringType(), this.constToString((IrConst)last) + this.constToString((IrConst)next)));
        }
        Object t = CollectionsKt.singleOrNull(folded);
        IrConst irConst = t instanceof IrConst ? (IrConst)t : null;
        return irConst != null ? (IrExpression)irConst : (IrExpression)new IrStringConcatenationImpl($this$tryToFold.getStartOffset(), $this$tryToFold.getEndOffset(), $this$tryToFold.getType(), folded);
    }

    private final String constToString(IrConst<?> irConst) {
        return String.valueOf(this.normalizeUnsignedValue(irConst));
    }

    private final Object normalizeUnsignedValue(IrConst<?> irConst) {
        if (IrTypeUtilsKt.isUnsigned(irConst.getType())) {
            IrConstKind<?> kind = irConst.getKind();
            if (kind instanceof IrConstKind.Byte) {
                return UByte.box-impl(UByte.constructor-impl(((Number)((IrConstKind.Byte)kind).valueOf(irConst)).byteValue()));
            }
            if (kind instanceof IrConstKind.Short) {
                return UShort.box-impl(UShort.constructor-impl(((Number)((IrConstKind.Short)kind).valueOf(irConst)).shortValue()));
            }
            if (kind instanceof IrConstKind.Int) {
                return UInt.box-impl(UInt.constructor-impl(((Number)((IrConstKind.Int)kind).valueOf(irConst)).intValue()));
            }
            if (kind instanceof IrConstKind.Long) {
                return ULong.box-impl(ULong.constructor-impl(((Number)((IrConstKind.Long)kind).valueOf(irConst)).longValue()));
            }
        }
        return irConst.getValue();
    }

    static {
        FqName[] fqNameArray = new FqName[2];
        fqNameArray[0] = StandardNames.BUILT_INS_PACKAGE_FQ_NAME;
        Intrinsics.checkNotNullExpressionValue(StandardNames.FqNames.string.toSafe(), "toSafe(...)");
        PARENT_NAMES = SetsKt.setOf(fqNameArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0012H\u0002J\u0010\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0012H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\u00020\u0007*\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\tR\u0018\u0010\n\u001a\u00020\u0007*\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\fR\u0018\u0010\r\u001a\u00020\u0007*\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\fR\u0015\u0010\u000e\u001a\u00020\u0007*\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\tR\u0018\u0010\u000f\u001a\u00020\u0007*\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\f\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/FlattenStringConcatenationLowering$Companion;", "", "()V", "PARENT_NAMES", "", "Lorg/jetbrains/kotlin/name/FqName;", "isNullableToString", "", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "(Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;)Z", "isSpecialToStringCall", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "(Lorg/jetbrains/kotlin/ir/expressions/IrCall;)Z", "isStringPlusCall", "isToString", "isToStringCall", "collectStringConcatenationArguments", "", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "isStringConcatenationExpression", "ir.backend.common"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isStringPlusCall(IrCall $this$isStringPlusCall) {
            IrValueParameter receiverParameter;
            IrSimpleFunction function2 = (IrSimpleFunction)$this$isStringPlusCall.getSymbol().getOwner();
            IrValueParameter irValueParameter = function2.getDispatchReceiverParameter();
            if (irValueParameter == null) {
                irValueParameter = function2.getExtensionReceiverParameter();
            }
            if ((receiverParameter = irValueParameter) == null) return false;
            if (!IrTypePredicatesKt.isStringClassType(receiverParameter.getType())) return false;
            if (!IrTypePredicatesKt.isStringClassType(function2.getReturnType())) return false;
            if (function2.getValueParameters().size() != 1) return false;
            if (!Intrinsics.areEqual(function2.getName(), OperatorNameConventions.PLUS)) return false;
            FqName fqName2 = IrUtilsKt.getFqNameWhenAvailable(function2);
            if (!CollectionsKt.contains(PARENT_NAMES, fqName2 != null ? fqName2.parent() : null)) return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isToString(@NotNull IrSimpleFunction $this$isToString) {
            boolean bl;
            Intrinsics.checkNotNullParameter($this$isToString, "<this>");
            if (!Intrinsics.areEqual($this$isToString.getName(), OperatorNameConventions.TO_STRING)) return false;
            if (!((Collection)$this$isToString.getValueParameters()).isEmpty()) {
                return false;
            }
            boolean bl2 = false;
            if (bl2) return false;
            if (!IrTypePredicatesKt.isString($this$isToString.getReturnType())) {
                return false;
            }
            if ($this$isToString.getDispatchReceiverParameter() == null) return false;
            if ($this$isToString.getExtensionReceiverParameter() != null) return false;
            IrAnnotationContainer irAnnotationContainer = $this$isToString.getDispatchReceiverParameter();
            if (irAnnotationContainer != null && (irAnnotationContainer = irAnnotationContainer.getType()) != null) {
                if (IrTypePredicatesKt.isAny((IrType)irAnnotationContainer)) {
                    return true;
                }
                bl = false;
            } else {
                bl = false;
            }
            if (bl) return true;
            if (((Collection)$this$isToString.getOverriddenSymbols()).isEmpty()) return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isNullableToString(IrSimpleFunction $this$isNullableToString) {
            if (!Intrinsics.areEqual($this$isNullableToString.getName(), OperatorNameConventions.TO_STRING)) return false;
            if (!((Collection)$this$isNullableToString.getValueParameters()).isEmpty()) {
                return false;
            }
            boolean bl = false;
            if (bl) return false;
            if (!IrTypePredicatesKt.isString($this$isNullableToString.getReturnType())) {
                return false;
            }
            if ($this$isNullableToString.getDispatchReceiverParameter() != null) return false;
            IrValueParameter irValueParameter = $this$isNullableToString.getExtensionReceiverParameter();
            IrAnnotationContainer irAnnotationContainer = irValueParameter;
            if (irValueParameter == null) return false;
            IrType irType = irAnnotationContainer.getType();
            irAnnotationContainer = irType;
            if (irType == null) return false;
            if (!IrTypePredicatesKt.isNullableAny((IrType)irAnnotationContainer)) return false;
            boolean bl2 = true;
            if (!bl2) return false;
            FqName fqName2 = IrUtilsKt.getFqNameWhenAvailable($this$isNullableToString);
            if (!Intrinsics.areEqual(fqName2 != null ? fqName2.parent() : null, StandardNames.BUILT_INS_PACKAGE_FQ_NAME)) return false;
            return true;
        }

        private final boolean isToStringCall(IrCall $this$isToStringCall) {
            if ($this$isToStringCall.getSuperQualifierSymbol() != null) {
                return false;
            }
            IrSimpleFunction function2 = (IrSimpleFunction)$this$isToStringCall.getSymbol().getOwner();
            return this.isToString(function2) || this.isNullableToString(function2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isSpecialToStringCall(IrCall $this$isSpecialToStringCall) {
            if (!this.isToStringCall($this$isSpecialToStringCall)) return false;
            IrExpression irExpression = $this$isSpecialToStringCall.getDispatchReceiver();
            Object object = irExpression;
            if (irExpression == null) return true;
            IrType irType = ((IrExpression)object).getType();
            object = irType;
            if (irType == null) return true;
            if (IrTypePredicatesKt.isPrimitiveType$default((IrType)object, false, 1, null)) return true;
            return false;
        }

        private final boolean isStringConcatenationExpression(IrExpression expression2) {
            return expression2 instanceof IrStringConcatenation || expression2 instanceof IrCall && this.isStringPlusCall((IrCall)expression2);
        }

        private final List<IrExpression> collectStringConcatenationArguments(IrExpression expression2) {
            List arguments2 = new ArrayList();
            IrVisitorsKt.acceptChildrenVoid(expression2, new IrElementVisitorVoid(arguments2){
                final /* synthetic */ List<IrExpression> $arguments;
                {
                    this.$arguments = $arguments;
                }

                public void visitElement(IrElement element2) {
                    Intrinsics.checkNotNullParameter(element2, "element");
                    IrVisitorsKt.acceptChildrenVoid(element2, this);
                }

                public void visitCall(IrCall expression2) {
                    Intrinsics.checkNotNullParameter(expression2, "expression");
                    if (org.jetbrains.kotlin.backend.common.lower.FlattenStringConcatenationLowering$Companion.access$isStringConcatenationExpression(FlattenStringConcatenationLowering.Companion, expression2) || org.jetbrains.kotlin.backend.common.lower.FlattenStringConcatenationLowering$Companion.access$isToStringCall(FlattenStringConcatenationLowering.Companion, expression2)) {
                        IrVisitorsKt.acceptChildrenVoid(expression2, this);
                    } else {
                        this.$arguments.add(expression2);
                    }
                }

                public void visitStringConcatenation(IrStringConcatenation expression2) {
                    Intrinsics.checkNotNullParameter(expression2, "expression");
                    IrVisitorsKt.acceptChildrenVoid(expression2, this);
                }

                public void visitExpression(IrExpression expression2) {
                    Intrinsics.checkNotNullParameter(expression2, "expression");
                    this.$arguments.add(expression2);
                }

                public void visitElement(IrElement element2, Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitElement(this, element2, data2);
                }

                public void visitCall(IrCall expression2, Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2, data2);
                }

                public void visitStringConcatenation(IrStringConcatenation expression2, Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2, data2);
                }

                public void visitExpression(IrExpression expression2, Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2, data2);
                }

                public void visitAnonymousInitializer(IrAnonymousInitializer declaration2) {
                    IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration2);
                }

                public void visitAnonymousInitializer(IrAnonymousInitializer declaration2, Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration2, data2);
                }

                public void visitBlock(IrBlock expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2);
                }

                public void visitBlock(IrBlock expression2, Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2, data2);
                }

                public void visitBlockBody(IrBlockBody body2) {
                    IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2);
                }

                public void visitBlockBody(IrBlockBody body2, Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2, data2);
                }

                public void visitBody(IrBody body2) {
                    IrElementVisitorVoid.DefaultImpls.visitBody(this, body2);
                }

                public void visitBody(IrBody body2, Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitBody(this, body2, data2);
                }

                public void visitBranch(IrBranch branch) {
                    IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch);
                }

                public void visitBranch(IrBranch branch, Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch, data2);
                }

                public void visitBreak(IrBreak jump) {
                    IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump);
                }

                public void visitBreak(IrBreak jump, Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump, data2);
                }

                public void visitBreakContinue(IrBreakContinue jump) {
                    IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump);
                }

                public void visitBreakContinue(IrBreakContinue jump, Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump, data2);
                }

                public void visitCallableReference(IrCallableReference<?> expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2);
                }

                public void visitCallableReference(IrCallableReference<?> expression2, Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2, data2);
                }

                public void visitCatch(IrCatch aCatch) {
                    IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch);
                }

                public void visitCatch(IrCatch aCatch, Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch, data2);
                }

                public void visitClass(IrClass declaration2) {
                    IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration2);
                }

                public void visitClass(IrClass declaration2, Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration2, data2);
                }

                public void visitClassReference(IrClassReference expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2);
                }

                public void visitClassReference(IrClassReference expression2, Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2, data2);
                }

                public void visitComposite(IrComposite expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2);
                }

                public void visitComposite(IrComposite expression2, Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2, data2);
                }

                public void visitConst(IrConst<?> expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2);
                }

                public void visitConst(IrConst<?> expression2, Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2, data2);
                }

                public void visitConstantArray(IrConstantArray expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitConstantArray(this, expression2);
                }

                public void visitConstantArray(IrConstantArray expression2, Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitConstantArray(this, expression2, data2);
                }

                public void visitConstantObject(IrConstantObject expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitConstantObject(this, expression2);
                }

                public void visitConstantObject(IrConstantObject expression2, Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitConstantObject(this, expression2, data2);
                }

                public void visitConstantPrimitive(IrConstantPrimitive expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitConstantPrimitive(this, expression2);
                }

                public void visitConstantPrimitive(IrConstantPrimitive expression2, Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitConstantPrimitive(this, expression2, data2);
                }

                public void visitConstantValue(IrConstantValue expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitConstantValue(this, expression2);
                }

                public void visitConstantValue(IrConstantValue expression2, Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitConstantValue(this, expression2, data2);
                }

                public void visitConstructor(IrConstructor declaration2) {
                    IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration2);
                }

                public void visitConstructor(IrConstructor declaration2, Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration2, data2);
                }

                public void visitConstructorCall(IrConstructorCall expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression2);
                }

                public void visitConstructorCall(IrConstructorCall expression2, Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression2, data2);
                }

                public void visitContainerExpression(IrContainerExpression expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2);
                }

                public void visitContainerExpression(IrContainerExpression expression2, Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2, data2);
                }

                public void visitContinue(IrContinue jump) {
                    IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump);
                }

                public void visitContinue(IrContinue jump, Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump, data2);
                }

                public void visitDeclaration(IrDeclarationBase declaration2) {
                    IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration2);
                }

                public void visitDeclaration(IrDeclarationBase declaration2, Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration2, data2);
                }

                public void visitDeclarationReference(IrDeclarationReference expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2);
                }

                public void visitDeclarationReference(IrDeclarationReference expression2, Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2, data2);
                }

                public void visitDelegatingConstructorCall(IrDelegatingConstructorCall expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2);
                }

                public void visitDelegatingConstructorCall(IrDelegatingConstructorCall expression2, Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2, data2);
                }

                public void visitDoWhileLoop(IrDoWhileLoop loop2) {
                    IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop2);
                }

                public void visitDoWhileLoop(IrDoWhileLoop loop2, Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop2, data2);
                }

                public void visitDynamicExpression(IrDynamicExpression expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression2);
                }

                public void visitDynamicExpression(IrDynamicExpression expression2, Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression2, data2);
                }

                public void visitDynamicMemberExpression(IrDynamicMemberExpression expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression2);
                }

                public void visitDynamicMemberExpression(IrDynamicMemberExpression expression2, Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression2, data2);
                }

                public void visitDynamicOperatorExpression(IrDynamicOperatorExpression expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression2);
                }

                public void visitDynamicOperatorExpression(IrDynamicOperatorExpression expression2, Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression2, data2);
                }

                public void visitElseBranch(IrElseBranch branch) {
                    IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch);
                }

                public void visitElseBranch(IrElseBranch branch, Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch, data2);
                }

                public void visitEnumConstructorCall(IrEnumConstructorCall expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2);
                }

                public void visitEnumConstructorCall(IrEnumConstructorCall expression2, Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2, data2);
                }

                public void visitEnumEntry(IrEnumEntry declaration2) {
                    IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration2);
                }

                public void visitEnumEntry(IrEnumEntry declaration2, Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration2, data2);
                }

                public void visitErrorCallExpression(IrErrorCallExpression expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2);
                }

                public void visitErrorCallExpression(IrErrorCallExpression expression2, Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2, data2);
                }

                public void visitErrorDeclaration(IrErrorDeclaration declaration2) {
                    IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration2);
                }

                public void visitErrorDeclaration(IrErrorDeclaration declaration2, Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration2, data2);
                }

                public void visitErrorExpression(IrErrorExpression expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2);
                }

                public void visitErrorExpression(IrErrorExpression expression2, Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2, data2);
                }

                public void visitExpressionBody(IrExpressionBody body2) {
                    IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2);
                }

                public void visitExpressionBody(IrExpressionBody body2, Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2, data2);
                }

                public void visitExternalPackageFragment(IrExternalPackageFragment declaration2) {
                    IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration2);
                }

                public void visitExternalPackageFragment(IrExternalPackageFragment declaration2, Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration2, data2);
                }

                public void visitField(IrField declaration2) {
                    IrElementVisitorVoid.DefaultImpls.visitField(this, declaration2);
                }

                public void visitField(IrField declaration2, Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitField(this, declaration2, data2);
                }

                public void visitFieldAccess(IrFieldAccessExpression expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2);
                }

                public void visitFieldAccess(IrFieldAccessExpression expression2, Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2, data2);
                }

                public void visitFile(IrFile declaration2) {
                    IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration2);
                }

                public void visitFile(IrFile declaration2, Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration2, data2);
                }

                public void visitFunction(IrFunction declaration2) {
                    IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration2);
                }

                public void visitFunction(IrFunction declaration2, Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration2, data2);
                }

                public void visitFunctionAccess(IrFunctionAccessExpression expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2);
                }

                public void visitFunctionAccess(IrFunctionAccessExpression expression2, Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2, data2);
                }

                public void visitFunctionExpression(IrFunctionExpression expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression2);
                }

                public void visitFunctionExpression(IrFunctionExpression expression2, Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression2, data2);
                }

                public void visitFunctionReference(IrFunctionReference expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2);
                }

                public void visitFunctionReference(IrFunctionReference expression2, Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2, data2);
                }

                public void visitGetClass(IrGetClass expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2);
                }

                public void visitGetClass(IrGetClass expression2, Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2, data2);
                }

                public void visitGetEnumValue(IrGetEnumValue expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2);
                }

                public void visitGetEnumValue(IrGetEnumValue expression2, Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2, data2);
                }

                public void visitGetField(IrGetField expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2);
                }

                public void visitGetField(IrGetField expression2, Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2, data2);
                }

                public void visitGetObjectValue(IrGetObjectValue expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2);
                }

                public void visitGetObjectValue(IrGetObjectValue expression2, Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2, data2);
                }

                public void visitGetValue(IrGetValue expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2);
                }

                public void visitGetValue(IrGetValue expression2, Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2, data2);
                }

                public void visitInstanceInitializerCall(IrInstanceInitializerCall expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2);
                }

                public void visitInstanceInitializerCall(IrInstanceInitializerCall expression2, Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2, data2);
                }

                public void visitLocalDelegatedProperty(IrLocalDelegatedProperty declaration2) {
                    IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration2);
                }

                public void visitLocalDelegatedProperty(IrLocalDelegatedProperty declaration2, Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration2, data2);
                }

                public void visitLocalDelegatedPropertyReference(IrLocalDelegatedPropertyReference expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2);
                }

                public void visitLocalDelegatedPropertyReference(IrLocalDelegatedPropertyReference expression2, Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data2);
                }

                public void visitLoop(IrLoop loop2) {
                    IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop2);
                }

                public void visitLoop(IrLoop loop2, Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop2, data2);
                }

                public void visitMemberAccess(IrMemberAccessExpression<?> expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2);
                }

                public void visitMemberAccess(IrMemberAccessExpression<?> expression2, Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2, data2);
                }

                public void visitModuleFragment(IrModuleFragment declaration2) {
                    IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration2);
                }

                public void visitModuleFragment(IrModuleFragment declaration2, Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration2, data2);
                }

                public void visitPackageFragment(IrPackageFragment declaration2) {
                    IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration2);
                }

                public void visitPackageFragment(IrPackageFragment declaration2, Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration2, data2);
                }

                public void visitProperty(IrProperty declaration2) {
                    IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration2);
                }

                public void visitProperty(IrProperty declaration2, Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration2, data2);
                }

                public void visitPropertyReference(IrPropertyReference expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2);
                }

                public void visitPropertyReference(IrPropertyReference expression2, Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2, data2);
                }

                public void visitRawFunctionReference(IrRawFunctionReference expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference(this, expression2);
                }

                public void visitRawFunctionReference(IrRawFunctionReference expression2, Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference(this, expression2, data2);
                }

                public void visitReturn(IrReturn expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2);
                }

                public void visitReturn(IrReturn expression2, Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2, data2);
                }

                public void visitScript(IrScript declaration2) {
                    IrElementVisitorVoid.DefaultImpls.visitScript(this, declaration2);
                }

                public void visitScript(IrScript declaration2, Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitScript(this, declaration2, data2);
                }

                public void visitSetField(IrSetField expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2);
                }

                public void visitSetField(IrSetField expression2, Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2, data2);
                }

                public void visitSetValue(IrSetValue expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitSetValue(this, expression2);
                }

                public void visitSetValue(IrSetValue expression2, Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitSetValue(this, expression2, data2);
                }

                public void visitSimpleFunction(IrSimpleFunction declaration2) {
                    IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration2);
                }

                public void visitSimpleFunction(IrSimpleFunction declaration2, Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration2, data2);
                }

                public void visitSingletonReference(IrGetSingletonValue expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2);
                }

                public void visitSingletonReference(IrGetSingletonValue expression2, Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2, data2);
                }

                public void visitSpreadElement(IrSpreadElement spread) {
                    IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread);
                }

                public void visitSpreadElement(IrSpreadElement spread, Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread, data2);
                }

                public void visitSuspendableExpression(IrSuspendableExpression expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2);
                }

                public void visitSuspendableExpression(IrSuspendableExpression expression2, Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2, data2);
                }

                public void visitSuspensionPoint(IrSuspensionPoint expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2);
                }

                public void visitSuspensionPoint(IrSuspensionPoint expression2, Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2, data2);
                }

                public void visitSyntheticBody(IrSyntheticBody body2) {
                    IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2);
                }

                public void visitSyntheticBody(IrSyntheticBody body2, Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2, data2);
                }

                public void visitThrow(IrThrow expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2);
                }

                public void visitThrow(IrThrow expression2, Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2, data2);
                }

                public void visitTry(IrTry aTry) {
                    IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry);
                }

                public void visitTry(IrTry aTry, Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry, data2);
                }

                public void visitTypeAlias(IrTypeAlias declaration2) {
                    IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration2);
                }

                public void visitTypeAlias(IrTypeAlias declaration2, Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration2, data2);
                }

                public void visitTypeOperator(IrTypeOperatorCall expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2);
                }

                public void visitTypeOperator(IrTypeOperatorCall expression2, Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2, data2);
                }

                public void visitTypeParameter(IrTypeParameter declaration2) {
                    IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration2);
                }

                public void visitTypeParameter(IrTypeParameter declaration2, Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration2, data2);
                }

                public void visitValueAccess(IrValueAccessExpression expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitValueAccess(this, expression2);
                }

                public void visitValueAccess(IrValueAccessExpression expression2, Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitValueAccess(this, expression2, data2);
                }

                public void visitValueParameter(IrValueParameter declaration2) {
                    IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration2);
                }

                public void visitValueParameter(IrValueParameter declaration2, Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration2, data2);
                }

                public void visitVararg(IrVararg expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2);
                }

                public void visitVararg(IrVararg expression2, Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2, data2);
                }

                public void visitVariable(IrVariable declaration2) {
                    IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration2);
                }

                public void visitVariable(IrVariable declaration2, Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration2, data2);
                }

                public void visitWhen(IrWhen expression2) {
                    IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2);
                }

                public void visitWhen(IrWhen expression2, Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2, data2);
                }

                public void visitWhileLoop(IrWhileLoop loop2) {
                    IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop2);
                }

                public void visitWhileLoop(IrWhileLoop loop2, Void data2) {
                    IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop2, data2);
                }
            });
            return arguments2;
        }

        public static final /* synthetic */ boolean access$isToStringCall(Companion $this, IrCall $receiver) {
            return $this.isToStringCall($receiver);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

