/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.decompiler.konan;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.indexing.FileContent;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.decompiler.konan.FileWithMetadata;
import org.jetbrains.kotlin.analysis.decompiler.konan.KlibMetadataStubBuilder;
import org.jetbrains.kotlin.analysis.decompiler.stub.CallableClsStubBuilderKt;
import org.jetbrains.kotlin.analysis.decompiler.stub.ClassClsStubBuilderKt;
import org.jetbrains.kotlin.analysis.decompiler.stub.ClsStubBuilderComponents;
import org.jetbrains.kotlin.analysis.decompiler.stub.ClsStubBuilderContext;
import org.jetbrains.kotlin.analysis.decompiler.stub.ClsStubBuildingKt;
import org.jetbrains.kotlin.analysis.decompiler.stub.file.AnnotationLoaderForStubBuilderImpl;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.NameResolver;
import org.jetbrains.kotlin.metadata.deserialization.NameResolverImpl;
import org.jetbrains.kotlin.metadata.deserialization.TypeTable;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinFileStubImpl;
import org.jetbrains.kotlin.serialization.SerializerExtensionProtocol;
import org.jetbrains.kotlin.serialization.deserialization.AnnotationLoader;
import org.jetbrains.kotlin.serialization.deserialization.ClassDataFinder;
import org.jetbrains.kotlin.serialization.deserialization.NameResolverUtilKt;
import org.jetbrains.kotlin.serialization.deserialization.ProtoBasedClassDataFinder;
import org.jetbrains.kotlin.serialization.deserialization.ProtoContainer;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0014\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\f0\n\u00a2\u0006\u0002\u0010\rJ\u001c\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\b\u0010\u0014\u001a\u00020\u0003H\u0016R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/analysis/decompiler/konan/K2KlibMetadataStubBuilder;", "Lorg/jetbrains/kotlin/analysis/decompiler/konan/KlibMetadataStubBuilder;", "version", "", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "serializerProtocol", "Lkotlin/Function0;", "Lorg/jetbrains/kotlin/serialization/SerializerExtensionProtocol;", "readFile", "Lkotlin/Function1;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lorg/jetbrains/kotlin/analysis/decompiler/konan/FileWithMetadata;", "(ILcom/intellij/openapi/fileTypes/FileType;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;)V", "buildMetadataFileStub", "Lcom/intellij/psi/stubs/PsiFileStub;", "fileWithMetadata", "Lorg/jetbrains/kotlin/analysis/decompiler/konan/FileWithMetadata$Compatible;", "fileContent", "Lcom/intellij/util/indexing/FileContent;", "getStubVersion", "decompiler-native"})
public final class K2KlibMetadataStubBuilder
extends KlibMetadataStubBuilder {
    private final int version;
    @NotNull
    private final Function0<SerializerExtensionProtocol> serializerProtocol;

    public K2KlibMetadataStubBuilder(int version, @NotNull FileType fileType, @NotNull Function0<? extends SerializerExtensionProtocol> serializerProtocol, @NotNull Function1<? super VirtualFile, ? extends FileWithMetadata> readFile) {
        Intrinsics.checkNotNullParameter(fileType, "fileType");
        Intrinsics.checkNotNullParameter(serializerProtocol, "serializerProtocol");
        Intrinsics.checkNotNullParameter(readFile, "readFile");
        super(version, fileType, readFile);
        this.version = version;
        this.serializerProtocol = serializerProtocol;
    }

    @Override
    public int getStubVersion() {
        return this.version;
    }

    @Override
    @NotNull
    protected PsiFileStub<?> buildMetadataFileStub(@NotNull FileWithMetadata.Compatible fileWithMetadata, @NotNull FileContent fileContent) {
        Intrinsics.checkNotNullParameter(fileWithMetadata, "fileWithMetadata");
        Intrinsics.checkNotNullParameter(fileContent, "fileContent");
        ProtoBuf.Package packageProto = fileWithMetadata.getProto().getPackage();
        FqName packageFqName = fileWithMetadata.getPackageFqName();
        NameResolverImpl nameResolver2 = fileWithMetadata.getNameResolver();
        SerializerExtensionProtocol protocol = this.serializerProtocol.invoke();
        ClassDataFinder classDataFinder2 = new ProtoBasedClassDataFinder(fileWithMetadata.getProto(), nameResolver2, fileWithMetadata.getVersion(), null, 8, null);
        AnnotationLoader annotationLoader = new AnnotationLoaderForStubBuilderImpl(protocol);
        VirtualFile virtualFile2 = fileContent.getFile();
        Intrinsics.checkNotNullExpressionValue(virtualFile2, "getFile(...)");
        ClsStubBuilderComponents components2 = new ClsStubBuilderComponents(classDataFinder2, annotationLoader, virtualFile2, protocol, null, null, 48, null);
        NameResolver nameResolver3 = nameResolver2;
        ProtoBuf.TypeTable typeTable = packageProto.getTypeTable();
        Intrinsics.checkNotNullExpressionValue(typeTable, "getTypeTable(...)");
        ClsStubBuilderContext context2 = components2.createContext(nameResolver3, packageFqName, new TypeTable(typeTable));
        KotlinFileStubImpl fileStub = ClsStubBuildingKt.createFileStub(packageFqName, false);
        StubElement stubElement = fileStub;
        ProtoContainer.Package package_ = new ProtoContainer.Package(packageFqName, context2.getNameResolver(), context2.getTypeTable(), null);
        Intrinsics.checkNotNull(packageProto);
        CallableClsStubBuilderKt.createPackageDeclarationsStubs(stubElement, context2, package_, packageProto);
        for (ProtoBuf.Class classProto : fileWithMetadata.getClassesToDecompile()) {
            ClassClsStubBuilderKt.createClassStub(fileStub, classProto, nameResolver2, NameResolverUtilKt.getClassId(nameResolver2, classProto.getFqName()), null, context2);
        }
        return fileStub;
    }
}

