/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter.transformer;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.constant.EvaluatedConstTracker;
import org.jetbrains.kotlin.incremental.components.InlineConstTracker;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrElementBase;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionsKt;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrVarargElement;
import org.jetbrains.kotlin.ir.expressions.impl.IrVarargImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrVarargImplKt;
import org.jetbrains.kotlin.ir.interpreter.IrInterpreter;
import org.jetbrains.kotlin.ir.interpreter.UtilsKt;
import org.jetbrains.kotlin.ir.interpreter.checker.EvaluationMode;
import org.jetbrains.kotlin.ir.interpreter.checker.IrInterpreterChecker;
import org.jetbrains.kotlin.ir.interpreter.transformer.IrConstTransformer;
import org.jetbrains.kotlin.ir.types.IrErrorType;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b \u0018\u00002\u00020\u0001B\u0081\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u0012\u001e\u0010\u000e\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u000f\u0012\u001e\u0010\u0013\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u000f\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0002\u0010\u0016J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0004J\u0010\u0010\u001f\u001a\u00020\u00122\u0006\u0010 \u001a\u00020!H\u0004J\u0014\u0010\"\u001a\u00020\u001b*\u00020\u001b2\u0006\u0010#\u001a\u00020$H\u0002J\u0014\u0010%\u001a\u00020\u001b*\u00020\u001b2\u0006\u0010&\u001a\u00020$H\u0002J\f\u0010'\u001a\u00020(*\u00020(H\u0002\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/transformer/IrConstAnnotationTransformer;", "Lorg/jetbrains/kotlin/ir/interpreter/transformer/IrConstTransformer;", "interpreter", "Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreter;", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "mode", "Lorg/jetbrains/kotlin/ir/interpreter/checker/EvaluationMode;", "checker", "Lorg/jetbrains/kotlin/ir/interpreter/checker/IrInterpreterChecker;", "evaluatedConstTracker", "Lorg/jetbrains/kotlin/constant/EvaluatedConstTracker;", "inlineConstTracker", "Lorg/jetbrains/kotlin/incremental/components/InlineConstTracker;", "onWarning", "Lkotlin/Function3;", "Lorg/jetbrains/kotlin/ir/IrElement;", "Lorg/jetbrains/kotlin/ir/expressions/IrErrorExpression;", "", "onError", "suppressExceptions", "", "(Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreter;Lorg/jetbrains/kotlin/ir/declarations/IrFile;Lorg/jetbrains/kotlin/ir/interpreter/checker/EvaluationMode;Lorg/jetbrains/kotlin/ir/interpreter/checker/IrInterpreterChecker;Lorg/jetbrains/kotlin/constant/EvaluatedConstTracker;Lorg/jetbrains/kotlin/incremental/components/InlineConstTracker;Lkotlin/jvm/functions/Function3;Lkotlin/jvm/functions/Function3;Z)V", "transformAnnotation", "annotation", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "transformAnnotationArgument", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "argument", "valueParameter", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "transformAnnotations", "annotationContainer", "Lorg/jetbrains/kotlin/ir/declarations/IrAnnotationContainer;", "convertToConstIfPossible", "type", "Lorg/jetbrains/kotlin/ir/types/IrType;", "transformSingleArg", "expectedType", "transformVarArg", "Lorg/jetbrains/kotlin/ir/expressions/IrVararg;", "ir.interpreter"})
@SourceDebugExtension(value={"SMAP\nIrConstAnnotationTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrConstAnnotationTransformer.kt\norg/jetbrains/kotlin/ir/interpreter/transformer/IrConstAnnotationTransformer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,92:1\n1863#2,2:93\n1863#2,2:95\n*S KotlinDebug\n*F\n+ 1 IrConstAnnotationTransformer.kt\norg/jetbrains/kotlin/ir/interpreter/transformer/IrConstAnnotationTransformer\n*L\n39#1:93,2\n63#1:95,2\n*E\n"})
public abstract class IrConstAnnotationTransformer
extends IrConstTransformer {
    public IrConstAnnotationTransformer(@NotNull IrInterpreter interpreter2, @NotNull IrFile irFile, @NotNull EvaluationMode mode, @NotNull IrInterpreterChecker checker, @Nullable EvaluatedConstTracker evaluatedConstTracker, @Nullable InlineConstTracker inlineConstTracker, @NotNull Function3<? super IrFile, ? super IrElement, ? super IrErrorExpression, Unit> onWarning, @NotNull Function3<? super IrFile, ? super IrElement, ? super IrErrorExpression, Unit> onError, boolean suppressExceptions) {
        Intrinsics.checkNotNullParameter((Object)interpreter2, (String)"interpreter");
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        Intrinsics.checkNotNullParameter((Object)checker, (String)"checker");
        Intrinsics.checkNotNullParameter(onWarning, (String)"onWarning");
        Intrinsics.checkNotNullParameter(onError, (String)"onError");
        super(interpreter2, irFile, mode, checker, evaluatedConstTracker, inlineConstTracker, onWarning, onError, suppressExceptions);
    }

    protected final void transformAnnotations(@NotNull IrAnnotationContainer annotationContainer) {
        Intrinsics.checkNotNullParameter((Object)annotationContainer, (String)"annotationContainer");
        Iterable $this$forEach$iv = annotationContainer.getAnnotations();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrConstructorCall annotation2 = (IrConstructorCall)element$iv;
            boolean bl = false;
            this.transformAnnotation(annotation2);
        }
    }

    private final void transformAnnotation(IrConstructorCall annotation2) {
        int n = annotation2.getValueArgumentsCount();
        for (int i = 0; i < n; ++i) {
            IrExpression arg;
            if (annotation2.getValueArgument(i) == null) continue;
            annotation2.putValueArgument(i, this.transformAnnotationArgument(arg, ((IrConstructor)annotation2.getSymbol().getOwner()).getValueParameters().get(i)));
        }
    }

    @NotNull
    protected final IrExpression transformAnnotationArgument(@NotNull IrExpression argument2, @NotNull IrValueParameter valueParameter2) {
        Intrinsics.checkNotNullParameter((Object)argument2, (String)"argument");
        Intrinsics.checkNotNullParameter((Object)valueParameter2, (String)"valueParameter");
        return argument2 instanceof IrVararg ? (IrExpression)this.transformVarArg((IrVararg)argument2) : this.transformSingleArg(argument2, valueParameter2.getType());
    }

    private final IrVararg transformVarArg(IrVararg $this$transformVarArg) {
        if ($this$transformVarArg.getElements().isEmpty()) {
            return $this$transformVarArg;
        }
        IrVarargImpl newIrVararg = IrVarargImplKt.IrVarargImpl($this$transformVarArg.getStartOffset(), $this$transformVarArg.getEndOffset(), $this$transformVarArg.getType(), $this$transformVarArg.getVarargElementType());
        for (IrVarargElement element2 : $this$transformVarArg.getElements()) {
            IrVarargElement arg;
            IrElementBase irElementBase = element2 instanceof IrSpreadElement ? (IrSpreadElement)element2 : null;
            IrVarargElement irVarargElement = irElementBase != null && (irElementBase = irElementBase.getExpression()) != null ? (IrVarargElement)((Object)irElementBase) : (arg = element2);
            if (arg instanceof IrVararg) {
                Iterable $this$forEach$iv = this.transformVarArg((IrVararg)arg).getElements();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    IrVarargElement it = (IrVarargElement)element$iv;
                    boolean bl = false;
                    IrExpressionsKt.addElement(newIrVararg, it);
                }
                continue;
            }
            if (arg instanceof IrExpression) {
                IrExpressionsKt.addElement(newIrVararg, this.transformSingleArg((IrExpression)arg, $this$transformVarArg.getVarargElementType()));
                continue;
            }
            IrExpressionsKt.addElement(newIrVararg, arg);
        }
        return newIrVararg;
    }

    private final IrExpression transformSingleArg(IrExpression $this$transformSingleArg, IrType expectedType) {
        IrExpression irExpression;
        if ($this$transformSingleArg instanceof IrGetEnumValue || $this$transformSingleArg instanceof IrClassReference) {
            irExpression = $this$transformSingleArg;
        } else if ($this$transformSingleArg instanceof IrConstructorCall && IrTypeUtilsKt.isAnnotation($this$transformSingleArg.getType())) {
            this.transformAnnotation((IrConstructorCall)$this$transformSingleArg);
            irExpression = $this$transformSingleArg;
        } else if (this.canBeInterpreted($this$transformSingleArg)) {
            irExpression = this.convertToConstIfPossible(this.interpret($this$transformSingleArg, true), expectedType);
        } else {
            throw new IllegalStateException(("Cannot evaluate IR expression in annotation:\n " + DumpIrTreeKt.dump$default($this$transformSingleArg, null, 1, null)).toString());
        }
        return irExpression;
    }

    private final IrExpression convertToConstIfPossible(IrExpression $this$convertToConstIfPossible, IrType type2) {
        IrExpression irExpression;
        if (!($this$convertToConstIfPossible instanceof IrConst) || type2 instanceof IrErrorType) {
            irExpression = $this$convertToConstIfPossible;
        } else if (IrTypePredicatesKt.isArray(type2)) {
            Intrinsics.checkNotNull((Object)type2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.types.IrSimpleType");
            IrType irType = IrTypesKt.getTypeOrNull((IrTypeArgument)CollectionsKt.single(((IrSimpleType)type2).getArguments()));
            Intrinsics.checkNotNull((Object)irType);
            irExpression = this.convertToConstIfPossible($this$convertToConstIfPossible, irType);
        } else {
            irExpression = UtilsKt.isPrimitiveArray(type2) ? this.convertToConstIfPossible($this$convertToConstIfPossible, $this$convertToConstIfPossible.getType()) : (IrExpression)IrUtilsKt.toIrConst(((IrConst)$this$convertToConstIfPossible).getValue(), type2, $this$convertToConstIfPossible.getStartOffset(), $this$convertToConstIfPossible.getEndOffset());
        }
        return irExpression;
    }
}

