/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.serialization.constant;

import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirArrayLiteral;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirGetClassCall;
import org.jetbrains.kotlin.fir.expressions.FirLiteralExpression;
import org.jetbrains.kotlin.fir.expressions.FirNamedArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.FirPropertyAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirStringConcatenationCall;
import org.jetbrains.kotlin.fir.expressions.FirVarargArgumentsExpression;
import org.jetbrains.kotlin.fir.expressions.ReferenceUtilsKt;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.transformers.body.resolve.FirArrayOfCallTransformer;
import org.jetbrains.kotlin.fir.serialization.constant.ConstantValueUtilsKt;
import org.jetbrains.kotlin.fir.serialization.constant.FirToConstantValueTransformerKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFieldSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.visitors.FirDefaultVisitor;
import org.jetbrains.kotlin.types.ConstantValueKind;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u001d\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\fJ\u001d\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\u0010J\u001d\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\u0014J\u001d\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\u0018J\u001d\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\u001cJ\u001d\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u000b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010 J)\u0010!\u001a\u00020\u0002\"\u0004\b\u0000\u0010\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u0002H\"0$2\u0006\u0010\u000b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010%J\u001d\u0010&\u001a\u00020\u00022\u0006\u0010'\u001a\u00020(2\u0006\u0010\u000b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010)J\u001d\u0010*\u001a\u00020\u00022\u0006\u0010+\u001a\u00020,2\u0006\u0010\u000b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010-J\u001d\u0010.\u001a\u00020\u00022\u0006\u0010/\u001a\u0002002\u0006\u0010\u000b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u00101J\u001d\u00102\u001a\u00020\u00022\u0006\u00103\u001a\u0002042\u0006\u0010\u000b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u00105J\u001d\u00106\u001a\u00020\u00022\u0006\u00107\u001a\u0002082\u0006\u0010\u000b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u00109R\u0018\u0010\u0005\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lorg/jetbrains/kotlin/fir/serialization/constant/FirToConstantValueChecker;", "Lorg/jetbrains/kotlin/fir/visitors/FirDefaultVisitor;", "", "Lorg/jetbrains/kotlin/fir/FirSession;", "()V", "supportedConstKinds", "", "Lorg/jetbrains/kotlin/types/ConstantValueKind;", "visitAnnotation", "annotation", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "data", "(Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;Lorg/jetbrains/kotlin/fir/FirSession;)Ljava/lang/Boolean;", "visitAnnotationCall", "annotationCall", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotationCall;", "(Lorg/jetbrains/kotlin/fir/expressions/FirAnnotationCall;Lorg/jetbrains/kotlin/fir/FirSession;)Ljava/lang/Boolean;", "visitArrayLiteral", "arrayLiteral", "Lorg/jetbrains/kotlin/fir/expressions/FirArrayLiteral;", "(Lorg/jetbrains/kotlin/fir/expressions/FirArrayLiteral;Lorg/jetbrains/kotlin/fir/FirSession;)Ljava/lang/Boolean;", "visitElement", "element", "Lorg/jetbrains/kotlin/fir/FirElement;", "(Lorg/jetbrains/kotlin/fir/FirElement;Lorg/jetbrains/kotlin/fir/FirSession;)Ljava/lang/Boolean;", "visitFunctionCall", "functionCall", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "(Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;Lorg/jetbrains/kotlin/fir/FirSession;)Ljava/lang/Boolean;", "visitGetClassCall", "getClassCall", "Lorg/jetbrains/kotlin/fir/expressions/FirGetClassCall;", "(Lorg/jetbrains/kotlin/fir/expressions/FirGetClassCall;Lorg/jetbrains/kotlin/fir/FirSession;)Ljava/lang/Boolean;", "visitLiteralExpression", "T", "literalExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirLiteralExpression;", "(Lorg/jetbrains/kotlin/fir/expressions/FirLiteralExpression;Lorg/jetbrains/kotlin/fir/FirSession;)Ljava/lang/Boolean;", "visitNamedArgumentExpression", "namedArgumentExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirNamedArgumentExpression;", "(Lorg/jetbrains/kotlin/fir/expressions/FirNamedArgumentExpression;Lorg/jetbrains/kotlin/fir/FirSession;)Ljava/lang/Boolean;", "visitPropertyAccessExpression", "propertyAccessExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirPropertyAccessExpression;", "(Lorg/jetbrains/kotlin/fir/expressions/FirPropertyAccessExpression;Lorg/jetbrains/kotlin/fir/FirSession;)Ljava/lang/Boolean;", "visitQualifiedAccessExpression", "qualifiedAccessExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "(Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;Lorg/jetbrains/kotlin/fir/FirSession;)Ljava/lang/Boolean;", "visitStringConcatenationCall", "stringConcatenationCall", "Lorg/jetbrains/kotlin/fir/expressions/FirStringConcatenationCall;", "(Lorg/jetbrains/kotlin/fir/expressions/FirStringConcatenationCall;Lorg/jetbrains/kotlin/fir/FirSession;)Ljava/lang/Boolean;", "visitVarargArgumentsExpression", "varargArgumentsExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirVarargArgumentsExpression;", "(Lorg/jetbrains/kotlin/fir/expressions/FirVarargArgumentsExpression;Lorg/jetbrains/kotlin/fir/FirSession;)Ljava/lang/Boolean;", "fir-serialization"})
@SourceDebugExtension(value={"SMAP\nFirToConstantValueTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirToConstantValueTransformer.kt\norg/jetbrains/kotlin/fir/serialization/constant/FirToConstantValueChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n+ 4 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,319:1\n1734#2,3:320\n1734#2,3:324\n1734#2,3:331\n1734#2,3:334\n43#3:323\n43#3:330\n47#4:327\n17#4,2:328\n*S KotlinDebug\n*F\n+ 1 FirToConstantValueTransformer.kt\norg/jetbrains/kotlin/fir/serialization/constant/FirToConstantValueChecker\n*L\n261#1:320,3\n265#1:324,3\n307#1:331,3\n312#1:334,3\n265#1:323\n307#1:330\n282#1:327\n284#1:328,2\n*E\n"})
public final class FirToConstantValueChecker
extends FirDefaultVisitor<Boolean, FirSession> {
    @NotNull
    public static final FirToConstantValueChecker INSTANCE = new FirToConstantValueChecker();
    @NotNull
    private static final Set<ConstantValueKind<?>> supportedConstKinds;

    private FirToConstantValueChecker() {
    }

    @Override
    @NotNull
    public Boolean visitElement(@NotNull FirElement element2, @NotNull FirSession data2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        return false;
    }

    @Override
    @NotNull
    public <T> Boolean visitLiteralExpression(@NotNull FirLiteralExpression<T> literalExpression, @NotNull FirSession data2) {
        Intrinsics.checkNotNullParameter(literalExpression, (String)"literalExpression");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        return supportedConstKinds.contains(literalExpression.getKind());
    }

    @Override
    @NotNull
    public Boolean visitStringConcatenationCall(@NotNull FirStringConcatenationCall stringConcatenationCall, @NotNull FirSession data2) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)stringConcatenationCall, (String)"stringConcatenationCall");
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            Iterable $this$all$iv = stringConcatenationCall.getArgumentList().getArguments();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    FirExpression it = (FirExpression)element$iv;
                    boolean bl2 = false;
                    if (((Boolean)it.accept(this, data2)).booleanValue()) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    @Override
    @NotNull
    public Boolean visitArrayLiteral(@NotNull FirArrayLiteral arrayLiteral, @NotNull FirSession data2) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)arrayLiteral, (String)"arrayLiteral");
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            FirCall $this$arguments$iv = arrayLiteral;
            boolean $i$f$getArguments = false;
            Iterable $this$all$iv = $this$arguments$iv.getArgumentList().getArguments();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    FirExpression it = (FirExpression)element$iv;
                    boolean bl2 = false;
                    if (((Boolean)it.accept(this, data2)).booleanValue()) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    @Override
    @NotNull
    public Boolean visitAnnotation(@NotNull FirAnnotation annotation2, @NotNull FirSession data2) {
        Intrinsics.checkNotNullParameter((Object)annotation2, (String)"annotation");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        return true;
    }

    @Override
    @NotNull
    public Boolean visitAnnotationCall(@NotNull FirAnnotationCall annotationCall, @NotNull FirSession data2) {
        Intrinsics.checkNotNullParameter((Object)annotationCall, (String)"annotationCall");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        return true;
    }

    @Override
    @NotNull
    public Boolean visitGetClassCall(@NotNull FirGetClassCall getClassCall, @NotNull FirSession data2) {
        Intrinsics.checkNotNullParameter((Object)getClassCall, (String)"getClassCall");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        return ConstantValueUtilsKt.create(FirTypeUtilsKt.getResolvedType(getClassCall.getArgument())) != null;
    }

    @Override
    @NotNull
    public Boolean visitQualifiedAccessExpression(@NotNull FirQualifiedAccessExpression qualifiedAccessExpression, @NotNull FirSession data2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)qualifiedAccessExpression, (String)"qualifiedAccessExpression");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        FirCallableSymbol<?> firCallableSymbol = ReferenceUtilsKt.toResolvedCallableSymbol(qualifiedAccessExpression);
        if (firCallableSymbol == null) {
            return false;
        }
        FirCallableSymbol<?> symbol2 = firCallableSymbol;
        if (symbol2.getFir() instanceof FirEnumEntry) {
            bl = symbol2.getCallableId().getClassId() != null;
        } else if (symbol2 instanceof FirPropertySymbol) {
            FirMemberDeclaration $this$isConst$iv = (FirMemberDeclaration)((FirPropertySymbol)symbol2).getFir();
            boolean $i$f$isConst = false;
            bl = $this$isConst$iv.getStatus().isConst();
        } else if (symbol2 instanceof FirFieldSymbol) {
            Modality modality$iv;
            FirMemberDeclaration $this$isFinal$iv = (FirMemberDeclaration)((FirFieldSymbol)symbol2).getFir();
            boolean $i$f$isFinal = false;
            Modality modality = $this$isFinal$iv.getStatus().getModality();
            bl = modality == null ? true : (modality$iv = modality) == Modality.FINAL;
        } else if (symbol2 instanceof FirConstructorSymbol) {
            Object object = ClassMembersKt.containingClassLookupTag(symbol2);
            bl = (object != null && (object = LookupTagUtilsKt.toFirRegularClassSymbol((ConeClassLikeLookupTag)object, data2)) != null ? ((FirClassSymbol)object).getClassKind() : null) == ClassKind.ANNOTATION_CLASS;
        } else if (Intrinsics.areEqual((Object)symbol2.getCallableId().getPackageName().asString(), (Object)"kotlin")) {
            FirExpression dispatchReceiver = qualifiedAccessExpression.getDispatchReceiver();
            String string2 = symbol2.getCallableId().getCallableName().asString();
            if (!FirToConstantValueTransformerKt.access$getConstantIntrinsicCalls$p().contains(string2)) {
                bl = false;
            } else {
                FirExpression firExpression2 = dispatchReceiver;
                bl = firExpression2 != null ? (Boolean)firExpression2.accept(this, data2) : false;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public Boolean visitPropertyAccessExpression(@NotNull FirPropertyAccessExpression propertyAccessExpression, @NotNull FirSession data2) {
        Intrinsics.checkNotNullParameter((Object)propertyAccessExpression, (String)"propertyAccessExpression");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        return this.visitQualifiedAccessExpression((FirQualifiedAccessExpression)propertyAccessExpression, data2);
    }

    @Override
    @NotNull
    public Boolean visitFunctionCall(@NotNull FirFunctionCall functionCall, @NotNull FirSession data2) {
        Intrinsics.checkNotNullParameter((Object)functionCall, (String)"functionCall");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        if (FirArrayOfCallTransformer.Companion.isArrayOfCall(functionCall, data2)) {
            boolean bl;
            block4: {
                FirCall $this$arguments$iv = functionCall;
                boolean $i$f$getArguments = false;
                Iterable $this$all$iv = $this$arguments$iv.getArgumentList().getArguments();
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        FirExpression it = (FirExpression)element$iv;
                        boolean bl2 = false;
                        if (((Boolean)it.accept(this, data2)).booleanValue()) continue;
                        bl = false;
                        break block4;
                    }
                    bl = true;
                }
            }
            return bl;
        }
        return this.visitQualifiedAccessExpression((FirQualifiedAccessExpression)functionCall, data2);
    }

    @Override
    @NotNull
    public Boolean visitVarargArgumentsExpression(@NotNull FirVarargArgumentsExpression varargArgumentsExpression, @NotNull FirSession data2) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)varargArgumentsExpression, (String)"varargArgumentsExpression");
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            Iterable $this$all$iv = varargArgumentsExpression.getArguments();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    FirExpression it = (FirExpression)element$iv;
                    boolean bl2 = false;
                    if (((Boolean)it.accept(this, data2)).booleanValue()) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    @Override
    @NotNull
    public Boolean visitNamedArgumentExpression(@NotNull FirNamedArgumentExpression namedArgumentExpression, @NotNull FirSession data2) {
        Intrinsics.checkNotNullParameter((Object)namedArgumentExpression, (String)"namedArgumentExpression");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        return (Boolean)namedArgumentExpression.getExpression().accept(this, data2);
    }

    static {
        Object[] objectArray = new ConstantValueKind[]{ConstantValueKind.Boolean.INSTANCE, ConstantValueKind.Char.INSTANCE, ConstantValueKind.String.INSTANCE, ConstantValueKind.Float.INSTANCE, ConstantValueKind.Double.INSTANCE, ConstantValueKind.Byte.INSTANCE, ConstantValueKind.UnsignedByte.INSTANCE, ConstantValueKind.Short.INSTANCE, ConstantValueKind.UnsignedShort.INSTANCE, ConstantValueKind.Int.INSTANCE, ConstantValueKind.UnsignedInt.INSTANCE, ConstantValueKind.Long.INSTANCE, ConstantValueKind.UnsignedLong.INSTANCE};
        supportedConstKinds = SetsKt.setOf((Object[])objectArray);
    }
}

