/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers.body.resolve;

import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.synthetic.FirSyntheticProperty;
import org.jetbrains.kotlin.fir.resolve.transformers.body.resolve.ImplicitBodyResolveComputationStatus;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirSyntheticPropertySymbol;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J3\u0010\b\u001a\u0002H\t\"\b\b\u0000\u0010\t*\u00020\n2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\u00052\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\t0\rH\u0000\u00a2\u0006\u0004\b\u000e\u0010\u000fJ1\u0010\u0010\u001a\u0002H\t\"\b\b\u0000\u0010\t*\u00020\n2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\u00052\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\t0\rH\u0014\u00a2\u0006\u0002\u0010\u000fJ\u0019\u0010\u0011\u001a\u00020\u00062\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0000\u00a2\u0006\u0002\b\u0012J\u0014\u0010\u0013\u001a\u00020\u00142\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0002J\u001c\u0010\u0015\u001a\u00020\u00142\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\u00052\u0006\u0010\u0016\u001a\u00020\nH\u0002R2\u0010\u0003\u001a&\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/body/resolve/ImplicitBodyResolveComputationSession;", "", "()V", "implicitBodyResolveStatusMap", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/body/resolve/ImplicitBodyResolveComputationStatus;", "Lkotlin/collections/HashMap;", "compute", "D", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "symbol", "transformation", "Lkotlin/Function0;", "compute$resolve", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;Lkotlin/jvm/functions/Function0;)Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "executeTransformation", "getStatus", "getStatus$resolve", "startComputing", "", "storeResult", "transformedDeclaration", "resolve"})
public class ImplicitBodyResolveComputationSession {
    @NotNull
    private final HashMap<FirCallableSymbol<?>, ImplicitBodyResolveComputationStatus> implicitBodyResolveStatusMap = new HashMap();

    @NotNull
    public final ImplicitBodyResolveComputationStatus getStatus$resolve(@NotNull FirCallableSymbol<?> symbol2) {
        FirProperty fir;
        Intrinsics.checkNotNullParameter(symbol2, (String)"symbol");
        if (symbol2 instanceof FirSyntheticPropertySymbol && (fir = (FirProperty)((FirSyntheticPropertySymbol)symbol2).getFir()) instanceof FirSyntheticProperty) {
            return this.getStatus$resolve(((FirSyntheticProperty)fir).getGetter().getDelegate().getSymbol());
        }
        ImplicitBodyResolveComputationStatus implicitBodyResolveComputationStatus = this.implicitBodyResolveStatusMap.get(symbol2);
        if (implicitBodyResolveComputationStatus == null) {
            implicitBodyResolveComputationStatus = ImplicitBodyResolveComputationStatus.NotComputed.INSTANCE;
        }
        return implicitBodyResolveComputationStatus;
    }

    @NotNull
    protected <D extends FirCallableDeclaration> D executeTransformation(@NotNull FirCallableSymbol<?> symbol2, @NotNull Function0<? extends D> transformation) {
        Intrinsics.checkNotNullParameter(symbol2, (String)"symbol");
        Intrinsics.checkNotNullParameter(transformation, (String)"transformation");
        return (D)((FirCallableDeclaration)transformation.invoke());
    }

    @NotNull
    public final <D extends FirCallableDeclaration> D compute$resolve(@NotNull FirCallableSymbol<?> symbol2, @NotNull Function0<? extends D> transformation) {
        Intrinsics.checkNotNullParameter(symbol2, (String)"symbol");
        Intrinsics.checkNotNullParameter(transformation, (String)"transformation");
        this.startComputing(symbol2);
        D result2 = this.executeTransformation(symbol2, transformation);
        this.storeResult(symbol2, (FirCallableDeclaration)result2);
        return result2;
    }

    private final void startComputing(FirCallableSymbol<?> symbol2) {
        if (!(this.implicitBodyResolveStatusMap.get(symbol2) == null)) {
            boolean bl = false;
            String string2 = "Unexpected static in startComputing for " + symbol2 + ": " + this.implicitBodyResolveStatusMap.get(symbol2);
            throw new IllegalArgumentException(string2.toString());
        }
        ((Map)this.implicitBodyResolveStatusMap).put(symbol2, ImplicitBodyResolveComputationStatus.Computing.INSTANCE);
    }

    private final void storeResult(FirCallableSymbol<?> symbol2, FirCallableDeclaration transformedDeclaration) {
        if (!Intrinsics.areEqual((Object)this.implicitBodyResolveStatusMap.get(symbol2), (Object)ImplicitBodyResolveComputationStatus.Computing.INSTANCE)) {
            boolean bl = false;
            String string2 = "Unexpected static in storeResult for " + symbol2 + ": " + this.implicitBodyResolveStatusMap.get(symbol2);
            throw new IllegalArgumentException(string2.toString());
        }
        FirTypeRef returnTypeRef = transformedDeclaration.getReturnTypeRef();
        if (!(returnTypeRef instanceof FirResolvedTypeRef)) {
            boolean bl = false;
            String string3 = "Not FirResolvedTypeRef (" + UtilsKt.render(transformedDeclaration.getReturnTypeRef()) + ") in storeResult for: " + UtilsKt.render((FirElement)symbol2.getFir());
            throw new IllegalArgumentException(string3.toString());
        }
        ((Map)this.implicitBodyResolveStatusMap).put(symbol2, new ImplicitBodyResolveComputationStatus.Computed((FirResolvedTypeRef)returnTypeRef, transformedDeclaration));
    }
}

