/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.contracts.description.LogicOperationKind;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirEvaluatorResult;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirField;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirArgumentList;
import org.jetbrains.kotlin.fir.expressions.FirArgumentUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirArrayLiteral;
import org.jetbrains.kotlin.fir.expressions.FirBinaryLogicExpression;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirComparisonExpression;
import org.jetbrains.kotlin.fir.expressions.FirEqualityOperatorCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirGetClassCall;
import org.jetbrains.kotlin.fir.expressions.FirIntegerLiteralOperatorCall;
import org.jetbrains.kotlin.fir.expressions.FirLazyExpression;
import org.jetbrains.kotlin.fir.expressions.FirLiteralExpression;
import org.jetbrains.kotlin.fir.expressions.FirNamedArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.FirOperation;
import org.jetbrains.kotlin.fir.expressions.FirPropertyAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import org.jetbrains.kotlin.fir.expressions.FirSpreadArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.FirStringConcatenationCall;
import org.jetbrains.kotlin.fir.expressions.FirTypeOperatorCall;
import org.jetbrains.kotlin.fir.expressions.FirVarargArgumentsExpression;
import org.jetbrains.kotlin.fir.expressions.ReferenceUtilsKt;
import org.jetbrains.kotlin.fir.expressions.builder.FirArgumentListBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirArrayLiteralBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirFunctionCallBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirNamedArgumentExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirSpreadArgumentExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirVarargArgumentsExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.impl.FirResolvedArgumentList;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.resolve.diagnostics.FirConstChecksKt;
import org.jetbrains.kotlin.fir.resolve.transformers.FirCompileTimeConstantEvaluatorKt;
import org.jetbrains.kotlin.fir.resolve.transformers.FirExpressionEvaluator;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirEnumEntrySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFieldSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeSimpleKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirErrorTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeProjection;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.fir.visitors.FirVisitor;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.ConstantValueKind;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001eB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0018\u0010\u000b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\nJ\u0018\u0010\u000e\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\nJ\"\u0010\u0011\u001a\u00020\u0012*\u0004\u0018\u00010\u00132\u0006\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002J\u0014\u0010\u0016\u001a\u00020\u0006*\u00020\u00132\u0006\u0010\t\u001a\u00020\nH\u0002J)\u0010\u0017\u001a\u0002H\u0018\"\u0004\b\u0000\u0010\u0018*\u0006\u0012\u0002\b\u00030\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00180\u001bH\u0002\u00a2\u0006\u0002\u0010\u001cJ\u0010\u0010\u001d\u001a\u00020\u0012*\u0006\u0012\u0002\b\u00030\u0019H\u0002\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/FirExpressionEvaluator;", "", "()V", "evaluateAnnotationArguments", "", "Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/kotlin/fir/FirEvaluatorResult;", "annotationCall", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotationCall;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "evaluateDefault", "valueParameter", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "evaluatePropertyInitializer", "property", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "canBeEvaluated", "", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "expectedType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "evaluate", "visit", "T", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "block", "Lkotlin/Function0;", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "wasVisited", "EvaluationVisitor", "resolve"})
@SourceDebugExtension(value={"SMAP\nFirCompileTimeConstantEvaluator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirCompileTimeConstantEvaluator.kt\norg/jetbrains/kotlin/fir/resolve/transformers/FirExpressionEvaluator\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,520:1\n47#2:521\n188#3,3:522\n126#3:525\n153#3,3:526\n*S KotlinDebug\n*F\n+ 1 FirCompileTimeConstantEvaluator.kt\norg/jetbrains/kotlin/fir/resolve/transformers/FirExpressionEvaluator\n*L\n43#1:521\n78#1:522,3\n82#1:525\n82#1:526,3\n*E\n"})
public final class FirExpressionEvaluator {
    @NotNull
    public static final FirExpressionEvaluator INSTANCE = new FirExpressionEvaluator();

    private FirExpressionEvaluator() {
    }

    @Nullable
    public final FirEvaluatorResult evaluatePropertyInitializer(@NotNull FirProperty property2, @NotNull FirSession session2) {
        ConeKotlinType type2;
        Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        FirMemberDeclaration $this$isConst$iv = property2;
        boolean $i$f$isConst = false;
        if (!$this$isConst$iv.getStatus().isConst()) {
            return null;
        }
        ConeKotlinType coneKotlinType = FirTypeUtilsKt.getConeTypeOrNull(property2.getReturnTypeRef());
        ConeKotlinType coneKotlinType2 = type2 = coneKotlinType != null ? TypeExpansionUtilsKt.fullyExpandedType(coneKotlinType, session2) : null;
        if (type2 == null || type2 instanceof ConeErrorType || !FirConstChecksKt.canBeUsedForConstVal(type2)) {
            return null;
        }
        FirExpression initializer2 = property2.getInitializer();
        if (initializer2 == null || !this.canBeEvaluated(initializer2, session2, type2)) {
            return null;
        }
        return this.evaluate(initializer2, session2);
    }

    @Nullable
    public final FirEvaluatorResult evaluateDefault(@NotNull FirValueParameter valueParameter2, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter((Object)valueParameter2, (String)"valueParameter");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        if (!DeclarationUtilsKt.isAnnotationConstructor((FirBasedSymbol)valueParameter2.getContainingFunctionSymbol(), session2)) {
            return null;
        }
        FirExpression firExpression2 = valueParameter2.getDefaultValue();
        if (firExpression2 == null) {
            return null;
        }
        FirExpression defaultValueToEvaluate = firExpression2;
        if (!this.canBeEvaluated(defaultValueToEvaluate, session2, FirTypeUtilsKt.getConeTypeOrNull(valueParameter2.getReturnTypeRef()))) {
            return null;
        }
        return this.evaluate(defaultValueToEvaluate, session2);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Map<Name, FirEvaluatorResult> evaluateAnnotationArguments(@NotNull FirAnnotationCall annotationCall, @NotNull FirSession session2) {
        void $this$mapTo$iv$iv;
        Object object;
        boolean bl;
        FirResolvedArgumentList argumentList2;
        block7: {
            Intrinsics.checkNotNullParameter((Object)annotationCall, (String)"annotationCall");
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            if (annotationCall.getAnnotationTypeRef() instanceof FirErrorTypeRef) {
                return null;
            }
            FirArgumentList firArgumentList = annotationCall.getArgumentList();
            FirResolvedArgumentList firResolvedArgumentList = firArgumentList instanceof FirResolvedArgumentList ? (FirResolvedArgumentList)firArgumentList : null;
            if (firResolvedArgumentList == null) {
                return null;
            }
            argumentList2 = firResolvedArgumentList;
            Map $this$any$iv = argumentList2.getMapping();
            boolean $i$f$any = false;
            if ($this$any$iv.isEmpty()) {
                bl = false;
            } else {
                object = $this$any$iv.entrySet().iterator();
                while (object.hasNext()) {
                    FirValueParameter parameter2;
                    Map.Entry element$iv;
                    Map.Entry entry = element$iv = object.next();
                    boolean bl2 = false;
                    FirExpression expr = (FirExpression)entry.getKey();
                    if (!(!INSTANCE.canBeEvaluated(expr, session2, FirTypeUtilsKt.getConeTypeOrNull((parameter2 = (FirValueParameter)entry.getValue()).getReturnTypeRef())))) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        if (bl) {
            return null;
        }
        Map $this$map$iv = argumentList2.getMapping();
        boolean $i$f$map = false;
        object = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            FirExpression expression2 = (FirExpression)entry.getKey();
            FirValueParameter parameter3 = (FirValueParameter)entry.getValue();
            collection.add(TuplesKt.to((Object)parameter3.getName(), (Object)INSTANCE.evaluate(expression2, session2)));
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    private final boolean canBeEvaluated(FirExpression $this$canBeEvaluated, FirSession session2, ConeKotlinType expectedType) {
        boolean intrinsicConstEvaluation = FirLanguageSettingsComponentKt.getLanguageVersionSettings(session2).supportsFeature(LanguageFeature.IntrinsicConstEvaluation);
        if ($this$canBeEvaluated == null || intrinsicConstEvaluation || $this$canBeEvaluated instanceof FirLazyExpression || !FirTypeUtilsKt.isResolved($this$canBeEvaluated)) {
            return false;
        }
        if (expectedType != null && !TypeUtilsKt.isSubtypeOf$default(FirTypeUtilsKt.getResolvedType($this$canBeEvaluated), expectedType, session2, false, 4, null)) {
            return false;
        }
        return FirConstChecksKt.canBeEvaluatedAtCompileTime($this$canBeEvaluated, session2, false, false);
    }

    static /* synthetic */ boolean canBeEvaluated$default(FirExpressionEvaluator firExpressionEvaluator, FirExpression firExpression2, FirSession firSession, ConeKotlinType coneKotlinType, int n, Object object) {
        if ((n & 2) != 0) {
            coneKotlinType = null;
        }
        return firExpressionEvaluator.canBeEvaluated(firExpression2, firSession, coneKotlinType);
    }

    private final FirEvaluatorResult evaluate(FirExpression $this$evaluate, FirSession session2) {
        EvaluationVisitor visitor2 = new EvaluationVisitor(session2);
        return visitor2.evaluate($this$evaluate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> T visit(FirCallableSymbol<?> $this$visit, Function0<? extends T> block) {
        Object object = $this$visit.getFir();
        FirProperty firProperty = object instanceof FirProperty ? (FirProperty)object : null;
        if (firProperty == null) {
            return (T)block.invoke();
        }
        FirProperty firProperty2 = firProperty;
        FirEvaluatorResult oldEvaluatedResult = DeclarationAttributesKt.getEvaluatedInitializer(firProperty2);
        DeclarationAttributesKt.setEvaluatedInitializer(firProperty2, FirEvaluatorResult.DuringEvaluation.INSTANCE);
        try {
            object = block.invoke();
            return (T)object;
        }
        finally {
            DeclarationAttributesKt.setEvaluatedInitializer(firProperty2, oldEvaluatedResult);
        }
    }

    private final boolean wasVisited(FirCallableSymbol<?> $this$wasVisited) {
        Object e = $this$wasVisited.getFir();
        FirProperty firProperty = e instanceof FirProperty ? (FirProperty)e : null;
        if (firProperty == null) {
            return false;
        }
        FirProperty firProperty2 = firProperty;
        return Intrinsics.areEqual((Object)DeclarationAttributesKt.getEvaluatedInitializer(firProperty2), (Object)FirEvaluatorResult.DuringEvaluation.INSTANCE);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00b8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\u00022\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ\u001a\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u0016J\u0010\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u001a\u0010\u001c\u001a\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u001f\u001a\u00020\u00022\u0006\u0010 \u001a\u00020!2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\"\u001a\u00020\u00022\u0006\u0010#\u001a\u00020\u001b2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010$\u001a\u00020\u00022\u0006\u0010%\u001a\u00020&2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010'\u001a\u00020\u00022\u0006\u0010(\u001a\u00020)2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u0016J&\u0010*\u001a\u00020\u0002\"\u0004\b\u0000\u0010+2\f\u0010,\u001a\b\u0012\u0004\u0012\u0002H+0-2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010.\u001a\u00020\u00022\u0006\u0010/\u001a\u0002002\b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u0016J\u0018\u00101\u001a\u00020\u00022\u0006\u0010#\u001a\u00020\u001b2\u0006\u00102\u001a\u000203H\u0002J\u001a\u00104\u001a\u00020\u00022\u0006\u00105\u001a\u0002062\b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u00107\u001a\u00020\u00022\u0006\u00108\u001a\u0002092\b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010:\u001a\u00020\u00022\u0006\u0010;\u001a\u00020<2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010=\u001a\u00020\u00022\u0006\u0010>\u001a\u00020?2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010@\u001a\u00020\u00022\u0006\u0010A\u001a\u00020B2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010C\u001a\u00020\u00022\u0006\u0010D\u001a\u00020E2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010F\u001a\u00020\u00022\u0006\u0010G\u001a\u00020H2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006I"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/FirExpressionEvaluator$EvaluationVisitor;", "Lorg/jetbrains/kotlin/fir/visitors/FirVisitor;", "Lorg/jetbrains/kotlin/fir/FirEvaluatorResult;", "", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "(Lorg/jetbrains/kotlin/fir/FirSession;)V", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "evaluate", "expression", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "visitArgumentList", "argumentList", "Lorg/jetbrains/kotlin/fir/expressions/FirArgumentList;", "data", "visitArrayLiteral", "arrayLiteral", "Lorg/jetbrains/kotlin/fir/expressions/FirArrayLiteral;", "visitBinaryLogicExpression", "binaryLogicExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirBinaryLogicExpression;", "visitComparisonExpression", "comparisonExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirComparisonExpression;", "visitConstructorCall", "constructorCall", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "visitElement", "element", "Lorg/jetbrains/kotlin/fir/FirElement;", "visitEqualityOperatorCall", "equalityOperatorCall", "Lorg/jetbrains/kotlin/fir/expressions/FirEqualityOperatorCall;", "visitFunctionCall", "functionCall", "visitGetClassCall", "getClassCall", "Lorg/jetbrains/kotlin/fir/expressions/FirGetClassCall;", "visitIntegerLiteralOperatorCall", "integerLiteralOperatorCall", "Lorg/jetbrains/kotlin/fir/expressions/FirIntegerLiteralOperatorCall;", "visitLiteralExpression", "T", "literalExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirLiteralExpression;", "visitNamedArgumentExpression", "namedArgumentExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirNamedArgumentExpression;", "visitNamedFunction", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "visitPropertyAccessExpression", "propertyAccessExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirPropertyAccessExpression;", "visitResolvedNamedReference", "resolvedNamedReference", "Lorg/jetbrains/kotlin/fir/references/FirResolvedNamedReference;", "visitResolvedQualifier", "resolvedQualifier", "Lorg/jetbrains/kotlin/fir/expressions/FirResolvedQualifier;", "visitSpreadArgumentExpression", "spreadArgumentExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirSpreadArgumentExpression;", "visitStringConcatenationCall", "stringConcatenationCall", "Lorg/jetbrains/kotlin/fir/expressions/FirStringConcatenationCall;", "visitTypeOperatorCall", "typeOperatorCall", "Lorg/jetbrains/kotlin/fir/expressions/FirTypeOperatorCall;", "visitVarargArgumentsExpression", "varargArgumentsExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirVarargArgumentsExpression;", "resolve"})
    @SourceDebugExtension(value={"SMAP\nFirCompileTimeConstantEvaluator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirCompileTimeConstantEvaluator.kt\norg/jetbrains/kotlin/fir/resolve/transformers/FirExpressionEvaluator$EvaluationVisitor\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 FirEvaluatorResult.kt\norg/jetbrains/kotlin/fir/FirEvaluatorResultKt\n+ 5 FirArgumentListBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirArgumentListBuilderKt\n+ 6 FirNamedArgumentExpressionBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirNamedArgumentExpressionBuilderKt\n+ 7 FirArrayLiteralBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirArrayLiteralBuilderKt\n+ 8 FirVarargArgumentsExpressionBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirVarargArgumentsExpressionBuilderKt\n+ 9 FirSpreadArgumentExpressionBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirSpreadArgumentExpressionBuilderKt\n+ 10 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n+ 11 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 12 FirFunctionCallBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirFunctionCallBuilderKt\n*L\n1#1,520:1\n423#2:521\n1246#3,2:522\n1249#3:528\n1557#3:533\n1628#3,2:534\n1630#3:540\n1557#3:561\n1628#3,2:562\n1630#3:568\n1557#3:582\n1628#3,2:583\n1630#3:589\n1557#3:613\n1628#3,2:614\n1630#3:620\n1557#3:633\n1628#3,2:634\n1630#3:640\n27#4,4:524\n27#4,4:536\n27#4,4:545\n27#4,4:553\n27#4,4:564\n27#4,4:573\n27#4,4:577\n27#4,4:585\n27#4,6:591\n27#4,6:602\n27#4,4:608\n27#4,4:616\n27#4,6:621\n27#4,6:627\n27#4,4:636\n27#4,6:642\n33#5,4:529\n54#6,4:541\n44#7,4:549\n46#8,4:557\n53#9,4:569\n43#10:581\n45#10:601\n43#10:612\n45#10:641\n1#11:590\n63#12,4:597\n*S KotlinDebug\n*F\n+ 1 FirCompileTimeConstantEvaluator.kt\norg/jetbrains/kotlin/fir/resolve/transformers/FirExpressionEvaluator$EvaluationVisitor\n*L\n145#1:521\n145#1:522,2\n145#1:528\n149#1:533\n149#1:534,2\n149#1:540\n180#1:561\n180#1:562,2\n180#1:568\n242#1:582\n242#1:583,2\n242#1:589\n308#1:613\n308#1:614,2\n308#1:620\n338#1:633\n338#1:634,2\n338#1:640\n145#1:524,4\n149#1:536,4\n158#1:545,4\n170#1:553,4\n180#1:564,4\n189#1:573,4\n215#1:577,4\n243#1:585,4\n265#1:591,6\n279#1:602,6\n295#1:608,4\n309#1:616,4\n326#1:621,6\n327#1:627,6\n339#1:636,4\n347#1:642,6\n147#1:529,4\n155#1:541,4\n166#1:549,4\n176#1:557,4\n186#1:569,4\n242#1:581\n278#1:601\n308#1:612\n347#1:641\n266#1:597,4\n*E\n"})
    private static final class EvaluationVisitor
    extends FirVisitor {
        @NotNull
        private final FirSession session;

        public EvaluationVisitor(@NotNull FirSession session2) {
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            this.session = session2;
        }

        @NotNull
        public final FirSession getSession() {
            return this.session;
        }

        @NotNull
        public final FirEvaluatorResult evaluate(@Nullable FirExpression expression2) {
            Object object = expression2;
            if (object == null || (object = (FirEvaluatorResult)((FirExpression)object).accept(this, null)) == null) {
                object = FirEvaluatorResult.NotEvaluated.INSTANCE;
            }
            return object;
        }

        @NotNull
        public FirEvaluatorResult visitElement(@NotNull FirElement element2, @Nullable Void data2) {
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            throw new IllegalStateException(("FIR element \"" + Reflection.getOrCreateKotlinClass(element2.getClass()) + "\" is not supported in constant evaluation").toString());
        }

        @NotNull
        public <T> FirEvaluatorResult visitLiteralExpression(@NotNull FirLiteralExpression<T> literalExpression, @Nullable Void data2) {
            Intrinsics.checkNotNullParameter(literalExpression, (String)"literalExpression");
            return FirCompileTimeConstantEvaluatorKt.access$wrap(literalExpression);
        }

        @NotNull
        public FirEvaluatorResult visitResolvedNamedReference(@NotNull FirResolvedNamedReference resolvedNamedReference, @Nullable Void data2) {
            Intrinsics.checkNotNullParameter((Object)resolvedNamedReference, (String)"resolvedNamedReference");
            return FirCompileTimeConstantEvaluatorKt.access$wrap(resolvedNamedReference);
        }

        @NotNull
        public FirEvaluatorResult visitResolvedQualifier(@NotNull FirResolvedQualifier resolvedQualifier, @Nullable Void data2) {
            Intrinsics.checkNotNullParameter((Object)resolvedQualifier, (String)"resolvedQualifier");
            return FirCompileTimeConstantEvaluatorKt.access$wrap(resolvedQualifier);
        }

        @NotNull
        public FirEvaluatorResult visitGetClassCall(@NotNull FirGetClassCall getClassCall, @Nullable Void data2) {
            Intrinsics.checkNotNullParameter((Object)getClassCall, (String)"getClassCall");
            return FirCompileTimeConstantEvaluatorKt.access$wrap(getClassCall);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public FirEvaluatorResult visitArgumentList(@NotNull FirArgumentList argumentList2, @Nullable Void data2) {
            FirArgumentList firArgumentList;
            Intrinsics.checkNotNullParameter((Object)argumentList2, (String)"argumentList");
            if (argumentList2 instanceof FirResolvedArgumentList) {
                void destination$iv;
                void $this$mapKeysTo$iv;
                Map map = ((FirResolvedArgumentList)argumentList2).getMapping();
                Map map2 = new LinkedHashMap();
                FirArgumentList firArgumentList2 = ((FirResolvedArgumentList)argumentList2).getOriginalArgumentList();
                boolean $i$f$mapKeysTo = false;
                Iterable $this$associateByTo$iv$iv = $this$mapKeysTo$iv.entrySet();
                boolean $i$f$associateByTo = false;
                for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                    void it$iv;
                    FirExpression firExpression2;
                    FirExpression it;
                    Map.Entry entry = (Map.Entry)element$iv$iv;
                    void var24_35 = destination$iv;
                    boolean $i$a$-mapKeysTo-FirExpressionEvaluator$EvaluationVisitor$visitArgumentList$22 = false;
                    FirEvaluatorResult $this$unwrapOr$iv = this.evaluate((FirExpression)it.getKey());
                    boolean $i$f$unwrapOr = false;
                    FirEvaluatorResult firEvaluatorResult = $this$unwrapOr$iv;
                    if (firEvaluatorResult instanceof FirEvaluatorResult.CompileTimeException) {
                        FirEvaluatorResult.CompileTimeException it2 = (FirEvaluatorResult.CompileTimeException)$this$unwrapOr$iv;
                        boolean bl = false;
                        return it2;
                    }
                    if (firEvaluatorResult instanceof FirEvaluatorResult.Evaluated) {
                        FirElement firElement = ((FirEvaluatorResult.Evaluated)$this$unwrapOr$iv).getResult();
                        if (!(firElement instanceof FirExpression)) {
                            firElement = null;
                        }
                        firExpression2 = (FirExpression)firElement;
                    } else {
                        firExpression2 = null;
                    }
                    if (firExpression2 == null) {
                        return FirEvaluatorResult.NotEvaluated.INSTANCE;
                    }
                    Map.Entry entry2 = (Map.Entry)element$iv$iv;
                    it = firExpression2;
                    void var18_31 = var24_35;
                    boolean bl = false;
                    Object $i$a$-mapKeysTo-FirExpressionEvaluator$EvaluationVisitor$visitArgumentList$22 = it$iv.getValue();
                    var18_31.put(it, $i$a$-mapKeysTo-FirExpressionEvaluator$EvaluationVisitor$visitArgumentList$22);
                }
                firArgumentList = FirArgumentUtilKt.buildResolvedArgumentList(firArgumentList2, (LinkedHashMap)destination$iv);
            } else {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                FirArgumentListBuilder firArgumentListBuilder;
                boolean $i$f$buildArgumentList = false;
                FirArgumentListBuilder $this$visitArgumentList_u24lambda_u244 = firArgumentListBuilder = new FirArgumentListBuilder();
                boolean bl = false;
                $this$visitArgumentList_u24lambda_u244.setSource(argumentList2.getSource());
                Iterable $i$f$associateByTo = argumentList2.getArguments();
                List<FirExpression> list2 = $this$visitArgumentList_u24lambda_u244.getArguments();
                boolean $i$f$map = false;
                void it = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    FirExpression firExpression3;
                    FirExpression it2 = (FirExpression)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    FirEvaluatorResult $this$unwrapOr$iv = this.evaluate(it2);
                    boolean $i$f$unwrapOr = false;
                    FirEvaluatorResult firEvaluatorResult = $this$unwrapOr$iv;
                    if (firEvaluatorResult instanceof FirEvaluatorResult.CompileTimeException) {
                        FirEvaluatorResult.CompileTimeException it3 = (FirEvaluatorResult.CompileTimeException)$this$unwrapOr$iv;
                        boolean bl3 = false;
                        return it3;
                    }
                    if (firEvaluatorResult instanceof FirEvaluatorResult.Evaluated) {
                        FirElement firElement = ((FirEvaluatorResult.Evaluated)$this$unwrapOr$iv).getResult();
                        if (!(firElement instanceof FirExpression)) {
                            firElement = null;
                        }
                        firExpression3 = (FirExpression)firElement;
                    } else {
                        firExpression3 = null;
                    }
                    if (firExpression3 == null) {
                        return FirEvaluatorResult.NotEvaluated.INSTANCE;
                    }
                    collection.add(firExpression3);
                }
                list2.addAll((List)destination$iv$iv);
                firArgumentList = firArgumentListBuilder.build();
            }
            return FirCompileTimeConstantEvaluatorKt.access$wrap(firArgumentList);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public FirEvaluatorResult visitNamedArgumentExpression(@NotNull FirNamedArgumentExpression namedArgumentExpression, @Nullable Void data2) {
            FirExpression firExpression2;
            FirNamedArgumentExpressionBuilder firNamedArgumentExpressionBuilder;
            Intrinsics.checkNotNullParameter((Object)namedArgumentExpression, (String)"namedArgumentExpression");
            boolean $i$f$buildNamedArgumentExpression = false;
            FirNamedArgumentExpressionBuilder $this$visitNamedArgumentExpression_u24lambda_u246 = firNamedArgumentExpressionBuilder = new FirNamedArgumentExpressionBuilder();
            boolean bl = false;
            $this$visitNamedArgumentExpression_u24lambda_u246.setSource(namedArgumentExpression.getSource());
            $this$visitNamedArgumentExpression_u24lambda_u246.getAnnotations().addAll((Collection<FirAnnotation>)namedArgumentExpression.getAnnotations());
            FirEvaluatorResult $this$unwrapOr$iv = this.evaluate(namedArgumentExpression.getExpression());
            boolean $i$f$unwrapOr = false;
            FirEvaluatorResult firEvaluatorResult = $this$unwrapOr$iv;
            if (firEvaluatorResult instanceof FirEvaluatorResult.CompileTimeException) {
                void it;
                FirEvaluatorResult.CompileTimeException compileTimeException = (FirEvaluatorResult.CompileTimeException)$this$unwrapOr$iv;
                boolean bl2 = false;
                return (FirEvaluatorResult)it;
            }
            if (firEvaluatorResult instanceof FirEvaluatorResult.Evaluated) {
                FirElement firElement = ((FirEvaluatorResult.Evaluated)$this$unwrapOr$iv).getResult();
                if (!(firElement instanceof FirExpression)) {
                    firElement = null;
                }
                firExpression2 = (FirExpression)firElement;
            } else {
                firExpression2 = null;
            }
            if (firExpression2 == null) {
                return FirEvaluatorResult.NotEvaluated.INSTANCE;
            }
            $this$visitNamedArgumentExpression_u24lambda_u246.setExpression(firExpression2);
            $this$visitNamedArgumentExpression_u24lambda_u246.setSpread(namedArgumentExpression.isSpread());
            $this$visitNamedArgumentExpression_u24lambda_u246.setName(namedArgumentExpression.getName());
            return FirCompileTimeConstantEvaluatorKt.access$wrap(firNamedArgumentExpressionBuilder.build());
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public FirEvaluatorResult visitArrayLiteral(@NotNull FirArrayLiteral arrayLiteral, @Nullable Void data2) {
            FirArgumentList firArgumentList;
            FirArrayLiteralBuilder firArrayLiteralBuilder;
            Intrinsics.checkNotNullParameter((Object)arrayLiteral, (String)"arrayLiteral");
            boolean $i$f$buildArrayLiteral = false;
            FirArrayLiteralBuilder $this$visitArrayLiteral_u24lambda_u248 = firArrayLiteralBuilder = new FirArrayLiteralBuilder();
            boolean bl = false;
            $this$visitArrayLiteral_u24lambda_u248.setSource(arrayLiteral.getSource());
            $this$visitArrayLiteral_u24lambda_u248.setConeTypeOrNull(arrayLiteral.getConeTypeOrNull());
            $this$visitArrayLiteral_u24lambda_u248.getAnnotations().addAll((Collection<FirAnnotation>)arrayLiteral.getAnnotations());
            FirEvaluatorResult $this$unwrapOr$iv = this.visitArgumentList(arrayLiteral.getArgumentList(), data2);
            boolean $i$f$unwrapOr = false;
            FirEvaluatorResult firEvaluatorResult = $this$unwrapOr$iv;
            if (firEvaluatorResult instanceof FirEvaluatorResult.CompileTimeException) {
                void it;
                FirEvaluatorResult.CompileTimeException compileTimeException = (FirEvaluatorResult.CompileTimeException)$this$unwrapOr$iv;
                boolean bl2 = false;
                return (FirEvaluatorResult)it;
            }
            if (firEvaluatorResult instanceof FirEvaluatorResult.Evaluated) {
                FirElement firElement = ((FirEvaluatorResult.Evaluated)$this$unwrapOr$iv).getResult();
                if (!(firElement instanceof FirArgumentList)) {
                    firElement = null;
                }
                firArgumentList = (FirArgumentList)firElement;
            } else {
                firArgumentList = null;
            }
            if (firArgumentList == null) {
                return FirEvaluatorResult.NotEvaluated.INSTANCE;
            }
            $this$visitArrayLiteral_u24lambda_u248.setArgumentList(firArgumentList);
            return FirCompileTimeConstantEvaluatorKt.access$wrap(firArrayLiteralBuilder.build());
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public FirEvaluatorResult visitVarargArgumentsExpression(@NotNull FirVarargArgumentsExpression varargArgumentsExpression, @Nullable Void data2) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            FirVarargArgumentsExpressionBuilder firVarargArgumentsExpressionBuilder;
            Intrinsics.checkNotNullParameter((Object)varargArgumentsExpression, (String)"varargArgumentsExpression");
            boolean $i$f$buildVarargArgumentsExpression = false;
            FirVarargArgumentsExpressionBuilder $this$visitVarargArgumentsExpression_u24lambda_u2411 = firVarargArgumentsExpressionBuilder = new FirVarargArgumentsExpressionBuilder();
            boolean bl = false;
            $this$visitVarargArgumentsExpression_u24lambda_u2411.setSource(varargArgumentsExpression.getSource());
            $this$visitVarargArgumentsExpression_u24lambda_u2411.setConeTypeOrNull(varargArgumentsExpression.getConeTypeOrNull());
            $this$visitVarargArgumentsExpression_u24lambda_u2411.getAnnotations().addAll((Collection<FirAnnotation>)varargArgumentsExpression.getAnnotations());
            Iterable iterable = varargArgumentsExpression.getArguments();
            List<FirExpression> list2 = $this$visitVarargArgumentsExpression_u24lambda_u2411.getArguments();
            boolean $i$f$map = false;
            void var10_10 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                FirExpression firExpression2;
                void it;
                FirExpression firExpression3 = (FirExpression)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                FirEvaluatorResult $this$unwrapOr$iv = this.evaluate((FirExpression)it);
                boolean $i$f$unwrapOr = false;
                FirEvaluatorResult firEvaluatorResult = $this$unwrapOr$iv;
                if (firEvaluatorResult instanceof FirEvaluatorResult.CompileTimeException) {
                    FirEvaluatorResult.CompileTimeException it2 = (FirEvaluatorResult.CompileTimeException)$this$unwrapOr$iv;
                    boolean bl3 = false;
                    return it2;
                }
                if (firEvaluatorResult instanceof FirEvaluatorResult.Evaluated) {
                    FirElement firElement = ((FirEvaluatorResult.Evaluated)$this$unwrapOr$iv).getResult();
                    if (!(firElement instanceof FirExpression)) {
                        firElement = null;
                    }
                    firExpression2 = (FirExpression)firElement;
                } else {
                    firExpression2 = null;
                }
                if (firExpression2 == null) {
                    return FirEvaluatorResult.NotEvaluated.INSTANCE;
                }
                collection.add(firExpression2);
            }
            list2.addAll((List)destination$iv$iv);
            $this$visitVarargArgumentsExpression_u24lambda_u2411.setConeElementTypeOrNull(varargArgumentsExpression.getConeElementTypeOrNull());
            return FirCompileTimeConstantEvaluatorKt.access$wrap(firVarargArgumentsExpressionBuilder.build());
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public FirEvaluatorResult visitSpreadArgumentExpression(@NotNull FirSpreadArgumentExpression spreadArgumentExpression, @Nullable Void data2) {
            FirExpression firExpression2;
            FirSpreadArgumentExpressionBuilder firSpreadArgumentExpressionBuilder;
            Intrinsics.checkNotNullParameter((Object)spreadArgumentExpression, (String)"spreadArgumentExpression");
            boolean $i$f$buildSpreadArgumentExpression = false;
            FirSpreadArgumentExpressionBuilder $this$visitSpreadArgumentExpression_u24lambda_u2413 = firSpreadArgumentExpressionBuilder = new FirSpreadArgumentExpressionBuilder();
            boolean bl = false;
            $this$visitSpreadArgumentExpression_u24lambda_u2413.setSource(spreadArgumentExpression.getSource());
            $this$visitSpreadArgumentExpression_u24lambda_u2413.getAnnotations().addAll((Collection<FirAnnotation>)spreadArgumentExpression.getAnnotations());
            FirEvaluatorResult $this$unwrapOr$iv = this.evaluate(spreadArgumentExpression.getExpression());
            boolean $i$f$unwrapOr = false;
            FirEvaluatorResult firEvaluatorResult = $this$unwrapOr$iv;
            if (firEvaluatorResult instanceof FirEvaluatorResult.CompileTimeException) {
                void it;
                FirEvaluatorResult.CompileTimeException compileTimeException = (FirEvaluatorResult.CompileTimeException)$this$unwrapOr$iv;
                boolean bl2 = false;
                return (FirEvaluatorResult)it;
            }
            if (firEvaluatorResult instanceof FirEvaluatorResult.Evaluated) {
                FirElement firElement = ((FirEvaluatorResult.Evaluated)$this$unwrapOr$iv).getResult();
                if (!(firElement instanceof FirExpression)) {
                    firElement = null;
                }
                firExpression2 = (FirExpression)firElement;
            } else {
                firExpression2 = null;
            }
            if (firExpression2 == null) {
                return FirEvaluatorResult.NotEvaluated.INSTANCE;
            }
            $this$visitSpreadArgumentExpression_u24lambda_u2413.setExpression(firExpression2);
            return FirCompileTimeConstantEvaluatorKt.access$wrap(firSpreadArgumentExpressionBuilder.build());
        }

        @NotNull
        public FirEvaluatorResult visitPropertyAccessExpression(@NotNull FirPropertyAccessExpression propertyAccessExpression, @Nullable Void data2) {
            FirEvaluatorResult firEvaluatorResult;
            Intrinsics.checkNotNullParameter((Object)propertyAccessExpression, (String)"propertyAccessExpression");
            Object object = ReferenceUtilsKt.toReference(propertyAccessExpression, this.session);
            if (object == null || (object = FirReferenceUtilsKt.toResolvedCallableSymbol((FirReference)object, true)) == null) {
                return FirEvaluatorResult.NotEvaluated.INSTANCE;
            }
            Object propertySymbol = object;
            if (INSTANCE.wasVisited((FirCallableSymbol)propertySymbol)) {
                return FirEvaluatorResult.RecursionInInitializer.INSTANCE;
            }
            Object object2 = propertySymbol;
            if (object2 instanceof FirPropertySymbol) {
                if (FirCompileTimeConstantEvaluatorKt.access$isStringLength(((FirCallableSymbol)propertySymbol).getCallableId()) || FirCompileTimeConstantEvaluatorKt.access$isCharCode(((FirCallableSymbol)propertySymbol).getCallableId())) {
                    FirExpression firExpression2;
                    FirEvaluatorResult receiver = this.evaluate(propertyAccessExpression.getExplicitReceiver());
                    boolean bl = false;
                    FirEvaluatorResult $this$unwrapOr$iv = receiver;
                    boolean $i$f$unwrapOr = false;
                    FirEvaluatorResult firEvaluatorResult2 = $this$unwrapOr$iv;
                    if (firEvaluatorResult2 instanceof FirEvaluatorResult.CompileTimeException) {
                        FirEvaluatorResult.CompileTimeException it = (FirEvaluatorResult.CompileTimeException)$this$unwrapOr$iv;
                        boolean bl2 = false;
                        return it;
                    }
                    if (firEvaluatorResult2 instanceof FirEvaluatorResult.Evaluated) {
                        FirElement firElement = ((FirEvaluatorResult.Evaluated)$this$unwrapOr$iv).getResult();
                        if (!(firElement instanceof FirExpression)) {
                            firElement = null;
                        }
                        firExpression2 = (FirExpression)firElement;
                    } else {
                        firExpression2 = null;
                    }
                    if (firExpression2 == null) {
                        return FirEvaluatorResult.NotEvaluated.INSTANCE;
                    }
                    FirExpression unaryArg = firExpression2;
                    firEvaluatorResult = FirCompileTimeConstantEvaluatorKt.access$adjustTypeAndConvertToLiteral(FirCompileTimeConstantEvaluatorKt.access$evaluateUnary(unaryArg, ((FirCallableSymbol)propertySymbol).getCallableId()), propertyAccessExpression);
                } else {
                    firEvaluatorResult = EvaluationVisitor.visitPropertyAccessExpression$evaluateOrCopy(propertySymbol, propertyAccessExpression, this, ((FirProperty)((FirPropertySymbol)propertySymbol).getFir()).getInitializer());
                }
            } else if (object2 instanceof FirFieldSymbol) {
                firEvaluatorResult = EvaluationVisitor.visitPropertyAccessExpression$evaluateOrCopy(propertySymbol, propertyAccessExpression, this, ((FirField)((FirFieldSymbol)propertySymbol).getFir()).getInitializer());
            } else if (object2 instanceof FirEnumEntrySymbol) {
                firEvaluatorResult = FirCompileTimeConstantEvaluatorKt.access$wrap(propertyAccessExpression);
            } else {
                throw new IllegalStateException(("FIR symbol \"" + Reflection.getOrCreateKotlinClass(propertySymbol.getClass()) + "\" is not supported in constant evaluation").toString());
            }
            return firEvaluatorResult;
        }

        @NotNull
        public FirEvaluatorResult visitFunctionCall(@NotNull FirFunctionCall functionCall, @Nullable Void data2) {
            Intrinsics.checkNotNullParameter((Object)functionCall, (String)"functionCall");
            FirNamedReference calleeReference = functionCall.getCalleeReference();
            if (!(calleeReference instanceof FirResolvedNamedReference)) {
                return FirEvaluatorResult.NotEvaluated.INSTANCE;
            }
            FirBasedSymbol<?> symbol2 = ((FirResolvedNamedReference)calleeReference).getResolvedSymbol();
            return symbol2 instanceof FirNamedFunctionSymbol ? this.visitNamedFunction(functionCall, (FirNamedFunctionSymbol)symbol2) : (symbol2 instanceof FirConstructorSymbol ? this.visitConstructorCall(functionCall) : (FirEvaluatorResult)FirEvaluatorResult.NotEvaluated.INSTANCE);
        }

        /*
         * WARNING - void declaration
         */
        private final FirEvaluatorResult visitNamedFunction(FirFunctionCall functionCall, FirNamedFunctionSymbol symbol2) {
            FirEvaluatorResult firEvaluatorResult;
            void $this$mapTo$iv$iv;
            Object[] objectArray = new FirExpression[]{functionCall.getDispatchReceiver(), functionCall.getExtensionReceiver()};
            List receivers = CollectionsKt.listOfNotNull((Object[])objectArray);
            FirCall $this$arguments$iv = functionCall;
            boolean $i$f$getArguments = false;
            Iterable $this$map$iv = CollectionsKt.plus((Collection)receivers, (Iterable)$this$arguments$iv.getArgumentList().getArguments());
            boolean $i$f$map22 = false;
            Object object = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                FirLiteralExpression firLiteralExpression;
                void it;
                FirExpression firExpression2 = (FirExpression)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                FirEvaluatorResult $this$unwrapOr$iv = this.evaluate((FirExpression)it);
                boolean $i$f$unwrapOr = false;
                FirEvaluatorResult firEvaluatorResult2 = $this$unwrapOr$iv;
                if (firEvaluatorResult2 instanceof FirEvaluatorResult.CompileTimeException) {
                    FirEvaluatorResult.CompileTimeException it2 = (FirEvaluatorResult.CompileTimeException)$this$unwrapOr$iv;
                    boolean bl2 = false;
                    return it2;
                }
                if (firEvaluatorResult2 instanceof FirEvaluatorResult.Evaluated) {
                    FirElement firElement = ((FirEvaluatorResult.Evaluated)$this$unwrapOr$iv).getResult();
                    if (!(firElement instanceof FirLiteralExpression)) {
                        firElement = null;
                    }
                    firLiteralExpression = (FirLiteralExpression)firElement;
                } else {
                    firLiteralExpression = null;
                }
                if (firLiteralExpression == null) {
                    return FirEvaluatorResult.NotEvaluated.INSTANCE;
                }
                collection.add(firLiteralExpression);
            }
            List evaluatedArgs = (List)destination$iv$iv;
            FirLiteralExpression firLiteralExpression = (FirLiteralExpression)CollectionsKt.getOrNull((List)evaluatedArgs, (int)0);
            if (firLiteralExpression == null) {
                return FirEvaluatorResult.NotEvaluated.INSTANCE;
            }
            FirLiteralExpression opr1 = firLiteralExpression;
            Object $i$f$map22 = FirCompileTimeConstantEvaluatorKt.access$evaluateUnary(opr1, symbol2.getCallableId());
            if ($i$f$map22 != null && (object = FirCompileTimeConstantEvaluatorKt.access$adjustTypeAndConvertToLiteral($i$f$map22, functionCall)) != null) {
                Object it = object;
                boolean bl = false;
                return it;
            }
            FirLiteralExpression firLiteralExpression2 = (FirLiteralExpression)CollectionsKt.getOrNull((List)evaluatedArgs, (int)1);
            if (firLiteralExpression2 == null) {
                return FirEvaluatorResult.NotEvaluated.INSTANCE;
            }
            FirLiteralExpression opr2 = firLiteralExpression2;
            object = FirCompileTimeConstantEvaluatorKt.access$evaluateBinary(opr1, symbol2.getCallableId(), opr2);
            if (object != null && (firEvaluatorResult = FirCompileTimeConstantEvaluatorKt.access$adjustTypeAndConvertToLiteral(object, functionCall)) != null) {
                FirEvaluatorResult it = firEvaluatorResult;
                boolean bl = false;
                return it;
            }
            return FirEvaluatorResult.NotEvaluated.INSTANCE;
        }

        /*
         * WARNING - void declaration
         */
        private final FirEvaluatorResult visitConstructorCall(FirFunctionCall constructorCall) {
            ConeSimpleKotlinType type2 = ConeTypeUtilsKt.lowerBoundIfFlexible(TypeExpansionUtilsKt.fullyExpandedType(FirTypeUtilsKt.getResolvedType(constructorCall), this.session));
            FirRegularClassSymbol firRegularClassSymbol = TypeUtilsKt.toRegularClassSymbol(type2, this.session);
            if ((firRegularClassSymbol != null ? firRegularClassSymbol.getClassKind() : null) == ClassKind.ANNOTATION_CLASS) {
                FirResolvedArgumentList firResolvedArgumentList;
                FirFunctionCallBuilder $this$unwrapOr$iv;
                FirEvaluatorResult firEvaluatorResult = (FirEvaluatorResult)constructorCall.getArgumentList().accept(this, null);
                boolean $i$f$unwrapOr = false;
                FirFunctionCallBuilder firFunctionCallBuilder = $this$unwrapOr$iv;
                if (firFunctionCallBuilder instanceof FirEvaluatorResult.CompileTimeException) {
                    FirEvaluatorResult.CompileTimeException it = (FirEvaluatorResult.CompileTimeException)((Object)$this$unwrapOr$iv);
                    boolean bl = false;
                    return it;
                }
                if (firFunctionCallBuilder instanceof FirEvaluatorResult.Evaluated) {
                    FirElement firElement = ((FirEvaluatorResult.Evaluated)((Object)$this$unwrapOr$iv)).getResult();
                    if (!(firElement instanceof FirResolvedArgumentList)) {
                        firElement = null;
                    }
                    firResolvedArgumentList = (FirResolvedArgumentList)firElement;
                } else {
                    firResolvedArgumentList = null;
                }
                if (firResolvedArgumentList == null) {
                    return FirEvaluatorResult.NotEvaluated.INSTANCE;
                }
                FirResolvedArgumentList evaluatedArgs = firResolvedArgumentList;
                boolean $i$f$buildFunctionCall = false;
                FirFunctionCallBuilder $this$visitConstructorCall_u24lambda_u2421 = $this$unwrapOr$iv = new FirFunctionCallBuilder();
                boolean bl = false;
                $this$visitConstructorCall_u24lambda_u2421.setConeTypeOrNull(constructorCall.getConeTypeOrNull());
                $this$visitConstructorCall_u24lambda_u2421.getAnnotations().addAll((Collection<FirAnnotation>)constructorCall.getAnnotations());
                $this$visitConstructorCall_u24lambda_u2421.getTypeArguments().addAll((Collection<FirTypeProjection>)constructorCall.getTypeArguments());
                $this$visitConstructorCall_u24lambda_u2421.setSource(constructorCall.getSource());
                $this$visitConstructorCall_u24lambda_u2421.getNonFatalDiagnostics().addAll((Collection<ConeDiagnostic>)constructorCall.getNonFatalDiagnostics());
                $this$visitConstructorCall_u24lambda_u2421.setArgumentList(evaluatedArgs);
                $this$visitConstructorCall_u24lambda_u2421.setCalleeReference(constructorCall.getCalleeReference());
                $this$visitConstructorCall_u24lambda_u2421.setOrigin(constructorCall.getOrigin());
                return FirCompileTimeConstantEvaluatorKt.access$wrap($this$unwrapOr$iv.build());
            }
            if (ConeBuiltinTypeUtilsKt.isUnsignedType(type2)) {
                FirLiteralExpression firLiteralExpression;
                FirLiteralExpression firLiteralExpression2;
                void $this$unwrapOr$iv;
                Object $this$argument$iv = constructorCall;
                boolean $i$f$getArgument = false;
                $this$argument$iv = this.evaluate((FirExpression)CollectionsKt.first($this$argument$iv.getArgumentList().getArguments()));
                boolean $i$f$unwrapOr = false;
                void var7_10 = $this$unwrapOr$iv;
                if (var7_10 instanceof FirEvaluatorResult.CompileTimeException) {
                    FirEvaluatorResult.CompileTimeException it = (FirEvaluatorResult.CompileTimeException)$this$unwrapOr$iv;
                    boolean bl = false;
                    return it;
                }
                if (var7_10 instanceof FirEvaluatorResult.Evaluated) {
                    FirElement firElement = ((FirEvaluatorResult.Evaluated)$this$unwrapOr$iv).getResult();
                    if (!(firElement instanceof FirLiteralExpression)) {
                        firElement = null;
                    }
                    firLiteralExpression2 = (FirLiteralExpression)firElement;
                } else {
                    firLiteralExpression2 = firLiteralExpression = null;
                }
                if (firLiteralExpression2 == null || (firLiteralExpression = firLiteralExpression.getValue()) == null) {
                    return FirEvaluatorResult.NotEvaluated.INSTANCE;
                }
                FirLiteralExpression argument2 = firLiteralExpression;
                return FirCompileTimeConstantEvaluatorKt.access$adjustTypeAndConvertToLiteral(argument2, constructorCall);
            }
            return FirEvaluatorResult.NotEvaluated.INSTANCE;
        }

        @NotNull
        public FirEvaluatorResult visitIntegerLiteralOperatorCall(@NotNull FirIntegerLiteralOperatorCall integerLiteralOperatorCall, @Nullable Void data2) {
            Intrinsics.checkNotNullParameter((Object)integerLiteralOperatorCall, (String)"integerLiteralOperatorCall");
            return this.visitFunctionCall((FirFunctionCall)integerLiteralOperatorCall, data2);
        }

        @NotNull
        public FirEvaluatorResult visitComparisonExpression(@NotNull FirComparisonExpression comparisonExpression, @Nullable Void data2) {
            boolean bl;
            FirLiteralExpression firLiteralExpression;
            Intrinsics.checkNotNullParameter((Object)comparisonExpression, (String)"comparisonExpression");
            FirEvaluatorResult it = this.visitFunctionCall(comparisonExpression.getCompareToCall(), data2);
            boolean bl2 = false;
            FirEvaluatorResult $this$unwrapOr$iv = it;
            boolean $i$f$unwrapOr = false;
            FirEvaluatorResult firEvaluatorResult = $this$unwrapOr$iv;
            if (firEvaluatorResult instanceof FirEvaluatorResult.CompileTimeException) {
                FirEvaluatorResult.CompileTimeException it2 = (FirEvaluatorResult.CompileTimeException)$this$unwrapOr$iv;
                boolean bl3 = false;
                return it2;
            }
            if (firEvaluatorResult instanceof FirEvaluatorResult.Evaluated) {
                FirElement firElement = ((FirEvaluatorResult.Evaluated)$this$unwrapOr$iv).getResult();
                if (!(firElement instanceof FirLiteralExpression)) {
                    firElement = null;
                }
                firLiteralExpression = (FirLiteralExpression)firElement;
            } else {
                firLiteralExpression = null;
            }
            Object t = firLiteralExpression != null ? firLiteralExpression.getValue() : null;
            Integer n = t instanceof Integer ? (Integer)t : null;
            if (n == null) {
                return FirEvaluatorResult.NotEvaluated.INSTANCE;
            }
            int intResult = n;
            switch (WhenMappings.$EnumSwitchMapping$0[comparisonExpression.getOperation().ordinal()]) {
                case 1: {
                    if (intResult < 0) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 2: {
                    if (intResult <= 0) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 3: {
                    if (intResult > 0) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 4: {
                    if (intResult >= 0) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                default: {
                    throw new IllegalStateException(("Unsupported comparison operation type \"" + comparisonExpression.getOperation().name() + '\"').toString());
                }
            }
            boolean compareToResult = bl;
            return FirCompileTimeConstantEvaluatorKt.access$adjustTypeAndConvertToLiteral(compareToResult, comparisonExpression);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public FirEvaluatorResult visitEqualityOperatorCall(@NotNull FirEqualityOperatorCall equalityOperatorCall, @Nullable Void data2) {
            boolean bl;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)equalityOperatorCall, (String)"equalityOperatorCall");
            Object $this$arguments$iv = equalityOperatorCall;
            boolean $i$f$getArguments = false;
            $this$arguments$iv = $this$arguments$iv.getArgumentList().getArguments();
            boolean $i$f$map = false;
            void var6_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                FirLiteralExpression firLiteralExpression;
                void it;
                FirExpression firExpression2 = (FirExpression)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                FirEvaluatorResult $this$unwrapOr$iv = this.evaluate((FirExpression)it);
                boolean $i$f$unwrapOr = false;
                FirEvaluatorResult firEvaluatorResult = $this$unwrapOr$iv;
                if (firEvaluatorResult instanceof FirEvaluatorResult.CompileTimeException) {
                    FirEvaluatorResult.CompileTimeException it2 = (FirEvaluatorResult.CompileTimeException)$this$unwrapOr$iv;
                    boolean bl3 = false;
                    return it2;
                }
                if (firEvaluatorResult instanceof FirEvaluatorResult.Evaluated) {
                    FirElement firElement = ((FirEvaluatorResult.Evaluated)$this$unwrapOr$iv).getResult();
                    if (!(firElement instanceof FirLiteralExpression)) {
                        firElement = null;
                    }
                    firLiteralExpression = (FirLiteralExpression)firElement;
                } else {
                    firLiteralExpression = null;
                }
                if (firLiteralExpression == null) {
                    return FirEvaluatorResult.NotEvaluated.INSTANCE;
                }
                collection.add(firLiteralExpression);
            }
            List evaluatedArgs = (List)destination$iv$iv;
            if (evaluatedArgs.size() != 2) {
                return FirEvaluatorResult.NotEvaluated.INSTANCE;
            }
            switch (WhenMappings.$EnumSwitchMapping$0[equalityOperatorCall.getOperation().ordinal()]) {
                case 5: {
                    bl = Intrinsics.areEqual(((FirLiteralExpression)evaluatedArgs.get(0)).getValue(), ((FirLiteralExpression)evaluatedArgs.get(1)).getValue());
                    break;
                }
                case 6: {
                    if (!Intrinsics.areEqual(((FirLiteralExpression)evaluatedArgs.get(0)).getValue(), ((FirLiteralExpression)evaluatedArgs.get(1)).getValue())) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                default: {
                    throw new IllegalStateException(("Operation \"" + (Object)((Object)equalityOperatorCall.getOperation()) + "\" is not supported in compile time evaluation").toString());
                }
            }
            boolean result2 = bl;
            return FirCompileTimeConstantEvaluatorKt.access$wrap(FirCompileTimeConstantEvaluatorKt.access$toConstExpression(result2, ConstantValueKind.Boolean.INSTANCE, equalityOperatorCall));
        }

        @NotNull
        public FirEvaluatorResult visitBinaryLogicExpression(@NotNull FirBinaryLogicExpression binaryLogicExpression, @Nullable Void data2) {
            boolean bl;
            FirLiteralExpression firLiteralExpression;
            FirLiteralExpression firLiteralExpression2;
            Intrinsics.checkNotNullParameter((Object)binaryLogicExpression, (String)"binaryLogicExpression");
            FirEvaluatorResult left = this.evaluate(binaryLogicExpression.getLeftOperand());
            FirEvaluatorResult right = this.evaluate(binaryLogicExpression.getRightOperand());
            FirEvaluatorResult $this$unwrapOr$iv = left;
            boolean $i$f$unwrapOr = false;
            FirEvaluatorResult firEvaluatorResult = $this$unwrapOr$iv;
            if (firEvaluatorResult instanceof FirEvaluatorResult.CompileTimeException) {
                FirEvaluatorResult.CompileTimeException it = (FirEvaluatorResult.CompileTimeException)$this$unwrapOr$iv;
                boolean bl2 = false;
                return it;
            }
            if (firEvaluatorResult instanceof FirEvaluatorResult.Evaluated) {
                FirElement firElement = ((FirEvaluatorResult.Evaluated)$this$unwrapOr$iv).getResult();
                if (!(firElement instanceof FirLiteralExpression)) {
                    firElement = null;
                }
                firLiteralExpression2 = (FirLiteralExpression)firElement;
            } else {
                firLiteralExpression2 = null;
            }
            Object t = firLiteralExpression2 != null ? firLiteralExpression2.getValue() : null;
            Boolean bl3 = t instanceof Boolean ? (Boolean)t : null;
            if (bl3 == null) {
                return FirEvaluatorResult.NotEvaluated.INSTANCE;
            }
            boolean leftBoolean = bl3;
            FirEvaluatorResult $this$unwrapOr$iv2 = right;
            boolean $i$f$unwrapOr2 = false;
            FirEvaluatorResult firEvaluatorResult2 = $this$unwrapOr$iv2;
            if (firEvaluatorResult2 instanceof FirEvaluatorResult.CompileTimeException) {
                FirEvaluatorResult.CompileTimeException it = (FirEvaluatorResult.CompileTimeException)$this$unwrapOr$iv2;
                boolean bl4 = false;
                return it;
            }
            if (firEvaluatorResult2 instanceof FirEvaluatorResult.Evaluated) {
                FirElement firElement = ((FirEvaluatorResult.Evaluated)$this$unwrapOr$iv2).getResult();
                if (!(firElement instanceof FirLiteralExpression)) {
                    firElement = null;
                }
                firLiteralExpression = (FirLiteralExpression)firElement;
            } else {
                firLiteralExpression = null;
            }
            Object t2 = firLiteralExpression != null ? firLiteralExpression.getValue() : null;
            Boolean bl5 = t2 instanceof Boolean ? (Boolean)t2 : null;
            if (bl5 == null) {
                return FirEvaluatorResult.NotEvaluated.INSTANCE;
            }
            boolean rightBoolean = bl5;
            switch (WhenMappings.$EnumSwitchMapping$1[binaryLogicExpression.getKind().ordinal()]) {
                case 1: {
                    if (leftBoolean && rightBoolean) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 2: {
                    if (leftBoolean || rightBoolean) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                default: {
                    throw new IllegalStateException(("Boolean logic expression of a kind \"" + (Object)((Object)binaryLogicExpression.getKind()) + "\" is not supported in compile time evaluation").toString());
                }
            }
            boolean result2 = bl;
            return FirCompileTimeConstantEvaluatorKt.access$wrap(FirCompileTimeConstantEvaluatorKt.access$toConstExpression(result2, ConstantValueKind.Boolean.INSTANCE, binaryLogicExpression));
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public FirEvaluatorResult visitStringConcatenationCall(@NotNull FirStringConcatenationCall stringConcatenationCall, @Nullable Void data2) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)stringConcatenationCall, (String)"stringConcatenationCall");
            Iterable $this$map$iv = stringConcatenationCall.getArgumentList().getArguments();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                FirLiteralExpression firLiteralExpression;
                void it;
                FirExpression firExpression2 = (FirExpression)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                FirEvaluatorResult $this$unwrapOr$iv = this.evaluate((FirExpression)it);
                boolean $i$f$unwrapOr = false;
                FirEvaluatorResult firEvaluatorResult = $this$unwrapOr$iv;
                if (firEvaluatorResult instanceof FirEvaluatorResult.CompileTimeException) {
                    FirEvaluatorResult.CompileTimeException it2 = (FirEvaluatorResult.CompileTimeException)$this$unwrapOr$iv;
                    boolean bl2 = false;
                    return it2;
                }
                if (firEvaluatorResult instanceof FirEvaluatorResult.Evaluated) {
                    FirElement firElement = ((FirEvaluatorResult.Evaluated)$this$unwrapOr$iv).getResult();
                    if (!(firElement instanceof FirLiteralExpression)) {
                        firElement = null;
                    }
                    firLiteralExpression = (FirLiteralExpression)firElement;
                } else {
                    firLiteralExpression = null;
                }
                if (firLiteralExpression == null) {
                    return FirEvaluatorResult.NotEvaluated.INSTANCE;
                }
                collection.add(firLiteralExpression);
            }
            List strings2 = (List)destination$iv$iv;
            String result2 = CollectionsKt.joinToString$default((Iterable)strings2, (CharSequence)"", null, null, (int)0, null, (Function1)visitStringConcatenationCall.result.1.INSTANCE, (int)30, null);
            return FirCompileTimeConstantEvaluatorKt.access$wrap(FirCompileTimeConstantEvaluatorKt.access$toConstExpression(result2, ConstantValueKind.String.INSTANCE, stringConcatenationCall));
        }

        @NotNull
        public FirEvaluatorResult visitTypeOperatorCall(@NotNull FirTypeOperatorCall typeOperatorCall, @Nullable Void data2) {
            FirLiteralExpression firLiteralExpression;
            Intrinsics.checkNotNullParameter((Object)typeOperatorCall, (String)"typeOperatorCall");
            if (typeOperatorCall.getOperation() != FirOperation.AS) {
                return FirEvaluatorResult.NotEvaluated.INSTANCE;
            }
            FirCall $this$argument$iv = typeOperatorCall;
            boolean $i$f$getArgument = false;
            FirEvaluatorResult $this$unwrapOr$iv = this.evaluate((FirExpression)CollectionsKt.first($this$argument$iv.getArgumentList().getArguments()));
            boolean $i$f$unwrapOr = false;
            FirEvaluatorResult firEvaluatorResult = $this$unwrapOr$iv;
            if (firEvaluatorResult instanceof FirEvaluatorResult.CompileTimeException) {
                FirEvaluatorResult.CompileTimeException it = (FirEvaluatorResult.CompileTimeException)$this$unwrapOr$iv;
                boolean bl = false;
                return it;
            }
            if (firEvaluatorResult instanceof FirEvaluatorResult.Evaluated) {
                FirElement firElement = ((FirEvaluatorResult.Evaluated)$this$unwrapOr$iv).getResult();
                if (!(firElement instanceof FirLiteralExpression)) {
                    firElement = null;
                }
                firLiteralExpression = (FirLiteralExpression)firElement;
            } else {
                firLiteralExpression = null;
            }
            if (firLiteralExpression == null) {
                return FirEvaluatorResult.NotEvaluated.INSTANCE;
            }
            FirLiteralExpression result2 = firLiteralExpression;
            if (TypeUtilsKt.isSubtypeOf$default(FirTypeUtilsKt.getResolvedType(result2), FirTypeUtilsKt.getResolvedType(typeOperatorCall), this.session, false, 4, null)) {
                return FirCompileTimeConstantEvaluatorKt.access$wrap(result2);
            }
            return FirCompileTimeConstantEvaluatorKt.access$wrap(typeOperatorCall);
        }

        private static final FirEvaluatorResult visitPropertyAccessExpression$evaluateOrCopy(FirCallableSymbol<?> propertySymbol, FirPropertyAccessExpression $propertyAccessExpression, EvaluationVisitor this$0, FirExpression initializer2) {
            return (FirEvaluatorResult)INSTANCE.visit(propertySymbol, (Function0)new Function0<FirEvaluatorResult>(initializer2, $propertyAccessExpression, this$0){
                final /* synthetic */ FirExpression $initializer;
                final /* synthetic */ FirPropertyAccessExpression $propertyAccessExpression;
                final /* synthetic */ EvaluationVisitor this$0;
                {
                    this.$initializer = $initializer;
                    this.$propertyAccessExpression = $propertyAccessExpression;
                    this.this$0 = $receiver;
                    super(0);
                }

                public final FirEvaluatorResult invoke() {
                    return this.$initializer instanceof FirLiteralExpression ? FirCompileTimeConstantEvaluatorKt.access$wrap(FirCompileTimeConstantEvaluatorKt.access$copy((FirLiteralExpression)this.$initializer, this.$propertyAccessExpression)) : this.this$0.evaluate(this.$initializer);
                }
            });
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;
            public static final /* synthetic */ int[] $EnumSwitchMapping$1;

            static {
                int[] nArray = new int[FirOperation.values().length];
                try {
                    nArray[FirOperation.LT.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[FirOperation.LT_EQ.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[FirOperation.GT.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[FirOperation.GT_EQ.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[FirOperation.EQ.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[FirOperation.NOT_EQ.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
                nArray = new int[LogicOperationKind.values().length];
                try {
                    nArray[LogicOperationKind.AND.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[LogicOperationKind.OR.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$1 = nArray;
            }
        }
    }
}

