/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.js.checkers.declaration;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.diagnostics.js.FirJsErrors;
import org.jetbrains.kotlin.fir.analysis.diagnostics.web.common.FirWebCommonErrors;
import org.jetbrains.kotlin.fir.analysis.js.checkers.FirJsHelpersKt;
import org.jetbrains.kotlin.fir.analysis.js.checkers.declaration.FirJsExternalChecker;
import org.jetbrains.kotlin.fir.analysis.web.common.checkers.declaration.FirWebCommonExternalChecker;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.impl.FirDefaultPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.impl.FirDefaultPropertyBackingField;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjectionKt;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.JsStandardClassIds;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u001c\u0010\u001b\u001a\u00020\u00042\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u001d2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J \u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u001c\u0010\u001f\u001a\u00020\u000e*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u0018\u0010\u0003\u001a\u00020\u0004*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u0004\u0018\u00010\t*\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsExternalChecker;", "Lorg/jetbrains/kotlin/fir/analysis/web/common/checkers/declaration/FirWebCommonExternalChecker;", "()V", "allowsReporting", "", "Lorg/jetbrains/kotlin/KtSourceElement;", "getAllowsReporting", "(Lorg/jetbrains/kotlin/KtSourceElement;)Z", "varargElementType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "getVarargElementType", "(Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;)Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "additionalCheck", "", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "hasExternalLikeAnnotations", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "isDefinedExternallyCallableId", "callableId", "Lorg/jetbrains/kotlin/name/CallableId;", "isNativeOrEffectivelyExternal", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "reportExternalEnum", "checkEnumEntry", "checkers.js"})
@SourceDebugExtension(value={"SMAP\nFirJsExternalChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJsExternalChecker.kt\norg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsExternalChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,132:1\n43#2:133\n*S KotlinDebug\n*F\n+ 1 FirJsExternalChecker.kt\norg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsExternalChecker\n*L\n44#1:133\n*E\n"})
public final class FirJsExternalChecker
extends FirWebCommonExternalChecker {
    @NotNull
    public static final FirJsExternalChecker INSTANCE = new FirJsExternalChecker();

    private FirJsExternalChecker() {
        super(true);
    }

    @Override
    public boolean isNativeOrEffectivelyExternal(@NotNull FirBasedSymbol<?> symbol2, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter(symbol2, (String)"symbol");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        return FirJsHelpersKt.isNativeObject(symbol2, session2);
    }

    @Override
    public void reportExternalEnum(@NotNull FirDeclaration declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration2.getSource(), FirJsErrors.INSTANCE.getENUM_CLASS_IN_EXTERNAL_DECLARATION_WARNING(), (DiagnosticContext)context2, null, 8, null);
    }

    @Override
    public void additionalCheck(@NotNull FirDeclaration declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (declaration2 instanceof FirFunction) {
            FirMemberDeclaration $this$isInline$iv = (FirMemberDeclaration)declaration2;
            boolean $i$f$isInline = false;
            if ($this$isInline$iv.getStatus().isInline()) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration2.getSource(), FirWebCommonErrors.INSTANCE.getINLINE_EXTERNAL_DECLARATION(), (DiagnosticContext)context2, null, 8, null);
            }
        }
        KtDiagnosticFactory0 valueClassInExternalDiagnostic = context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.JsAllowValueClassesInExternals) ? FirJsErrors.INSTANCE.getINLINE_CLASS_IN_EXTERNAL_DECLARATION_WARNING() : FirJsErrors.INSTANCE.getINLINE_CLASS_IN_EXTERNAL_DECLARATION();
        FirJsExternalChecker.additionalCheck$reportOnParametersAndReturnTypesIf(declaration2, reporter, context2, valueClassInExternalDiagnostic, (Function1<? super ConeKotlinType, Boolean>)((Function1)new Function1<ConeKotlinType, Boolean>(context2){
            final /* synthetic */ CheckerContext $context;
            {
                this.$context = $context;
                super(1);
            }

            public final Boolean invoke(ConeKotlinType it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return FirHelpersKt.isValueClass(it, this.$context.getSession());
            }
        }));
        if (!context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.JsEnableExtensionFunctionInExternals)) {
            FirJsExternalChecker.additionalCheck$reportOnParametersAndReturnTypesIf(declaration2, reporter, context2, FirJsErrors.INSTANCE.getEXTENSION_FUNCTION_IN_EXTERNAL_DECLARATION(), (Function1<? super ConeKotlinType, Boolean>)((Function1)additionalCheck.2.INSTANCE));
        }
        this.checkEnumEntry(declaration2, context2, reporter);
    }

    @Override
    public boolean isDefinedExternallyCallableId(@NotNull CallableId callableId) {
        Intrinsics.checkNotNullParameter((Object)callableId, (String)"callableId");
        return JsStandardClassIds.Callables.definedExternallyPropertyNames.contains(callableId);
    }

    @Override
    public boolean hasExternalLikeAnnotations(@NotNull FirDeclaration declaration2, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        return FirAnnotationUtilsKt.hasAnnotation(declaration2, JsStandardClassIds.Annotations.JsNative, session2);
    }

    private final boolean getAllowsReporting(KtSourceElement $this$allowsReporting) {
        return !($this$allowsReporting.getKind() instanceof KtFakeSourceElementKind) || Intrinsics.areEqual((Object)$this$allowsReporting.getKind(), (Object)KtFakeSourceElementKind.PropertyFromParameter.INSTANCE);
    }

    private final ConeKotlinType getVarargElementType(FirValueParameter $this$varargElementType) {
        ConeKotlinType coneKotlinType;
        if (!$this$varargElementType.isVararg()) {
            coneKotlinType = null;
        } else {
            ConeTypeProjection coneTypeProjection = (ConeTypeProjection)ArraysKt.firstOrNull((Object[])FirTypeUtilsKt.getConeType($this$varargElementType.getReturnTypeRef()).getTypeArguments());
            coneKotlinType = coneTypeProjection != null ? ConeTypeProjectionKt.getType(coneTypeProjection) : null;
        }
        return coneKotlinType;
    }

    private final void checkEnumEntry(FirDeclaration $this$checkEnumEntry, CheckerContext context2, DiagnosticReporter reporter) {
        block1: {
            if (!($this$checkEnumEntry instanceof FirEnumEntry)) {
                return;
            }
            FirExpression firExpression2 = ((FirEnumEntry)$this$checkEnumEntry).getInitializer();
            if (firExpression2 == null) break block1;
            FirExpression it = firExpression2;
            boolean bl = false;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)it.getSource(), FirJsErrors.INSTANCE.getEXTERNAL_ENUM_ENTRY_WITH_BODY(), (DiagnosticContext)context2, null, 8, null);
        }
    }

    private static final void additionalCheck$reportOnParametersAndReturnTypesIf$checkTypeIsNotInlineClass(Function1<? super ConeKotlinType, Boolean> $condition, DiagnosticReporter $reporter, KtDiagnosticFactory0 $diagnosticFactory, CheckerContext $context, ConeKotlinType type2, KtSourceElement elementToReport) {
        if (((Boolean)$condition.invoke((Object)type2)).booleanValue()) {
            KtDiagnosticReportHelpersKt.reportOn$default($reporter, (AbstractKtSourceElement)elementToReport, $diagnosticFactory, (DiagnosticContext)$context, null, 8, null);
        }
    }

    private static final void additionalCheck$reportOnParametersAndReturnTypesIf(FirDeclaration $declaration, DiagnosticReporter $reporter, CheckerContext $context, KtDiagnosticFactory0 diagnosticFactory, Function1<? super ConeKotlinType, Boolean> condition) {
        if (!($declaration instanceof FirCallableDeclaration) || $declaration instanceof FirDefaultPropertyAccessor || $declaration instanceof FirDefaultPropertyBackingField) {
            return;
        }
        KtSourceElement ktSourceElement = ((FirCallableDeclaration)$declaration).getReturnTypeRef().getSource();
        boolean bl = ktSourceElement != null ? INSTANCE.getAllowsReporting(ktSourceElement) : false;
        if (bl) {
            KtSourceElement ktSourceElement2 = ((FirCallableDeclaration)$declaration).getReturnTypeRef().getSource();
            if (ktSourceElement2 != null) {
                KtSourceElement it = ktSourceElement2;
                boolean bl2 = false;
                FirJsExternalChecker.additionalCheck$reportOnParametersAndReturnTypesIf$checkTypeIsNotInlineClass(condition, $reporter, diagnosticFactory, $context, FirTypeUtilsKt.getConeType(((FirCallableDeclaration)$declaration).getReturnTypeRef()), it);
            }
        }
        if (!($declaration instanceof FirFunction)) {
            return;
        }
        for (FirValueParameter parameter2 : ((FirFunction)$declaration).getValueParameters()) {
            KtSourceElement ktParam;
            KtSourceElement ktSourceElement3 = ktParam = parameter2.getSource();
            boolean bl3 = ktSourceElement3 != null ? INSTANCE.getAllowsReporting(ktSourceElement3) : false;
            if (!bl3) continue;
            ConeKotlinType coneKotlinType = INSTANCE.getVarargElementType(parameter2);
            if (coneKotlinType == null) {
                coneKotlinType = FirTypeUtilsKt.getConeType(parameter2.getReturnTypeRef());
            }
            ConeKotlinType typeToCheck = coneKotlinType;
            FirJsExternalChecker.additionalCheck$reportOnParametersAndReturnTypesIf$checkTypeIsNotInlineClass(condition, $reporter, diagnosticFactory, $context, typeToCheck, ktParam);
        }
    }
}

