/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.overrides;

import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrOverridableMember;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.overrides.IrExternalOverridabilityCondition;
import org.jetbrains.kotlin.ir.overrides.MemberWithOriginal;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002J\u0018\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/overrides/IrJavaIncompatibilityRulesOverridabilityCondition;", "Lorg/jetbrains/kotlin/ir/overrides/IrExternalOverridabilityCondition;", "()V", "contract", "Lorg/jetbrains/kotlin/ir/overrides/IrExternalOverridabilityCondition$Contract;", "getContract", "()Lorg/jetbrains/kotlin/ir/overrides/IrExternalOverridabilityCondition$Contract;", "doesJavaOverrideHaveIncompatibleValueParameterKinds", "", "superMember", "Lorg/jetbrains/kotlin/ir/overrides/MemberWithOriginal;", "subMember", "isJvmParameterTypePrimitive", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "index", "", "isOverridable", "Lorg/jetbrains/kotlin/ir/overrides/IrExternalOverridabilityCondition$Result;", "backend.jvm"})
@SourceDebugExtension(value={"SMAP\nIrJavaIncompatibilityRulesOverridabilityCondition.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrJavaIncompatibilityRulesOverridabilityCondition.kt\norg/jetbrains/kotlin/backend/jvm/overrides/IrJavaIncompatibilityRulesOverridabilityCondition\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,65:1\n1755#2,3:66\n*S KotlinDebug\n*F\n+ 1 IrJavaIncompatibilityRulesOverridabilityCondition.kt\norg/jetbrains/kotlin/backend/jvm/overrides/IrJavaIncompatibilityRulesOverridabilityCondition\n*L\n47#1:66,3\n*E\n"})
public final class IrJavaIncompatibilityRulesOverridabilityCondition
implements IrExternalOverridabilityCondition {
    @Override
    @NotNull
    public IrExternalOverridabilityCondition.Result isOverridable(@NotNull MemberWithOriginal superMember, @NotNull MemberWithOriginal subMember) {
        Intrinsics.checkNotNullParameter((Object)superMember, (String)"superMember");
        Intrinsics.checkNotNullParameter((Object)subMember, (String)"subMember");
        if (this.doesJavaOverrideHaveIncompatibleValueParameterKinds(superMember, subMember)) {
            return IrExternalOverridabilityCondition.Result.INCOMPATIBLE;
        }
        return IrExternalOverridabilityCondition.Result.UNKNOWN;
    }

    @Override
    @NotNull
    public IrExternalOverridabilityCondition.Contract getContract() {
        return IrExternalOverridabilityCondition.Contract.CONFLICTS_ONLY;
    }

    private final boolean doesJavaOverrideHaveIncompatibleValueParameterKinds(MemberWithOriginal superMember, MemberWithOriginal subMember) {
        boolean bl;
        block7: {
            IrOverridableMember irOverridableMember = superMember.getOriginal();
            IrSimpleFunction irSimpleFunction = irOverridableMember instanceof IrSimpleFunction ? (IrSimpleFunction)irOverridableMember : null;
            if (irSimpleFunction == null) {
                return false;
            }
            IrSimpleFunction originalSuperMember = irSimpleFunction;
            IrOverridableMember irOverridableMember2 = subMember.getOriginal();
            IrSimpleFunction irSimpleFunction2 = irOverridableMember2 instanceof IrSimpleFunction ? (IrSimpleFunction)irOverridableMember2 : null;
            if (irSimpleFunction2 == null) {
                return false;
            }
            IrSimpleFunction originalSubMember = irSimpleFunction2;
            IrValueParameter irValueParameter = originalSubMember.getDispatchReceiverParameter();
            Intrinsics.checkNotNull((Object)irValueParameter);
            IrClass irClass = IrTypesKt.getClass(irValueParameter.getType());
            Intrinsics.checkNotNull((Object)irClass);
            if (!IrUtilsKt.isFromJava(irClass)) {
                return false;
            }
            if (!(originalSubMember.getValueParameters().size() == originalSuperMember.getValueParameters().size())) {
                boolean $i$a$-require-IrJavaIncompatibilityRulesOverridabilityCondition$doesJavaOverrideHaveIncompatibleValueParameterKinds$22 = false;
                String $i$a$-require-IrJavaIncompatibilityRulesOverridabilityCondition$doesJavaOverrideHaveIncompatibleValueParameterKinds$22 = "External overridability condition with CONFLICTS_ONLY should not be run with different value parameters size: subMember=" + RenderIrElementKt.render$default(originalSubMember, null, 1, null) + " superMember=" + RenderIrElementKt.render$default(originalSuperMember, null, 1, null);
                throw new IllegalArgumentException($i$a$-require-IrJavaIncompatibilityRulesOverridabilityCondition$doesJavaOverrideHaveIncompatibleValueParameterKinds$22.toString());
            }
            Iterable $this$any$iv = (Iterable)CollectionsKt.getIndices((Collection)originalSubMember.getValueParameters());
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                Iterator iterator2 = $this$any$iv.iterator();
                while (iterator2.hasNext()) {
                    int element$iv;
                    int i = element$iv = ((IntIterator)iterator2).nextInt();
                    boolean bl2 = false;
                    if (!(this.isJvmParameterTypePrimitive(originalSuperMember, i) != this.isJvmParameterTypePrimitive(originalSubMember, i))) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean isJvmParameterTypePrimitive(IrSimpleFunction function2, int index2) {
        IrType type2 = function2.getValueParameters().get(index2).getType();
        return IrTypePredicatesKt.isPrimitiveType$default(type2, false, 1, null) && !IrUtilsKt.hasAnnotation((IrAnnotationContainer)type2, StandardClassIds.Annotations.INSTANCE.getFlexibleNullability()) && !IrUtilsKt.hasAnnotation((IrAnnotationContainer)type2, StandardClassIds.Annotations.INSTANCE.getEnhancedNullability());
    }
}

