/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.fir.components;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.components.KtTypeInfoProvider;
import org.jetbrains.kotlin.analysis.api.fir.KtFirAnalysisSession;
import org.jetbrains.kotlin.analysis.api.fir.components.KtFirAnalysisSessionComponent;
import org.jetbrains.kotlin.analysis.api.fir.types.KtFirType;
import org.jetbrains.kotlin.analysis.api.fir.types.PublicTypeApproximator;
import org.jetbrains.kotlin.analysis.api.lifetime.KtLifetimeToken;
import org.jetbrains.kotlin.analysis.api.types.KtType;
import org.jetbrains.kotlin.builtins.functions.FunctionTypeKind;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.resolve.FirSamResolver;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.types.ArrayUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FunctionalTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.types.TypeApproximatorConfiguration;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0015\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0016\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0005\u001a\u00020\u0006X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/components/KtFirTypeInfoProvider;", "Lorg/jetbrains/kotlin/analysis/api/components/KtTypeInfoProvider;", "Lorg/jetbrains/kotlin/analysis/api/fir/components/KtFirAnalysisSessionComponent;", "analysisSession", "Lorg/jetbrains/kotlin/analysis/api/fir/KtFirAnalysisSession;", "token", "Lorg/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeToken;", "(Lorg/jetbrains/kotlin/analysis/api/fir/KtFirAnalysisSession;Lorg/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeToken;)V", "getAnalysisSession", "()Lorg/jetbrains/kotlin/analysis/api/fir/KtFirAnalysisSession;", "getToken", "()Lorg/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeToken;", "canBeNull", "", "type", "Lorg/jetbrains/kotlin/analysis/api/types/KtType;", "fullyExpandedType", "getFunctionClassKind", "Lorg/jetbrains/kotlin/builtins/functions/FunctionTypeKind;", "isArrayOrPrimitiveArray", "isDenotable", "isFunctionalInterfaceType", "isNestedArray", "analysis-api-fir"})
public final class KtFirTypeInfoProvider
extends KtTypeInfoProvider
implements KtFirAnalysisSessionComponent {
    @NotNull
    private final KtFirAnalysisSession analysisSession;
    @NotNull
    private final KtLifetimeToken token;

    public KtFirTypeInfoProvider(@NotNull KtFirAnalysisSession analysisSession, @NotNull KtLifetimeToken token) {
        Intrinsics.checkNotNullParameter((Object)analysisSession, (String)"analysisSession");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        this.analysisSession = analysisSession;
        this.token = token;
    }

    @Override
    @NotNull
    public KtFirAnalysisSession getAnalysisSession() {
        return this.analysisSession;
    }

    @Override
    @NotNull
    protected KtLifetimeToken getToken() {
        return this.token;
    }

    @Override
    public boolean isFunctionalInterfaceType(@NotNull KtType type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        ConeKotlinType coneType = ((KtFirType)((Object)type2)).getConeType();
        FirSession firSession = this.getAnalysisSession().getUseSiteSession$analysis_api_fir();
        FirSamResolver samResolver = new FirSamResolver(firSession, this.getAnalysisSession().getScopeSessionFor(firSession), null, 4, null);
        return samResolver.isSamType(coneType);
    }

    @Override
    @Nullable
    public FunctionTypeKind getFunctionClassKind(@NotNull KtType type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        return FunctionalTypeUtilsKt.functionTypeKind(((KtFirType)((Object)type2)).getConeType(), this.getAnalysisSession().getUseSiteSession$analysis_api_fir());
    }

    @Override
    public boolean canBeNull(@NotNull KtType type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        return TypeUtilsKt.canBeNull(((KtFirType)((Object)type2)).getConeType(), this.getAnalysisSession().getUseSiteSession$analysis_api_fir());
    }

    @Override
    public boolean isDenotable(@NotNull KtType type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        ConeKotlinType coneType = ((KtFirType)((Object)type2)).getConeType();
        return TypeComponentsKt.getTypeApproximator(this.getAnalysisSession().getUseSiteSession$analysis_api_fir()).approximateToSuperType(coneType, (TypeApproximatorConfiguration)new PublicTypeApproximator.PublicApproximatorConfiguration(false)) == null;
    }

    @Override
    public boolean isArrayOrPrimitiveArray(@NotNull KtType type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        if (!(type2 instanceof KtFirType)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        return ArrayUtilsKt.isArrayOrPrimitiveArray(((KtFirType)((Object)type2)).getConeType());
    }

    @Override
    public boolean isNestedArray(@NotNull KtType type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        if (!this.isArrayOrPrimitiveArray(type2)) {
            return false;
        }
        if (!(type2 instanceof KtFirType)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        ConeKotlinType coneKotlinType = FirTypeUtilsKt.arrayElementType$default(((KtFirType)((Object)type2)).getConeType(), false, 1, null);
        return coneKotlinType != null ? ArrayUtilsKt.isArrayOrPrimitiveArray(coneKotlinType) : false;
    }

    @Override
    @NotNull
    public KtType fullyExpandedType(@NotNull KtType type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        return this.asKtType(TypeExpansionUtilsKt.fullyExpandedType(this.getConeType(type2), this.getAnalysisSession().getUseSiteSession$analysis_api_fir()));
    }
}

