/*
 * Decompiled with CFR 0.152.
 */
package javaslang.control;

import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javaslang.Value;
import javaslang.collection.Iterator;
import javaslang.collection.LinearSeq;
import javaslang.collection.List;
import javaslang.collection.Seq;

public interface Option<T>
extends Value<T>,
Serializable {
    public static final long serialVersionUID = 1L;

    public static <T> Option<T> of(T value2) {
        return value2 == null ? Option.none() : Option.some(value2);
    }

    public static <T> Option<Seq<T>> sequence(Iterable<? extends Option<? extends T>> values2) {
        Objects.requireNonNull(values2, "values is null");
        LinearSeq list2 = List.empty();
        for (Option<T> value2 : values2) {
            if (value2.isEmpty()) {
                return Option.none();
            }
            list2 = list2.prepend((Object)value2.get());
        }
        return Option.some(list2.reverse());
    }

    public static <T> Option<T> some(T value2) {
        return new Some(value2);
    }

    public static <T> Option<T> none() {
        None none2 = None.INSTANCE;
        return none2;
    }

    public static Option<Void> nothing() {
        return Some.NOTHING;
    }

    public static <T> Option<T> narrow(Option<? extends T> option) {
        return option;
    }

    public static <T> Option<T> when(boolean condition, Supplier<? extends T> supplier) {
        Objects.requireNonNull(supplier, "supplier is null");
        return condition ? Option.some(supplier.get()) : Option.none();
    }

    public static <T> Option<T> when(boolean condition, T value2) {
        return condition ? Option.some(value2) : Option.none();
    }

    public static <T> Option<T> ofOptional(Optional<? extends T> optional) {
        Objects.requireNonNull(optional, "optional is null");
        return optional.isPresent() ? Option.of(optional.get()) : Option.none();
    }

    @Override
    public boolean isEmpty();

    default public boolean isDefined() {
        return !this.isEmpty();
    }

    @Override
    default public boolean isSingleValued() {
        return true;
    }

    @Override
    public T get();

    @Override
    default public Option<T> getOption() {
        return this;
    }

    @Override
    default public T getOrElse(T other) {
        return this.isEmpty() ? other : this.get();
    }

    default public Option<T> orElse(Option<? extends T> other) {
        Objects.requireNonNull(other, "other is null");
        return this.isEmpty() ? other : this;
    }

    default public Option<T> orElse(Supplier<? extends Option<? extends T>> supplier) {
        Objects.requireNonNull(supplier, "supplier is null");
        return this.isEmpty() ? supplier.get() : this;
    }

    @Override
    default public T getOrElse(Supplier<? extends T> supplier) {
        Objects.requireNonNull(supplier, "supplier is null");
        return this.isEmpty() ? supplier.get() : this.get();
    }

    @Override
    default public <X extends Throwable> T getOrElseThrow(Supplier<X> exceptionSupplier) throws X {
        Objects.requireNonNull(exceptionSupplier, "exceptionSupplier is null");
        if (this.isEmpty()) {
            throw (Throwable)exceptionSupplier.get();
        }
        return this.get();
    }

    default public Option<T> filter(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        return this.isEmpty() || predicate.test(this.get()) ? this : Option.none();
    }

    default public <U> Option<U> flatMap(Function<? super T, ? extends Option<? extends U>> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        return this.isEmpty() ? Option.none() : mapper.apply(this.get());
    }

    @Override
    default public <U> Option<U> map(Function<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        return this.isEmpty() ? Option.none() : Option.some(mapper.apply(this.get()));
    }

    @Override
    default public Option<T> peek(Consumer<? super T> action) {
        Objects.requireNonNull(action, "action is null");
        if (this.isDefined()) {
            action.accept(this.get());
        }
        return this;
    }

    default public <U> U transform(Function<? super Option<T>, ? extends U> f) {
        Objects.requireNonNull(f, "f is null");
        return f.apply(this);
    }

    @Override
    default public Iterator<T> iterator() {
        return this.isEmpty() ? Iterator.empty() : Iterator.of(this.get());
    }

    @Override
    public boolean equals(Object var1);

    @Override
    public int hashCode();

    @Override
    public String toString();

    public static final class None<T>
    implements Option<T>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private static final None<?> INSTANCE = new None();

        private None() {
        }

        @Override
        public T get() {
            throw new NoSuchElementException("No value present");
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean equals(Object o) {
            return o == this;
        }

        @Override
        public int hashCode() {
            return 1;
        }

        @Override
        public String stringPrefix() {
            return "None";
        }

        @Override
        public String toString() {
            return this.stringPrefix();
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }

    public static final class Some<T>
    implements Option<T>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private static final Some<Void> NOTHING = new Some<Object>(null);
        private final T value;

        private Some(T value2) {
            this.value = value2;
        }

        @Override
        public T get() {
            return this.value;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean equals(Object obj) {
            return obj == this || obj instanceof Some && Objects.equals(this.value, ((Some)obj).value);
        }

        @Override
        public int hashCode() {
            return Objects.hashCode(this.value);
        }

        @Override
        public String stringPrefix() {
            return "Some";
        }

        @Override
        public String toString() {
            return this.stringPrefix() + "(" + this.value + ")";
        }
    }
}

