/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirReceiverParameter;
import org.jetbrains.kotlin.fir.expressions.FirCallableReferenceAccess;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.resolve.providers.FirProviderKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0016\u0010\f\u001a\u0004\u0018\u00010\r*\u00020\u000e2\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirLateinitIntrinsicApplicabilityChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirQualifiedAccessExpressionChecker;", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "containingClassOrFile", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirLateinitIntrinsicApplicabilityChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirLateinitIntrinsicApplicabilityChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirLateinitIntrinsicApplicabilityChecker\n+ 2 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 3 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,81:1\n39#2:82\n43#3:83\n*S KotlinDebug\n*F\n+ 1 FirLateinitIntrinsicApplicabilityChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirLateinitIntrinsicApplicabilityChecker\n*L\n48#1:82\n65#1:83\n*E\n"})
public final class FirLateinitIntrinsicApplicabilityChecker
extends FirExpressionChecker<FirQualifiedAccessExpression> {
    @NotNull
    public static final FirLateinitIntrinsicApplicabilityChecker INSTANCE = new FirLateinitIntrinsicApplicabilityChecker();

    private FirLateinitIntrinsicApplicabilityChecker() {
    }

    @Override
    public void check(@NotNull FirQualifiedAccessExpression expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        FirPropertySymbol firPropertySymbol = FirReferenceUtilsKt.toResolvedPropertySymbol$default(expression2.getCalleeReference(), false, 1, null);
        if (firPropertySymbol == null) {
            return;
        }
        FirPropertySymbol resolvedSymbol = firPropertySymbol;
        if (!Intrinsics.areEqual(resolvedSymbol.getName().getIdentifierOrNullIfSpecial(), "isInitialized")) {
            return;
        }
        FirReceiverParameter firReceiverParameter = resolvedSymbol.getReceiverParameter();
        if (firReceiverParameter == null) {
            return;
        }
        FirReceiverParameter receiverParameter = firReceiverParameter;
        if (!FirAnnotationUtilsKt.hasAnnotation(receiverParameter, StandardClassIds.Annotations.INSTANCE.getAccessibleLateinitPropertyLiteral(), context2.getSession())) {
            return;
        }
        KtSourceElement source = expression2.getCalleeReference().getSource();
        FirExpression extensionReceiver2 = expression2.getExtensionReceiver();
        if (!(extensionReceiver2 instanceof FirCallableReferenceAccess)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getLATEINIT_INTRINSIC_CALL_ON_NON_LITERAL(), (DiagnosticContext)context2, null, 8, null);
            return;
        }
        FirPropertySymbol firPropertySymbol2 = FirReferenceUtilsKt.toResolvedPropertySymbol$default(((FirCallableReferenceAccess)extensionReceiver2).getCalleeReference(), false, 1, null);
        if (firPropertySymbol2 == null) {
            return;
        }
        FirPropertySymbol calleePropertySymbol = firPropertySymbol2;
        FirCallableSymbol $this$isLateInit$iv = calleePropertySymbol;
        boolean $i$f$isLateInit = false;
        if (!$this$isLateInit$iv.getRawStatus().isLateInit()) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getLATEINIT_INTRINSIC_CALL_ON_NON_LATEINIT(), (DiagnosticContext)context2, null, 8, null);
            return;
        }
        if (!CollectionsKt.contains((Iterable)context2.getContainingDeclarations(), this.containingClassOrFile(calleePropertySymbol, context2))) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getLATEINIT_INTRINSIC_CALL_ON_NON_ACCESSIBLE_PROPERTY(), (Object)calleePropertySymbol, (DiagnosticContext)context2, null, 16, null);
            return;
        }
        FirDeclaration closestOwnFunction = CollectionsKt.lastOrNull(context2.getContainingDeclarations());
        if (closestOwnFunction instanceof FirFunction) {
            FirMemberDeclaration $this$isInline$iv = (FirMemberDeclaration)closestOwnFunction;
            boolean $i$f$isInline = false;
            if ($this$isInline$iv.getStatus().isInline()) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getLATEINIT_INTRINSIC_CALL_IN_INLINE_FUNCTION(), (DiagnosticContext)context2, null, 8, null);
            }
        }
    }

    private final FirDeclaration containingClassOrFile(FirPropertySymbol $this$containingClassOrFile, CheckerContext context2) {
        FirClassLikeSymbol<?> firClassLikeSymbol = FirHelpersKt.getContainingClassSymbol($this$containingClassOrFile, context2.getSession());
        return firClassLikeSymbol != null && (firClassLikeSymbol = (FirClassLikeDeclaration)firClassLikeSymbol.getFir()) != null ? (FirDeclaration)((Object)firClassLikeSymbol) : (FirDeclaration)FirProviderKt.getFirProvider(context2.getSession()).getFirCallableContainerFile($this$containingClassOrFile);
    }
}

