/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.impl.FirDefaultPropertyGetter;
import org.jetbrains.kotlin.fir.declarations.impl.FirDefaultPropertySetter;
import org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirErrorTypeRef;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\f\u0010\u0015\u001a\u00020\u0006*\u00020\u0002H\u0002J\f\u0010\u0016\u001a\u00020\u0006*\u00020\u0002H\u0002J\f\u0010\u0017\u001a\u00020\u0006*\u00020\u0002H\u0002J&\u0010\u0018\u001a\u00020\u000b*\u00020\u00102\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u0018\u0010\u0005\u001a\u00020\u0006*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirInapplicableLateinitChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirPropertyChecker;", "()V", "hasNullableUpperBound", "", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "getHasNullableUpperBound", "(Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;)Z", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "hasUnderlyingTypeForbiddenForLateinit", "type", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "hasGetter", "hasSetter", "isNullable", "reportError", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "target", "", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirInapplicableLateinitChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirInapplicableLateinitChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirInapplicableLateinitChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,121:1\n48#2:122\n1747#3,3:123\n*S KotlinDebug\n*F\n+ 1 FirInapplicableLateinitChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirInapplicableLateinitChecker\n*L\n27#1:122\n108#1:123,3\n*E\n"})
public final class FirInapplicableLateinitChecker
extends FirDeclarationChecker<FirProperty> {
    @NotNull
    public static final FirInapplicableLateinitChecker INSTANCE = new FirInapplicableLateinitChecker();

    private FirInapplicableLateinitChecker() {
    }

    @Override
    public void check(@NotNull FirProperty declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        FirMemberDeclaration $this$isLateInit$iv = declaration2;
        boolean $i$f$isLateInit = false;
        if (!$this$isLateInit$iv.getStatus().isLateInit() || declaration2.getReturnTypeRef() instanceof FirErrorTypeRef) {
            return;
        }
        if (declaration2.isVal()) {
            this.reportError(reporter, declaration2.getSource(), "is allowed only on mutable properties", context2);
        }
        if (declaration2.getInitializer() != null) {
            if (declaration2.isLocal()) {
                this.reportError(reporter, declaration2.getSource(), "is not allowed on local variables with initializer", context2);
            } else {
                this.reportError(reporter, declaration2.getSource(), "is not allowed on properties with initializer", context2);
            }
        }
        if (declaration2.getDelegate() != null) {
            this.reportError(reporter, declaration2.getSource(), "is not allowed on delegated properties", context2);
        }
        if (this.isNullable(declaration2)) {
            this.reportError(reporter, declaration2.getSource(), "is not allowed on properties of a type with nullable upper bound", context2);
        }
        if (ConeBuiltinTypeUtilsKt.isPrimitive(FirTypeUtilsKt.getConeType(declaration2.getReturnTypeRef()))) {
            if (declaration2.isLocal()) {
                this.reportError(reporter, declaration2.getSource(), "is not allowed on local variables of primitive types", context2);
            } else {
                this.reportError(reporter, declaration2.getSource(), "is not allowed on properties of primitive types", context2);
            }
        }
        if (DeclarationAttributesKt.getHasExplicitBackingField(declaration2)) {
            this.reportError(reporter, declaration2.getSource(), "must be moved to the field declaration", context2);
        }
        if ((this.hasGetter(declaration2) || this.hasSetter(declaration2)) && declaration2.getDelegate() == null) {
            this.reportError(reporter, declaration2.getSource(), "is not allowed on properties with a custom getter or setter", context2);
        }
        if (FirHelpersKt.isSingleFieldValueClass(FirTypeUtilsKt.getConeType(declaration2.getReturnTypeRef()), context2.getSession())) {
            ConeKotlinType declarationType = FirTypeUtilsKt.getConeType(declaration2.getReturnTypeRef());
            String variables = declaration2.isLocal() ? "local variables" : "properties";
            if (ConeBuiltinTypeUtilsKt.isUnsignedType(declarationType)) {
                this.reportError(reporter, declaration2.getSource(), "is not allowed on " + variables + " of unsigned types", context2);
            } else if (!context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.InlineLateinit)) {
                this.reportError(reporter, declaration2.getSource(), "is not allowed on " + variables + " of inline class types", context2);
            } else if (this.hasUnderlyingTypeForbiddenForLateinit(declarationType, context2.getSession())) {
                this.reportError(reporter, declaration2.getSource(), "is not allowed on " + variables + " of inline type with underlying type not suitable for lateinit declaration", context2);
            }
        }
    }

    private final boolean hasUnderlyingTypeForbiddenForLateinit(ConeKotlinType type2, FirSession session) {
        if (FirHelpersKt.isRecursiveValueClassType(type2, session)) {
            return false;
        }
        return FirInapplicableLateinitChecker.hasUnderlyingTypeForbiddenForLateinit$isForbiddenTypeForLateinit(session, FirHelpersKt.getInlineClassUnderlyingType(type2, session));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean getHasNullableUpperBound(ConeKotlinType $this$hasNullableUpperBound) {
        if ($this$hasNullableUpperBound instanceof ConeTypeParameterType) {
            FirResolvedTypeRef it;
            if (ConeTypeUtilsKt.isNullable($this$hasNullableUpperBound)) return true;
            Iterable $this$any$iv = ((ConeTypeParameterType)$this$hasNullableUpperBound).getLookupTag().getTypeParameterSymbol().getResolvedBounds();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator2 = $this$any$iv.iterator();
            do {
                if (!iterator2.hasNext()) return false;
                Object element$iv = iterator2.next();
                it = (FirResolvedTypeRef)element$iv;
                boolean bl = false;
            } while (!ConeTypeUtilsKt.isNullable(FirTypeUtilsKt.getConeType(it)));
            return true;
        }
        boolean bl = ConeTypeUtilsKt.isNullable($this$hasNullableUpperBound);
        return bl;
    }

    private final boolean isNullable(FirProperty $this$isNullable) {
        return this.getHasNullableUpperBound(FirTypeUtilsKt.getConeType($this$isNullable.getReturnTypeRef()));
    }

    private final boolean hasGetter(FirProperty $this$hasGetter) {
        return $this$hasGetter.getGetter() != null && !($this$hasGetter.getGetter() instanceof FirDefaultPropertyGetter);
    }

    private final boolean hasSetter(FirProperty $this$hasSetter) {
        return $this$hasSetter.getSetter() != null && !($this$hasSetter.getSetter() instanceof FirDefaultPropertySetter);
    }

    private final void reportError(DiagnosticReporter $this$reportError, KtSourceElement source, String target, CheckerContext context2) {
        KtDiagnosticReportHelpersKt.reportOn$default($this$reportError, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getINAPPLICABLE_LATEINIT_MODIFIER(), (Object)target, (DiagnosticContext)context2, null, 16, null);
    }

    private static final boolean hasUnderlyingTypeForbiddenForLateinit$isForbiddenTypeForLateinit(FirSession $session, ConeKotlinType type2) {
        if (ConeBuiltinTypeUtilsKt.isPrimitiveOrNullablePrimitive(type2)) {
            return true;
        }
        if (INSTANCE.getHasNullableUpperBound(type2)) {
            return true;
        }
        if (FirHelpersKt.isSingleFieldValueClass(type2, $session)) {
            return FirInapplicableLateinitChecker.hasUnderlyingTypeForbiddenForLateinit$isForbiddenTypeForLateinit($session, FirHelpersKt.getInlineClassUnderlyingType(type2, $session));
        }
        return false;
    }
}

