/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.DataInputOutputUtilRt;
import com.intellij.util.ThrowableConsumer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DataInputOutputUtil {
    public static final long timeBase = 1040688000000L;

    private DataInputOutputUtil() {
    }

    public static int readINT(@NotNull DataInput record2) throws IOException {
        if (record2 == null) {
            DataInputOutputUtil.$$$reportNull$$$0(0);
        }
        return DataInputOutputUtilRt.readINT(record2);
    }

    public static int readINT(@NotNull ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            DataInputOutputUtil.$$$reportNull$$$0(1);
        }
        return DataInputOutputUtilRt.readINT(byteBuffer);
    }

    public static void writeINT(@NotNull DataOutput record2, int val) throws IOException {
        if (record2 == null) {
            DataInputOutputUtil.$$$reportNull$$$0(2);
        }
        DataInputOutputUtilRt.writeINT(record2, val);
    }

    public static void writeINT(@NotNull ByteBuffer byteBuffer, int val) {
        if (byteBuffer == null) {
            DataInputOutputUtil.$$$reportNull$$$0(3);
        }
        DataInputOutputUtilRt.writeINT(byteBuffer, val);
    }

    public static long readLONG(@NotNull DataInput record2) throws IOException {
        int val;
        if (record2 == null) {
            DataInputOutputUtil.$$$reportNull$$$0(4);
        }
        if ((val = record2.readUnsignedByte()) < 192) {
            return val;
        }
        long res = val - 192;
        int sh = 6;
        while (true) {
            int next = record2.readUnsignedByte();
            res |= (long)(next & 0x7F) << sh;
            if ((next & 0x80) == 0) {
                return res;
            }
            sh += 7;
        }
    }

    public static void writeLONG(@NotNull DataOutput record2, long val) throws IOException {
        if (record2 == null) {
            DataInputOutputUtil.$$$reportNull$$$0(5);
        }
        if (0L > val || val >= 192L) {
            record2.writeByte(192 + (int)(val & 0x3FL));
            val >>>= 6;
            while (val >= 128L) {
                record2.writeByte((int)(val & 0x7FL) | 0x80);
                val >>>= 7;
            }
        }
        record2.writeByte((int)val);
    }

    public static int readSINT(@NotNull DataInput record2) throws IOException {
        if (record2 == null) {
            DataInputOutputUtil.$$$reportNull$$$0(6);
        }
        return DataInputOutputUtil.readINT(record2) - 64;
    }

    public static void writeSINT(@NotNull DataOutput record2, int val) throws IOException {
        if (record2 == null) {
            DataInputOutputUtil.$$$reportNull$$$0(7);
        }
        DataInputOutputUtil.writeINT(record2, val + 64);
    }

    public static void writeTIME(@NotNull DataOutput record2, long timestamp) throws IOException {
        long relStamp;
        if (record2 == null) {
            DataInputOutputUtil.$$$reportNull$$$0(8);
        }
        if ((relStamp = timestamp - 1040688000000L) < 0L || relStamp >= 0xFF00000000L) {
            record2.writeByte(255);
            record2.writeLong(timestamp);
        } else {
            record2.writeByte((int)(relStamp >> 32));
            record2.writeByte((int)(relStamp >> 24));
            record2.writeByte((int)(relStamp >> 16));
            record2.writeByte((int)(relStamp >> 8));
            record2.writeByte((int)relStamp);
        }
    }

    public static long readTIME(@NotNull DataInput record2) throws IOException {
        int first;
        if (record2 == null) {
            DataInputOutputUtil.$$$reportNull$$$0(9);
        }
        if ((first = record2.readUnsignedByte()) == 255) {
            return record2.readLong();
        }
        int second = record2.readUnsignedByte();
        int third = record2.readUnsignedByte() << 16;
        int fourth = record2.readUnsignedByte() << 8;
        int fifth = record2.readUnsignedByte();
        return ((long)(first << 8 | second) << 24 | (long)(third | fourth | fifth)) + 1040688000000L;
    }

    public static <T> void writeNullable(@NotNull DataOutput out, @Nullable T value2, @NotNull ThrowableConsumer<T, IOException> writeValue) throws IOException {
        if (out == null) {
            DataInputOutputUtil.$$$reportNull$$$0(10);
        }
        if (writeValue == null) {
            DataInputOutputUtil.$$$reportNull$$$0(11);
        }
        out.writeBoolean(value2 != null);
        if (value2 != null) {
            writeValue.consume(value2);
        }
    }

    @Nullable
    public static <T> T readNullable(@NotNull DataInput in, @NotNull ThrowableComputable<T, IOException> readValue) throws IOException {
        if (in == null) {
            DataInputOutputUtil.$$$reportNull$$$0(12);
        }
        if (readValue == null) {
            DataInputOutputUtil.$$$reportNull$$$0(13);
        }
        return in.readBoolean() ? (T)readValue.compute() : null;
    }

    @NotNull
    public static <T> List<T> readSeq(@NotNull DataInput in, @NotNull ThrowableComputable<? extends T, IOException> readElement) throws IOException {
        if (in == null) {
            DataInputOutputUtil.$$$reportNull$$$0(14);
        }
        if (readElement == null) {
            DataInputOutputUtil.$$$reportNull$$$0(15);
        }
        List<? extends T> list2 = DataInputOutputUtilRt.readSeq(in, readElement);
        if (list2 == null) {
            DataInputOutputUtil.$$$reportNull$$$0(16);
        }
        return list2;
    }

    public static <T> void writeSeq(@NotNull DataOutput out, @NotNull Collection<? extends T> collection, @NotNull ThrowableConsumer<T, IOException> writeElement) throws IOException {
        if (out == null) {
            DataInputOutputUtil.$$$reportNull$$$0(17);
        }
        if (collection == null) {
            DataInputOutputUtil.$$$reportNull$$$0(18);
        }
        if (writeElement == null) {
            DataInputOutputUtil.$$$reportNull$$$0(19);
        }
        DataInputOutputUtilRt.writeSeq(out, collection, writeElement);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 16: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "record";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "byteBuffer";
                break;
            }
            case 10: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "writeValue";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "in";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "readValue";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "readElement";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/io/DataInputOutputUtil";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "writeElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/io/DataInputOutputUtil";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "readSeq";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "readINT";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "writeINT";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "readLONG";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "writeLONG";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "readSINT";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "writeSINT";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "writeTIME";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "readTIME";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "writeNullable";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "readNullable";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "readSeq";
                break;
            }
            case 16: {
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "writeSeq";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 16: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

