/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java.structure.impl.classFiles;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javaslang.collection.HashMap;
import javaslang.collection.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.load.java.structure.JavaClass;
import org.jetbrains.kotlin.load.java.structure.JavaClassifier;
import org.jetbrains.kotlin.load.java.structure.JavaTypeParameter;
import org.jetbrains.kotlin.load.java.structure.impl.classFiles.BinaryJavaClass;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.util.javaslang.JavaslangAdaptersKt;
import org.jetbrains.kotlin.utils.SmartList;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u001e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001:\u0002)*B!\b\u0016\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0003j\u0002`\u0006\u00a2\u0006\u0002\u0010\u0007Bi\b\u0002\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0003j\u0002`\u0006\u0012\"\u0010\b\u001a\u001e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tj\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b`\f\u0012\"\u0010\r\u001a\u001e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000e0\tj\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000e`\f\u00a2\u0006\u0002\u0010\u000fJ%\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\u0015J\u001b\u0010\u0016\u001a\u00020\u00112\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0018H\u0000\u00a2\u0006\u0002\b\u0019J\u0017\u0010\u001a\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001b\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\u001cJ\r\u0010\u001d\u001a\u00020\u0000H\u0000\u00a2\u0006\u0002\b\u001eJ\u0015\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b J\u0015\u0010!\u001a\u00020\"2\u0006\u0010\u001b\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b#J\u0010\u0010$\u001a\u00020\"2\u0006\u0010%\u001a\u00020\u0004H\u0002J\u0015\u0010&\u001a\u00020\"2\u0006\u0010'\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b(R \u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0003j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\r\u001a\u001e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000e0\tj\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000e`\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\b\u001a\u001e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tj\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b`\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lorg/jetbrains/kotlin/load/java/structure/impl/classFiles/ClassifierResolutionContext;", "", "classesByQName", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/name/ClassId;", "Lorg/jetbrains/kotlin/load/java/structure/JavaClass;", "Lorg/jetbrains/kotlin/load/java/structure/impl/classFiles/ClassIdToJavaClass;", "(Lkotlin/jvm/functions/Function1;)V", "typeParameters", "Ljavaslang/collection/Map;", "", "Lorg/jetbrains/kotlin/load/java/structure/JavaTypeParameter;", "Lorg/jetbrains/kotlin/util/javaslang/ImmutableMap;", "innerClasses", "Lorg/jetbrains/kotlin/load/java/structure/impl/classFiles/ClassifierResolutionContext$InnerClassInfo;", "(Lkotlin/jvm/functions/Function1;Ljavaslang/collection/Map;Ljavaslang/collection/Map;)V", "addInnerClass", "", "innerInternalName", "outerInternalName", "simpleName", "addInnerClass$resolution_common_jvm", "addTypeParameters", "newTypeParameters", "", "addTypeParameters$resolution_common_jvm", "convertNestedClassInternalNameWithSimpleHeuristic", "internalName", "convertNestedClassInternalNameWithSimpleHeuristic$resolution_common_jvm", "copyForMember", "copyForMember$resolution_common_jvm", "mapInternalNameToClassId", "mapInternalNameToClassId$resolution_common_jvm", "resolveByInternalName", "Lorg/jetbrains/kotlin/load/java/structure/impl/classFiles/ClassifierResolutionContext$Result;", "resolveByInternalName$resolution_common_jvm", "resolveClass", "classId", "resolveTypeParameter", "name", "resolveTypeParameter$resolution_common_jvm", "InnerClassInfo", "Result", "resolution.common.jvm"})
@SourceDebugExtension(value={"SMAP\nClassifierResolutionContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassifierResolutionContext.kt\norg/jetbrains/kotlin/load/java/structure/impl/classFiles/ClassifierResolutionContext\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,121:1\n1789#2,3:122\n1549#2:125\n1620#2,3:126\n*S KotlinDebug\n*F\n+ 1 ClassifierResolutionContext.kt\norg/jetbrains/kotlin/load/java/structure/impl/classFiles/ClassifierResolutionContext\n*L\n53#1:122,3\n87#1:125\n87#1:126,3\n*E\n"})
public final class ClassifierResolutionContext {
    @NotNull
    private final Function1<ClassId, JavaClass> classesByQName;
    @NotNull
    private Map<String, JavaTypeParameter> typeParameters;
    @NotNull
    private Map<String, InnerClassInfo> innerClasses;

    private ClassifierResolutionContext(Function1<? super ClassId, ? extends JavaClass> classesByQName, Map<String, JavaTypeParameter> typeParameters2, Map<String, InnerClassInfo> innerClasses) {
        this.classesByQName = classesByQName;
        this.typeParameters = typeParameters2;
        this.innerClasses = innerClasses;
    }

    public ClassifierResolutionContext(@NotNull Function1<? super ClassId, ? extends JavaClass> classesByQName) {
        Intrinsics.checkNotNullParameter(classesByQName, "classesByQName");
        HashMap hashMap = HashMap.empty();
        Intrinsics.checkNotNullExpressionValue(hashMap, "empty(...)");
        Map map = (Map)hashMap;
        HashMap hashMap2 = HashMap.empty();
        Intrinsics.checkNotNullExpressionValue(hashMap2, "empty(...)");
        this(classesByQName, (Map<String, JavaTypeParameter>)map, (Map<String, InnerClassInfo>)((Map)hashMap2));
    }

    public final void addInnerClass$resolution_common_jvm(@NotNull String innerInternalName, @NotNull String outerInternalName, @NotNull String simpleName2) {
        Intrinsics.checkNotNullParameter(innerInternalName, "innerInternalName");
        Intrinsics.checkNotNullParameter(outerInternalName, "outerInternalName");
        Intrinsics.checkNotNullParameter(simpleName2, "simpleName");
        Map map = this.innerClasses.put((Object)innerInternalName, (Object)new InnerClassInfo(outerInternalName, simpleName2));
        Intrinsics.checkNotNullExpressionValue(map, "put(...)");
        this.innerClasses = map;
    }

    /*
     * WARNING - void declaration
     */
    public final void addTypeParameters$resolution_common_jvm(@NotNull Collection<? extends JavaTypeParameter> newTypeParameters) {
        void $this$fold$iv;
        void initial$iv;
        Intrinsics.checkNotNullParameter(newTypeParameters, "newTypeParameters");
        if (newTypeParameters.isEmpty()) {
            return;
        }
        Iterable iterable = newTypeParameters;
        Map<String, JavaTypeParameter> map = this.typeParameters;
        ClassifierResolutionContext classifierResolutionContext = this;
        boolean $i$f$fold = false;
        Map accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void typeParameter;
            JavaTypeParameter javaTypeParameter = (JavaTypeParameter)element$iv;
            void acc = accumulator$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue(acc.put((Object)typeParameter.getName().getIdentifier(), (Object)typeParameter), "put(...)");
        }
        classifierResolutionContext.typeParameters = accumulator$iv;
    }

    private final Result resolveClass(ClassId classId) {
        JavaClassifier javaClassifier = this.classesByQName.invoke(classId);
        String string2 = classId.asSingleFqName().asString();
        Intrinsics.checkNotNullExpressionValue(string2, "asString(...)");
        return new Result(javaClassifier, string2);
    }

    @NotNull
    public final Result resolveTypeParameter$resolution_common_jvm(@NotNull String name2) {
        Intrinsics.checkNotNullParameter(name2, "name");
        return new Result(JavaslangAdaptersKt.getOrNull(this.typeParameters, name2), name2);
    }

    @NotNull
    public final ClassifierResolutionContext copyForMember$resolution_common_jvm() {
        return new ClassifierResolutionContext(this.classesByQName, this.typeParameters, this.innerClasses);
    }

    @NotNull
    public final ClassId mapInternalNameToClassId$resolution_common_jvm(@NotNull String internalName2) {
        InnerClassInfo innerClassInfo;
        Intrinsics.checkNotNullParameter(internalName2, "internalName");
        if (StringsKt.contains$default((CharSequence)internalName2, '$', false, 2, null) && (innerClassInfo = JavaslangAdaptersKt.getOrNull(this.innerClasses, internalName2)) != null && Name.isValidIdentifier(innerClassInfo.getSimpleName())) {
            ClassId outerClassId = this.mapInternalNameToClassId$resolution_common_jvm(innerClassInfo.getOuterInternalName());
            ClassId classId = outerClassId.createNestedClassId(Name.identifier(innerClassInfo.getSimpleName()));
            Intrinsics.checkNotNullExpressionValue(classId, "createNestedClassId(...)");
            return classId;
        }
        ClassId classId = ClassId.topLevel(new FqName(StringsKt.replace$default(internalName2, '/', '.', false, 4, null)));
        Intrinsics.checkNotNullExpressionValue(classId, "topLevel(...)");
        return classId;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final ClassId convertNestedClassInternalNameWithSimpleHeuristic$resolution_common_jvm(@NotNull String internalName2) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(internalName2, "internalName");
        SmartList<Integer> splitPoints = new SmartList<Integer>();
        int n = internalName2.length();
        for (int p = 0; p < n; ++p) {
            char c = internalName2.charAt(p);
            if (c != '$' || p <= 0 || internalName2.charAt(p - 1) == '/' || p >= internalName2.length() - 1 || internalName2.charAt(p + 1) == '$') continue;
            splitPoints.add(p);
        }
        if (splitPoints.isEmpty()) {
            return null;
        }
        Iterable $this$map$iv = CollectionsKt.zip((Iterable)CollectionsKt.plus((Collection)CollectionsKt.listOf(-1), (Iterable)splitPoints), (Iterable)CollectionsKt.plus((Collection)splitPoints, Integer.valueOf(internalName2.length())));
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Integer from2 = (Integer)pair.component1();
            Integer to = (Integer)pair.component2();
            int n2 = from2 + 1;
            Intrinsics.checkNotNull(to);
            String string2 = internalName2.substring(n2, to);
            Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
            collection.add(string2);
        }
        List substrings = (List)destination$iv$iv;
        FqName outerFqName = new FqName(StringsKt.replace$default((String)substrings.get(0), '/', '.', false, 4, null));
        FqName fqName2 = outerFqName.parent();
        Intrinsics.checkNotNullExpressionValue(fqName2, "parent(...)");
        FqName packageFqName = fqName2;
        FqName relativeName = new FqName(outerFqName.shortName().asString() + '.' + CollectionsKt.joinToString$default(substrings.subList(1, substrings.size()), ".", null, null, 0, null, null, 62, null));
        return new ClassId(packageFqName, relativeName, false);
    }

    @NotNull
    public final Result resolveByInternalName$resolution_common_jvm(@NotNull String internalName2) {
        ClassId realName;
        Result heuristicResult;
        ClassId heuristicName;
        Intrinsics.checkNotNullParameter(internalName2, "internalName");
        Result result2 = this.resolveClass(this.mapInternalNameToClassId$resolution_common_jvm(internalName2));
        if (result2.getClassifier() == null && StringsKt.contains$default((CharSequence)internalName2, '$', false, 2, null) && (heuristicName = this.convertNestedClassInternalNameWithSimpleHeuristic$resolution_common_jvm(internalName2)) != null && (heuristicResult = this.resolveClass(heuristicName)).getClassifier() instanceof BinaryJavaClass && Intrinsics.areEqual(heuristicName, realName = ((BinaryJavaClass)heuristicResult.getClassifier()).getContext$resolution_common_jvm().mapInternalNameToClassId$resolution_common_jvm(internalName2))) {
            return heuristicResult;
        }
        return result2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/load/java/structure/impl/classFiles/ClassifierResolutionContext$InnerClassInfo;", "", "outerInternalName", "", "simpleName", "(Ljava/lang/String;Ljava/lang/String;)V", "getOuterInternalName", "()Ljava/lang/String;", "getSimpleName", "resolution.common.jvm"})
    private static final class InnerClassInfo {
        @NotNull
        private final String outerInternalName;
        @NotNull
        private final String simpleName;

        public InnerClassInfo(@NotNull String outerInternalName, @NotNull String simpleName2) {
            Intrinsics.checkNotNullParameter(outerInternalName, "outerInternalName");
            Intrinsics.checkNotNullParameter(simpleName2, "simpleName");
            this.outerInternalName = outerInternalName;
            this.simpleName = simpleName2;
        }

        @NotNull
        public final String getOuterInternalName() {
            return this.outerInternalName;
        }

        @NotNull
        public final String getSimpleName() {
            return this.simpleName;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001f\u0010\r\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0005H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/load/java/structure/impl/classFiles/ClassifierResolutionContext$Result;", "", "classifier", "Lorg/jetbrains/kotlin/load/java/structure/JavaClassifier;", "qualifiedName", "", "(Lorg/jetbrains/kotlin/load/java/structure/JavaClassifier;Ljava/lang/String;)V", "getClassifier", "()Lorg/jetbrains/kotlin/load/java/structure/JavaClassifier;", "getQualifiedName", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "resolution.common.jvm"})
    public static final class Result {
        @Nullable
        private final JavaClassifier classifier;
        @NotNull
        private final String qualifiedName;

        public Result(@Nullable JavaClassifier classifier, @NotNull String qualifiedName2) {
            Intrinsics.checkNotNullParameter(qualifiedName2, "qualifiedName");
            this.classifier = classifier;
            this.qualifiedName = qualifiedName2;
        }

        @Nullable
        public final JavaClassifier getClassifier() {
            return this.classifier;
        }

        @NotNull
        public final String getQualifiedName() {
            return this.qualifiedName;
        }

        @Nullable
        public final JavaClassifier component1() {
            return this.classifier;
        }

        @NotNull
        public final String component2() {
            return this.qualifiedName;
        }

        @NotNull
        public final Result copy(@Nullable JavaClassifier classifier, @NotNull String qualifiedName2) {
            Intrinsics.checkNotNullParameter(qualifiedName2, "qualifiedName");
            return new Result(classifier, qualifiedName2);
        }

        public static /* synthetic */ Result copy$default(Result result2, JavaClassifier javaClassifier, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                javaClassifier = result2.classifier;
            }
            if ((n & 2) != 0) {
                string2 = result2.qualifiedName;
            }
            return result2.copy(javaClassifier, string2);
        }

        @NotNull
        public String toString() {
            return "Result(classifier=" + this.classifier + ", qualifiedName=" + this.qualifiedName + ')';
        }

        public int hashCode() {
            int result2 = this.classifier == null ? 0 : this.classifier.hashCode();
            result2 = result2 * 31 + this.qualifiedName.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Result)) {
                return false;
            }
            Result result2 = (Result)other;
            if (!Intrinsics.areEqual(this.classifier, result2.classifier)) {
                return false;
            }
            return Intrinsics.areEqual(this.qualifiedName, result2.qualifiedName);
        }
    }
}

