/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.functions.FunctionTypeKind;
import org.jetbrains.kotlin.builtins.functions.FunctionTypeKindExtractor;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.extensions.FirExtensionServiceKt;
import org.jetbrains.kotlin.fir.extensions.FirFunctionTypeKindExtension;
import org.jetbrains.kotlin.fir.extensions.FirFunctionTypeKindExtensionKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirAnonymousFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.types.FirFunctionTypeKindService;
import org.jetbrains.kotlin.fir.types.FirFunctionTypeRef;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\r2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000fH\u0016J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J \u0010\u0013\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\rH\u0016J\u0016\u0010\u0018\u001a\u0004\u0018\u00010\u000b2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000fH\u0016JZ\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000b0\r\"\u0004\b\u0000\u0010\u001a2\u0006\u0010\u001b\u001a\u0002H\u001a2\u0017\u0010\u001c\u001a\u0013\u0012\u0004\u0012\u0002H\u001a\u0012\u0004\u0012\u00020\u001e0\u001d\u00a2\u0006\u0002\b\u001f2\u001d\u0010\u0016\u001a\u0019\u0012\u0004\u0012\u0002H\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\r0\u001d\u00a2\u0006\u0002\b\u001fH\u0082\b\u00a2\u0006\u0002\u0010 J \u0010!\u001a\u00020\"*\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\rH\u0002R\u0014\u0010\u0005\u001a\u00020\u0006X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/fir/types/FirFunctionTypeKindServiceImpl;", "Lorg/jetbrains/kotlin/fir/types/FirFunctionTypeKindService;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "(Lorg/jetbrains/kotlin/fir/FirSession;)V", "extractor", "Lorg/jetbrains/kotlin/builtins/functions/FunctionTypeKindExtractor;", "getExtractor", "()Lorg/jetbrains/kotlin/builtins/functions/FunctionTypeKindExtractor;", "nonReflectKindsFromExtensions", "", "Lorg/jetbrains/kotlin/builtins/functions/FunctionTypeKind;", "extractAllSpecialKindsForFunction", "", "functionSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirFunctionSymbol;", "extractAllSpecialKindsForFunctionTypeRef", "typeRef", "Lorg/jetbrains/kotlin/fir/types/FirFunctionTypeRef;", "extractSingleExtensionKindForDeserializedConeType", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "annotations", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "extractSingleSpecialKindForFunction", "extractSpecialKindsImpl", "T", "source", "isSuspend", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)Ljava/util/List;", "extractKindsFromAnnotations", "", "providers"})
@SourceDebugExtension(value={"SMAP\nFirFunctionTypeKindServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirFunctionTypeKindServiceImpl.kt\norg/jetbrains/kotlin/fir/types/FirFunctionTypeKindServiceImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n*L\n1#1,121:1\n101#1,2:128\n103#1,4:131\n108#1:148\n101#1,6:149\n108#1:168\n1#2:122\n1#2:145\n1#2:165\n1#2:179\n1549#3:123\n1620#3,3:124\n1603#3,9:135\n1855#3:144\n1856#3:146\n1612#3:147\n1603#3,9:155\n1855#3:164\n1856#3:166\n1612#3:167\n1603#3,9:169\n1855#3:178\n1856#3:180\n1612#3:181\n31#4:127\n31#4:130\n*S KotlinDebug\n*F\n+ 1 FirFunctionTypeKindServiceImpl.kt\norg/jetbrains/kotlin/fir/types/FirFunctionTypeKindServiceImpl\n*L\n63#1:128,2\n63#1:131,4\n63#1:148\n76#1:149,6\n76#1:168\n68#1:145\n76#1:165\n87#1:179\n45#1:123\n45#1:124,3\n68#1:135,9\n68#1:144\n68#1:146\n68#1:147\n76#1:155,9\n76#1:164\n76#1:166\n76#1:167\n87#1:169,9\n87#1:178\n87#1:180\n87#1:181\n56#1:127\n65#1:130\n*E\n"})
public final class FirFunctionTypeKindServiceImpl
extends FirFunctionTypeKindService {
    @NotNull
    private final FirSession session;
    @NotNull
    private final List<FunctionTypeKind> nonReflectKindsFromExtensions;
    @NotNull
    private final FunctionTypeKindExtractor extractor;

    /*
     * WARNING - void declaration
     */
    public FirFunctionTypeKindServiceImpl(@NotNull FirSession session2) {
        void $this$extractor_u24lambda_u245;
        List<FunctionTypeKind> list2;
        Intrinsics.checkNotNullParameter(session2, "session");
        this.session = session2;
        this.nonReflectKindsFromExtensions = new ArrayList();
        FirFunctionTypeKindServiceImpl firFunctionTypeKindServiceImpl = this;
        FirFunctionTypeKindServiceImpl firFunctionTypeKindServiceImpl2 = this;
        boolean bl = false;
        List<FunctionTypeKind> $this$extractor_u24lambda_u245_u24lambda_u241 = list2 = CollectionsKt.createListBuilder();
        boolean bl2 = false;
        $this$extractor_u24lambda_u245_u24lambda_u241.add(FunctionTypeKind.Function.INSTANCE);
        $this$extractor_u24lambda_u245_u24lambda_u241.add(FunctionTypeKind.SuspendFunction.INSTANCE);
        $this$extractor_u24lambda_u245_u24lambda_u241.add(FunctionTypeKind.KFunction.INSTANCE);
        $this$extractor_u24lambda_u245_u24lambda_u241.add(FunctionTypeKind.KSuspendFunction.INSTANCE);
        FirFunctionTypeKindExtension.FunctionTypeKindRegistrar registrar2 = new FirFunctionTypeKindExtension.FunctionTypeKindRegistrar($this$extractor_u24lambda_u245_u24lambda_u241, (FirFunctionTypeKindServiceImpl)$this$extractor_u24lambda_u245){
            final /* synthetic */ List<FunctionTypeKind> $this_buildList;
            final /* synthetic */ FirFunctionTypeKindServiceImpl $this_run;
            {
                this.$this_buildList = $receiver;
                this.$this_run = $receiver2;
            }

            public void registerKind(@NotNull FunctionTypeKind nonReflectKind, @NotNull FunctionTypeKind reflectKind) {
                Intrinsics.checkNotNullParameter(nonReflectKind, "nonReflectKind");
                Intrinsics.checkNotNullParameter(reflectKind, "reflectKind");
                if (!Intrinsics.areEqual(nonReflectKind.reflectKind(), reflectKind)) {
                    String string2 = "Failed requirement.";
                    throw new IllegalArgumentException(string2.toString());
                }
                if (!Intrinsics.areEqual(reflectKind.nonReflectKind(), nonReflectKind)) {
                    String string3 = "Failed requirement.";
                    throw new IllegalArgumentException(string3.toString());
                }
                this.$this_buildList.add(nonReflectKind);
                this.$this_buildList.add(reflectKind);
                ((Collection)FirFunctionTypeKindServiceImpl.access$getNonReflectKindsFromExtensions$p(this.$this_run)).add(nonReflectKind);
            }
        };
        Iterator<FirFunctionTypeKindExtension> iterator2 = FirFunctionTypeKindExtensionKt.getFunctionTypeKindExtensions(FirExtensionServiceKt.getExtensionService($this$extractor_u24lambda_u245.session)).iterator();
        while (iterator2.hasNext()) {
            FirFunctionTypeKindExtension firFunctionTypeKindExtension;
            FirFunctionTypeKindExtension $this$extractor_u24lambda_u245_u24lambda_u241_u24lambda_u240 = firFunctionTypeKindExtension = iterator2.next();
            boolean bl3 = false;
            $this$extractor_u24lambda_u245_u24lambda_u241_u24lambda_u240.registerKinds(registrar2);
        }
        List<FunctionTypeKind> kinds2 = list2 = CollectionsKt.build(list2);
        boolean bl4 = false;
        Iterable $this$map$iv = kinds2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : iterable) {
            void it;
            FunctionTypeKind functionTypeKind = (FunctionTypeKind)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl5 = false;
            collection.add(it.getPackageFqName() + '.' + it.getClassNamePrefix());
        }
        List allNames2 = (List)destination$iv$iv;
        if (!Intrinsics.areEqual(CollectionsKt.distinct(allNames2), allNames2)) {
            boolean bl6 = false;
            String string2 = "There are clashing functional type kinds: " + allNames2;
            throw new IllegalArgumentException(string2.toString());
        }
        List<FunctionTypeKind> kinds3 = list2;
        firFunctionTypeKindServiceImpl2.extractor = new FunctionTypeKindExtractor(kinds3);
    }

    @Override
    @NotNull
    protected FunctionTypeKindExtractor getExtractor() {
        return this.extractor;
    }

    @Override
    @Nullable
    public FunctionTypeKind extractSingleSpecialKindForFunction(@NotNull FirFunctionSymbol<?> functionSymbol) {
        Intrinsics.checkNotNullParameter(functionSymbol, "functionSymbol");
        if (this.nonReflectKindsFromExtensions.isEmpty()) {
            FunctionTypeKind.SuspendFunction suspendFunction;
            FunctionTypeKind.SuspendFunction it = suspendFunction = FunctionTypeKind.SuspendFunction.INSTANCE;
            boolean bl = false;
            FirCallableSymbol $this$isSuspend$iv = functionSymbol;
            boolean $i$f$isSuspend = false;
            return $this$isSuspend$iv.getRawStatus().isSuspend() ? suspendFunction : null;
        }
        return CollectionsKt.singleOrNull(this.extractAllSpecialKindsForFunction(functionSymbol));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<FunctionTypeKind> extractAllSpecialKindsForFunction(@NotNull FirFunctionSymbol<?> functionSymbol) {
        List<FunctionTypeKind> list2;
        Intrinsics.checkNotNullParameter(functionSymbol, "functionSymbol");
        FirFunctionTypeKindServiceImpl this_$iv = this;
        boolean $i$f$extractSpecialKindsImpl = false;
        List<FunctionTypeKind> $this$extractSpecialKindsImpl_u24lambda_u2415$iv = list2 = CollectionsKt.createListBuilder();
        boolean bl = false;
        FirFunctionSymbol<?> $this$extractAllSpecialKindsForFunction_u24lambda_u247 = functionSymbol;
        boolean bl2 = false;
        FirCallableSymbol $this$isSuspend$iv = $this$extractAllSpecialKindsForFunction_u24lambda_u247;
        boolean $i$f$isSuspend = false;
        if ($this$isSuspend$iv.getRawStatus().isSuspend()) {
            $this$extractSpecialKindsImpl_u24lambda_u2415$iv.add(FunctionTypeKind.SuspendFunction.INSTANCE);
        }
        if (!((Collection)this_$iv.nonReflectKindsFromExtensions).isEmpty()) {
            List list3;
            $this$extractAllSpecialKindsForFunction_u24lambda_u247 = functionSymbol;
            List<FunctionTypeKind> list4 = $this$extractSpecialKindsImpl_u24lambda_u2415$iv;
            FirFunctionTypeKindServiceImpl firFunctionTypeKindServiceImpl = this_$iv;
            boolean bl3 = false;
            if (functionSymbol instanceof FirAnonymousFunctionSymbol) {
                void $this$mapNotNullTo$iv$iv;
                Iterable $this$mapNotNull$iv = functionSymbol.getAnnotations();
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    ClassId it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl4 = false;
                    FirAnnotation it = (FirAnnotation)element$iv$iv;
                    boolean bl5 = false;
                    if (FirAnnotationUtilsKt.toAnnotationClassId(it, this.session) == null) continue;
                    boolean bl6 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                list3 = (List)destination$iv$iv;
            } else {
                void $this$extractAllSpecialKindsForFunction_u24lambda_u249;
                list3 = $this$extractAllSpecialKindsForFunction_u24lambda_u249.getResolvedAnnotationClassIds();
            }
            List list5 = list3;
            firFunctionTypeKindServiceImpl.extractKindsFromAnnotations(list4, list5);
        }
        return CollectionsKt.build(list2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<FunctionTypeKind> extractAllSpecialKindsForFunctionTypeRef(@NotNull FirFunctionTypeRef typeRef) {
        List<FunctionTypeKind> list2;
        Intrinsics.checkNotNullParameter(typeRef, "typeRef");
        FirFunctionTypeKindServiceImpl this_$iv = this;
        boolean $i$f$extractSpecialKindsImpl = false;
        List<FunctionTypeKind> $this$extractSpecialKindsImpl_u24lambda_u2415$iv = list2 = CollectionsKt.createListBuilder();
        boolean bl = false;
        FirFunctionTypeRef $this$extractAllSpecialKindsForFunctionTypeRef_u24lambda_u2410 = typeRef;
        boolean bl2 = false;
        if ($this$extractAllSpecialKindsForFunctionTypeRef_u24lambda_u2410.isSuspend()) {
            $this$extractSpecialKindsImpl_u24lambda_u2415$iv.add(FunctionTypeKind.SuspendFunction.INSTANCE);
        }
        if (!((Collection)this_$iv.nonReflectKindsFromExtensions).isEmpty()) {
            void $this$mapNotNullTo$iv$iv;
            void $this$extractAllSpecialKindsForFunctionTypeRef_u24lambda_u2412;
            $this$extractAllSpecialKindsForFunctionTypeRef_u24lambda_u2410 = typeRef;
            List<FunctionTypeKind> list3 = $this$extractSpecialKindsImpl_u24lambda_u2415$iv;
            FirFunctionTypeKindServiceImpl firFunctionTypeKindServiceImpl = this_$iv;
            boolean bl3 = false;
            Iterable $this$mapNotNull$iv = $this$extractAllSpecialKindsForFunctionTypeRef_u24lambda_u2412.getAnnotations();
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                ClassId it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl4 = false;
                FirAnnotation it = (FirAnnotation)element$iv$iv;
                boolean bl5 = false;
                if (FirAnnotationUtilsKt.toAnnotationClassId(it, this.session) == null) continue;
                boolean bl6 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List list4 = (List)destination$iv$iv;
            firFunctionTypeKindServiceImpl.extractKindsFromAnnotations(list3, list4);
        }
        return CollectionsKt.build(list2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public FunctionTypeKind extractSingleExtensionKindForDeserializedConeType(@NotNull ClassId classId, @NotNull List<? extends FirAnnotation> annotations2) {
        FunctionTypeKind functionTypeKind;
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        List<FunctionTypeKind> list2;
        Intrinsics.checkNotNullParameter(classId, "classId");
        Intrinsics.checkNotNullParameter(annotations2, "annotations");
        if (this.nonReflectKindsFromExtensions.isEmpty() || annotations2.isEmpty()) {
            return null;
        }
        FunctionTypeKindExtractor functionTypeKindExtractor = this.getExtractor();
        FqName fqName2 = classId.getPackageFqName();
        Intrinsics.checkNotNullExpressionValue(fqName2, "getPackageFqName(...)");
        String string2 = classId.getShortClassName().asString();
        Intrinsics.checkNotNullExpressionValue(string2, "asString(...)");
        FunctionTypeKind functionTypeKind2 = functionTypeKindExtractor.getFunctionalClassKind(fqName2, string2);
        if (functionTypeKind2 == null) {
            return null;
        }
        FunctionTypeKind baseKind = functionTypeKind2;
        if (!Intrinsics.areEqual(baseKind.nonReflectKind(), FunctionTypeKind.Function.INSTANCE)) {
            return null;
        }
        List<FunctionTypeKind> $this$extractSingleExtensionKindForDeserializedConeType_u24lambda_u2414 = list2 = CollectionsKt.createListBuilder();
        boolean bl = false;
        Iterable iterable = annotations2;
        List<FunctionTypeKind> list3 = $this$extractSingleExtensionKindForDeserializedConeType_u24lambda_u2414;
        FirFunctionTypeKindServiceImpl firFunctionTypeKindServiceImpl = this;
        boolean $i$f$mapNotNull = false;
        void var12_12 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            ClassId it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl2 = false;
            FirAnnotation it = (FirAnnotation)element$iv$iv;
            boolean bl3 = false;
            if (FirAnnotationUtilsKt.toAnnotationClassId(it, this.session) == null) continue;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List list4 = (List)destination$iv$iv;
        firFunctionTypeKindServiceImpl.extractKindsFromAnnotations(list3, list4);
        List<FunctionTypeKind> matchingExtensionKinds = CollectionsKt.build(list2);
        FunctionTypeKind functionTypeKind3 = CollectionsKt.singleOrNull(matchingExtensionKinds);
        if (functionTypeKind3 == null) {
            return null;
        }
        FunctionTypeKind matchingKind = functionTypeKind3;
        boolean bl5 = baseKind.isReflectType();
        if (!bl5) {
            functionTypeKind = matchingKind;
        } else if (bl5) {
            functionTypeKind = matchingKind.reflectKind();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return functionTypeKind;
    }

    private final <T> List<FunctionTypeKind> extractSpecialKindsImpl(T source, Function1<? super T, Boolean> isSuspend, Function1<? super T, ? extends List<ClassId>> annotations2) {
        List<FunctionTypeKind> list2;
        boolean $i$f$extractSpecialKindsImpl = false;
        List<FunctionTypeKind> $this$extractSpecialKindsImpl_u24lambda_u2415 = list2 = CollectionsKt.createListBuilder();
        boolean bl = false;
        if (isSuspend.invoke(source).booleanValue()) {
            $this$extractSpecialKindsImpl_u24lambda_u2415.add(FunctionTypeKind.SuspendFunction.INSTANCE);
        }
        if (!((Collection)this.nonReflectKindsFromExtensions).isEmpty()) {
            this.extractKindsFromAnnotations($this$extractSpecialKindsImpl_u24lambda_u2415, annotations2.invoke(source));
        }
        return CollectionsKt.build(list2);
    }

    private final void extractKindsFromAnnotations(List<FunctionTypeKind> $this$extractKindsFromAnnotations, List<ClassId> annotations2) {
        for (ClassId annotationClassId : annotations2) {
            for (FunctionTypeKind kind : this.nonReflectKindsFromExtensions) {
                if (!Intrinsics.areEqual(kind.getAnnotationOnInvokeClassId(), annotationClassId)) continue;
                $this$extractKindsFromAnnotations.add(kind);
            }
        }
    }

    public static final /* synthetic */ List access$getNonReflectKindsFromExtensions$p(FirFunctionTypeKindServiceImpl $this) {
        return $this.nonReflectKindsFromExtensions;
    }
}

