/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.dfa;

import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.collections.immutable.PersistentList;
import kotlinx.collections.immutable.PersistentMap;
import kotlinx.collections.immutable.PersistentSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.resolve.dfa.DataFlowVariable;
import org.jetbrains.kotlin.fir.resolve.dfa.Flow;
import org.jetbrains.kotlin.fir.resolve.dfa.Implication;
import org.jetbrains.kotlin.fir.resolve.dfa.MutableFlow;
import org.jetbrains.kotlin.fir.resolve.dfa.PersistentTypeStatement;
import org.jetbrains.kotlin.fir.resolve.dfa.RealVariable;
import org.jetbrains.kotlin.fir.resolve.dfa.TypeStatement;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0081\u0001\b\u0000\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0000\u0012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u0012\u0018\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0004\u0012\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\f0\u0004\u0012\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0018\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u000f0\u0004\u00a2\u0006\u0002\u0010\u0010J\u0006\u0010\u001a\u001a\u00020\u001bJ\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u0005H\u0016J\u0010\u0010\u001f\u001a\u0004\u0018\u00010\u00002\u0006\u0010 \u001a\u00020\u0000J\u0010\u0010!\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u0005H\u0016R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\f0\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R \u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u000f0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0012R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/fir/resolve/dfa/PersistentFlow;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/Flow;", "previousFlow", "approvedTypeStatements", "Lkotlinx/collections/immutable/PersistentMap;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/RealVariable;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/PersistentTypeStatement;", "logicStatements", "Lorg/jetbrains/kotlin/fir/resolve/dfa/DataFlowVariable;", "Lkotlinx/collections/immutable/PersistentList;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/Implication;", "assignmentIndex", "", "directAliasMap", "backwardsAliasMap", "Lkotlinx/collections/immutable/PersistentSet;", "(Lorg/jetbrains/kotlin/fir/resolve/dfa/PersistentFlow;Lkotlinx/collections/immutable/PersistentMap;Lkotlinx/collections/immutable/PersistentMap;Lkotlinx/collections/immutable/PersistentMap;Lkotlinx/collections/immutable/PersistentMap;Lkotlinx/collections/immutable/PersistentMap;)V", "getAssignmentIndex$semantics", "()Lkotlinx/collections/immutable/PersistentMap;", "getDirectAliasMap$semantics", "knownVariables", "", "getKnownVariables", "()Ljava/util/Set;", "level", "getLogicStatements$semantics", "fork", "Lorg/jetbrains/kotlin/fir/resolve/dfa/MutableFlow;", "getTypeStatement", "Lorg/jetbrains/kotlin/fir/resolve/dfa/TypeStatement;", "variable", "lowestCommonAncestor", "other", "unwrapVariable", "semantics"})
public final class PersistentFlow
extends Flow {
    @Nullable
    private final PersistentFlow previousFlow;
    @NotNull
    private final PersistentMap<RealVariable, PersistentTypeStatement> approvedTypeStatements;
    @NotNull
    private final PersistentMap<DataFlowVariable, PersistentList<Implication>> logicStatements;
    @NotNull
    private final PersistentMap<RealVariable, Integer> assignmentIndex;
    @NotNull
    private final PersistentMap<RealVariable, RealVariable> directAliasMap;
    @NotNull
    private final PersistentMap<RealVariable, PersistentSet<RealVariable>> backwardsAliasMap;
    private final int level;

    public PersistentFlow(@Nullable PersistentFlow previousFlow, @NotNull PersistentMap<RealVariable, PersistentTypeStatement> approvedTypeStatements, @NotNull PersistentMap<DataFlowVariable, ? extends PersistentList<Implication>> logicStatements, @NotNull PersistentMap<RealVariable, Integer> assignmentIndex, @NotNull PersistentMap<RealVariable, RealVariable> directAliasMap, @NotNull PersistentMap<RealVariable, ? extends PersistentSet<RealVariable>> backwardsAliasMap) {
        Intrinsics.checkNotNullParameter(approvedTypeStatements, "approvedTypeStatements");
        Intrinsics.checkNotNullParameter(logicStatements, "logicStatements");
        Intrinsics.checkNotNullParameter(assignmentIndex, "assignmentIndex");
        Intrinsics.checkNotNullParameter(directAliasMap, "directAliasMap");
        Intrinsics.checkNotNullParameter(backwardsAliasMap, "backwardsAliasMap");
        this.previousFlow = previousFlow;
        this.approvedTypeStatements = approvedTypeStatements;
        this.logicStatements = logicStatements;
        this.assignmentIndex = assignmentIndex;
        this.directAliasMap = directAliasMap;
        this.backwardsAliasMap = backwardsAliasMap;
        this.level = this.previousFlow != null ? this.previousFlow.level + 1 : 0;
    }

    @NotNull
    public final PersistentMap<DataFlowVariable, PersistentList<Implication>> getLogicStatements$semantics() {
        return this.logicStatements;
    }

    @NotNull
    public final PersistentMap<RealVariable, Integer> getAssignmentIndex$semantics() {
        return this.assignmentIndex;
    }

    @NotNull
    public final PersistentMap<RealVariable, RealVariable> getDirectAliasMap$semantics() {
        return this.directAliasMap;
    }

    @Override
    @NotNull
    public Set<RealVariable> getKnownVariables() {
        return SetsKt.plus(this.approvedTypeStatements.keySet(), this.directAliasMap.keySet());
    }

    @Override
    @NotNull
    public RealVariable unwrapVariable(@NotNull RealVariable variable2) {
        Intrinsics.checkNotNullParameter(variable2, "variable");
        RealVariable realVariable2 = (RealVariable)this.directAliasMap.get(variable2);
        if (realVariable2 == null) {
            realVariable2 = variable2;
        }
        return realVariable2;
    }

    @Override
    @Nullable
    public TypeStatement getTypeStatement(@NotNull RealVariable variable2) {
        Intrinsics.checkNotNullParameter(variable2, "variable");
        PersistentTypeStatement persistentTypeStatement = (PersistentTypeStatement)this.approvedTypeStatements.get(this.unwrapVariable(variable2));
        return persistentTypeStatement != null ? PersistentTypeStatement.copy$default(persistentTypeStatement, variable2, null, 2, null) : null;
    }

    @Nullable
    public final PersistentFlow lowestCommonAncestor(@NotNull PersistentFlow other) {
        Intrinsics.checkNotNullParameter(other, "other");
        PersistentFlow left = this;
        PersistentFlow right = other;
        while (left.level > right.level) {
            if (left.previousFlow != null) continue;
            return null;
        }
        while (right.level > left.level) {
            if (right.previousFlow != null) continue;
            return null;
        }
        while (!Intrinsics.areEqual(left, right)) {
            if (left.previousFlow == null) {
                return null;
            }
            if (right.previousFlow != null) continue;
            return null;
        }
        return left;
    }

    @NotNull
    public final MutableFlow fork() {
        return new MutableFlow(this, this.approvedTypeStatements.builder(), this.logicStatements.builder(), this.assignmentIndex.builder(), this.directAliasMap.builder(), this.backwardsAliasMap.builder());
    }
}

