/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.jvm.JavaToKotlinClassMap;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderKt;
import org.jetbrains.kotlin.fir.scopes.FirPlatformClassMapper;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0016J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0014\u0010\b\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/FirJavaClassMapper;", "Lorg/jetbrains/kotlin/fir/scopes/FirPlatformClassMapper;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "(Lorg/jetbrains/kotlin/fir/FirSession;)V", "getCorrespondingKotlinClass", "Lorg/jetbrains/kotlin/name/ClassId;", "classId", "getCorrespondingPlatformClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;", "java"})
@SourceDebugExtension(value={"SMAP\nFirJavaClassMapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJavaClassMapper.kt\norg/jetbrains/kotlin/fir/resolve/FirJavaClassMapper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,34:1\n1#2:35\n*E\n"})
public final class FirJavaClassMapper
extends FirPlatformClassMapper {
    @NotNull
    private final FirSession session;

    public FirJavaClassMapper(@NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter(session2, "session");
        this.session = session2;
    }

    @Override
    @Nullable
    public FirRegularClass getCorrespondingPlatformClass(@NotNull FirClassLikeDeclaration declaration2) {
        FirClassLikeDeclaration firClassLikeDeclaration;
        ClassId javaClassId;
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        ClassId classId = javaClassId = this.getCorrespondingPlatformClass(declaration2.getSymbol().getClassId());
        if (classId != null) {
            ClassId it = classId;
            boolean bl = false;
            FirClassLikeSymbol<?> firClassLikeSymbol = FirSymbolProviderKt.getSymbolProvider(this.session).getClassLikeSymbolByClassId(it);
            firClassLikeDeclaration = firClassLikeSymbol != null ? (FirClassLikeDeclaration)firClassLikeSymbol.getFir() : null;
        } else {
            firClassLikeDeclaration = null;
        }
        FirClassLikeDeclaration firClassLikeDeclaration2 = firClassLikeDeclaration;
        return firClassLikeDeclaration2 instanceof FirRegularClass ? (FirRegularClass)firClassLikeDeclaration2 : null;
    }

    @Override
    @Nullable
    public ClassId getCorrespondingPlatformClass(@Nullable ClassId classId) {
        if (classId == null) {
            return null;
        }
        FqNameUnsafe fqNameUnsafe = classId.asSingleFqName().toUnsafe();
        Intrinsics.checkNotNullExpressionValue(fqNameUnsafe, "toUnsafe(...)");
        return JavaToKotlinClassMap.INSTANCE.mapKotlinToJava(fqNameUnsafe);
    }

    @Override
    @Nullable
    public ClassId getCorrespondingKotlinClass(@Nullable ClassId classId) {
        if (classId == null) {
            return null;
        }
        FqName fqName2 = classId.asSingleFqName();
        Intrinsics.checkNotNullExpressionValue(fqName2, "asSingleFqName(...)");
        return JavaToKotlinClassMap.INSTANCE.mapJavaToKotlin(fqName2);
    }
}

