/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.backend;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.serialization.mangle.BaseKotlinMangleComputer;
import org.jetbrains.kotlin.backend.common.serialization.mangle.MangleConstant;
import org.jetbrains.kotlin.backend.common.serialization.mangle.MangleMode;
import org.jetbrains.kotlin.backend.common.serialization.mangle.MangleUtilsKt;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousObject;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirContextReceiver;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirField;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirReceiverParameter;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirTypeParametersOwner;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.declarations.synthetic.FirSyntheticPropertyAccessor;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderKt;
import org.jetbrains.kotlin.fir.signaturer.FirManglerUtilKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.ConeClassifierLookupTag;
import org.jetbrains.kotlin.fir.symbols.ConeTypeParameterLookupTag;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.CompilerConeAttributesKt;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeCapturedType;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeDefinitelyNotNullType;
import org.jetbrains.kotlin.fir.types.ConeDynamicType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeInferenceContext;
import org.jetbrains.kotlin.fir.types.ConeIntersectionType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeLookupTagBasedType;
import org.jetbrains.kotlin.fir.types.ConeRawType;
import org.jetbrains.kotlin.fir.types.ConeSimpleKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.fir.visitors.FirVisitorVoid;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.types.model.SimpleTypeMarker;
import org.jetbrains.kotlin.types.model.TypeParameterMarker;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\t\b\u0016\u0018\u00002,\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0001:\u00017B\u0019\u0012\n\u0010\t\u001a\u00060\nj\u0002`\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\rH\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0006H\u0014J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00030\u00172\u0006\u0010\u0018\u001a\u00020\u0007H\u0014J\u0010\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u0004H\u0014J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0018\u001a\u00020\u0007H\u0014J\u0018\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u0006H\u0014J\u0010\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0007H\u0014J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u001a\u001a\u00020\u0004H\u0014J$\u0010!\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040#0\"2\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u0002H\u0014J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\bH\u0014J\u0010\u0010'\u001a\u00020\u00032\u0006\u0010(\u001a\u00020\u0005H\u0014J\u0016\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00050\u00172\u0006\u0010\u0018\u001a\u00020\u0007H\u0014J\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u0003H\u0014J\u0010\u0010-\u001a\u00020+2\u0006\u0010(\u001a\u00020\u0005H\u0014J$\u0010.\u001a\u00020/2\n\u00100\u001a\u00060\nj\u0002`\u000b2\u0006\u0010,\u001a\u00020\u00032\u0006\u00101\u001a\u00020\bH\u0014J\u0010\u00102\u001a\u00020 2\u0006\u00103\u001a\u00020\u0002H\u0014J\u000e\u00104\u001a\u0004\u0018\u00010\u0006*\u00020\u0002H\u0014J\f\u00105\u001a\u00020/*\u00020\u0002H\u0014J\f\u00106\u001a\u00020/*\u00020\u0002H\u0014R\u0012\u0010\u000f\u001a\u00060\u0010R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lorg/jetbrains/kotlin/fir/backend/FirMangleComputer;", "Lorg/jetbrains/kotlin/backend/common/serialization/mangle/BaseKotlinMangleComputer;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "Lorg/jetbrains/kotlin/fir/symbols/ConeTypeParameterLookupTag;", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "Lorg/jetbrains/kotlin/fir/FirSession;", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "mode", "Lorg/jetbrains/kotlin/backend/common/serialization/mangle/MangleMode;", "(Ljava/lang/StringBuilder;Lorg/jetbrains/kotlin/backend/common/serialization/mangle/MangleMode;)V", "visitor", "Lorg/jetbrains/kotlin/fir/backend/FirMangleComputer$Visitor;", "copy", "newMode", "getContainerIndex", "", "parent", "getContextReceiverTypes", "", "function", "getEffectiveParent", "typeParameter", "getExtensionReceiverParameterType", "getIndexOfTypeParameter", "container", "getReturnType", "getTypeParameterName", "", "getTypeParametersWithIndices", "", "Lkotlin/collections/IndexedValue;", "getTypeSystemContext", "Lorg/jetbrains/kotlin/fir/types/ConeInferenceContext;", "session", "getValueParameterType", "valueParameter", "getValueParameters", "isUnit", "", "type", "isVararg", "mangleType", "", "tBuilder", "declarationSiteSession", "renderDeclaration", "declaration", "asTypeParameterContainer", "visit", "visitParent", "Visitor", "fir2ir"})
@SourceDebugExtension(value={"SMAP\nFirMangleComputer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirMangleComputer.kt\norg/jetbrains/kotlin/fir/backend/FirMangleComputer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,291:1\n1#2:292\n1549#3:293\n1620#3,3:294\n1549#3:297\n1620#3,3:298\n350#3,7:301\n*S KotlinDebug\n*F\n+ 1 FirMangleComputer.kt\norg/jetbrains/kotlin/fir/backend/FirMangleComputer\n*L\n86#1:293\n86#1:294,3\n104#1:297\n104#1:298,3\n118#1:301,7\n*E\n"})
public class FirMangleComputer
extends BaseKotlinMangleComputer<FirDeclaration, ConeKotlinType, ConeTypeParameterLookupTag, FirValueParameter, FirMemberDeclaration, FirFunction, FirSession> {
    @NotNull
    private final Visitor visitor;

    public FirMangleComputer(@NotNull StringBuilder builder2, @NotNull MangleMode mode) {
        Intrinsics.checkNotNullParameter(builder2, "builder");
        Intrinsics.checkNotNullParameter((Object)mode, "mode");
        super(builder2, mode, false, 4, null);
        this.visitor = new Visitor();
    }

    @NotNull
    public FirMangleComputer copy(@NotNull MangleMode newMode) {
        Intrinsics.checkNotNullParameter((Object)newMode, "newMode");
        return new FirMangleComputer(this.getBuilder(), newMode);
    }

    @NotNull
    protected ConeInferenceContext getTypeSystemContext(@NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter(session2, "session");
        return new ConeInferenceContext(session2){
            final /* synthetic */ FirSession $session;
            {
                this.$session = $session;
            }

            @NotNull
            public FirSession getSession() {
                return this.$session;
            }
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void visitParent(@NotNull FirDeclaration $this$visitParent) {
        Pair<Object, ClassId> pair;
        Object it;
        Intrinsics.checkNotNullParameter($this$visitParent, "<this>");
        FirDeclaration firDeclaration = $this$visitParent;
        if (firDeclaration instanceof FirCallableDeclaration) {
            it = ((FirCallableDeclaration)$this$visitParent).getSymbol().getCallableId().getPackageName();
            boolean bl = false;
            ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.containingClassLookupTag((FirCallableDeclaration)$this$visitParent);
            pair = TuplesKt.to(it, coneClassLikeLookupTag != null ? coneClassLikeLookupTag.getClassId() : null);
        } else {
            if (!(firDeclaration instanceof FirClassLikeDeclaration)) return;
            it = ((FirClassLikeDeclaration)$this$visitParent).getSymbol().getClassId();
            boolean bl = false;
            pair = TuplesKt.to(((ClassId)it).getPackageFqName(), ((ClassId)it).getOuterClassId());
        }
        Pair<Object, ClassId> pair2 = pair;
        FqName parentPackageFqName = (FqName)pair2.component1();
        ClassId parentClassId = pair2.component2();
        if (parentClassId != null && !parentClassId.isLocal()) {
            FirClassLikeSymbol<?> firClassLikeSymbol = FirSymbolProviderKt.getSymbolProvider($this$visitParent.getModuleData().getSession()).getClassLikeSymbolByClassId(parentClassId);
            if (firClassLikeSymbol == null || (firClassLikeSymbol = (FirClassLikeDeclaration)firClassLikeSymbol.getFir()) == null) {
                throw new IllegalStateException(("Attempt to find parent (" + parentClassId + ") for probably-local declaration!").toString());
            }
            FirClassLikeSymbol<?> parentClassLike = firClassLikeSymbol;
            if (!(parentClassLike instanceof FirRegularClass) && !(parentClassLike instanceof FirTypeAlias)) throw new IllegalStateException(("Strange class-like declaration: " + UtilsKt.render((FirElement)((Object)parentClassLike))).toString());
            this.visit((FirDeclaration)((Object)parentClassLike));
            return;
        } else {
            if (parentClassId != null || parentPackageFqName.isRoot()) return;
            StringBuilder stringBuilder2 = this.getBuilder();
            String string2 = parentPackageFqName.asString();
            Intrinsics.checkNotNullExpressionValue(string2, "asString(...)");
            this.appendName(stringBuilder2, string2);
        }
    }

    @Override
    protected void visit(@NotNull FirDeclaration $this$visit) {
        Intrinsics.checkNotNullParameter($this$visit, "<this>");
        $this$visit.accept(this.visitor, null);
    }

    @Override
    @Nullable
    protected FirMemberDeclaration asTypeParameterContainer(@NotNull FirDeclaration $this$asTypeParameterContainer) {
        Intrinsics.checkNotNullParameter($this$asTypeParameterContainer, "<this>");
        return $this$asTypeParameterContainer instanceof FirMemberDeclaration ? (FirMemberDeclaration)$this$asTypeParameterContainer : null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected List<ConeKotlinType> getContextReceiverTypes(@NotNull FirFunction function2) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(function2, "function");
        Iterable $this$map$iv = function2 instanceof FirPropertyAccessor ? ((FirProperty)((FirPropertyAccessor)function2).getPropertySymbol().getFir()).getContextReceivers() : function2.getContextReceivers();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FirContextReceiver firContextReceiver = (FirContextReceiver)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(FirTypeUtilsKt.getConeType(it.getTypeRef()));
        }
        return (List)destination$iv$iv;
    }

    @Override
    @Nullable
    protected ConeKotlinType getExtensionReceiverParameterType(@NotNull FirFunction function2) {
        Intrinsics.checkNotNullParameter(function2, "function");
        Object object = function2.getReceiverParameter();
        if (object == null || (object = ((FirReceiverParameter)object).getTypeRef()) == null || (object = FirTypeUtilsKt.getConeType((FirTypeRef)object)) == null) {
            Object object2 = function2 instanceof FirPropertyAccessor ? (FirPropertyAccessor)function2 : null;
            object = object2 != null && (object2 = ((FirPropertyAccessor)object2).getPropertySymbol()) != null && (object2 = (FirProperty)((FirBasedSymbol)object2).getFir()) != null && (object2 = ((FirProperty)object2).getReceiverParameter()) != null && (object2 = ((FirReceiverParameter)object2).getTypeRef()) != null ? FirTypeUtilsKt.getConeType((FirTypeRef)object2) : null;
        }
        return object;
    }

    @Override
    @NotNull
    protected List<FirValueParameter> getValueParameters(@NotNull FirFunction function2) {
        Intrinsics.checkNotNullParameter(function2, "function");
        return function2.getValueParameters();
    }

    @Override
    @NotNull
    protected ConeKotlinType getReturnType(@NotNull FirFunction function2) {
        Intrinsics.checkNotNullParameter(function2, "function");
        return FirTypeUtilsKt.getConeType(function2.getReturnTypeRef());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected Iterable<IndexedValue<ConeTypeParameterLookupTag>> getTypeParametersWithIndices(@NotNull FirFunction function2, @NotNull FirDeclaration container2) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(function2, "function");
        Intrinsics.checkNotNullParameter(container2, "container");
        FirTypeParametersOwner firTypeParametersOwner = container2 instanceof FirTypeParametersOwner ? (FirTypeParametersOwner)((Object)container2) : null;
        List<FirTypeParameter> list2 = firTypeParametersOwner != null ? firTypeParametersOwner.getTypeParameters() : null;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        Iterable $this$map$iv = list2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FirTypeParameter firTypeParameter = (FirTypeParameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getSymbol().toLookupTag());
        }
        return CollectionsKt.withIndex((List)destination$iv$iv);
    }

    @Override
    protected boolean isUnit(@NotNull ConeKotlinType type2) {
        Intrinsics.checkNotNullParameter(type2, "type");
        return ConeBuiltinTypeUtilsKt.isUnit(type2);
    }

    @Override
    @NotNull
    protected FirMemberDeclaration getEffectiveParent(@NotNull ConeTypeParameterLookupTag typeParameter) {
        Intrinsics.checkNotNullParameter(typeParameter, "typeParameter");
        Object obj = typeParameter.getSymbol().getContainingDeclarationSymbol().getFir();
        Intrinsics.checkNotNull(obj, "null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration");
        return (FirMemberDeclaration)obj;
    }

    @Override
    protected int getContainerIndex(@NotNull FirMemberDeclaration parent2) {
        int n;
        block2: {
            Intrinsics.checkNotNullParameter(parent2, "parent");
            Object object = parent2 instanceof FirCallableDeclaration ? (FirCallableDeclaration)parent2 : null;
            CallableId callableId = object != null && (object = ((FirCallableDeclaration)object).getSymbol()) != null ? ((FirCallableSymbol)object).getCallableId() : null;
            List $this$indexOfFirst$iv = this.getTypeParameterContainers();
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            for (Object item$iv : $this$indexOfFirst$iv) {
                FirMemberDeclaration it = (FirMemberDeclaration)item$iv;
                boolean bl = false;
                if (Intrinsics.areEqual(it, parent2) || it instanceof FirCallableDeclaration && Intrinsics.areEqual(((FirCallableDeclaration)it).getSymbol().getCallableId(), callableId)) {
                    n = index$iv;
                    break block2;
                }
                ++index$iv;
            }
            n = -1;
        }
        return n;
    }

    @Override
    @NotNull
    protected String renderDeclaration(@NotNull FirDeclaration declaration2) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        return UtilsKt.render(declaration2);
    }

    @Override
    @NotNull
    protected String getTypeParameterName(@NotNull ConeTypeParameterLookupTag typeParameter) {
        Intrinsics.checkNotNullParameter(typeParameter, "typeParameter");
        String string2 = typeParameter.getName().asString();
        Intrinsics.checkNotNullExpressionValue(string2, "asString(...)");
        return string2;
    }

    @Override
    protected boolean isVararg(@NotNull FirValueParameter valueParameter2) {
        Intrinsics.checkNotNullParameter(valueParameter2, "valueParameter");
        return valueParameter2.isVararg();
    }

    @Override
    @NotNull
    protected ConeKotlinType getValueParameterType(@NotNull FirValueParameter valueParameter2) {
        Intrinsics.checkNotNullParameter(valueParameter2, "valueParameter");
        return FirTypeUtilsKt.getConeType(valueParameter2.getReturnTypeRef());
    }

    @Override
    protected int getIndexOfTypeParameter(@NotNull ConeTypeParameterLookupTag typeParameter, @NotNull FirMemberDeclaration container2) {
        Intrinsics.checkNotNullParameter(typeParameter, "typeParameter");
        Intrinsics.checkNotNullParameter(container2, "container");
        return container2.getTypeParameters().indexOf(typeParameter.getSymbol().getFir());
    }

    @Override
    protected void mangleType(@NotNull StringBuilder tBuilder, @NotNull ConeKotlinType type2, @NotNull FirSession declarationSiteSession) {
        Intrinsics.checkNotNullParameter(tBuilder, "tBuilder");
        Intrinsics.checkNotNullParameter(type2, "type");
        Intrinsics.checkNotNullParameter(declarationSiteSession, "declarationSiteSession");
        ConeKotlinType coneKotlinType = type2;
        if (coneKotlinType instanceof ConeLookupTagBasedType) {
            FirClassifierSymbol<?> symbol2 = LookupTagUtilsKt.toSymbol(((ConeLookupTagBasedType)type2).getLookupTag(), declarationSiteSession);
            if (symbol2 instanceof FirTypeAliasSymbol) {
                this.mangleType(tBuilder, TypeExpansionUtilsKt.fullyExpandedType((ConeSimpleKotlinType)type2, declarationSiteSession), declarationSiteSession);
                return;
            }
            if (symbol2 instanceof FirClassSymbol) {
                FirMangleComputer $this$mangleType_u24lambda_u245 = this.copy(MangleMode.FQNAME);
                boolean bl = false;
                $this$mangleType_u24lambda_u245.visit((FirDeclaration)symbol2.getFir());
            } else if (symbol2 instanceof FirTypeParameterSymbol) {
                this.mangleTypeParameterReference(tBuilder, (TypeParameterMarker)((FirTypeParameterSymbol)symbol2).toLookupTag());
            } else if (symbol2 == null) {
                ConeClassifierLookupTag $this$mangleType_u24lambda_u245 = ((ConeLookupTagBasedType)type2).getLookupTag();
                ConeClassLikeLookupTag coneClassLikeLookupTag = $this$mangleType_u24lambda_u245 instanceof ConeClassLikeLookupTag ? (ConeClassLikeLookupTag)$this$mangleType_u24lambda_u245 : null;
                if (coneClassLikeLookupTag != null) {
                    ConeClassLikeLookupTag it = coneClassLikeLookupTag;
                    boolean bl2 = false;
                    tBuilder.append(it.getClassId().asFqNameString());
                }
            }
            this.mangleTypeArguments(tBuilder, (KotlinTypeMarker)type2, declarationSiteSession);
            if (ConeTypeUtilsKt.isMarkedNullable(type2)) {
                this.appendSignature(tBuilder, '?');
            }
            if (CompilerConeAttributesKt.getHasEnhancedNullability(type2)) {
                this.appendSignature(tBuilder, "{EnhancedNullability}");
            }
        } else if (coneKotlinType instanceof ConeRawType) {
            this.mangleType(tBuilder, ((ConeRawType)type2).getLowerBound(), declarationSiteSession);
        } else if (coneKotlinType instanceof ConeDynamicType) {
            this.appendSignature(tBuilder, "<dynamic>");
        } else if (coneKotlinType instanceof ConeFlexibleType) {
            ConeInferenceContext $this$mangleType_u24lambda_u247 = TypeComponentsKt.getTypeContext(declarationSiteSession);
            boolean bl = false;
            ConeSimpleKotlinType upper = ((ConeFlexibleType)type2).getUpperBound();
            if (upper instanceof ConeClassLikeType) {
                ConeSimpleKotlinType bl2 = ((ConeFlexibleType)type2).getLowerBound();
                ConeClassLikeType coneClassLikeType = bl2 instanceof ConeClassLikeType ? (ConeClassLikeType)bl2 : null;
                if (coneClassLikeType == null) {
                    throw new IllegalStateException(("Expecting class-like type, got " + ((ConeFlexibleType)type2).getLowerBound()).toString());
                }
                ConeClassLikeType lower2 = coneClassLikeType;
                SimpleTypeMarker intermediate = Intrinsics.areEqual(lower2.getLookupTag(), ((ConeClassLikeType)upper).getLookupTag()) ? $this$mangleType_u24lambda_u247.replaceArguments((SimpleTypeMarker)lower2, $this$mangleType_u24lambda_u247.getArguments(upper)) : (SimpleTypeMarker)lower2;
                KotlinTypeMarker mixed = ConeTypeUtilsKt.isNullable(upper) ? $this$mangleType_u24lambda_u247.makeNullable(intermediate) : $this$mangleType_u24lambda_u247.makeDefinitelyNotNullOrNotNull(intermediate);
                Intrinsics.checkNotNull(mixed, "null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
                this.mangleType(tBuilder, (ConeKotlinType)mixed, declarationSiteSession);
            } else {
                this.mangleType(tBuilder, upper, declarationSiteSession);
            }
        } else if (coneKotlinType instanceof ConeDefinitelyNotNullType) {
            this.mangleType(tBuilder, ((ConeDefinitelyNotNullType)type2).getOriginal(), declarationSiteSession);
        } else if (coneKotlinType instanceof ConeCapturedType) {
            ConeKotlinType coneKotlinType2 = ((ConeCapturedType)type2).getLowerType();
            if (coneKotlinType2 == null) {
                List<ConeKotlinType> list2 = ((ConeCapturedType)type2).getConstructor().getSupertypes();
                Intrinsics.checkNotNull(list2);
                coneKotlinType2 = CollectionsKt.first(list2);
            }
            this.mangleType(tBuilder, coneKotlinType2, declarationSiteSession);
        } else if (coneKotlinType instanceof ConeIntersectionType) {
            this.mangleType(tBuilder, (ConeKotlinType)CollectionsKt.first((Iterable)((ConeIntersectionType)type2).getIntersectedTypes()), declarationSiteSession);
        } else {
            throw new IllegalStateException(("Unexpected type " + type2).toString());
        }
    }

    public static final /* synthetic */ void access$mangleTypeParameter(FirMangleComputer $this, StringBuilder tpBuilder, ConeTypeParameterLookupTag param, int index2, FirSession declarationSiteSession) {
        $this.mangleTypeParameter(tpBuilder, (TypeParameterMarker)param, index2, declarationSiteSession);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0094\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u00042\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\u00042\u0006\u0010$\u001a\u00020%H\u0016\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/fir/backend/FirMangleComputer$Visitor;", "Lorg/jetbrains/kotlin/fir/visitors/FirVisitorVoid;", "(Lorg/jetbrains/kotlin/fir/backend/FirMangleComputer;)V", "visitAnonymousObject", "", "anonymousObject", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousObject;", "visitConstructor", "constructor", "Lorg/jetbrains/kotlin/fir/declarations/FirConstructor;", "visitElement", "", "element", "Lorg/jetbrains/kotlin/fir/FirElement;", "visitEnumEntry", "enumEntry", "Lorg/jetbrains/kotlin/fir/declarations/FirEnumEntry;", "visitField", "field", "Lorg/jetbrains/kotlin/fir/declarations/FirField;", "visitProperty", "property", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "visitPropertyAccessor", "propertyAccessor", "Lorg/jetbrains/kotlin/fir/declarations/FirPropertyAccessor;", "visitRegularClass", "regularClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "visitSimpleFunction", "simpleFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "visitTypeAlias", "typeAlias", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;", "visitVariable", "variable", "Lorg/jetbrains/kotlin/fir/declarations/FirVariable;", "fir2ir"})
    @SourceDebugExtension(value={"SMAP\nFirMangleComputer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirMangleComputer.kt\norg/jetbrains/kotlin/fir/backend/FirMangleComputer$Visitor\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,291:1\n39#2:292\n39#2:293\n39#2:294\n*S KotlinDebug\n*F\n+ 1 FirMangleComputer.kt\norg/jetbrains/kotlin/fir/backend/FirMangleComputer$Visitor\n*L\n222#1:292\n259#1:293\n283#1:294\n*E\n"})
    protected class Visitor
    extends FirVisitorVoid {
        @NotNull
        public Void visitElement(@NotNull FirElement element2) {
            Intrinsics.checkNotNullParameter(element2, "element");
            throw new IllegalStateException(("unexpected element " + UtilsKt.render(element2)).toString());
        }

        @Override
        public void visitRegularClass(@NotNull FirRegularClass regularClass) {
            Intrinsics.checkNotNullParameter(regularClass, "regularClass");
            FirMangleComputer.this.getTypeParameterContainers().add(regularClass);
            FirDeclaration firDeclaration = regularClass;
            String string2 = regularClass.getName().asString();
            Intrinsics.checkNotNullExpressionValue(string2, "asString(...)");
            FirMangleComputer.this.mangleSimpleDeclaration(firDeclaration, string2);
        }

        @Override
        public void visitAnonymousObject(@NotNull FirAnonymousObject anonymousObject) {
            Intrinsics.checkNotNullParameter(anonymousObject, "anonymousObject");
            FirMangleComputer.this.mangleSimpleDeclaration(anonymousObject, "<anonymous>");
        }

        @Override
        public void visitVariable(@NotNull FirVariable variable2) {
            FirPureAbstractElement firPureAbstractElement;
            Intrinsics.checkNotNullParameter(variable2, "variable");
            FirMangleComputer.this.getTypeParameterContainers().add(variable2);
            FirMangleComputer.this.visitParent(variable2);
            FirMemberDeclaration $this$isStatic$iv = variable2;
            boolean $i$f$isStatic = false;
            boolean isStaticProperty = $this$isStatic$iv.getStatus().isStatic();
            if (isStaticProperty) {
                FirMangleComputer.this.appendSignature(FirMangleComputer.this.getBuilder(), "#static");
            }
            if ((firPureAbstractElement = variable2.getReceiverParameter()) != null && (firPureAbstractElement = firPureAbstractElement.getTypeRef()) != null) {
                FirPureAbstractElement firPureAbstractElement2 = firPureAbstractElement;
                FirMangleComputer firMangleComputer = FirMangleComputer.this;
                FirPureAbstractElement it = firPureAbstractElement2;
                boolean bl = false;
                firMangleComputer.appendSignature(firMangleComputer.getBuilder(), '@');
                firMangleComputer.mangleType(firMangleComputer.getBuilder(), FirTypeUtilsKt.getConeType((FirTypeRef)it), variable2.getModuleData().getSession());
            }
            MangleUtilsKt.collectForMangler(CollectionsKt.toList(CollectionsKt.withIndex((Iterable)variable2.getTypeParameters())), FirMangleComputer.this.getBuilder(), MangleConstant.TYPE_PARAMETERS, (Function2)new Function2<StringBuilder, IndexedValue<? extends FirTypeParameterRef>, Unit>(FirMangleComputer.this, variable2){
                final /* synthetic */ FirMangleComputer this$0;
                final /* synthetic */ FirVariable $variable;
                {
                    this.this$0 = $receiver;
                    this.$variable = $variable;
                    super(2);
                }

                public final void invoke(@NotNull StringBuilder $this$collectForMangler, @NotNull IndexedValue<? extends FirTypeParameterRef> indexedValue) {
                    Intrinsics.checkNotNullParameter($this$collectForMangler, "$this$collectForMangler");
                    Intrinsics.checkNotNullParameter(indexedValue, "<name for destructuring parameter 0>");
                    int index2 = indexedValue.component1();
                    FirTypeParameterRef typeParameter = indexedValue.component2();
                    FirMangleComputer.access$mangleTypeParameter(this.this$0, $this$collectForMangler, typeParameter.getSymbol().toLookupTag(), index2, this.$variable.getModuleData().getSession());
                }
            });
            FirMangleComputer.this.getBuilder().append(variable2.getName().asString());
        }

        @Override
        public void visitProperty(@NotNull FirProperty property) {
            Intrinsics.checkNotNullParameter(property, "property");
            this.visitVariable(property);
        }

        @Override
        public void visitField(@NotNull FirField field2) {
            Intrinsics.checkNotNullParameter(field2, "field");
            FirDeclaration firDeclaration = field2;
            String string2 = field2.getName().asString();
            Intrinsics.checkNotNullExpressionValue(string2, "asString(...)");
            FirMangleComputer.this.mangleSimpleDeclaration(firDeclaration, string2);
        }

        @Override
        public void visitEnumEntry(@NotNull FirEnumEntry enumEntry) {
            Intrinsics.checkNotNullParameter(enumEntry, "enumEntry");
            FirDeclaration firDeclaration = enumEntry;
            String string2 = enumEntry.getName().asString();
            Intrinsics.checkNotNullExpressionValue(string2, "asString(...)");
            FirMangleComputer.this.mangleSimpleDeclaration(firDeclaration, string2);
        }

        @Override
        public void visitTypeAlias(@NotNull FirTypeAlias typeAlias) {
            Intrinsics.checkNotNullParameter(typeAlias, "typeAlias");
            FirDeclaration firDeclaration = typeAlias;
            String string2 = typeAlias.getName().asString();
            Intrinsics.checkNotNullExpressionValue(string2, "asString(...)");
            FirMangleComputer.this.mangleSimpleDeclaration(firDeclaration, string2);
        }

        @Override
        public void visitSimpleFunction(@NotNull FirSimpleFunction simpleFunction) {
            Intrinsics.checkNotNullParameter(simpleFunction, "simpleFunction");
            FirMemberDeclaration $this$isStatic$iv = simpleFunction;
            boolean $i$f$isStatic = false;
            FirMangleComputer.this.mangleFunction(simpleFunction, simpleFunction.getName(), false, $this$isStatic$iv.getStatus().isStatic(), simpleFunction, simpleFunction.getModuleData().getSession());
        }

        @Override
        public void visitConstructor(@NotNull FirConstructor constructor2) {
            Intrinsics.checkNotNullParameter(constructor2, "constructor");
            FirMangleComputer.this.mangleFunction(constructor2, SpecialNames.INIT, true, false, constructor2, constructor2.getModuleData().getSession());
        }

        @Override
        public void visitPropertyAccessor(@NotNull FirPropertyAccessor propertyAccessor) {
            Intrinsics.checkNotNullParameter(propertyAccessor, "propertyAccessor");
            if (propertyAccessor instanceof FirSyntheticPropertyAccessor) {
                this.visitSimpleFunction(((FirSyntheticPropertyAccessor)propertyAccessor).getDelegate());
            } else {
                FirMemberDeclaration $this$isStatic$iv = propertyAccessor;
                boolean $i$f$isStatic = false;
                FirMangleComputer.this.mangleFunction(propertyAccessor, FirManglerUtilKt.getIrName(propertyAccessor), false, $this$isStatic$iv.getStatus().isStatic(), propertyAccessor.getPropertySymbol().getFir(), propertyAccessor.getModuleData().getSession());
            }
        }
    }
}

