/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.backend;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.constant.ConstantValue;
import org.jetbrains.kotlin.constant.EvaluatedConstTracker;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.backend.ConversionUtilsKt;
import org.jetbrains.kotlin.fir.backend.Fir2IrComponents;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirVarargArgumentsExpression;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.serialization.constant.ConstValueProvider;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\r\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/fir/backend/ConstValueProviderImpl;", "Lorg/jetbrains/kotlin/fir/serialization/constant/ConstValueProvider;", "components", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrComponents;", "(Lorg/jetbrains/kotlin/fir/backend/Fir2IrComponents;)V", "evaluatedConstTracker", "Lorg/jetbrains/kotlin/constant/EvaluatedConstTracker;", "getEvaluatedConstTracker", "()Lorg/jetbrains/kotlin/constant/EvaluatedConstTracker;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "findConstantValueFor", "Lorg/jetbrains/kotlin/constant/ConstantValue;", "firExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "fir2ir"})
public final class ConstValueProviderImpl
extends ConstValueProvider {
    @NotNull
    private final FirSession session;
    @NotNull
    private final EvaluatedConstTracker evaluatedConstTracker;

    public ConstValueProviderImpl(@NotNull Fir2IrComponents components2) {
        Intrinsics.checkNotNullParameter(components2, "components");
        this.session = components2.getSession();
        this.evaluatedConstTracker = components2.getConfiguration().getEvaluatedConstTracker();
    }

    @Override
    @NotNull
    public FirSession getSession() {
        return this.session;
    }

    @Override
    @NotNull
    public EvaluatedConstTracker getEvaluatedConstTracker() {
        return this.evaluatedConstTracker;
    }

    @Override
    @Nullable
    public ConstantValue<?> findConstantValueFor(@Nullable FirExpression firExpression2) {
        ConstantValue<?> constantValue;
        FirFile firFile = this.getProcessingFirFile();
        if (firExpression2 == null || firFile == null) {
            return null;
        }
        if (firExpression2 instanceof FirVarargArgumentsExpression) {
            return null;
        }
        String string2 = UtilsKt.getPackageFqName(firFile).child(Name.identifier(firFile.getName())).asString();
        Intrinsics.checkNotNullExpressionValue(string2, "asString(...)");
        String fileName2 = string2;
        if (firExpression2 instanceof FirQualifiedAccessExpression) {
            int n;
            FirReference calleeReference = ((FirQualifiedAccessExpression)firExpression2).getCalleeReference();
            Object object = calleeReference.getSource();
            if (object != null && (object = ConversionUtilsKt.startOffsetSkippingComments((AbstractKtSourceElement)object)) != null) {
                n = (Integer)object;
            } else {
                KtSourceElement ktSourceElement = calleeReference.getSource();
                n = ktSourceElement != null ? ktSourceElement.getStartOffset() : -1;
            }
            int start = n;
            KtSourceElement ktSourceElement = ((FirQualifiedAccessExpression)firExpression2).getSource();
            if (ktSourceElement == null) {
                return null;
            }
            int end = ktSourceElement.getEndOffset();
            constantValue = this.getEvaluatedConstTracker().load(start, end, fileName2);
        } else {
            KtSourceElement ktSourceElement = firExpression2.getSource();
            if (ktSourceElement == null) {
                return null;
            }
            int start = ktSourceElement.getStartOffset();
            KtSourceElement ktSourceElement2 = firExpression2.getSource();
            if (ktSourceElement2 == null) {
                return null;
            }
            int end = ktSourceElement2.getEndOffset();
            constantValue = this.getEvaluatedConstTracker().load(start, end, fileName2);
        }
        return constantValue;
    }
}

