/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis;

import kotlin.Metadata;
import kotlin.annotation.AnnotationRetention;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0012\u0010\u0007\u001a\u00020\b*\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006\u001a\f\u0010\u0007\u001a\u0004\u0018\u00010\b*\u00020\u0001\u001a\u0012\u0010\u0007\u001a\u00020\b*\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0014\u0010\n\u001a\u0004\u0018\u00010\u0001*\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0016\u0010\n\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\f"}, d2={"getAnnotationByClassId", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "getRetention", "Lkotlin/annotation/AnnotationRetention;", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "getRetentionAnnotation", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "semantics"})
@SourceDebugExtension(value={"SMAP\nFirRetentionAnnotationHelpers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirRetentionAnnotationHelpers.kt\norg/jetbrains/kotlin/fir/analysis/FirRetentionAnnotationHelpersKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,46:1\n288#2,2:47\n288#2,2:49\n*S KotlinDebug\n*F\n+ 1 FirRetentionAnnotationHelpers.kt\norg/jetbrains/kotlin/fir/analysis/FirRetentionAnnotationHelpersKt\n*L\n33#1:47,2\n45#1:49,2\n*E\n"})
public final class FirRetentionAnnotationHelpersKt {
    @NotNull
    public static final AnnotationRetention getRetention(@NotNull FirRegularClass $this$getRetention, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter($this$getRetention, "<this>");
        Intrinsics.checkNotNullParameter(session2, "session");
        Object object = FirRetentionAnnotationHelpersKt.getRetentionAnnotation($this$getRetention, session2);
        if (object == null || (object = FirRetentionAnnotationHelpersKt.getRetention(object)) == null) {
            object = AnnotationRetention.RUNTIME;
        }
        return object;
    }

    @NotNull
    public static final AnnotationRetention getRetention(@NotNull FirRegularClassSymbol $this$getRetention, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter($this$getRetention, "<this>");
        Intrinsics.checkNotNullParameter(session2, "session");
        Object object = FirRetentionAnnotationHelpersKt.getRetentionAnnotation($this$getRetention, session2);
        if (object == null || (object = FirRetentionAnnotationHelpersKt.getRetention(object)) == null) {
            object = AnnotationRetention.RUNTIME;
        }
        return object;
    }

    @Nullable
    public static final AnnotationRetention getRetention(@NotNull FirAnnotation $this$getRetention) {
        Object v1;
        block3: {
            Intrinsics.checkNotNullParameter($this$getRetention, "<this>");
            FirExpression firExpression2 = FirAnnotationUtilsKt.findArgumentByName($this$getRetention, StandardClassIds.Annotations.ParameterNames.INSTANCE.getRetentionValue());
            FirQualifiedAccessExpression propertyAccess = firExpression2 instanceof FirQualifiedAccessExpression ? (FirQualifiedAccessExpression)firExpression2 : null;
            Object object = propertyAccess;
            if (object == null || (object = ((FirQualifiedAccessExpression)object).getCalleeReference()) == null || (object = FirReferenceUtilsKt.toResolvedEnumEntrySymbol$default((FirReference)object, false, 1, null)) == null || (object = ((FirVariableSymbol)object).getCallableId()) == null) {
                return null;
            }
            Object callableId = object;
            if (!Intrinsics.areEqual(((CallableId)callableId).getClassId(), StandardClassIds.INSTANCE.getAnnotationRetention())) {
                return null;
            }
            Iterable $this$firstOrNull$iv = EntriesMappings.entries$0;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                AnnotationRetention it = (AnnotationRetention)((Object)element$iv);
                boolean bl = false;
                if (!Intrinsics.areEqual(it.name(), ((CallableId)callableId).getCallableName().asString())) continue;
                v1 = element$iv;
                break block3;
            }
            v1 = null;
        }
        return v1;
    }

    @Nullable
    public static final FirAnnotation getRetentionAnnotation(@NotNull FirDeclaration $this$getRetentionAnnotation, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter($this$getRetentionAnnotation, "<this>");
        Intrinsics.checkNotNullParameter(session2, "session");
        return FirAnnotationUtilsKt.getAnnotationByClassId($this$getRetentionAnnotation, StandardClassIds.Annotations.INSTANCE.getRetention(), session2);
    }

    private static final FirAnnotation getRetentionAnnotation(FirRegularClassSymbol $this$getRetentionAnnotation, FirSession session2) {
        return FirRetentionAnnotationHelpersKt.getAnnotationByClassId($this$getRetentionAnnotation, StandardClassIds.Annotations.INSTANCE.getRetention(), session2);
    }

    private static final FirAnnotation getAnnotationByClassId(FirRegularClassSymbol $this$getAnnotationByClassId, ClassId classId, FirSession session2) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = $this$getAnnotationByClassId.getResolvedAnnotationsWithArguments();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                FirAnnotation it = (FirAnnotation)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(FirAnnotationUtilsKt.toAnnotationClassId(it, session2), classId)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<AnnotationRetention> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])AnnotationRetention.values());
        }
    }
}

