/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.impl.source.PsiFileImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.UtilsKt;
import org.jetbrains.kotlin.backend.common.lower.IrBuildingTransformer;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.jvm.InlineClassAbiKt;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredDeclarationOrigin;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrBuilder;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrBuilderKt;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrTypeUtilsKt;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrUtilsKt;
import org.jetbrains.kotlin.backend.jvm.lower.TypeOperatorLowering;
import org.jetbrains.kotlin.backend.jvm.mapping.IrTypeMapper;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrElementBase;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBodyBuilder;
import org.jetbrains.kotlin.ir.builders.IrBlockBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.IrStatementsBuilder;
import org.jetbrains.kotlin.ir.builders.PrimitivesKt;
import org.jetbrains.kotlin.ir.builders.Scope;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstantArray;
import org.jetbrains.kotlin.ir.expressions.IrConstantObject;
import org.jetbrains.kotlin.ir.expressions.IrConstantPrimitive;
import org.jetbrains.kotlin.ir.expressions.IrConstantValue;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStatementContainer;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperator;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrVarargElement;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.expressions.impl.IrBlockImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrBranchImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrCompositeImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrRawFunctionReferenceImpl;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.ir.types.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformer;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.org.objectweb.asm.Handle;
import org.jetbrains.org.objectweb.asm.commons.Method;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00fa\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002:\u0003stuB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0011\u001a\u00020\nH\u0002J\u001e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0002J\b\u0010\u0019\u001a\u00020\nH\u0002J,\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001c2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0017H\u0002J\u0018\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#H\u0002J\b\u0010%\u001a\u00020\u0013H\u0002J\u0010\u0010&\u001a\u00020\u00132\u0006\u0010'\u001a\u00020(H\u0016J\u0018\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020*2\u0006\u0010,\u001a\u00020#H\u0002J\u0018\u0010-\u001a\u00020*2\u0006\u0010+\u001a\u00020*2\u0006\u0010,\u001a\u00020#H\u0002J\u0010\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u0018H\u0002J\u0010\u00101\u001a\u0002022\u0006\u00103\u001a\u000202H\u0002J\u0012\u00104\u001a\u0004\u0018\u0001052\u0006\u00106\u001a\u000207H\u0002J\u0010\u00108\u001a\u00020*2\u0006\u00109\u001a\u000202H\u0016J\u0010\u0010:\u001a\u00020;2\u0006\u00106\u001a\u00020\u0015H\u0016J\u0010\u0010<\u001a\u00020*2\u0006\u00109\u001a\u00020=H\u0016J \u0010>\u001a\u0002022\u0006\u0010?\u001a\u00020@2\u0006\u0010\u001e\u001a\u00020\u001c2\u0006\u0010A\u001a\u00020BH\u0002J\u0016\u0010C\u001a\u0004\u0018\u00010D*\u00020E2\u0006\u0010F\u001a\u00020=H\u0002JB\u0010G\u001a\u000202*\u00020H2\u0006\u0010I\u001a\u00020\u00072\u0006\u0010J\u001a\u00020K2\u0006\u0010L\u001a\u00020K2\u0006\u0010M\u001a\u00020!2\f\u0010N\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010O\u001a\u000202H\u0002J\u0018\u0010P\u001a\u000e\u0012\u0004\u0012\u00020R\u0012\u0004\u0012\u00020R0Q*\u00020SH\u0002J\u001c\u0010T\u001a\u00020**\u00020H2\u0006\u0010U\u001a\u00020V2\u0006\u00100\u001a\u00020\u0018H\u0002J\u001c\u0010W\u001a\u00020**\u00020H2\u0006\u0010U\u001a\u00020V2\u0006\u0010X\u001a\u00020/H\u0002J\f\u0010Y\u001a\u00020#*\u00020#H\u0002J%\u0010Z\u001a\u00020**\u00020H2\u0012\u0010[\u001a\n\u0012\u0006\b\u0001\u0012\u00020*0\\\"\u00020*H\u0002\u00a2\u0006\u0002\u0010]J\u001c\u0010^\u001a\u000202*\u00020H2\u0006\u0010_\u001a\u00020*2\u0006\u0010`\u001a\u00020*H\u0002J\f\u0010a\u001a\u00020!*\u00020*H\u0002J\f\u0010b\u001a\u00020!*\u00020cH\u0002J\f\u0010d\u001a\u00020!*\u00020eH\u0002J*\u0010f\u001a\u000202*\u00020H2\u0006\u0010O\u001a\u0002022\u0006\u0010g\u001a\u00020\r2\f\u0010h\u001a\b\u0012\u0004\u0012\u00020*0\u0017H\u0002J\u0014\u0010i\u001a\u000202*\u00020H2\u0006\u0010j\u001a\u00020\rH\u0002J\u0014\u0010k\u001a\u000202*\u00020H2\u0006\u0010l\u001a\u00020KH\u0002J\f\u0010m\u001a\u00020**\u00020*H\u0002J\u0011\u0010n\u001a\u00070D\u00a2\u0006\u0002\bo*\u00020DH\u0002J\u001c\u0010p\u001a\u00020!*\u0002052\u0006\u0010q\u001a\u00020R2\u0006\u0010r\u001a\u00020RH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006v"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/TypeOperatorLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "Lorg/jetbrains/kotlin/backend/common/lower/IrBuildingTransformer;", "backendContext", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "checkExpressionValueIsNotNull", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "classContextStack", "Lkotlin/collections/ArrayDeque;", "Lorg/jetbrains/kotlin/backend/jvm/lower/TypeOperatorLowering$ClassContext;", "equalsAny", "jdkAltMetafactoryHandle", "Lorg/jetbrains/org/objectweb/asm/Handle;", "jdkMetafactoryHandle", "jvmIndyLambdaMetafactoryIntrinsic", "throwTypeCastException", "enterClass", "generateDeserializeLambdaMethod", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "serializableMethodRefInfos", "", "Lorg/jetbrains/kotlin/backend/jvm/lower/TypeOperatorLowering$SerializableMethodRefInfo;", "getClassContext", "getOverriddenMethodsRequiringBridges", "", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "instanceMethod", "samMethod", "extraOverriddenMethods", "isCompatibleArrayType", "", "actualType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "expectedType", "leaveClass", "lower", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "lowerCast", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "argument", "type", "lowerInstanceOf", "mapDeserializedLambda", "Lorg/jetbrains/kotlin/backend/jvm/lower/TypeOperatorLowering$DeserializedLambdaInfo;", "info", "rewriteIndyLambdaMetafactoryCall", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "call", "sourceViewFor", "", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "visitCall", "expression", "visitClass", "Lorg/jetbrains/kotlin/ir/IrStatement;", "visitTypeOperator", "Lorg/jetbrains/kotlin/ir/expressions/IrTypeOperatorCall;", "wrapClosureInDynamicCall", "erasedSamType", "Lorg/jetbrains/kotlin/ir/types/IrSimpleType;", "targetRef", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "computeNotNullAssertionText", "", "Lorg/jetbrains/kotlin/ir/builders/IrBuilderWithScope;", "typeOperatorCall", "createLambdaMetafactoryCall", "Lorg/jetbrains/kotlin/backend/jvm/ir/JvmIrBuilder;", "samMethodSymbol", "implFunSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "instanceMethodSymbol", "shouldBeSerializable", "requiredBridges", "dynamicCall", "extents", "Lkotlin/Pair;", "", "Lorg/jetbrains/kotlin/ir/IrElement;", "generateCreateDeserializedMethodRef", "lambdaParameter", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "generateSerializedLambdaEquals", "deserializedLambdaInfo", "getArrayElementLowerType", "irAndAnd", "args", "", "(Lorg/jetbrains/kotlin/backend/jvm/ir/JvmIrBuilder;[Lorg/jetbrains/kotlin/ir/expressions/IrExpression;)Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "irObjectEquals", "receiver", "arg", "isDefinitelyNotNull", "isDefinitelyNotNullVal", "Lorg/jetbrains/kotlin/ir/declarations/IrValueDeclaration;", "isDelegated", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "jvmInvokeDynamic", "bootstrapMethodHandle", "bootstrapMethodArguments", "jvmMethodHandle", "handle", "jvmOriginalMethodType", "methodSymbol", "transformVoid", "trimForRuntimeAssertion", "Lorg/jetbrains/annotations/NotNull;", "validSourcePosition", "startOffset", "endOffset", "ClassContext", "DeserializedLambdaInfo", "SerializableMethodRefInfo", "backend.jvm.lower"})
@SourceDebugExtension(value={"SMAP\nTypeOperatorLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypeOperatorLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/TypeOperatorLowering\n+ 2 ExpressionHelpers.kt\norg/jetbrains/kotlin/ir/builders/ExpressionHelpersKt\n+ 3 IrBuilder.kt\norg/jetbrains/kotlin/ir/builders/IrBlockBuilder\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 declarationBuilders.kt\norg/jetbrains/kotlin/ir/builders/declarations/DeclarationBuildersKt\n+ 6 IrBuilder.kt\norg/jetbrains/kotlin/ir/builders/IrBlockBodyBuilder\n+ 7 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 8 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,825:1\n19#2,26:826\n19#2,17:852\n388#2,13:869\n36#2,9:884\n416#2,10:904\n402#2,13:936\n19#2,26:951\n19#2,17:977\n402#2,13:994\n36#2,9:1009\n98#3,2:882\n98#3,2:949\n98#3,2:1007\n372#4,7:893\n236#5,4:900\n236#5,4:932\n72#6:914\n73#6:923\n1549#7:915\n1620#7,2:916\n1549#7:918\n1620#7,3:919\n1622#7:922\n1549#7:924\n1620#7,3:925\n1549#7:928\n1620#7,3:929\n1#8:1018\n*S KotlinDebug\n*F\n+ 1 TypeOperatorLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/TypeOperatorLowering\n*L\n72#1:826,26\n97#1:852,17\n104#1:869,13\n97#1:884,9\n326#1:904,10\n692#1:936,13\n713#1:951,26\n741#1:977,17\n742#1:994,13\n741#1:1009,9\n104#1:882,2\n692#1:949,2\n742#1:1007,2\n313#1:893,7\n317#1:900,4\n613#1:932,4\n326#1:914\n326#1:923\n334#1:915\n334#1:916,2\n339#1:918\n339#1:919,3\n334#1:922\n490#1:924\n490#1:925,3\n551#1:928\n551#1:929,3\n*E\n"})
final class TypeOperatorLowering
extends IrBuildingTransformer
implements FileLoweringPass {
    @NotNull
    private final JvmBackendContext backendContext;
    @NotNull
    private final IrSimpleFunctionSymbol jvmIndyLambdaMetafactoryIntrinsic;
    @NotNull
    private final Handle jdkMetafactoryHandle;
    @NotNull
    private final Handle jdkAltMetafactoryHandle;
    @NotNull
    private final ArrayDeque<ClassContext> classContextStack;
    @NotNull
    private final IrSimpleFunctionSymbol equalsAny;
    @NotNull
    private final IrSimpleFunctionSymbol throwTypeCastException;
    @NotNull
    private final IrSimpleFunctionSymbol checkExpressionValueIsNotNull;

    public TypeOperatorLowering(@NotNull JvmBackendContext backendContext) {
        Intrinsics.checkNotNullParameter(backendContext, "backendContext");
        super(backendContext);
        this.backendContext = backendContext;
        this.jvmIndyLambdaMetafactoryIntrinsic = this.backendContext.getIr().getSymbols().getIndyLambdaMetafactoryIntrinsic();
        this.jdkMetafactoryHandle = new Handle(6, "java/lang/invoke/LambdaMetafactory", "metafactory", "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodHandle;Ljava/lang/invoke/MethodType;)Ljava/lang/invoke/CallSite;", false);
        this.jdkAltMetafactoryHandle = new Handle(6, "java/lang/invoke/LambdaMetafactory", "altMetafactory", "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;[Ljava/lang/Object;)Ljava/lang/invoke/CallSite;", false);
        this.classContextStack = new ArrayDeque();
        IrSimpleFunctionSymbol irSimpleFunctionSymbol = AdditionalIrUtilsKt.getSimpleFunction(this.backendContext.getIrBuiltIns().getAnyClass(), "equals");
        Intrinsics.checkNotNull(irSimpleFunctionSymbol);
        this.equalsAny = irSimpleFunctionSymbol;
        this.throwTypeCastException = this.backendContext.getIr().getSymbols().getThrowTypeCastException();
        this.checkExpressionValueIsNotNull = this.backendContext.getConfig().getUnifiedNullChecks() ? this.backendContext.getIr().getSymbols().getCheckNotNullExpressionValue() : this.backendContext.getIr().getSymbols().getCheckExpressionValueIsNotNull();
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter(irFile, "irFile");
        this.transformChildrenVoid(irFile);
    }

    private final IrExpression transformVoid(IrExpression $this$transformVoid) {
        return $this$transformVoid.transform((IrElementTransformer)this, (Object)null);
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression lowerInstanceOf(IrExpression argument2, IrType type2) {
        IrExpression irExpression;
        IrBuilderWithScope $this$lowerInstanceOf_u24lambda_u241 = this.getBuilder();
        boolean bl = false;
        if (JvmIrTypeUtilsKt.isReifiedTypeParameter(type2)) {
            irExpression = ExpressionHelpersKt.irIs($this$lowerInstanceOf_u24lambda_u241, argument2, type2);
        } else if (IrTypeUtilsKt.isNullable(argument2.getType()) && IrTypeUtilsKt.isNullable(type2)) {
            void $this$irLetS_u24default$iv;
            IrBuilderWithScope irBuilderWithScope = $this$lowerInstanceOf_u24lambda_u241;
            IrType irType$iv = $this$lowerInstanceOf_u24lambda_u241.getContext().getIrBuiltIns().getAnyNType();
            IrStatementOrigin origin$iv = null;
            String nameHint$iv = null;
            boolean $i$f$irLetS = false;
            IrVariable irTemporary$iv = null;
            IrValueSymbol valueSymbol$iv = null;
            if (argument2 instanceof IrGetValue && IrUtilsKt.isImmutable(((IrGetValue)argument2).getSymbol().getOwner())) {
                irTemporary$iv = null;
                valueSymbol$iv = ((IrGetValue)argument2).getSymbol();
            } else {
                irTemporary$iv = Scope.createTemporaryVariable$default($this$irLetS_u24default$iv.getScope(), argument2, nameHint$iv, false, null, irType$iv, 0, 0, 108, null);
                valueSymbol$iv = irTemporary$iv.getSymbol();
            }
            IrValueSymbol valueSymbol = valueSymbol$iv;
            boolean bl2 = false;
            IrExpression irResult$iv = PrimitivesKt.oror$default($this$lowerInstanceOf_u24lambda_u241.getContext(), ExpressionHelpersKt.irEqualsNull($this$lowerInstanceOf_u24lambda_u241, ExpressionHelpersKt.irGet($this$lowerInstanceOf_u24lambda_u241, valueSymbol.getOwner())), ExpressionHelpersKt.irIs($this$lowerInstanceOf_u24lambda_u241, ExpressionHelpersKt.irGet($this$lowerInstanceOf_u24lambda_u241, valueSymbol.getOwner()), IrTypesKt.makeNotNull(type2)), null, 4, null);
            if (irTemporary$iv == null) {
                irExpression = irResult$iv;
            } else {
                IrBlockImpl irBlock$iv = new IrBlockImpl($this$irLetS_u24default$iv.getStartOffset(), $this$irLetS_u24default$iv.getEndOffset(), irResult$iv.getType(), origin$iv);
                irBlock$iv.getStatements().add(irTemporary$iv);
                if (irResult$iv instanceof IrStatementContainer) {
                    irBlock$iv.getStatements().addAll((Collection<IrStatement>)((IrStatementContainer)((Object)irResult$iv)).getStatements());
                } else {
                    irBlock$iv.getStatements().add(irResult$iv);
                }
                irExpression = irBlock$iv;
            }
        } else {
            irExpression = IrTypeUtilsKt.isNullable(argument2.getType()) && !IrTypeUtilsKt.isNullable(type2) && Intrinsics.areEqual(JvmIrTypeUtilsKt.getErasedUpperBound(argument2.getType()), JvmIrTypeUtilsKt.getErasedUpperBound(type2)) ? ExpressionHelpersKt.irNotEquals($this$lowerInstanceOf_u24lambda_u241, argument2, ExpressionHelpersKt.irNull($this$lowerInstanceOf_u24lambda_u241)) : (IrExpression)ExpressionHelpersKt.irIs($this$lowerInstanceOf_u24lambda_u241, argument2, IrTypesKt.makeNotNull(type2));
        }
        return irExpression;
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression lowerCast(IrExpression argument2, IrType type2) {
        IrExpression irExpression;
        if (JvmIrTypeUtilsKt.isReifiedTypeParameter(type2)) {
            irExpression = ExpressionHelpersKt.irAs(this.getBuilder(), argument2, type2);
        } else if (JvmIrTypeUtilsKt.isInlineClassType(argument2.getType()) && IrTypeUtilsKt.isSubtypeOfClass(argument2.getType(), JvmIrTypeUtilsKt.getErasedUpperBound(type2).getSymbol())) {
            irExpression = argument2;
        } else if (this.isCompatibleArrayType(argument2.getType(), type2)) {
            irExpression = argument2;
        } else if (IrTypeUtilsKt.isNullable(type2) || this.isDefinitelyNotNull(argument2)) {
            irExpression = ExpressionHelpersKt.irAs(this.getBuilder(), argument2, type2);
        } else {
            IrExpression irExpression2;
            void $this$irLetS_u24default$iv;
            IrBuilderWithScope $this$lowerCast_u24lambda_u246 = this.getBuilder();
            boolean bl = false;
            IrBuilderWithScope irBuilderWithScope = $this$lowerCast_u24lambda_u246;
            IrType irType$iv = $this$lowerCast_u24lambda_u246.getContext().getIrBuiltIns().getAnyNType();
            IrStatementOrigin origin$iv = null;
            String nameHint$iv = null;
            boolean $i$f$irLetS = false;
            IrVariable irTemporary$iv = null;
            IrValueSymbol valueSymbol$iv = null;
            if (argument2 instanceof IrGetValue && IrUtilsKt.isImmutable(((IrGetValue)argument2).getSymbol().getOwner())) {
                irTemporary$iv = null;
                valueSymbol$iv = ((IrGetValue)argument2).getSymbol();
            } else {
                irTemporary$iv = Scope.createTemporaryVariable$default($this$irLetS_u24default$iv.getScope(), argument2, nameHint$iv, false, null, irType$iv, 0, 0, 108, null);
                valueSymbol$iv = irTemporary$iv.getSymbol();
            }
            IrValueSymbol tmp = valueSymbol$iv;
            boolean bl2 = false;
            IrConstImpl<String> message2 = ExpressionHelpersKt.irString($this$lowerCast_u24lambda_u246, "null cannot be cast to non-null type " + RenderIrElementKt.render$default(type2, null, 1, null));
            if (this.backendContext.getConfig().getUnifiedNullChecks()) {
                void $this$lowerCast_u24lambda_u246_u24lambda_u245_u24lambda_u243_u24lambda_u242;
                IrCall irCall;
                void this_$iv$iv;
                IrBuilderWithScope $this$irBlock_u24default$iv = $this$lowerCast_u24lambda_u246;
                int startOffset$iv = $this$irBlock_u24default$iv.getStartOffset();
                int endOffset$iv = $this$irBlock_u24default$iv.getEndOffset();
                IrStatementOrigin origin$iv2 = null;
                boolean $i$f$irBlock = false;
                IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irBlock_u24default$iv.getContext(), $this$irBlock_u24default$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv2, type2, false, 64, null);
                boolean $i$f$block = false;
                void $this$lowerCast_u24lambda_u246_u24lambda_u245_u24lambda_u243 = this_$iv$iv;
                boolean bl3 = false;
                IrCall irCall2 = irCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$lowerCast_u24lambda_u246_u24lambda_u245_u24lambda_u243, this.backendContext.getIr().getSymbols().getCheckNotNullWithMessage());
                void var26_29 = $this$lowerCast_u24lambda_u246_u24lambda_u245_u24lambda_u243;
                boolean bl4 = false;
                $this$lowerCast_u24lambda_u246_u24lambda_u245_u24lambda_u243_u24lambda_u242.putValueArgument(0, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$lowerCast_u24lambda_u246_u24lambda_u245_u24lambda_u243, tmp.getOwner()));
                $this$lowerCast_u24lambda_u246_u24lambda_u245_u24lambda_u243_u24lambda_u242.putValueArgument(1, message2);
                var26_29.unaryPlus(irCall);
                $this$lowerCast_u24lambda_u246_u24lambda_u245_u24lambda_u243.unaryPlus(ExpressionHelpersKt.irAs((IrBuilderWithScope)$this$lowerCast_u24lambda_u246_u24lambda_u245_u24lambda_u243, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$lowerCast_u24lambda_u246_u24lambda_u245_u24lambda_u243, tmp.getOwner()), IrTypesKt.makeNullable(type2)));
                irExpression2 = this_$iv$iv.doBuild();
            } else {
                void $this$lowerCast_u24lambda_u246_u24lambda_u245_u24lambda_u244;
                IrCall irCall;
                IrCall startOffset$iv = irCall = ExpressionHelpersKt.irCall($this$lowerCast_u24lambda_u246, this.throwTypeCastException);
                IrExpression irExpression3 = ExpressionHelpersKt.irGet($this$lowerCast_u24lambda_u246, tmp.getOwner());
                IrType irType = type2;
                IrBuilderWithScope irBuilderWithScope2 = $this$lowerCast_u24lambda_u246;
                boolean bl5 = false;
                $this$lowerCast_u24lambda_u246_u24lambda_u245_u24lambda_u244.putValueArgument(0, message2);
                Unit unit2 = Unit.INSTANCE;
                irExpression2 = ExpressionHelpersKt.irIfNull(irBuilderWithScope2, irType, irExpression3, irCall, ExpressionHelpersKt.irAs($this$lowerCast_u24lambda_u246, ExpressionHelpersKt.irGet($this$lowerCast_u24lambda_u246, tmp.getOwner()), IrTypesKt.makeNullable(type2)));
            }
            IrExpression irResult$iv = irExpression2;
            if (irTemporary$iv == null) {
                irExpression = irResult$iv;
            } else {
                IrBlockImpl irBlock$iv = new IrBlockImpl($this$irLetS_u24default$iv.getStartOffset(), $this$irLetS_u24default$iv.getEndOffset(), irResult$iv.getType(), origin$iv);
                irBlock$iv.getStatements().add(irTemporary$iv);
                if (irResult$iv instanceof IrStatementContainer) {
                    irBlock$iv.getStatements().addAll((Collection<IrStatement>)((IrStatementContainer)((Object)irResult$iv)).getStatements());
                } else {
                    irBlock$iv.getStatements().add(irResult$iv);
                }
                irExpression = irBlock$iv;
            }
        }
        return irExpression;
    }

    private final boolean isCompatibleArrayType(IrType actualType, IrType expectedType) {
        IrType actual = actualType;
        IrType expected = expectedType;
        while ((IrTypePredicatesKt.isArray(actual) || IrTypePredicatesKt.isNullableArray(actual)) && (IrTypePredicatesKt.isArray(expected) || IrTypePredicatesKt.isNullableArray(expected))) {
            actual = this.getArrayElementLowerType(actual);
            expected = this.getArrayElementLowerType(expected);
        }
        if (Intrinsics.areEqual(actual, actualType) || Intrinsics.areEqual(expected, expectedType)) {
            return false;
        }
        return IrTypeUtilsKt.isSubtypeOfClass(actual, JvmIrTypeUtilsKt.getErasedUpperBound(expected).getSymbol());
    }

    /*
     * Enabled aggressive block sorting
     */
    private final IrType getArrayElementLowerType(IrType $this$getArrayElementLowerType) {
        IrType irType;
        if (IrTypeUtilsKt.isBoxedArray($this$getArrayElementLowerType) && $this$getArrayElementLowerType instanceof IrSimpleType) {
            IrTypeArgument irTypeArgument = CollectionsKt.singleOrNull(((IrSimpleType)$this$getArrayElementLowerType).getArguments());
            IrTypeProjection irTypeProjection = irTypeArgument instanceof IrTypeProjection ? (IrTypeProjection)irTypeArgument : null;
            if ((irTypeProjection != null ? irTypeProjection.getVariance() : null) == Variance.IN_VARIANCE) {
                irType = this.backendContext.getIrBuiltIns().getAnyNType();
                return irType;
            }
        }
        irType = IrTypeUtilsKt.getArrayElementType($this$getArrayElementLowerType, this.backendContext.getIrBuiltIns());
        return irType;
    }

    private final boolean isDefinitelyNotNull(IrExpression $this$isDefinitelyNotNull) {
        IrExpression irExpression = $this$isDefinitelyNotNull;
        return irExpression instanceof IrGetValue ? this.isDefinitelyNotNullVal(((IrGetValue)$this$isDefinitelyNotNull).getSymbol().getOwner()) : ((irExpression instanceof IrGetClass ? true : irExpression instanceof IrConstructorCall) ? true : (irExpression instanceof IrCall ? Intrinsics.areEqual(((IrCall)$this$isDefinitelyNotNull).getSymbol(), this.backendContext.getIrBuiltIns().getCheckNotNullSymbol()) : false));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isDefinitelyNotNullVal(IrValueDeclaration $this$isDefinitelyNotNullVal) {
        if (!($this$isDefinitelyNotNullVal instanceof IrVariable)) return false;
        IrVariable irVariable = (IrVariable)$this$isDefinitelyNotNullVal;
        if (irVariable == null) {
            return false;
        }
        IrVariable irVariable2 = irVariable;
        if (irVariable2.isVar()) return false;
        IrExpression irExpression = irVariable2.getInitializer();
        if (irExpression == null) return false;
        if (!this.isDefinitelyNotNull(irExpression)) return false;
        return true;
    }

    private final IrCall jvmMethodHandle(JvmIrBuilder $this$jvmMethodHandle, Handle handle2) {
        IrCall irCall;
        IrCall $this$jvmMethodHandle_u24lambda_u247 = irCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$jvmMethodHandle, $this$jvmMethodHandle.getBackendContext().getIr().getSymbols().getJvmMethodHandle());
        boolean bl = false;
        $this$jvmMethodHandle_u24lambda_u247.putValueArgument(0, ExpressionHelpersKt.irInt$default($this$jvmMethodHandle, handle2.getTag(), null, 2, null));
        IrBuilderWithScope irBuilderWithScope = $this$jvmMethodHandle;
        String string2 = handle2.getOwner();
        Intrinsics.checkNotNullExpressionValue(string2, "getOwner(...)");
        $this$jvmMethodHandle_u24lambda_u247.putValueArgument(1, ExpressionHelpersKt.irString(irBuilderWithScope, string2));
        IrBuilderWithScope irBuilderWithScope2 = $this$jvmMethodHandle;
        String string3 = handle2.getName();
        Intrinsics.checkNotNullExpressionValue(string3, "getName(...)");
        $this$jvmMethodHandle_u24lambda_u247.putValueArgument(2, ExpressionHelpersKt.irString(irBuilderWithScope2, string3));
        IrBuilderWithScope irBuilderWithScope3 = $this$jvmMethodHandle;
        String string4 = handle2.getDesc();
        Intrinsics.checkNotNullExpressionValue(string4, "getDesc(...)");
        $this$jvmMethodHandle_u24lambda_u247.putValueArgument(3, ExpressionHelpersKt.irString(irBuilderWithScope3, string4));
        $this$jvmMethodHandle_u24lambda_u247.putValueArgument(4, ExpressionHelpersKt.irBoolean($this$jvmMethodHandle, handle2.isInterface()));
        return irCall;
    }

    private final IrCall jvmInvokeDynamic(JvmIrBuilder $this$jvmInvokeDynamic, IrCall dynamicCall, Handle bootstrapMethodHandle, List<? extends IrExpression> bootstrapMethodArguments) {
        IrCall irCall;
        IrCall $this$jvmInvokeDynamic_u24lambda_u248 = irCall = ExpressionHelpersKt.irCall$default($this$jvmInvokeDynamic, $this$jvmInvokeDynamic.getBackendContext().getIr().getSymbols().getJvmIndyIntrinsic(), dynamicCall.getType(), 0, 0, null, 28, null);
        boolean bl = false;
        $this$jvmInvokeDynamic_u24lambda_u248.putTypeArgument(0, dynamicCall.getType());
        $this$jvmInvokeDynamic_u24lambda_u248.putValueArgument(0, dynamicCall);
        $this$jvmInvokeDynamic_u24lambda_u248.putValueArgument(1, this.jvmMethodHandle($this$jvmInvokeDynamic, bootstrapMethodHandle));
        $this$jvmInvokeDynamic_u24lambda_u248.putValueArgument(2, ExpressionHelpersKt.irVararg($this$jvmInvokeDynamic, $this$jvmInvokeDynamic.getContext().getIrBuiltIns().getAnyType(), bootstrapMethodArguments));
        return irCall;
    }

    private final IrCall jvmOriginalMethodType(JvmIrBuilder $this$jvmOriginalMethodType, IrFunctionSymbol methodSymbol) {
        IrCall irCall;
        IrCall $this$jvmOriginalMethodType_u24lambda_u249 = irCall = ExpressionHelpersKt.irCall$default($this$jvmOriginalMethodType, $this$jvmOriginalMethodType.getBackendContext().getIr().getSymbols().getJvmOriginalMethodTypeIntrinsic(), $this$jvmOriginalMethodType.getContext().getIrBuiltIns().getAnyType(), 0, 0, null, 28, null);
        boolean bl = false;
        $this$jvmOriginalMethodType_u24lambda_u249.putValueArgument(0, ExpressionHelpersKt.irRawFunctionReference($this$jvmOriginalMethodType, $this$jvmOriginalMethodType.getContext().getIrBuiltIns().getAnyType(), methodSymbol));
        return irCall;
    }

    @Override
    @NotNull
    public IrExpression visitCall(@NotNull IrCall expression2) {
        IrExpression irExpression;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        if (Intrinsics.areEqual(expression2.getSymbol(), this.jvmIndyLambdaMetafactoryIntrinsic)) {
            this.transformChildrenVoid(expression2);
            irExpression = this.rewriteIndyLambdaMetafactoryCall(expression2);
        } else {
            irExpression = super.visitCall(expression2);
        }
        return irExpression;
    }

    private final ClassContext enterClass() {
        ClassContext classContext;
        ClassContext it = classContext = new ClassContext();
        boolean bl = false;
        UtilsKt.push(this.classContextStack, it);
        return classContext;
    }

    private final void leaveClass() {
        UtilsKt.pop(this.classContextStack);
    }

    private final ClassContext getClassContext() {
        if (this.classContextStack.isEmpty()) {
            throw new AssertionError((Object)"No class context");
        }
        return this.classContextStack.last();
    }

    @Override
    @NotNull
    public IrStatement visitClass(@NotNull IrClass declaration2) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        ClassContext context2 = this.enterClass();
        IrStatement result2 = super.visitClass(declaration2);
        if (!((Collection)context2.getSerializableMethodRefInfos()).isEmpty()) {
            this.generateDeserializeLambdaMethod(declaration2, (List<SerializableMethodRefInfo>)context2.getSerializableMethodRefInfos());
        }
        this.leaveClass();
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private final void generateDeserializeLambdaMethod(IrClass irClass2, List<SerializableMethodRefInfo> serializableMethodRefInfos) {
        void ctorCall;
        Collection<IrBranchImpl> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$generateDeserializeLambdaMethod_u24lambda_u2418_u24lambda_u2417_u24lambda_u2413;
        void this_$iv$iv;
        void $this$generateDeserializeLambdaMethod_u24lambda_u2418;
        Object answer$iv;
        HashMap groupedByImplMethodName = new HashMap();
        for (SerializableMethodRefInfo serializableMethodRefInfo : serializableMethodRefInfos) {
            Object object;
            void $this$getOrPut$iv;
            DeserializedLambdaInfo deserializedLambdaInfo = this.mapDeserializedLambda(serializableMethodRefInfo);
            String implMethodName = deserializedLambdaInfo.getImplMethodHandle().getName();
            Map map = groupedByImplMethodName;
            Intrinsics.checkNotNull(implMethodName);
            String key$iv = implMethodName;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                answer$iv = new HashMap();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            HashMap byDeserializedLambdaInfo = (HashMap)object;
            ((Map)byDeserializedLambdaInfo).put(deserializedLambdaInfo, serializableMethodRefInfo);
        }
        IrFactory $this$buildFun$iv = this.backendContext.getIrFactory();
        boolean $i$f$buildFun = false;
        Object $this$buildFun_u24lambda_u2420$iv = new IrFunctionBuilder();
        boolean bl = false;
        IrFunctionBuilder $this$generateDeserializeLambdaMethod_u24lambda_u2412 = $this$buildFun_u24lambda_u2420$iv;
        boolean bl2 = false;
        Name name2 = Name.identifier("$deserializeLambda$");
        Intrinsics.checkNotNullExpressionValue(name2, "identifier(...)");
        $this$generateDeserializeLambdaMethod_u24lambda_u2412.setName(name2);
        DescriptorVisibility descriptorVisibility = DescriptorVisibilities.PRIVATE;
        Intrinsics.checkNotNullExpressionValue(descriptorVisibility, "PRIVATE");
        $this$generateDeserializeLambdaMethod_u24lambda_u2412.setVisibility(descriptorVisibility);
        $this$generateDeserializeLambdaMethod_u24lambda_u2412.setOrigin(JvmLoweredDeclarationOrigin.DESERIALIZE_LAMBDA_FUN.INSTANCE);
        IrSimpleFunction deserializeLambdaFun = DeclarationBuildersKt.buildFunction($this$buildFun$iv, (IrFunctionBuilder)$this$buildFun_u24lambda_u2420$iv);
        deserializeLambdaFun.setParent(irClass2);
        IrValueParameter lambdaParameter = DeclarationBuildersKt.addValueParameter$default((IrFunction)deserializeLambdaFun, "lambda", (IrType)this.backendContext.getIr().getSymbols().getSerializedLambda().getIrType(), null, 4, null);
        deserializeLambdaFun.setReturnType(this.backendContext.getIrBuiltIns().getAnyType());
        $this$buildFun_u24lambda_u2420$iv = JvmIrBuilderKt.createJvmIrBuilder(this.backendContext, deserializeLambdaFun.getSymbol(), -1, -1);
        IrSimpleFunction irSimpleFunction = deserializeLambdaFun;
        boolean bl3 = false;
        IrBuilderWithScope $this$irBlockBody_u24default$iv = (IrBuilderWithScope)$this$generateDeserializeLambdaMethod_u24lambda_u2418;
        int startOffset$iv = $this$irBlockBody_u24default$iv.getStartOffset();
        int endOffset$iv = $this$irBlockBody_u24default$iv.getEndOffset();
        boolean $i$f$irBlockBody = false;
        answer$iv = new IrBlockBodyBuilder($this$irBlockBody_u24default$iv.getContext(), $this$irBlockBody_u24default$iv.getScope(), startOffset$iv, endOffset$iv);
        boolean $i$f$blockBody = false;
        void $this$generateDeserializeLambdaMethod_u24lambda_u2418_u24lambda_u2417 = this_$iv$iv;
        boolean bl4 = false;
        Object object = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$generateDeserializeLambdaMethod_u24lambda_u2418_u24lambda_u2417, $this$generateDeserializeLambdaMethod_u24lambda_u2418.getBackendContext().getIr().getSymbols().getSerializedLambda().getGetImplMethodName());
        IrFunctionAccessExpression irFunctionAccessExpression = object;
        IrStatementsBuilder irStatementsBuilder = (IrStatementsBuilder)$this$generateDeserializeLambdaMethod_u24lambda_u2418_u24lambda_u2417;
        boolean $i$a$-apply-TypeOperatorLowering$generateDeserializeLambdaMethod$1$1$tmp$22 = false;
        $this$generateDeserializeLambdaMethod_u24lambda_u2418_u24lambda_u2417_u24lambda_u2413.setDispatchReceiver(ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$generateDeserializeLambdaMethod_u24lambda_u2418_u24lambda_u2417, lambdaParameter));
        IrVariable tmp = ExpressionHelpersKt.irTemporary$default(irStatementsBuilder, (IrExpression)object, null, null, false, null, 30, null);
        IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$generateDeserializeLambdaMethod_u24lambda_u2418_u24lambda_u2417;
        IrType irType = $this$generateDeserializeLambdaMethod_u24lambda_u2418.getBackendContext().getIrBuiltIns().getUnitType();
        Set set = groupedByImplMethodName.entrySet();
        Intrinsics.checkNotNullExpressionValue(set, "<get-entries>(...)");
        object = set;
        Object object2 = irType;
        IrBuilderWithScope irBuilderWithScope2 = irBuilderWithScope;
        irStatementsBuilder = $this$generateDeserializeLambdaMethod_u24lambda_u2418_u24lambda_u2417;
        boolean $i$f$map22 = false;
        void $i$a$-apply-TypeOperatorLowering$generateDeserializeLambdaMethod$1$1$tmp$22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Collection<IrBranchImpl> collection2;
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            Map.Entry entry = (Map.Entry)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl5 = false;
            Intrinsics.checkNotNull(entry);
            String implMethodName = (String)entry.getKey();
            HashMap infos = (HashMap)entry.getValue();
            IrBuilderWithScope irBuilderWithScope3 = (IrBuilderWithScope)$this$generateDeserializeLambdaMethod_u24lambda_u2418_u24lambda_u2417;
            IrBuilderWithScope irBuilderWithScope4 = (IrBuilderWithScope)$this$generateDeserializeLambdaMethod_u24lambda_u2418_u24lambda_u2417;
            IrExpression irExpression = ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$generateDeserializeLambdaMethod_u24lambda_u2418_u24lambda_u2417, tmp);
            IrBuilderWithScope irBuilderWithScope5 = (IrBuilderWithScope)$this$generateDeserializeLambdaMethod_u24lambda_u2418_u24lambda_u2417;
            Intrinsics.checkNotNull(implMethodName);
            IrExpression irExpression2 = ExpressionHelpersKt.irEquals$default(irBuilderWithScope4, irExpression, ExpressionHelpersKt.irString(irBuilderWithScope5, implMethodName), null, 4, null);
            IrBuilderWithScope irBuilderWithScope6 = (IrBuilderWithScope)$this$generateDeserializeLambdaMethod_u24lambda_u2418_u24lambda_u2417;
            IrType irType2 = $this$generateDeserializeLambdaMethod_u24lambda_u2418.getBackendContext().getIrBuiltIns().getUnitType();
            Set set2 = infos.entrySet();
            Intrinsics.checkNotNullExpressionValue(set2, "<get-entries>(...)");
            Iterable iterable = set2;
            IrType irType3 = irType2;
            IrBuilderWithScope irBuilderWithScope7 = irBuilderWithScope6;
            IrExpression irExpression3 = irExpression2;
            IrBuilderWithScope irBuilderWithScope8 = irBuilderWithScope3;
            boolean $i$f$map = false;
            void var39_49 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                Map.Entry entry2 = (Map.Entry)item$iv$iv2;
                collection2 = destination$iv$iv2;
                boolean bl6 = false;
                Intrinsics.checkNotNull(entry2);
                DeserializedLambdaInfo deserializedLambdaInfo = (DeserializedLambdaInfo)entry2.getKey();
                SerializableMethodRefInfo serializedMethodRefInfo = (SerializableMethodRefInfo)entry2.getValue();
                IrBuilderWithScope irBuilderWithScope9 = (IrBuilderWithScope)$this$generateDeserializeLambdaMethod_u24lambda_u2418_u24lambda_u2417;
                Intrinsics.checkNotNull(deserializedLambdaInfo);
                IrExpression irExpression4 = this.generateSerializedLambdaEquals((JvmIrBuilder)$this$generateDeserializeLambdaMethod_u24lambda_u2418, lambdaParameter, deserializedLambdaInfo);
                IrBuilderWithScope irBuilderWithScope10 = (IrBuilderWithScope)$this$generateDeserializeLambdaMethod_u24lambda_u2418_u24lambda_u2417;
                Intrinsics.checkNotNull(serializedMethodRefInfo);
                collection2.add(ExpressionHelpersKt.irBranch(irBuilderWithScope9, irExpression4, ExpressionHelpersKt.irReturn(irBuilderWithScope10, this.generateCreateDeserializedMethodRef((JvmIrBuilder)$this$generateDeserializeLambdaMethod_u24lambda_u2418, lambdaParameter, serializedMethodRefInfo))));
            }
            collection2 = (List)destination$iv$iv2;
            collection.add(ExpressionHelpersKt.irBranch(irBuilderWithScope8, irExpression3, ExpressionHelpersKt.irWhen(irBuilderWithScope7, irType3, (List<? extends IrBranch>)collection2)));
        }
        collection = (List)destination$iv$iv;
        irStatementsBuilder.unaryPlus(ExpressionHelpersKt.irWhen(irBuilderWithScope2, (IrType)object2, (List<? extends IrBranch>)collection));
        Object $i$f$map22 = object = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$generateDeserializeLambdaMethod_u24lambda_u2418_u24lambda_u2417, $this$generateDeserializeLambdaMethod_u24lambda_u2418.getBackendContext().getIr().getSymbols().getIllegalArgumentExceptionCtorString());
        irBuilderWithScope2 = (IrBuilderWithScope)$this$generateDeserializeLambdaMethod_u24lambda_u2418_u24lambda_u2417;
        irStatementsBuilder = $this$generateDeserializeLambdaMethod_u24lambda_u2418_u24lambda_u2417;
        boolean bl7 = false;
        ctorCall.putValueArgument(0, ExpressionHelpersKt.irString((IrBuilderWithScope)$this$generateDeserializeLambdaMethod_u24lambda_u2418_u24lambda_u2417, "Invalid lambda deserialization"));
        object2 = Unit.INSTANCE;
        irStatementsBuilder.unaryPlus(LowerUtilsKt.irThrow(irBuilderWithScope2, (IrExpression)object));
        irSimpleFunction.setBody(this_$iv$iv.doBuild());
        irClass2.getDeclarations().add(deserializeLambdaFun);
    }

    private final DeserializedLambdaInfo mapDeserializedLambda(SerializableMethodRefInfo info) {
        String string2 = IrTypeMapper.mapType$default(this.backendContext.getDefaultTypeMapper(), info.getSamType(), null, null, false, 14, null).getInternalName();
        Intrinsics.checkNotNullExpressionValue(string2, "getInternalName(...)");
        return new DeserializedLambdaInfo(string2, this.backendContext.getDefaultMethodSignatureMapper().mapToMethodHandle(info.getImplFunSymbol().getOwner()), this.backendContext.getDefaultMethodSignatureMapper().mapAsmMethod(info.getSamMethodSymbol().getOwner()));
    }

    private final IrExpression generateSerializedLambdaEquals(JvmIrBuilder $this$generateSerializedLambdaEquals, IrValueParameter lambdaParameter, DeserializedLambdaInfo deserializedLambdaInfo) {
        String functionalInterfaceClass = deserializedLambdaInfo.getFunctionalInterfaceClass();
        Handle implMethodHandle = deserializedLambdaInfo.getImplMethodHandle();
        Method samMethod = deserializedLambdaInfo.getFunctionalInterfaceMethod();
        IrExpression[] irExpressionArray = new IrExpression[6];
        irExpressionArray[0] = ExpressionHelpersKt.irEquals$default($this$generateSerializedLambdaEquals, TypeOperatorLowering.generateSerializedLambdaEquals$irGetLambdaProperty($this$generateSerializedLambdaEquals, lambdaParameter, $this$generateSerializedLambdaEquals.getBackendContext().getIr().getSymbols().getSerializedLambda().getGetImplMethodKind()), ExpressionHelpersKt.irInt$default($this$generateSerializedLambdaEquals, implMethodHandle.getTag(), null, 2, null), null, 4, null);
        irExpressionArray[1] = this.irObjectEquals($this$generateSerializedLambdaEquals, TypeOperatorLowering.generateSerializedLambdaEquals$irGetLambdaProperty($this$generateSerializedLambdaEquals, lambdaParameter, $this$generateSerializedLambdaEquals.getBackendContext().getIr().getSymbols().getSerializedLambda().getGetFunctionalInterfaceClass()), ExpressionHelpersKt.irString($this$generateSerializedLambdaEquals, functionalInterfaceClass));
        IrExpression irExpression = TypeOperatorLowering.generateSerializedLambdaEquals$irGetLambdaProperty($this$generateSerializedLambdaEquals, lambdaParameter, $this$generateSerializedLambdaEquals.getBackendContext().getIr().getSymbols().getSerializedLambda().getGetFunctionalInterfaceMethodName());
        IrBuilderWithScope irBuilderWithScope = $this$generateSerializedLambdaEquals;
        String string2 = samMethod.getName();
        Intrinsics.checkNotNullExpressionValue(string2, "getName(...)");
        irExpressionArray[2] = this.irObjectEquals($this$generateSerializedLambdaEquals, irExpression, ExpressionHelpersKt.irString(irBuilderWithScope, string2));
        IrExpression irExpression2 = TypeOperatorLowering.generateSerializedLambdaEquals$irGetLambdaProperty($this$generateSerializedLambdaEquals, lambdaParameter, $this$generateSerializedLambdaEquals.getBackendContext().getIr().getSymbols().getSerializedLambda().getGetFunctionalInterfaceMethodSignature());
        IrBuilderWithScope irBuilderWithScope2 = $this$generateSerializedLambdaEquals;
        String string3 = samMethod.getDescriptor();
        Intrinsics.checkNotNullExpressionValue(string3, "getDescriptor(...)");
        irExpressionArray[3] = this.irObjectEquals($this$generateSerializedLambdaEquals, irExpression2, ExpressionHelpersKt.irString(irBuilderWithScope2, string3));
        IrExpression irExpression3 = TypeOperatorLowering.generateSerializedLambdaEquals$irGetLambdaProperty($this$generateSerializedLambdaEquals, lambdaParameter, $this$generateSerializedLambdaEquals.getBackendContext().getIr().getSymbols().getSerializedLambda().getGetImplClass());
        IrBuilderWithScope irBuilderWithScope3 = $this$generateSerializedLambdaEquals;
        String string4 = implMethodHandle.getOwner();
        Intrinsics.checkNotNullExpressionValue(string4, "getOwner(...)");
        irExpressionArray[4] = this.irObjectEquals($this$generateSerializedLambdaEquals, irExpression3, ExpressionHelpersKt.irString(irBuilderWithScope3, string4));
        IrExpression irExpression4 = TypeOperatorLowering.generateSerializedLambdaEquals$irGetLambdaProperty($this$generateSerializedLambdaEquals, lambdaParameter, $this$generateSerializedLambdaEquals.getBackendContext().getIr().getSymbols().getSerializedLambda().getGetImplMethodSignature());
        IrBuilderWithScope irBuilderWithScope4 = $this$generateSerializedLambdaEquals;
        String string5 = implMethodHandle.getDesc();
        Intrinsics.checkNotNullExpressionValue(string5, "getDesc(...)");
        irExpressionArray[5] = this.irObjectEquals($this$generateSerializedLambdaEquals, irExpression4, ExpressionHelpersKt.irString(irBuilderWithScope4, string5));
        return this.irAndAnd($this$generateSerializedLambdaEquals, irExpressionArray);
    }

    private final IrCall irObjectEquals(JvmIrBuilder $this$irObjectEquals, IrExpression receiver, IrExpression arg) {
        IrCall irCall;
        IrCall $this$irObjectEquals_u24lambda_u2420 = irCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$irObjectEquals, this.equalsAny);
        boolean bl = false;
        $this$irObjectEquals_u24lambda_u2420.setDispatchReceiver(receiver);
        $this$irObjectEquals_u24lambda_u2420.putValueArgument(0, arg);
        return irCall;
    }

    private final IrExpression irAndAnd(JvmIrBuilder $this$irAndAnd, IrExpression ... args2) {
        if (args2.length == 0) {
            throw new AssertionError((Object)"At least one argument expected");
        }
        IrExpression result2 = null;
        result2 = args2[0];
        int n = args2.length;
        for (int i = 1; i < n; ++i) {
            IrCall irCall;
            IrCall $this$irAndAnd_u24lambda_u2421 = irCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$irAndAnd, $this$irAndAnd.getBackendContext().getIrBuiltIns().getAndandSymbol());
            boolean bl = false;
            $this$irAndAnd_u24lambda_u2421.putValueArgument(0, result2);
            $this$irAndAnd_u24lambda_u2421.putValueArgument(1, args2[i]);
            result2 = irCall;
        }
        return result2;
    }

    private final IrExpression generateCreateDeserializedMethodRef(JvmIrBuilder $this$generateCreateDeserializedMethodRef, IrValueParameter lambdaParameter, SerializableMethodRefInfo info) {
        IrCall dynamicCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$generateCreateDeserializedMethodRef, info.getDynamicCallSymbol());
        Iterator<IrValueParameter> iterator2 = ((IrSimpleFunction)info.getDynamicCallSymbol().getOwner()).getValueParameters().iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            IrExpression irExpression;
            IrFunctionAccessExpression irFunctionAccessExpression;
            int index2 = n++;
            IrValueParameter dynamicValueParameter = iterator2.next();
            IrFunctionAccessExpression call2 = irFunctionAccessExpression = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$generateCreateDeserializedMethodRef, $this$generateCreateDeserializedMethodRef.getBackendContext().getIr().getSymbols().getSerializedLambda().getGetCapturedArg());
            boolean bl = false;
            call2.setDispatchReceiver(ExpressionHelpersKt.irGet($this$generateCreateDeserializedMethodRef, lambdaParameter));
            call2.putValueArgument(0, ExpressionHelpersKt.irInt$default($this$generateCreateDeserializedMethodRef, index2, null, 2, null));
            IrFunctionAccessExpression capturedArg = irFunctionAccessExpression;
            IrType expectedType = dynamicValueParameter.getType();
            if (JvmIrTypeUtilsKt.isInlineClassType(expectedType)) {
                IrCall irCall;
                IrType unboxedType = InlineClassAbiKt.unboxInlineClass(expectedType);
                IrCall coercion = irCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$generateCreateDeserializedMethodRef, $this$generateCreateDeserializedMethodRef.getBackendContext().getIr().getSymbols().getUnsafeCoerceIntrinsic());
                boolean bl2 = false;
                coercion.putTypeArgument(0, unboxedType);
                coercion.putTypeArgument(1, expectedType);
                coercion.putValueArgument(0, capturedArg);
                irExpression = irCall;
            } else {
                irExpression = ExpressionHelpersKt.irAs($this$generateCreateDeserializedMethodRef, capturedArg, expectedType);
            }
            IrExpression downcastArg = irExpression;
            dynamicCall.putValueArgument(index2, downcastArg);
        }
        return this.createLambdaMetafactoryCall($this$generateCreateDeserializedMethodRef, info.getSamMethodSymbol(), info.getImplFunSymbol(), info.getInstanceFunSymbol(), true, info.getRequiredBridges(), dynamicCall);
    }

    /*
     * WARNING - void declaration
     */
    private final IrCall rewriteIndyLambdaMetafactoryCall(IrCall call2) {
        void $this$mapTo$iv$iv;
        int startOffset = call2.getStartOffset();
        int endOffset = call2.getEndOffset();
        IrType irType = call2.getTypeArgument(0);
        IrSimpleType irSimpleType = irType instanceof IrSimpleType ? (IrSimpleType)irType : null;
        if (irSimpleType == null) {
            TypeOperatorLowering.rewriteIndyLambdaMetafactoryCall$fail(call2, "'samType' is expected to be a simple type");
            throw null;
        }
        IrSimpleType samType = irSimpleType;
        IrExpression irExpression = call2.getValueArgument(0);
        IrRawFunctionReference irRawFunctionReference = irExpression instanceof IrRawFunctionReference ? (IrRawFunctionReference)irExpression : null;
        if (irRawFunctionReference == null) {
            TypeOperatorLowering.rewriteIndyLambdaMetafactoryCall$fail(call2, "'samMethodType' should be 'IrRawFunctionReference'");
            throw null;
        }
        IrRawFunctionReference samMethodRef = irRawFunctionReference;
        IrExpression irExpression2 = call2.getValueArgument(1);
        IrFunctionReference irFunctionReference = irExpression2 instanceof IrFunctionReference ? (IrFunctionReference)irExpression2 : null;
        if (irFunctionReference == null) {
            TypeOperatorLowering.rewriteIndyLambdaMetafactoryCall$fail(call2, "'implMethodReference' is expected to be 'IrFunctionReference'");
            throw null;
        }
        IrFunctionReference implFunRef = irFunctionReference;
        IrFunctionSymbol implFunSymbol = (IrFunctionSymbol)implFunRef.getSymbol();
        IrExpression irExpression3 = call2.getValueArgument(2);
        IrRawFunctionReference irRawFunctionReference2 = irExpression3 instanceof IrRawFunctionReference ? (IrRawFunctionReference)irExpression3 : null;
        if (irRawFunctionReference2 == null) {
            TypeOperatorLowering.rewriteIndyLambdaMetafactoryCall$fail(call2, "'instantiatedMethodType' is expected to be 'IrRawFunctionReference'");
            throw null;
        }
        IrRawFunctionReference instanceMethodRef = irRawFunctionReference2;
        TypeOperatorLowering $this$rewriteIndyLambdaMetafactoryCall_u24lambda_u2425 = this;
        boolean bl = false;
        IrExpression irExpression4 = call2.getValueArgument(3);
        IrVararg irVararg = irExpression4 instanceof IrVararg ? (IrVararg)irExpression4 : null;
        if (irVararg == null) {
            TypeOperatorLowering.rewriteIndyLambdaMetafactoryCall$fail(call2, "'extraOverriddenMethodTypes' is expected to be 'IrVararg'");
            throw null;
        }
        IrElementBase extraOverriddenMethodVararg = irVararg;
        Iterable $this$map$iv = extraOverriddenMethodVararg.getElements();
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrVarargElement irVarargElement = (IrVarargElement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            IrRawFunctionReference irRawFunctionReference3 = it instanceof IrRawFunctionReference ? (IrRawFunctionReference)it : null;
            if (irRawFunctionReference3 == null) {
                TypeOperatorLowering.rewriteIndyLambdaMetafactoryCall$fail(call2, "'extraOverriddenMethodTypes' elements are expected to be 'IrRawFunctionReference'");
                throw null;
            }
            IrRawFunctionReference ref = irRawFunctionReference3;
            IrFunction irFunction2 = ref.getSymbol().getOwner();
            IrSimpleFunction irSimpleFunction = irFunction2 instanceof IrSimpleFunction ? (IrSimpleFunction)irFunction2 : null;
            if (irSimpleFunction == null) {
                TypeOperatorLowering.rewriteIndyLambdaMetafactoryCall$fail(call2, "Extra overridden method is expected to be 'IrSimpleFunction': " + RenderIrElementKt.render$default(ref.getSymbol().getOwner(), null, 1, null));
                throw null;
            }
            collection.add(irSimpleFunction);
        }
        List extraOverriddenMethods = (List)destination$iv$iv;
        boolean shouldBeSerializable = JvmIrUtilsKt.getBooleanConstArgument(call2, 4);
        IrFunction $i$f$map22 = samMethodRef.getSymbol().getOwner();
        IrSimpleFunction irSimpleFunction = $i$f$map22 instanceof IrSimpleFunction ? (IrSimpleFunction)$i$f$map22 : null;
        if (irSimpleFunction == null) {
            TypeOperatorLowering.rewriteIndyLambdaMetafactoryCall$fail(call2, "SAM method is expected to be 'IrSimpleFunction': " + RenderIrElementKt.render$default(samMethodRef.getSymbol().getOwner(), null, 1, null));
            throw null;
        }
        IrSimpleFunction samMethod = irSimpleFunction;
        extraOverriddenMethodVararg = instanceMethodRef.getSymbol().getOwner();
        IrSimpleFunction irSimpleFunction2 = extraOverriddenMethodVararg instanceof IrSimpleFunction ? (IrSimpleFunction)extraOverriddenMethodVararg : null;
        if (irSimpleFunction2 == null) {
            TypeOperatorLowering.rewriteIndyLambdaMetafactoryCall$fail(call2, "Instance method is expected to be 'IrSimpleFunction': " + RenderIrElementKt.render$default(instanceMethodRef.getSymbol().getOwner(), null, 1, null));
            throw null;
        }
        IrSimpleFunction instanceMethod = irSimpleFunction2;
        IrCall dynamicCall = this.wrapClosureInDynamicCall(samType, samMethod, implFunRef);
        Collection<IrSimpleFunction> requiredBridges = this.getOverriddenMethodsRequiringBridges(instanceMethod, samMethod, extraOverriddenMethods);
        if (shouldBeSerializable) {
            this.getClassContext().getSerializableMethodRefInfos().add(new SerializableMethodRefInfo(samType, samMethod.getSymbol(), implFunSymbol, instanceMethodRef.getSymbol(), requiredBridges, dynamicCall.getSymbol()));
        }
        return this.createLambdaMetafactoryCall(JvmIrBuilderKt.createJvmIrBuilder(this.backendContext, implFunSymbol, startOffset, endOffset), samMethod.getSymbol(), implFunSymbol, instanceMethodRef.getSymbol(), shouldBeSerializable, requiredBridges, dynamicCall);
    }

    /*
     * WARNING - void declaration
     */
    private final IrCall createLambdaMetafactoryCall(JvmIrBuilder $this$createLambdaMetafactoryCall, IrSimpleFunctionSymbol samMethodSymbol, IrFunctionSymbol implFunSymbol, IrFunctionSymbol instanceMethodSymbol, boolean shouldBeSerializable, Collection<? extends IrSimpleFunction> requiredBridges, IrCall dynamicCall) {
        IrCall samMethodType = this.jvmOriginalMethodType($this$createLambdaMetafactoryCall, samMethodSymbol);
        IrRawFunctionReferenceImpl implFunRawRef = ExpressionHelpersKt.irRawFunctionReference($this$createLambdaMetafactoryCall, $this$createLambdaMetafactoryCall.getContext().getIrBuiltIns().getAnyType(), implFunSymbol);
        IrCall instanceMethodType = this.jvmOriginalMethodType($this$createLambdaMetafactoryCall, instanceMethodSymbol);
        Handle bootstrapMethod = this.jdkMetafactoryHandle;
        IrExpression[] irExpressionArray = new IrExpression[]{samMethodType, implFunRawRef, instanceMethodType};
        ArrayList<IrExpression> bootstrapMethodArguments = CollectionsKt.arrayListOf(irExpressionArray);
        List bridgeMethodTypes = CollectionsKt.emptyList();
        int flags = 0;
        if (shouldBeSerializable) {
            ++flags;
        }
        if (!requiredBridges.isEmpty()) {
            void $this$mapTo$iv$iv;
            flags += 4;
            Iterable $this$map$iv = requiredBridges;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                IrSimpleFunction irSimpleFunction = (IrSimpleFunction)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.jvmOriginalMethodType($this$createLambdaMetafactoryCall, it.getSymbol()));
            }
            bridgeMethodTypes = (List)destination$iv$iv;
        }
        if (flags != 0) {
            bootstrapMethod = this.jdkAltMetafactoryHandle;
            bootstrapMethodArguments.add(ExpressionHelpersKt.irInt$default($this$createLambdaMetafactoryCall, flags, null, 2, null));
            if (!((Collection)bridgeMethodTypes).isEmpty()) {
                bootstrapMethodArguments.add(ExpressionHelpersKt.irInt$default($this$createLambdaMetafactoryCall, bridgeMethodTypes.size(), null, 2, null));
                bootstrapMethodArguments.addAll(bridgeMethodTypes);
            }
        }
        return this.jvmInvokeDynamic($this$createLambdaMetafactoryCall, dynamicCall, bootstrapMethod, (List<? extends IrExpression>)bootstrapMethodArguments);
    }

    private final Collection<IrSimpleFunction> getOverriddenMethodsRequiringBridges(IrSimpleFunction instanceMethod, IrSimpleFunction samMethod, List<? extends IrSimpleFunction> extraOverriddenMethods) {
        Method jvmInstanceMethod = this.backendContext.getDefaultMethodSignatureMapper().mapAsmMethod(instanceMethod);
        Method jvmSamMethod = this.backendContext.getDefaultMethodSignatureMapper().mapAsmMethod(samMethod);
        LinkedHashMap signatureToNonFakeOverride = new LinkedHashMap();
        for (IrSimpleFunction irSimpleFunction : extraOverriddenMethods) {
            Method jvmOverriddenMethod = this.backendContext.getDefaultMethodSignatureMapper().mapAsmMethod(irSimpleFunction);
            if (Intrinsics.areEqual(jvmOverriddenMethod, jvmInstanceMethod) || Intrinsics.areEqual(jvmOverriddenMethod, jvmSamMethod)) continue;
            ((Map)signatureToNonFakeOverride).put(jvmOverriddenMethod, irSimpleFunction);
        }
        Collection<IrSimpleFunction> collection = signatureToNonFakeOverride.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        return collection;
    }

    private final IrCall wrapClosureInDynamicCall(IrSimpleType erasedSamType, IrSimpleFunction samMethod, IrFunctionReference targetRef) {
        ArrayList<IrExpression> dynamicCallArguments = new ArrayList<IrExpression>();
        IrFactory $this$buildFun$iv = this.backendContext.getIrFactory();
        boolean $i$f$buildFun = false;
        IrFunctionBuilder $this$buildFun_u24lambda_u2420$iv = new IrFunctionBuilder();
        boolean bl = false;
        IrFunctionBuilder $this$wrapClosureInDynamicCall_u24lambda_u2428 = $this$buildFun_u24lambda_u2420$iv;
        boolean bl2 = false;
        $this$wrapClosureInDynamicCall_u24lambda_u2428.setOrigin(JvmLoweredDeclarationOrigin.INVOKEDYNAMIC_CALL_TARGET.INSTANCE);
        $this$wrapClosureInDynamicCall_u24lambda_u2428.setName(samMethod.getName());
        $this$wrapClosureInDynamicCall_u24lambda_u2428.setReturnType(erasedSamType);
        IrElementBase irElementBase = DeclarationBuildersKt.buildFunction($this$buildFun$iv, $this$buildFun_u24lambda_u2420$iv);
        IrSimpleFunction $this$wrapClosureInDynamicCall_u24lambda_u2429 = irElementBase;
        boolean bl3 = false;
        $this$wrapClosureInDynamicCall_u24lambda_u2429.setParent(this.backendContext.getIr().getSymbols().getKotlinJvmInternalInvokeDynamicPackage());
        IrFunction targetFun = ((IrFunctionSymbol)targetRef.getSymbol()).getOwner();
        IrExpression refDispatchReceiver = targetRef.getDispatchReceiver();
        IrExpression refExtensionReceiver = targetRef.getExtensionReceiver();
        int syntheticParameterIndex = 0;
        int argumentStart = 0;
        IrFunction irFunction2 = targetFun;
        if (irFunction2 instanceof IrSimpleFunction) {
            if (refDispatchReceiver != null) {
                DeclarationBuildersKt.addValueParameter$default((IrFunction)$this$wrapClosureInDynamicCall_u24lambda_u2429, "" + 'p' + syntheticParameterIndex++, (IrType)IrUtilsKt.getDefaultType(IrUtilsKt.getParentAsClass(targetFun)), null, 4, null);
                dynamicCallArguments.add(refDispatchReceiver);
            }
            if (refExtensionReceiver != null) {
                IrFunction irFunction3 = $this$wrapClosureInDynamicCall_u24lambda_u2429;
                String string2 = "" + 'p' + syntheticParameterIndex++;
                IrValueParameter irValueParameter = targetFun.getExtensionReceiverParameter();
                Intrinsics.checkNotNull(irValueParameter);
                DeclarationBuildersKt.addValueParameter$default(irFunction3, string2, irValueParameter.getType(), null, 4, null);
                dynamicCallArguments.add(refExtensionReceiver);
            }
        } else if (irFunction2 instanceof IrConstructor) {
            if (refDispatchReceiver != null) {
                DeclarationBuildersKt.addValueParameter$default((IrFunction)$this$wrapClosureInDynamicCall_u24lambda_u2429, "" + 'p' + syntheticParameterIndex++, targetFun.getValueParameters().get(0).getType(), null, 4, null);
                dynamicCallArguments.add(refDispatchReceiver);
                ++argumentStart;
            }
        } else {
            throw new AssertionError((Object)("Unexpected function: " + RenderIrElementKt.render$default(targetFun, null, 1, null)));
        }
        int samMethodValueParametersCount = samMethod.getValueParameters().size() + (samMethod.getExtensionReceiverParameter() != null && refExtensionReceiver == null ? 1 : 0);
        int targetFunValueParametersCount = targetFun.getValueParameters().size();
        int n = targetFunValueParametersCount - samMethodValueParametersCount;
        for (int i = argumentStart; i < n; ++i) {
            IrExpression capturedValueArgument;
            IrValueParameter targetFunValueParameter = targetFun.getValueParameters().get(i);
            DeclarationBuildersKt.addValueParameter$default((IrFunction)$this$wrapClosureInDynamicCall_u24lambda_u2429, "" + 'p' + syntheticParameterIndex++, targetFunValueParameter.getType(), null, 4, null);
            if (targetRef.getValueArgument(i) == null) {
                TypeOperatorLowering.wrapClosureInDynamicCall$fail$27(targetRef, "Captured value argument #" + i + " (" + RenderIrElementKt.render$default(targetFunValueParameter, null, 1, null) + ") not provided");
                throw null;
            }
            dynamicCallArguments.add(capturedValueArgument);
        }
        IrSimpleFunction irDynamicCallTarget = irElementBase;
        if (dynamicCallArguments.size() != irDynamicCallTarget.getValueParameters().size()) {
            throw new AssertionError((Object)("Dynamic call target value parameters (" + irDynamicCallTarget.getValueParameters().size() + ") don't match dynamic call arguments (" + dynamicCallArguments.size() + "):\nirDynamicCallTarget:\n" + DumpIrTreeKt.dump$default(irDynamicCallTarget, null, 1, null) + "dynamicCallArguments:\n" + CollectionsKt.joinToString$default(CollectionsKt.withIndex((Iterable)dynamicCallArguments), "\n ", "[\n ", "\n]", 0, null, wrapClosureInDynamicCall.1.INSTANCE, 24, null)));
        }
        IrElementBase $this$wrapClosureInDynamicCall_u24lambda_u2430 = irElementBase = ExpressionHelpersKt.irCall((IrBuilderWithScope)JvmIrBuilderKt.createJvmIrBuilder$default(this.backendContext, irDynamicCallTarget.getSymbol(), 0, 0, 6, null), irDynamicCallTarget.getSymbol());
        boolean bl4 = false;
        int n2 = dynamicCallArguments.size();
        for (int i = 0; i < n2; ++i) {
            ((IrMemberAccessExpression)$this$wrapClosureInDynamicCall_u24lambda_u2430).putValueArgument(i, (IrExpression)dynamicCallArguments.get(i));
        }
        return irElementBase;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public IrExpression visitTypeOperator(@NotNull IrTypeOperatorCall expression2) {
        IrExpression irExpression;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        IrBuilderWithScope $this$visitTypeOperator_u24lambda_u2437 = this.getBuilder();
        boolean bl = false;
        LowerUtilsKt.at((IrBuilder)$this$visitTypeOperator_u24lambda_u2437, expression2);
        switch (WhenMappings.$EnumSwitchMapping$0[expression2.getOperator().ordinal()]) {
            case 1: {
                void this_$iv$iv;
                void $this$irComposite_u24default$iv;
                IrBuilderWithScope irBuilderWithScope = $this$visitTypeOperator_u24lambda_u2437;
                IrType resultType$iv = expression2.getType();
                int startOffset$iv = $this$irComposite_u24default$iv.getStartOffset();
                int endOffset$iv = $this$irComposite_u24default$iv.getEndOffset();
                IrStatementOrigin origin$iv = null;
                boolean $i$f$irComposite = false;
                IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irComposite_u24default$iv.getContext(), $this$irComposite_u24default$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, resultType$iv, true);
                boolean $i$f$block = false;
                void $this$visitTypeOperator_u24lambda_u2437_u24lambda_u2431 = this_$iv$iv;
                boolean bl2 = false;
                $this$visitTypeOperator_u24lambda_u2437_u24lambda_u2431.unaryPlus(this.transformVoid(expression2.getArgument()));
                if (!IrTypeUtilsKt.isSubtypeOf(expression2.getArgument().getType(), IrTypesKt.makeNullable(expression2.getType()), this.backendContext.getTypeSystem())) {
                    $this$visitTypeOperator_u24lambda_u2437_u24lambda_u2431.unaryPlus(new IrCompositeImpl(-1, -1, expression2.getType(), null, 8, null));
                }
                irExpression = this_$iv$iv.doBuild();
                break;
            }
            case 2: {
                irExpression = ExpressionHelpersKt.irImplicitCast($this$visitTypeOperator_u24lambda_u2437, this.transformVoid(expression2.getArgument()), expression2.getTypeOperand());
                break;
            }
            case 3: {
                irExpression = this.lowerCast(this.transformVoid(expression2.getArgument()), expression2.getTypeOperand());
                break;
            }
            case 4: {
                void origin$iv;
                void $this$irLetS_u24default$iv;
                void value$iv2;
                if (JvmIrTypeUtilsKt.isReifiedTypeParameter(expression2.getTypeOperand())) {
                    this.transformChildrenVoid(expression2);
                    irExpression = expression2;
                    break;
                }
                IrBuilderWithScope $this$irComposite_u24default$iv = $this$visitTypeOperator_u24lambda_u2437;
                IrExpression startOffset$iv = this.transformVoid(expression2.getArgument());
                IrStatementOrigin endOffset$iv = IrStatementOrigin.SAFE_CALL.INSTANCE;
                IrType resultType$iv = $this$visitTypeOperator_u24lambda_u2437.getContext().getIrBuiltIns().getAnyNType();
                String nameHint$iv = null;
                boolean $i$f$irLetS = false;
                IrVariable irTemporary$iv = null;
                IrValueSymbol valueSymbol$iv = null;
                if (value$iv2 instanceof IrGetValue && IrUtilsKt.isImmutable(((IrGetValue)value$iv2).getSymbol().getOwner())) {
                    irTemporary$iv = null;
                    valueSymbol$iv = ((IrGetValue)value$iv2).getSymbol();
                } else {
                    void irType$iv;
                    irTemporary$iv = Scope.createTemporaryVariable$default($this$irLetS_u24default$iv.getScope(), (IrExpression)value$iv2, nameHint$iv, false, null, (IrType)irType$iv, 0, 0, 108, null);
                    valueSymbol$iv = irTemporary$iv.getSymbol();
                }
                IrValueSymbol valueSymbol = valueSymbol$iv;
                boolean bl3 = false;
                IrExpression thenPart = JvmIrTypeUtilsKt.isInlineClassType(valueSymbol.getOwner().getType()) ? this.lowerCast(ExpressionHelpersKt.irGet($this$visitTypeOperator_u24lambda_u2437, valueSymbol.getOwner()), expression2.getTypeOperand()) : (IrExpression)ExpressionHelpersKt.irGet($this$visitTypeOperator_u24lambda_u2437, valueSymbol.getOwner());
                IrExpression irResult$iv = ExpressionHelpersKt.irIfThenElse$default($this$visitTypeOperator_u24lambda_u2437, expression2.getType(), this.lowerInstanceOf(ExpressionHelpersKt.irGet($this$visitTypeOperator_u24lambda_u2437, valueSymbol.getOwner()), IrTypesKt.makeNotNull(expression2.getTypeOperand())), thenPart, ExpressionHelpersKt.irNull($this$visitTypeOperator_u24lambda_u2437, expression2.getType()), null, 16, null);
                if (irTemporary$iv == null) {
                    irExpression = irResult$iv;
                    break;
                }
                IrBlockImpl irBlock$iv = new IrBlockImpl($this$irLetS_u24default$iv.getStartOffset(), $this$irLetS_u24default$iv.getEndOffset(), irResult$iv.getType(), (IrStatementOrigin)origin$iv);
                irBlock$iv.getStatements().add(irTemporary$iv);
                if (irResult$iv instanceof IrStatementContainer) {
                    irBlock$iv.getStatements().addAll((Collection<IrStatement>)((IrStatementContainer)((Object)irResult$iv)).getStatements());
                } else {
                    irBlock$iv.getStatements().add(irResult$iv);
                }
                irExpression = irBlock$iv;
                break;
            }
            case 5: {
                irExpression = this.lowerInstanceOf(this.transformVoid(expression2.getArgument()), expression2.getTypeOperand());
                break;
            }
            case 6: {
                irExpression = LowerUtilsKt.irNot($this$visitTypeOperator_u24lambda_u2437, this.lowerInstanceOf(this.transformVoid(expression2.getArgument()), expression2.getTypeOperand()));
                break;
            }
            case 7: {
                void this_$iv$iv;
                void $this$irComposite_u24default$iv;
                void $this$irLetS_u24default$iv;
                void value$iv;
                String text = this.computeNotNullAssertionText($this$visitTypeOperator_u24lambda_u2437, expression2);
                IrBuilderWithScope value$iv2 = $this$visitTypeOperator_u24lambda_u2437;
                IrExpression origin$iv = this.transformVoid(expression2.getArgument());
                IrType irType$iv = $this$visitTypeOperator_u24lambda_u2437.getContext().getIrBuiltIns().getAnyNType();
                IrStatementOrigin origin$iv2 = null;
                String nameHint$iv = null;
                boolean $i$f$irLetS = false;
                IrVariable irTemporary$iv = null;
                IrValueSymbol valueSymbol$iv = null;
                if (value$iv instanceof IrGetValue && IrUtilsKt.isImmutable(((IrGetValue)value$iv).getSymbol().getOwner())) {
                    irTemporary$iv = null;
                    valueSymbol$iv = ((IrGetValue)value$iv).getSymbol();
                } else {
                    irTemporary$iv = Scope.createTemporaryVariable$default($this$irLetS_u24default$iv.getScope(), (IrExpression)value$iv, nameHint$iv, false, null, irType$iv, 0, 0, 108, null);
                    valueSymbol$iv = irTemporary$iv.getSymbol();
                }
                IrValueSymbol valueSymbol = valueSymbol$iv;
                boolean bl4 = false;
                IrBuilderWithScope irResult$iv = $this$visitTypeOperator_u24lambda_u2437;
                IrType resultType$iv = expression2.getType();
                int startOffset$iv = $this$irComposite_u24default$iv.getStartOffset();
                int endOffset$iv = $this$irComposite_u24default$iv.getEndOffset();
                IrStatementOrigin origin$iv3 = null;
                boolean $i$f$irComposite = false;
                IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irComposite_u24default$iv.getContext(), $this$irComposite_u24default$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv3, resultType$iv, true);
                boolean $i$f$block = false;
                void $this$visitTypeOperator_u24lambda_u2437_u24lambda_u2436_u24lambda_u2435 = this_$iv$iv;
                boolean bl5 = false;
                if (text != null) {
                    void $this$visitTypeOperator_u24lambda_u2437_u24lambda_u2436_u24lambda_u2435_u24lambda_u2433;
                    IrCall irCall;
                    IrCall irCall2 = irCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$visitTypeOperator_u24lambda_u2437_u24lambda_u2436_u24lambda_u2435, this.checkExpressionValueIsNotNull);
                    void var27_51 = $this$visitTypeOperator_u24lambda_u2437_u24lambda_u2436_u24lambda_u2435;
                    boolean bl6 = false;
                    $this$visitTypeOperator_u24lambda_u2437_u24lambda_u2436_u24lambda_u2435_u24lambda_u2433.putValueArgument(0, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$visitTypeOperator_u24lambda_u2437_u24lambda_u2436_u24lambda_u2435, valueSymbol.getOwner()));
                    $this$visitTypeOperator_u24lambda_u2437_u24lambda_u2436_u24lambda_u2435_u24lambda_u2433.putValueArgument(1, ExpressionHelpersKt.irString((IrBuilderWithScope)$this$visitTypeOperator_u24lambda_u2437_u24lambda_u2436_u24lambda_u2435, this.trimForRuntimeAssertion(text)));
                    var27_51.unaryPlus(irCall);
                } else {
                    void $this$visitTypeOperator_u24lambda_u2437_u24lambda_u2436_u24lambda_u2435_u24lambda_u2434;
                    IrCall irCall;
                    IrCall $this$visitTypeOperator_u24lambda_u2437_u24lambda_u2436_u24lambda_u2435_u24lambda_u2433 = irCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$visitTypeOperator_u24lambda_u2437_u24lambda_u2436_u24lambda_u2435, this.backendContext.getIr().getSymbols().getCheckNotNull());
                    void var27_52 = $this$visitTypeOperator_u24lambda_u2437_u24lambda_u2436_u24lambda_u2435;
                    boolean bl7 = false;
                    $this$visitTypeOperator_u24lambda_u2437_u24lambda_u2436_u24lambda_u2435_u24lambda_u2434.putValueArgument(0, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$visitTypeOperator_u24lambda_u2437_u24lambda_u2436_u24lambda_u2435, valueSymbol.getOwner()));
                    var27_52.unaryPlus(irCall);
                }
                $this$visitTypeOperator_u24lambda_u2437_u24lambda_u2436_u24lambda_u2435.unaryPlus(ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$visitTypeOperator_u24lambda_u2437_u24lambda_u2436_u24lambda_u2435, valueSymbol.getOwner()));
                IrExpression irResult$iv2 = this_$iv$iv.doBuild();
                if (irTemporary$iv == null) {
                    irExpression = irResult$iv2;
                    break;
                }
                IrBlockImpl irBlock$iv = new IrBlockImpl($this$irLetS_u24default$iv.getStartOffset(), $this$irLetS_u24default$iv.getEndOffset(), irResult$iv2.getType(), origin$iv2);
                irBlock$iv.getStatements().add(irTemporary$iv);
                if (irResult$iv2 instanceof IrStatementContainer) {
                    irBlock$iv.getStatements().addAll((Collection<IrStatement>)((IrStatementContainer)((Object)irResult$iv2)).getStatements());
                } else {
                    irBlock$iv.getStatements().add(irResult$iv2);
                }
                irExpression = irBlock$iv;
                break;
            }
            default: {
                this.transformChildrenVoid(expression2);
                irExpression = expression2;
            }
        }
        return irExpression;
    }

    private final String computeNotNullAssertionText(IrBuilderWithScope $this$computeNotNullAssertionText, IrTypeOperatorCall typeOperatorCall) {
        Object object;
        CharSequence charSequence;
        IrDeclaration declarationParent;
        if (this.backendContext.getConfig().getNoSourceCodeInNotNullAssertionExceptions()) {
            IrExpression argument2 = typeOperatorCall.getArgument();
            return argument2 instanceof IrCall ? ((IrSimpleFunction)((IrCall)argument2).getSymbol().getOwner()).getName().asString() + "(...)" : (argument2 instanceof IrGetField ? ((IrField)((IrGetField)argument2).getSymbol().getOwner()).getName().asString() : null);
        }
        IrSymbolOwner owner = $this$computeNotNullAssertionText.getScope().getScopeOwnerSymbol().getOwner();
        if (owner instanceof IrFunction && this.isDelegated((IrFunction)owner)) {
            return ((IrFunction)owner).getName().asString() + "(...)";
        }
        IrDeclarationParent irDeclarationParent = ExpressionHelpersKt.getParent($this$computeNotNullAssertionText);
        IrDeclaration irDeclaration2 = declarationParent = irDeclarationParent instanceof IrDeclaration ? (IrDeclaration)((Object)irDeclarationParent) : null;
        if (irDeclaration2 != null) {
            IrDeclaration p0 = irDeclaration2;
            boolean bl = false;
            charSequence = this.sourceViewFor(p0);
        } else {
            charSequence = null;
        }
        CharSequence sourceView = charSequence;
        Pair<Integer, Integer> pair = this.extents(typeOperatorCall);
        int startOffset = ((Number)pair.component1()).intValue();
        int endOffset = ((Number)pair.component2()).intValue();
        CharSequence charSequence2 = sourceView;
        boolean bl = charSequence2 != null ? this.validSourcePosition(charSequence2, startOffset, endOffset) : false;
        if (bl) {
            object = ((Object)sourceView.subSequence(startOffset, endOffset)).toString();
        } else {
            object = declarationParent instanceof IrDeclarationWithName ? (IrDeclarationWithName)declarationParent : null;
            if (object == null || (object = object.getName()) == null || (object = ((Name)object).asString()) == null) {
                object = "Unknown Declaration";
            }
        }
        return object;
    }

    private final String trimForRuntimeAssertion(String $this$trimForRuntimeAssertion) {
        String string2 = StringUtil.trimMiddle($this$trimForRuntimeAssertion, 50);
        Intrinsics.checkNotNullExpressionValue(string2, "trimMiddle(...)");
        return string2;
    }

    private final boolean isDelegated(IrFunction $this$isDelegated) {
        return Intrinsics.areEqual($this$isDelegated.getOrigin(), IrDeclarationOrigin.DELEGATED_PROPERTY_ACCESSOR.INSTANCE) || Intrinsics.areEqual($this$isDelegated.getOrigin(), IrDeclarationOrigin.DELEGATED_MEMBER.INSTANCE);
    }

    private final boolean validSourcePosition(CharSequence $this$validSourcePosition, int startOffset, int endOffset) {
        return (0 <= startOffset ? startOffset < endOffset : false) && endOffset < $this$validSourcePosition.length();
    }

    private final Pair<Integer, Integer> extents(IrElement $this$extents) {
        Ref.IntRef startOffset = new Ref.IntRef();
        startOffset.element = Integer.MAX_VALUE;
        Ref.IntRef endOffset = new Ref.IntRef();
        IrVisitorsKt.acceptVoid($this$extents, new IrElementVisitorVoid(startOffset, endOffset){
            final /* synthetic */ Ref.IntRef $startOffset;
            final /* synthetic */ Ref.IntRef $endOffset;
            {
                this.$startOffset = $startOffset;
                this.$endOffset = $endOffset;
            }

            public void visitElement(@NotNull IrElement element2) {
                Intrinsics.checkNotNullParameter(element2, "element");
                IrVisitorsKt.acceptChildrenVoid(element2, this);
                int n = element2.getStartOffset();
                boolean bl = 0 <= n ? n < this.$startOffset.element : false;
                if (bl) {
                    this.$startOffset.element = element2.getStartOffset();
                }
                if (this.$endOffset.element < element2.getEndOffset()) {
                    this.$endOffset.element = element2.getEndOffset();
                }
            }

            public void visitElement(@NotNull IrElement element2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitElement(this, element2, data2);
            }

            public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration2);
            }

            public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration2, data2);
            }

            public void visitBlock(@NotNull IrBlock expression2) {
                IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2);
            }

            public void visitBlock(@NotNull IrBlock expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2, data2);
            }

            public void visitBlockBody(@NotNull IrBlockBody body2) {
                IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2);
            }

            public void visitBlockBody(@NotNull IrBlockBody body2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2, data2);
            }

            public void visitBody(@NotNull IrBody body2) {
                IrElementVisitorVoid.DefaultImpls.visitBody(this, body2);
            }

            public void visitBody(@NotNull IrBody body2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitBody(this, body2, data2);
            }

            public void visitBranch(@NotNull IrBranch branch) {
                IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch);
            }

            public void visitBranch(@NotNull IrBranch branch, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch, data2);
            }

            public void visitBreak(@NotNull IrBreak jump) {
                IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump);
            }

            public void visitBreak(@NotNull IrBreak jump, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump, data2);
            }

            public void visitBreakContinue(@NotNull IrBreakContinue jump) {
                IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump);
            }

            public void visitBreakContinue(@NotNull IrBreakContinue jump, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump, data2);
            }

            public void visitCall(@NotNull IrCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2);
            }

            public void visitCall(@NotNull IrCall expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2, data2);
            }

            public void visitCallableReference(@NotNull IrCallableReference<?> expression2) {
                IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2);
            }

            public void visitCallableReference(@NotNull IrCallableReference<?> expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2, data2);
            }

            public void visitCatch(@NotNull IrCatch aCatch) {
                IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch);
            }

            public void visitCatch(@NotNull IrCatch aCatch, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch, data2);
            }

            public void visitClass(@NotNull IrClass declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration2);
            }

            public void visitClass(@NotNull IrClass declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration2, data2);
            }

            public void visitClassReference(@NotNull IrClassReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2);
            }

            public void visitClassReference(@NotNull IrClassReference expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2, data2);
            }

            public void visitComposite(@NotNull IrComposite expression2) {
                IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2);
            }

            public void visitComposite(@NotNull IrComposite expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2, data2);
            }

            public void visitConst(@NotNull IrConst<?> expression2) {
                IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2);
            }

            public void visitConst(@NotNull IrConst<?> expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2, data2);
            }

            public void visitConstantArray(@NotNull IrConstantArray expression2) {
                IrElementVisitorVoid.DefaultImpls.visitConstantArray(this, expression2);
            }

            public void visitConstantArray(@NotNull IrConstantArray expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitConstantArray(this, expression2, data2);
            }

            public void visitConstantObject(@NotNull IrConstantObject expression2) {
                IrElementVisitorVoid.DefaultImpls.visitConstantObject(this, expression2);
            }

            public void visitConstantObject(@NotNull IrConstantObject expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitConstantObject(this, expression2, data2);
            }

            public void visitConstantPrimitive(@NotNull IrConstantPrimitive expression2) {
                IrElementVisitorVoid.DefaultImpls.visitConstantPrimitive(this, expression2);
            }

            public void visitConstantPrimitive(@NotNull IrConstantPrimitive expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitConstantPrimitive(this, expression2, data2);
            }

            public void visitConstantValue(@NotNull IrConstantValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitConstantValue(this, expression2);
            }

            public void visitConstantValue(@NotNull IrConstantValue expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitConstantValue(this, expression2, data2);
            }

            public void visitConstructor(@NotNull IrConstructor declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration2);
            }

            public void visitConstructor(@NotNull IrConstructor declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration2, data2);
            }

            public void visitConstructorCall(@NotNull IrConstructorCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression2);
            }

            public void visitConstructorCall(@NotNull IrConstructorCall expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression2, data2);
            }

            public void visitContainerExpression(@NotNull IrContainerExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2);
            }

            public void visitContainerExpression(@NotNull IrContainerExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2, data2);
            }

            public void visitContinue(@NotNull IrContinue jump) {
                IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump);
            }

            public void visitContinue(@NotNull IrContinue jump, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump, data2);
            }

            public void visitDeclaration(@NotNull IrDeclarationBase declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration2);
            }

            public void visitDeclaration(@NotNull IrDeclarationBase declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration2, data2);
            }

            public void visitDeclarationReference(@NotNull IrDeclarationReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2);
            }

            public void visitDeclarationReference(@NotNull IrDeclarationReference expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2, data2);
            }

            public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2);
            }

            public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2, data2);
            }

            public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop2) {
                IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop2);
            }

            public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop2, data2);
            }

            public void visitDynamicExpression(@NotNull IrDynamicExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression2);
            }

            public void visitDynamicExpression(@NotNull IrDynamicExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression2, data2);
            }

            public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression2);
            }

            public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression2, data2);
            }

            public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression2);
            }

            public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression2, data2);
            }

            public void visitElseBranch(@NotNull IrElseBranch branch) {
                IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch);
            }

            public void visitElseBranch(@NotNull IrElseBranch branch, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch, data2);
            }

            public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2);
            }

            public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2, data2);
            }

            public void visitEnumEntry(@NotNull IrEnumEntry declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration2);
            }

            public void visitEnumEntry(@NotNull IrEnumEntry declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration2, data2);
            }

            public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2);
            }

            public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2, data2);
            }

            public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration2);
            }

            public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration2, data2);
            }

            public void visitErrorExpression(@NotNull IrErrorExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2);
            }

            public void visitErrorExpression(@NotNull IrErrorExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2, data2);
            }

            public void visitExpression(@NotNull IrExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2);
            }

            public void visitExpression(@NotNull IrExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2, data2);
            }

            public void visitExpressionBody(@NotNull IrExpressionBody body2) {
                IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2);
            }

            public void visitExpressionBody(@NotNull IrExpressionBody body2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2, data2);
            }

            public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration2);
            }

            public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration2, data2);
            }

            public void visitField(@NotNull IrField declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitField(this, declaration2);
            }

            public void visitField(@NotNull IrField declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitField(this, declaration2, data2);
            }

            public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2);
            }

            public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2, data2);
            }

            public void visitFile(@NotNull IrFile declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration2);
            }

            public void visitFile(@NotNull IrFile declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration2, data2);
            }

            public void visitFunction(@NotNull IrFunction declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration2);
            }

            public void visitFunction(@NotNull IrFunction declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration2, data2);
            }

            public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2);
            }

            public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2, data2);
            }

            public void visitFunctionExpression(@NotNull IrFunctionExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression2);
            }

            public void visitFunctionExpression(@NotNull IrFunctionExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression2, data2);
            }

            public void visitFunctionReference(@NotNull IrFunctionReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2);
            }

            public void visitFunctionReference(@NotNull IrFunctionReference expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2, data2);
            }

            public void visitGetClass(@NotNull IrGetClass expression2) {
                IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2);
            }

            public void visitGetClass(@NotNull IrGetClass expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2, data2);
            }

            public void visitGetEnumValue(@NotNull IrGetEnumValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2);
            }

            public void visitGetEnumValue(@NotNull IrGetEnumValue expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2, data2);
            }

            public void visitGetField(@NotNull IrGetField expression2) {
                IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2);
            }

            public void visitGetField(@NotNull IrGetField expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2, data2);
            }

            public void visitGetObjectValue(@NotNull IrGetObjectValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2);
            }

            public void visitGetObjectValue(@NotNull IrGetObjectValue expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2, data2);
            }

            public void visitGetValue(@NotNull IrGetValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2);
            }

            public void visitGetValue(@NotNull IrGetValue expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2, data2);
            }

            public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2);
            }

            public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2, data2);
            }

            public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration2);
            }

            public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration2, data2);
            }

            public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2);
            }

            public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data2);
            }

            public void visitLoop(@NotNull IrLoop loop2) {
                IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop2);
            }

            public void visitLoop(@NotNull IrLoop loop2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop2, data2);
            }

            public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2) {
                IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2);
            }

            public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2, data2);
            }

            public void visitModuleFragment(@NotNull IrModuleFragment declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration2);
            }

            public void visitModuleFragment(@NotNull IrModuleFragment declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration2, data2);
            }

            public void visitPackageFragment(@NotNull IrPackageFragment declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration2);
            }

            public void visitPackageFragment(@NotNull IrPackageFragment declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration2, data2);
            }

            public void visitProperty(@NotNull IrProperty declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration2);
            }

            public void visitProperty(@NotNull IrProperty declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration2, data2);
            }

            public void visitPropertyReference(@NotNull IrPropertyReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2);
            }

            public void visitPropertyReference(@NotNull IrPropertyReference expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2, data2);
            }

            public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference(this, expression2);
            }

            public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference(this, expression2, data2);
            }

            public void visitReturn(@NotNull IrReturn expression2) {
                IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2);
            }

            public void visitReturn(@NotNull IrReturn expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2, data2);
            }

            public void visitScript(@NotNull IrScript declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitScript(this, declaration2);
            }

            public void visitScript(@NotNull IrScript declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitScript(this, declaration2, data2);
            }

            public void visitSetField(@NotNull IrSetField expression2) {
                IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2);
            }

            public void visitSetField(@NotNull IrSetField expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2, data2);
            }

            public void visitSetValue(@NotNull IrSetValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitSetValue(this, expression2);
            }

            public void visitSetValue(@NotNull IrSetValue expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitSetValue(this, expression2, data2);
            }

            public void visitSimpleFunction(@NotNull IrSimpleFunction declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration2);
            }

            public void visitSimpleFunction(@NotNull IrSimpleFunction declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration2, data2);
            }

            public void visitSingletonReference(@NotNull IrGetSingletonValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2);
            }

            public void visitSingletonReference(@NotNull IrGetSingletonValue expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2, data2);
            }

            public void visitSpreadElement(@NotNull IrSpreadElement spread) {
                IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread);
            }

            public void visitSpreadElement(@NotNull IrSpreadElement spread, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread, data2);
            }

            public void visitStringConcatenation(@NotNull IrStringConcatenation expression2) {
                IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2);
            }

            public void visitStringConcatenation(@NotNull IrStringConcatenation expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2, data2);
            }

            public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2);
            }

            public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2, data2);
            }

            public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2) {
                IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2);
            }

            public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2, data2);
            }

            public void visitSyntheticBody(@NotNull IrSyntheticBody body2) {
                IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2);
            }

            public void visitSyntheticBody(@NotNull IrSyntheticBody body2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2, data2);
            }

            public void visitThrow(@NotNull IrThrow expression2) {
                IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2);
            }

            public void visitThrow(@NotNull IrThrow expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2, data2);
            }

            public void visitTry(@NotNull IrTry aTry) {
                IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry);
            }

            public void visitTry(@NotNull IrTry aTry, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry, data2);
            }

            public void visitTypeAlias(@NotNull IrTypeAlias declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration2);
            }

            public void visitTypeAlias(@NotNull IrTypeAlias declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration2, data2);
            }

            public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2);
            }

            public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2, data2);
            }

            public void visitTypeParameter(@NotNull IrTypeParameter declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration2);
            }

            public void visitTypeParameter(@NotNull IrTypeParameter declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration2, data2);
            }

            public void visitValueAccess(@NotNull IrValueAccessExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitValueAccess(this, expression2);
            }

            public void visitValueAccess(@NotNull IrValueAccessExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitValueAccess(this, expression2, data2);
            }

            public void visitValueParameter(@NotNull IrValueParameter declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration2);
            }

            public void visitValueParameter(@NotNull IrValueParameter declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration2, data2);
            }

            public void visitVararg(@NotNull IrVararg expression2) {
                IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2);
            }

            public void visitVararg(@NotNull IrVararg expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2, data2);
            }

            public void visitVariable(@NotNull IrVariable declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration2);
            }

            public void visitVariable(@NotNull IrVariable declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration2, data2);
            }

            public void visitWhen(@NotNull IrWhen expression2) {
                IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2);
            }

            public void visitWhen(@NotNull IrWhen expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2, data2);
            }

            public void visitWhileLoop(@NotNull IrWhileLoop loop2) {
                IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop2);
            }

            public void visitWhileLoop(@NotNull IrWhileLoop loop2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop2, data2);
            }
        });
        return TuplesKt.to(startOffset.element, endOffset.element);
    }

    private final CharSequence sourceViewFor(IrDeclaration declaration2) {
        Cloneable cloneable2 = JvmIrUtilsKt.getKtFile(JvmIrUtilsKt.getFileParent(declaration2));
        return cloneable2 != null && (cloneable2 = ((PsiFileImpl)cloneable2).getViewProvider()) != null ? cloneable2.getContents() : null;
    }

    private static final IrFunctionAccessExpression generateSerializedLambdaEquals$irGetLambdaProperty(JvmIrBuilder $this_generateSerializedLambdaEquals, IrValueParameter $lambdaParameter, IrSimpleFunction getter2) {
        IrFunctionAccessExpression irFunctionAccessExpression;
        IrFunctionAccessExpression $this$generateSerializedLambdaEquals_u24irGetLambdaProperty_u24lambda_u2419 = irFunctionAccessExpression = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this_generateSerializedLambdaEquals, getter2);
        boolean bl = false;
        $this$generateSerializedLambdaEquals_u24irGetLambdaProperty_u24lambda_u2419.setDispatchReceiver(ExpressionHelpersKt.irGet($this_generateSerializedLambdaEquals, $lambdaParameter));
        return irFunctionAccessExpression;
    }

    private static final Void rewriteIndyLambdaMetafactoryCall$fail(IrCall $call, String message2) {
        throw new AssertionError((Object)(message2 + ", call:\n" + DumpIrTreeKt.dump$default($call, null, 1, null)));
    }

    private static final Void wrapClosureInDynamicCall$fail$27(IrFunctionReference $targetRef, String message2) {
        throw new AssertionError((Object)(message2 + ", targetRef:\n" + DumpIrTreeKt.dump$default($targetRef, null, 1, null)));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R!\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/TypeOperatorLowering$ClassContext;", "", "()V", "serializableMethodRefInfos", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/backend/jvm/lower/TypeOperatorLowering$SerializableMethodRefInfo;", "Lkotlin/collections/ArrayList;", "getSerializableMethodRefInfos", "()Ljava/util/ArrayList;", "backend.jvm.lower"})
    private static final class ClassContext {
        @NotNull
        private final ArrayList<SerializableMethodRefInfo> serializableMethodRefInfos = new ArrayList();

        @NotNull
        public final ArrayList<SerializableMethodRefInfo> getSerializableMethodRefInfos() {
            return this.serializableMethodRefInfos;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/TypeOperatorLowering$DeserializedLambdaInfo;", "", "functionalInterfaceClass", "", "implMethodHandle", "Lorg/jetbrains/org/objectweb/asm/Handle;", "functionalInterfaceMethod", "Lorg/jetbrains/org/objectweb/asm/commons/Method;", "(Ljava/lang/String;Lorg/jetbrains/org/objectweb/asm/Handle;Lorg/jetbrains/org/objectweb/asm/commons/Method;)V", "getFunctionalInterfaceClass", "()Ljava/lang/String;", "getFunctionalInterfaceMethod", "()Lorg/jetbrains/org/objectweb/asm/commons/Method;", "getImplMethodHandle", "()Lorg/jetbrains/org/objectweb/asm/Handle;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "backend.jvm.lower"})
    private static final class DeserializedLambdaInfo {
        @NotNull
        private final String functionalInterfaceClass;
        @NotNull
        private final Handle implMethodHandle;
        @NotNull
        private final Method functionalInterfaceMethod;

        public DeserializedLambdaInfo(@NotNull String functionalInterfaceClass, @NotNull Handle implMethodHandle, @NotNull Method functionalInterfaceMethod) {
            Intrinsics.checkNotNullParameter(functionalInterfaceClass, "functionalInterfaceClass");
            Intrinsics.checkNotNullParameter(implMethodHandle, "implMethodHandle");
            Intrinsics.checkNotNullParameter(functionalInterfaceMethod, "functionalInterfaceMethod");
            this.functionalInterfaceClass = functionalInterfaceClass;
            this.implMethodHandle = implMethodHandle;
            this.functionalInterfaceMethod = functionalInterfaceMethod;
        }

        @NotNull
        public final String getFunctionalInterfaceClass() {
            return this.functionalInterfaceClass;
        }

        @NotNull
        public final Handle getImplMethodHandle() {
            return this.implMethodHandle;
        }

        @NotNull
        public final Method getFunctionalInterfaceMethod() {
            return this.functionalInterfaceMethod;
        }

        @NotNull
        public final String component1() {
            return this.functionalInterfaceClass;
        }

        @NotNull
        public final Handle component2() {
            return this.implMethodHandle;
        }

        @NotNull
        public final Method component3() {
            return this.functionalInterfaceMethod;
        }

        @NotNull
        public final DeserializedLambdaInfo copy(@NotNull String functionalInterfaceClass, @NotNull Handle implMethodHandle, @NotNull Method functionalInterfaceMethod) {
            Intrinsics.checkNotNullParameter(functionalInterfaceClass, "functionalInterfaceClass");
            Intrinsics.checkNotNullParameter(implMethodHandle, "implMethodHandle");
            Intrinsics.checkNotNullParameter(functionalInterfaceMethod, "functionalInterfaceMethod");
            return new DeserializedLambdaInfo(functionalInterfaceClass, implMethodHandle, functionalInterfaceMethod);
        }

        public static /* synthetic */ DeserializedLambdaInfo copy$default(DeserializedLambdaInfo deserializedLambdaInfo, String string2, Handle handle2, Method method, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = deserializedLambdaInfo.functionalInterfaceClass;
            }
            if ((n & 2) != 0) {
                handle2 = deserializedLambdaInfo.implMethodHandle;
            }
            if ((n & 4) != 0) {
                method = deserializedLambdaInfo.functionalInterfaceMethod;
            }
            return deserializedLambdaInfo.copy(string2, handle2, method);
        }

        @NotNull
        public String toString() {
            return "DeserializedLambdaInfo(functionalInterfaceClass=" + this.functionalInterfaceClass + ", implMethodHandle=" + this.implMethodHandle + ", functionalInterfaceMethod=" + this.functionalInterfaceMethod + ')';
        }

        public int hashCode() {
            int result2 = this.functionalInterfaceClass.hashCode();
            result2 = result2 * 31 + this.implMethodHandle.hashCode();
            result2 = result2 * 31 + this.functionalInterfaceMethod.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DeserializedLambdaInfo)) {
                return false;
            }
            DeserializedLambdaInfo deserializedLambdaInfo = (DeserializedLambdaInfo)other;
            if (!Intrinsics.areEqual(this.functionalInterfaceClass, deserializedLambdaInfo.functionalInterfaceClass)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.implMethodHandle, deserializedLambdaInfo.implMethodHandle)) {
                return false;
            }
            return Intrinsics.areEqual(this.functionalInterfaceMethod, deserializedLambdaInfo.functionalInterfaceMethod);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\r\b\u0002\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0006\u0010\f\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\rR\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/TypeOperatorLowering$SerializableMethodRefInfo;", "", "samType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "samMethodSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "implFunSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "instanceFunSymbol", "requiredBridges", "", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "dynamicCallSymbol", "(Lorg/jetbrains/kotlin/ir/types/IrType;Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;Ljava/util/Collection;Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;)V", "getDynamicCallSymbol", "()Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "getImplFunSymbol", "()Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "getInstanceFunSymbol", "getRequiredBridges", "()Ljava/util/Collection;", "getSamMethodSymbol", "getSamType", "()Lorg/jetbrains/kotlin/ir/types/IrType;", "backend.jvm.lower"})
    private static final class SerializableMethodRefInfo {
        @NotNull
        private final IrType samType;
        @NotNull
        private final IrSimpleFunctionSymbol samMethodSymbol;
        @NotNull
        private final IrFunctionSymbol implFunSymbol;
        @NotNull
        private final IrFunctionSymbol instanceFunSymbol;
        @NotNull
        private final Collection<IrSimpleFunction> requiredBridges;
        @NotNull
        private final IrSimpleFunctionSymbol dynamicCallSymbol;

        public SerializableMethodRefInfo(@NotNull IrType samType, @NotNull IrSimpleFunctionSymbol samMethodSymbol, @NotNull IrFunctionSymbol implFunSymbol, @NotNull IrFunctionSymbol instanceFunSymbol, @NotNull Collection<? extends IrSimpleFunction> requiredBridges, @NotNull IrSimpleFunctionSymbol dynamicCallSymbol) {
            Intrinsics.checkNotNullParameter(samType, "samType");
            Intrinsics.checkNotNullParameter(samMethodSymbol, "samMethodSymbol");
            Intrinsics.checkNotNullParameter(implFunSymbol, "implFunSymbol");
            Intrinsics.checkNotNullParameter(instanceFunSymbol, "instanceFunSymbol");
            Intrinsics.checkNotNullParameter(requiredBridges, "requiredBridges");
            Intrinsics.checkNotNullParameter(dynamicCallSymbol, "dynamicCallSymbol");
            this.samType = samType;
            this.samMethodSymbol = samMethodSymbol;
            this.implFunSymbol = implFunSymbol;
            this.instanceFunSymbol = instanceFunSymbol;
            this.requiredBridges = requiredBridges;
            this.dynamicCallSymbol = dynamicCallSymbol;
        }

        @NotNull
        public final IrType getSamType() {
            return this.samType;
        }

        @NotNull
        public final IrSimpleFunctionSymbol getSamMethodSymbol() {
            return this.samMethodSymbol;
        }

        @NotNull
        public final IrFunctionSymbol getImplFunSymbol() {
            return this.implFunSymbol;
        }

        @NotNull
        public final IrFunctionSymbol getInstanceFunSymbol() {
            return this.instanceFunSymbol;
        }

        @NotNull
        public final Collection<IrSimpleFunction> getRequiredBridges() {
            return this.requiredBridges;
        }

        @NotNull
        public final IrSimpleFunctionSymbol getDynamicCallSymbol() {
            return this.dynamicCallSymbol;
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[IrTypeOperator.values().length];
            try {
                nArray[IrTypeOperator.IMPLICIT_COERCION_TO_UNIT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.IMPLICIT_INTEGER_COERCION.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.CAST.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.SAFE_CAST.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.INSTANCEOF.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.NOT_INSTANCEOF.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.IMPLICIT_NOTNULL.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

