/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.jvm.LeafMfvcNode;
import org.jetbrains.kotlin.backend.jvm.MfvcNode;
import org.jetbrains.kotlin.backend.jvm.MfvcNodeInstance;
import org.jetbrains.kotlin.backend.jvm.MfvcNodeInstanceKt;
import org.jetbrains.kotlin.backend.jvm.MfvcNodeKt;
import org.jetbrains.kotlin.backend.jvm.MfvcNodeWithSubnodes;
import org.jetbrains.kotlin.backend.jvm.NameableMfvcNode;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.impl.IrSetValueImpl;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0016\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u0002`\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0002\u0010\fJ\u0013\u0010\u0017\u001a\u0004\u0018\u00010\u00002\u0006\u0010\u0018\u001a\u00020\u0019H\u0096\u0002J,\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\n2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!H\u0016J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\n2\u0006\u0010\u001c\u001a\u00020#H\u0002J&\u0010$\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020#2\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!H\u0016J$\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\n2\u0006\u0010\u001c\u001a\u00020#2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001b0\nH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R$\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u0002`\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/backend/jvm/ValueDeclarationMfvcNodeInstance;", "Lorg/jetbrains/kotlin/backend/jvm/MfvcNodeInstance;", "node", "Lorg/jetbrains/kotlin/backend/jvm/MfvcNode;", "typeArguments", "", "Lorg/jetbrains/kotlin/ir/symbols/IrTypeParameterSymbol;", "Lorg/jetbrains/kotlin/ir/types/IrType;", "Lorg/jetbrains/kotlin/backend/jvm/TypeArguments;", "valueDeclarations", "", "Lorg/jetbrains/kotlin/ir/declarations/IrValueDeclaration;", "(Lorg/jetbrains/kotlin/backend/jvm/MfvcNode;Ljava/util/Map;Ljava/util/List;)V", "getNode", "()Lorg/jetbrains/kotlin/backend/jvm/MfvcNode;", "type", "Lorg/jetbrains/kotlin/ir/types/IrSimpleType;", "getType", "()Lorg/jetbrains/kotlin/ir/types/IrSimpleType;", "getTypeArguments", "()Ljava/util/Map;", "getValueDeclarations", "()Ljava/util/List;", "get", "name", "Lorg/jetbrains/kotlin/name/Name;", "makeFlattenedGetterExpressions", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "scope", "Lorg/jetbrains/kotlin/ir/builders/IrBlockBuilder;", "currentClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "registerPossibleExtraBoxCreation", "Lkotlin/Function0;", "", "Lorg/jetbrains/kotlin/ir/builders/IrBuilderWithScope;", "makeGetterExpression", "makeSetterStatements", "Lorg/jetbrains/kotlin/ir/IrStatement;", "values", "backend.jvm"})
@SourceDebugExtension(value={"SMAP\nMfvcNodeInstance.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MfvcNodeInstance.kt\norg/jetbrains/kotlin/backend/jvm/ValueDeclarationMfvcNodeInstance\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,330:1\n1#2:331\n1549#3:332\n1620#3,3:333\n3433#3,7:336\n*S KotlinDebug\n*F\n+ 1 MfvcNodeInstance.kt\norg/jetbrains/kotlin/backend/jvm/ValueDeclarationMfvcNodeInstance\n*L\n92#1:332\n92#1:333,3\n108#1:336,7\n*E\n"})
public final class ValueDeclarationMfvcNodeInstance
implements MfvcNodeInstance {
    @NotNull
    private final MfvcNode node;
    @NotNull
    private final Map<IrTypeParameterSymbol, IrType> typeArguments;
    @NotNull
    private final List<IrValueDeclaration> valueDeclarations;
    @NotNull
    private final IrSimpleType type;

    public ValueDeclarationMfvcNodeInstance(@NotNull MfvcNode node, @NotNull Map<IrTypeParameterSymbol, ? extends IrType> typeArguments2, @NotNull List<? extends IrValueDeclaration> valueDeclarations) {
        Intrinsics.checkNotNullParameter(node, "node");
        Intrinsics.checkNotNullParameter(typeArguments2, "typeArguments");
        Intrinsics.checkNotNullParameter(valueDeclarations, "valueDeclarations");
        this.node = node;
        this.typeArguments = typeArguments2;
        this.valueDeclarations = valueDeclarations;
        if (!(this.valueDeclarations.size() == MfvcNodeInstanceKt.getSize(this))) {
            boolean bl = false;
            String string2 = "Expected value declarations list of size " + MfvcNodeInstanceKt.getSize(this) + " but got of size " + this.valueDeclarations.size();
            throw new IllegalArgumentException(string2.toString());
        }
        this.type = MfvcNodeInstanceKt.access$makeTypeFromMfvcNodeAndTypeArguments(this.getNode(), this.getTypeArguments());
    }

    @Override
    @NotNull
    public MfvcNode getNode() {
        return this.node;
    }

    @Override
    @NotNull
    public Map<IrTypeParameterSymbol, IrType> getTypeArguments() {
        return this.typeArguments;
    }

    @NotNull
    public final List<IrValueDeclaration> getValueDeclarations() {
        return this.valueDeclarations;
    }

    @Override
    @NotNull
    public IrSimpleType getType() {
        return this.type;
    }

    @Override
    @NotNull
    public List<IrExpression> makeFlattenedGetterExpressions(@NotNull IrBlockBuilder scope2, @NotNull IrClass currentClass, @NotNull Function0<Unit> registerPossibleExtraBoxCreation) {
        Intrinsics.checkNotNullParameter(scope2, "scope");
        Intrinsics.checkNotNullParameter(currentClass, "currentClass");
        Intrinsics.checkNotNullParameter(registerPossibleExtraBoxCreation, "registerPossibleExtraBoxCreation");
        return this.makeFlattenedGetterExpressions(scope2);
    }

    /*
     * WARNING - void declaration
     */
    private final List<IrExpression> makeFlattenedGetterExpressions(IrBuilderWithScope scope2) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.valueDeclarations;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrValueDeclaration irValueDeclaration = (IrValueDeclaration)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(ExpressionHelpersKt.irGet(scope2, (IrValueDeclaration)it));
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public IrExpression makeGetterExpression(@NotNull IrBuilderWithScope scope2, @NotNull IrClass currentClass, @NotNull Function0<Unit> registerPossibleExtraBoxCreation) {
        IrExpression irExpression;
        Intrinsics.checkNotNullParameter(scope2, "scope");
        Intrinsics.checkNotNullParameter(currentClass, "currentClass");
        Intrinsics.checkNotNullParameter(registerPossibleExtraBoxCreation, "registerPossibleExtraBoxCreation");
        MfvcNode mfvcNode = this.getNode();
        if (mfvcNode instanceof LeafMfvcNode) {
            irExpression = CollectionsKt.single(this.makeFlattenedGetterExpressions(scope2));
        } else if (mfvcNode instanceof MfvcNodeWithSubnodes) {
            irExpression = MfvcNodeKt.makeBoxedExpression((MfvcNodeWithSubnodes)this.getNode(), scope2, this.getTypeArguments(), this.makeFlattenedGetterExpressions(scope2), registerPossibleExtraBoxCreation);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return irExpression;
    }

    @Override
    @Nullable
    public ValueDeclarationMfvcNodeInstance get(@NotNull Name name2) {
        Intrinsics.checkNotNullParameter(name2, "name");
        Pair<NameableMfvcNode, IntRange> pair = MfvcNodeKt.getSubnodeAndIndices(this.getNode(), name2);
        if (pair == null) {
            return null;
        }
        Pair<NameableMfvcNode, IntRange> pair2 = pair;
        NameableMfvcNode newNode = pair2.component1();
        IntRange indices = pair2.component2();
        return new ValueDeclarationMfvcNodeInstance(newNode, this.getTypeArguments(), CollectionsKt.slice(this.valueDeclarations, indices));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<IrStatement> makeSetterStatements(@NotNull IrBuilderWithScope scope2, @NotNull List<? extends IrExpression> values2) {
        Intrinsics.checkNotNullParameter(scope2, "scope");
        Intrinsics.checkNotNullParameter(values2, "values");
        MfvcNodeInstanceKt.access$checkValuesCount(this, values2);
        Iterable $this$zip$iv = this.valueDeclarations;
        boolean $i$f$zip = false;
        Iterator first$iv = $this$zip$iv.iterator();
        Iterator second$iv = ((Iterable)values2).iterator();
        ArrayList<IrSetValueImpl> list$iv = new ArrayList<IrSetValueImpl>(Math.min(CollectionsKt.collectionSizeOrDefault($this$zip$iv, 10), CollectionsKt.collectionSizeOrDefault((Iterable)values2, 10)));
        while (first$iv.hasNext() && second$iv.hasNext()) {
            void value2;
            void declaration2;
            IrExpression irExpression = (IrExpression)second$iv.next();
            IrValueDeclaration irValueDeclaration = (IrValueDeclaration)first$iv.next();
            ArrayList<IrSetValueImpl> arrayList = list$iv;
            boolean bl = false;
            arrayList.add(ExpressionHelpersKt.irSet$default(scope2, (IrValueDeclaration)declaration2, (IrExpression)value2, null, 4, null));
        }
        return list$iv;
    }
}

