/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.actualizer;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtDiagnosticReporterWithImplicitIrBasedContext;
import org.jetbrains.kotlin.backend.common.actualizer.ActualDeclarationsCollector;
import org.jetbrains.kotlin.backend.common.actualizer.ClassActualizationInfo;
import org.jetbrains.kotlin.backend.common.actualizer.ExpectActualLinkCollector;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrTypeSystemContext;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0015B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u000b\u001a\u00020\fJ\b\u0010\r\u001a\u00020\u000eH\u0002J$\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u000eH\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/backend/common/actualizer/ExpectActualCollector;", "", "mainFragment", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "dependentFragments", "", "typeSystemContext", "Lorg/jetbrains/kotlin/ir/types/IrTypeSystemContext;", "diagnosticsReporter", "Lorg/jetbrains/kotlin/KtDiagnosticReporterWithImplicitIrBasedContext;", "(Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;Ljava/util/List;Lorg/jetbrains/kotlin/ir/types/IrTypeSystemContext;Lorg/jetbrains/kotlin/KtDiagnosticReporterWithImplicitIrBasedContext;)V", "collect", "Lorg/jetbrains/kotlin/backend/common/actualizer/ExpectActualCollector$Result;", "collectActualDeclarations", "Lorg/jetbrains/kotlin/backend/common/actualizer/ClassActualizationInfo;", "matchAllExpectDeclarations", "", "destination", "", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "classActualizationInfo", "Result", "ir.backend.common"})
@SourceDebugExtension(value={"SMAP\nExpectActualCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExpectActualCollector.kt\norg/jetbrains/kotlin/backend/common/actualizer/ExpectActualCollector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,238:1\n1855#2,2:239\n*S KotlinDebug\n*F\n+ 1 ExpectActualCollector.kt\norg/jetbrains/kotlin/backend/common/actualizer/ExpectActualCollector\n*L\n65#1:239,2\n*E\n"})
public final class ExpectActualCollector {
    @NotNull
    private final IrModuleFragment mainFragment;
    @NotNull
    private final List<IrModuleFragment> dependentFragments;
    @NotNull
    private final IrTypeSystemContext typeSystemContext;
    @NotNull
    private final KtDiagnosticReporterWithImplicitIrBasedContext diagnosticsReporter;

    public ExpectActualCollector(@NotNull IrModuleFragment mainFragment, @NotNull List<? extends IrModuleFragment> dependentFragments, @NotNull IrTypeSystemContext typeSystemContext2, @NotNull KtDiagnosticReporterWithImplicitIrBasedContext diagnosticsReporter) {
        Intrinsics.checkNotNullParameter(mainFragment, "mainFragment");
        Intrinsics.checkNotNullParameter(dependentFragments, "dependentFragments");
        Intrinsics.checkNotNullParameter(typeSystemContext2, "typeSystemContext");
        Intrinsics.checkNotNullParameter(diagnosticsReporter, "diagnosticsReporter");
        this.mainFragment = mainFragment;
        this.dependentFragments = dependentFragments;
        this.typeSystemContext = typeSystemContext2;
        this.diagnosticsReporter = diagnosticsReporter;
    }

    @NotNull
    public final Result collect() {
        Map result2 = new LinkedHashMap();
        ClassActualizationInfo actualDeclarations = this.collectActualDeclarations();
        this.matchAllExpectDeclarations(result2, actualDeclarations);
        return new Result(result2, actualDeclarations);
    }

    private final ClassActualizationInfo collectActualDeclarations() {
        List<IrModuleFragment> fragmentsWithActuals = CollectionsKt.plus((Collection)CollectionsKt.drop((Iterable)this.dependentFragments, 1), this.mainFragment);
        return ActualDeclarationsCollector.Companion.collectActualsFromFragments(fragmentsWithActuals);
    }

    private final void matchAllExpectDeclarations(Map<IrSymbol, IrSymbol> destination, ClassActualizationInfo classActualizationInfo) {
        ExpectActualLinkCollector linkCollector = new ExpectActualLinkCollector(destination, classActualizationInfo, this.typeSystemContext, this.diagnosticsReporter);
        Iterable $this$forEach$iv = this.dependentFragments;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrModuleFragment it = (IrModuleFragment)element$iv;
            boolean bl = false;
            linkCollector.visitModuleFragment(it);
        }
        linkCollector.visitModuleFragment(this.mainFragment);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0015\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0006H\u00c6\u0003J)\u0010\u000e\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/backend/common/actualizer/ExpectActualCollector$Result;", "", "expectToActualMap", "", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "classActualizationInfo", "Lorg/jetbrains/kotlin/backend/common/actualizer/ClassActualizationInfo;", "(Ljava/util/Map;Lorg/jetbrains/kotlin/backend/common/actualizer/ClassActualizationInfo;)V", "getClassActualizationInfo", "()Lorg/jetbrains/kotlin/backend/common/actualizer/ClassActualizationInfo;", "getExpectToActualMap", "()Ljava/util/Map;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "ir.backend.common"})
    public static final class Result {
        @NotNull
        private final Map<IrSymbol, IrSymbol> expectToActualMap;
        @NotNull
        private final ClassActualizationInfo classActualizationInfo;

        public Result(@NotNull Map<IrSymbol, IrSymbol> expectToActualMap, @NotNull ClassActualizationInfo classActualizationInfo) {
            Intrinsics.checkNotNullParameter(expectToActualMap, "expectToActualMap");
            Intrinsics.checkNotNullParameter(classActualizationInfo, "classActualizationInfo");
            this.expectToActualMap = expectToActualMap;
            this.classActualizationInfo = classActualizationInfo;
        }

        @NotNull
        public final Map<IrSymbol, IrSymbol> getExpectToActualMap() {
            return this.expectToActualMap;
        }

        @NotNull
        public final ClassActualizationInfo getClassActualizationInfo() {
            return this.classActualizationInfo;
        }

        @NotNull
        public final Map<IrSymbol, IrSymbol> component1() {
            return this.expectToActualMap;
        }

        @NotNull
        public final ClassActualizationInfo component2() {
            return this.classActualizationInfo;
        }

        @NotNull
        public final Result copy(@NotNull Map<IrSymbol, IrSymbol> expectToActualMap, @NotNull ClassActualizationInfo classActualizationInfo) {
            Intrinsics.checkNotNullParameter(expectToActualMap, "expectToActualMap");
            Intrinsics.checkNotNullParameter(classActualizationInfo, "classActualizationInfo");
            return new Result(expectToActualMap, classActualizationInfo);
        }

        public static /* synthetic */ Result copy$default(Result result2, Map map, ClassActualizationInfo classActualizationInfo, int n, Object object) {
            if ((n & 1) != 0) {
                map = result2.expectToActualMap;
            }
            if ((n & 2) != 0) {
                classActualizationInfo = result2.classActualizationInfo;
            }
            return result2.copy(map, classActualizationInfo);
        }

        @NotNull
        public String toString() {
            return "Result(expectToActualMap=" + this.expectToActualMap + ", classActualizationInfo=" + this.classActualizationInfo + ')';
        }

        public int hashCode() {
            int result2 = ((Object)this.expectToActualMap).hashCode();
            result2 = result2 * 31 + this.classActualizationInfo.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Result)) {
                return false;
            }
            Result result2 = (Result)other;
            if (!Intrinsics.areEqual(this.expectToActualMap, result2.expectToActualMap)) {
                return false;
            }
            return Intrinsics.areEqual(this.classActualizationInfo, result2.classActualizationInfo);
        }
    }
}

