/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.analysis.low.level.api.fir.LLFirModuleResolveComponents;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.FirDesignationKt;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.FirDesignationWithFile;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.targets.LLFirClassWithSpecificMembersResolveTarget;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.ClassDeclarationStructureElement;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.DeclarationStructureElement;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.FileStructureElement;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.RootScriptStructureElement;
import org.jetbrains.kotlin.fir.declarations.FirDanglingModifierList;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirField;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirScript;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.impl.FirPrimaryConstructor;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/FileElementFactory;", "", "()V", "createFileStructureElement", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/FileStructureElement;", "firDeclaration", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "firFile", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "moduleComponents", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/LLFirModuleResolveComponents;", "lazyResolveClassWithGeneratedMembers", "", "firClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "low-level-api-fir"})
public final class FileElementFactory {
    @NotNull
    public static final FileElementFactory INSTANCE = new FileElementFactory();

    private FileElementFactory() {
    }

    @NotNull
    public final FileStructureElement createFileStructureElement(@NotNull FirDeclaration firDeclaration, @NotNull FirFile firFile, @NotNull LLFirModuleResolveComponents moduleComponents) {
        FileStructureElement fileStructureElement;
        Intrinsics.checkNotNullParameter(firDeclaration, "firDeclaration");
        Intrinsics.checkNotNullParameter(firFile, "firFile");
        Intrinsics.checkNotNullParameter(moduleComponents, "moduleComponents");
        if (firDeclaration instanceof FirRegularClass) {
            this.lazyResolveClassWithGeneratedMembers((FirRegularClass)firDeclaration, moduleComponents);
            fileStructureElement = new ClassDeclarationStructureElement(firFile, (FirRegularClass)firDeclaration, moduleComponents);
        } else {
            fileStructureElement = firDeclaration instanceof FirScript ? (FileStructureElement)new RootScriptStructureElement(firFile, (FirScript)firDeclaration, moduleComponents) : (FileStructureElement)new DeclarationStructureElement(firFile, firDeclaration, moduleComponents);
        }
        return fileStructureElement;
    }

    private final void lazyResolveClassWithGeneratedMembers(FirRegularClass firClass, LLFirModuleResolveComponents moduleComponents) {
        List<FirDeclaration> list2;
        List<FirDeclaration> $this$lazyResolveClassWithGeneratedMembers_u24lambda_u240 = list2 = CollectionsKt.createListBuilder();
        boolean bl = false;
        for (FirDeclaration member2 : firClass.getDeclarations()) {
            if (member2 instanceof FirSimpleFunction) {
                KtSourceElement ktSourceElement = member2.getSource();
                if (Intrinsics.areEqual(ktSourceElement != null ? ktSourceElement.getKind() : null, KtFakeSourceElementKind.DataClassGeneratedMembers.INSTANCE)) {
                    $this$lazyResolveClassWithGeneratedMembers_u24lambda_u240.add(member2);
                    continue;
                }
            }
            if (member2 instanceof FirPrimaryConstructor) {
                KtSourceElement ktSourceElement = member2.getSource();
                if (Intrinsics.areEqual(ktSourceElement != null ? ktSourceElement.getKind() : null, KtFakeSourceElementKind.ImplicitConstructor.INSTANCE)) {
                    $this$lazyResolveClassWithGeneratedMembers_u24lambda_u240.add(member2);
                    continue;
                }
            }
            if (member2 instanceof FirProperty) {
                KtSourceElement ktSourceElement = member2.getSource();
                if (Intrinsics.areEqual(ktSourceElement != null ? ktSourceElement.getKind() : null, KtFakeSourceElementKind.PropertyFromParameter.INSTANCE)) {
                    $this$lazyResolveClassWithGeneratedMembers_u24lambda_u240.add(member2);
                    continue;
                }
            }
            if (member2 instanceof FirField) {
                KtSourceElement ktSourceElement = member2.getSource();
                if (Intrinsics.areEqual(ktSourceElement != null ? ktSourceElement.getKind() : null, KtFakeSourceElementKind.ClassDelegationField.INSTANCE)) {
                    $this$lazyResolveClassWithGeneratedMembers_u24lambda_u240.add(member2);
                    continue;
                }
            }
            if (!(member2 instanceof FirDanglingModifierList)) continue;
            $this$lazyResolveClassWithGeneratedMembers_u24lambda_u240.add(member2);
        }
        List classMembersToResolve = CollectionsKt.build(list2);
        FirDesignationWithFile firClassDesignation = FirDesignationKt.collectDesignationWithFile(firClass);
        LLFirClassWithSpecificMembersResolveTarget designationWithMembers = new LLFirClassWithSpecificMembersResolveTarget(firClassDesignation.getFirFile(), firClassDesignation.getPath(), firClass, classMembersToResolve);
        moduleComponents.getFirModuleLazyDeclarationResolver().lazyResolveTarget(designationWithMembers, FirResolvePhase.BODY_RESOLVE, null);
    }
}

