/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.patterns;

import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PsiClassNamePatternCondition;
import com.intellij.patterns.PsiMemberPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PsiClassPattern
extends PsiMemberPattern<PsiClass, PsiClassPattern> {
    protected PsiClassPattern() {
        super(PsiClass.class);
    }

    public PsiClassPattern inheritorOf(final boolean strict, final PsiClassPattern pattern) {
        return (PsiClassPattern)this.with(new PatternCondition<PsiClass>("inheritorOf"){

            @Override
            public boolean accepts(@NotNull PsiClass psiClass, ProcessingContext context2) {
                if (psiClass == null) {
                    1.$$$reportNull$$$0(0);
                }
                return PsiClassPattern.isInheritor(psiClass, pattern, context2, !strict);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/patterns/PsiClassPattern$1", "accepts"));
            }
        });
    }

    private static boolean isInheritor(PsiClass psiClass, ElementPattern pattern, ProcessingContext matchingContext, boolean checkThisClass) {
        if (psiClass == null) {
            return false;
        }
        if (checkThisClass && pattern.accepts(psiClass, matchingContext)) {
            return true;
        }
        if (PsiClassPattern.isInheritor(psiClass.getSuperClass(), pattern, matchingContext, true)) {
            return true;
        }
        for (PsiClass aClass : psiClass.getInterfaces()) {
            if (!PsiClassPattern.isInheritor(aClass, pattern, matchingContext, true)) continue;
            return true;
        }
        return false;
    }

    public PsiClassPattern inheritorOf(final boolean strict, final String className) {
        return (PsiClassPattern)this.with(new PatternCondition<PsiClass>("inheritorOf"){

            @Override
            public boolean accepts(@NotNull PsiClass psiClass, ProcessingContext context2) {
                if (psiClass == null) {
                    2.$$$reportNull$$$0(0);
                }
                return InheritanceUtil.isInheritor(psiClass, strict, className);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/patterns/PsiClassPattern$2", "accepts"));
            }
        });
    }

    public PsiClassPattern isInterface() {
        return (PsiClassPattern)this.with(new PatternCondition<PsiClass>("isInterface"){

            @Override
            public boolean accepts(@NotNull PsiClass psiClass, ProcessingContext context2) {
                if (psiClass == null) {
                    3.$$$reportNull$$$0(0);
                }
                return psiClass.isInterface();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/patterns/PsiClassPattern$3", "accepts"));
            }
        });
    }

    public PsiClassPattern isAnnotationType() {
        return (PsiClassPattern)this.with(new PatternCondition<PsiClass>("isAnnotationType"){

            @Override
            public boolean accepts(@NotNull PsiClass psiClass, ProcessingContext context2) {
                if (psiClass == null) {
                    4.$$$reportNull$$$0(0);
                }
                return psiClass.isAnnotationType();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/patterns/PsiClassPattern$4", "accepts"));
            }
        });
    }

    public PsiClassPattern withMethod(final boolean checkDeep, final ElementPattern<? extends PsiMethod> memberPattern) {
        return (PsiClassPattern)this.with(new PatternCondition<PsiClass>("withMethod"){

            @Override
            public boolean accepts(@NotNull PsiClass psiClass, ProcessingContext context2) {
                if (psiClass == null) {
                    5.$$$reportNull$$$0(0);
                }
                for (PsiMethod method : checkDeep ? psiClass.getAllMethods() : psiClass.getMethods()) {
                    if (!memberPattern.accepts(method, context2)) continue;
                    return true;
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/patterns/PsiClassPattern$5", "accepts"));
            }
        });
    }

    public PsiClassPattern withField(final boolean checkDeep, final ElementPattern<? extends PsiField> memberPattern) {
        return (PsiClassPattern)this.with(new PatternCondition<PsiClass>("withField"){

            @Override
            public boolean accepts(@NotNull PsiClass psiClass, ProcessingContext context2) {
                if (psiClass == null) {
                    6.$$$reportNull$$$0(0);
                }
                for (PsiField field2 : checkDeep ? psiClass.getAllFields() : psiClass.getFields()) {
                    if (!memberPattern.accepts(field2, context2)) continue;
                    return true;
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/patterns/PsiClassPattern$6", "accepts"));
            }
        });
    }

    public PsiClassPattern nonAnnotationType() {
        return (PsiClassPattern)this.with(new PatternCondition<PsiClass>("nonAnnotationType"){

            @Override
            public boolean accepts(@NotNull PsiClass psiClass, ProcessingContext context2) {
                if (psiClass == null) {
                    7.$$$reportNull$$$0(0);
                }
                return !psiClass.isAnnotationType();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/patterns/PsiClassPattern$7", "accepts"));
            }
        });
    }

    public PsiClassPattern withQualifiedName(@NonNls @NotNull String qname) {
        if (qname == null) {
            PsiClassPattern.$$$reportNull$$$0(0);
        }
        return (PsiClassPattern)this.with(new PsiClassNamePatternCondition((ElementPattern<String>)StandardPatterns.string().equalTo(qname)));
    }

    public PsiClassPattern withQualifiedName(@NonNls @NotNull ElementPattern<String> qname) {
        if (qname == null) {
            PsiClassPattern.$$$reportNull$$$0(1);
        }
        return (PsiClassPattern)this.with(new PsiClassNamePatternCondition(qname));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qname", "com/intellij/patterns/PsiClassPattern", "withQualifiedName"));
    }
}

