/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.jvm.checkers.expression;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.jvm.FirJvmErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.expressions.FirAnonymousFunctionExpression;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/jvm/checkers/expression/FirJvmSuspensionPointInsideMutexLockChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirFunctionCallChecker;", "()V", "synchronizedCallableId", "Lorg/jetbrains/kotlin/name/CallableId;", "withLockCallableId", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers.jvm"})
@SourceDebugExtension(value={"SMAP\nFirJvmSuspensionPointInsideMutexLockChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJvmSuspensionPointInsideMutexLockChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/expression/FirJvmSuspensionPointInsideMutexLockChecker\n+ 2 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 3 CheckerContext.kt\norg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContextKt\n+ 4 CheckerContext.kt\norg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContextKt$findClosest$1\n+ 5 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n*L\n1#1,51:1\n37#2:52\n86#3,3:53\n91#3:57\n86#4:56\n46#5:58\n*S KotlinDebug\n*F\n+ 1 FirJvmSuspensionPointInsideMutexLockChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/expression/FirJvmSuspensionPointInsideMutexLockChecker\n*L\n28#1:52\n29#1:53,3\n29#1:57\n29#1:56\n35#1:58\n*E\n"})
public final class FirJvmSuspensionPointInsideMutexLockChecker
extends FirExpressionChecker<FirFunctionCall> {
    @NotNull
    public static final FirJvmSuspensionPointInsideMutexLockChecker INSTANCE = new FirJvmSuspensionPointInsideMutexLockChecker();
    @NotNull
    private static final CallableId synchronizedCallableId;
    @NotNull
    private static final CallableId withLockCallableId;

    private FirJvmSuspensionPointInsideMutexLockChecker() {
    }

    @Override
    public void check(@NotNull FirFunctionCall expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        FirElement firElement;
        FirCallableSymbol symbol2;
        block11: {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            Intrinsics.checkNotNullParameter(context2, "context");
            Intrinsics.checkNotNullParameter(reporter, "reporter");
            FirCallableSymbol firCallableSymbol = FirReferenceUtilsKt.toResolvedCallableSymbol$default(expression2.getCalleeReference(), false, 1, null);
            if (firCallableSymbol == null) {
                return;
            }
            FirCallableSymbol $this$isSuspend$iv = symbol2 = firCallableSymbol;
            boolean $i$f$isSuspend = false;
            if (!$this$isSuspend$iv.getRawStatus().isSuspend()) {
                return;
            }
            CheckerContext $this$findClosest_u24default$iv = context2;
            boolean $i$f$findClosest = false;
            for (FirDeclaration it$iv : CollectionsKt.asReversed($this$findClosest_u24default$iv.getContainingDeclarations())) {
                FirElement firElement2;
                FirDeclaration firDeclaration = it$iv;
                if (!(firDeclaration instanceof FirAnonymousFunction)) {
                    firDeclaration = null;
                }
                if ((firElement = (FirElement)((FirAnonymousFunction)firDeclaration)) == null) continue;
                FirElement firElement3 = firElement2 = firElement;
                boolean bl = false;
                FirElement it = firElement3;
                firElement = true ? firElement2 : null;
                if (firElement == null) {
                    continue;
                }
                break block11;
            }
            firElement = null;
        }
        FirAnonymousFunction firAnonymousFunction = (FirAnonymousFunction)firElement;
        if (firAnonymousFunction == null) {
            return;
        }
        FirAnonymousFunction closestAnonymousFunction = firAnonymousFunction;
        for (FirStatement call2 : CollectionsKt.asReversed(context2.getCallsOrAssignments())) {
            FirCallableSymbol callableSymbol;
            if (!(call2 instanceof FirFunctionCall) || FirReferenceUtilsKt.toResolvedCallableSymbol$default(((FirFunctionCall)call2).getCalleeReference(), false, 1, null) == null) continue;
            if (Intrinsics.areEqual(callableSymbol.getCallableId(), synchronizedCallableId)) {
                int n;
                FirCall $this$arguments$iv = (FirCall)call2;
                boolean $i$f$getArguments = false;
                List<FirExpression> list2 = $this$arguments$iv.getArgumentList().getArguments();
                FirExpression firExpression2 = CollectionsKt.getOrNull(list2, n = 1);
                if (firExpression2 == null || (firExpression2 = FirExpressionUtilKt.unwrapArgument(firExpression2)) == null) {
                    return;
                }
                FirExpression unwrappedFirstArgument = firExpression2;
                FirPureAbstractElement firPureAbstractElement = unwrappedFirstArgument instanceof FirAnonymousFunctionExpression ? (FirAnonymousFunctionExpression)unwrappedFirstArgument : null;
                if (firPureAbstractElement == null || (firPureAbstractElement = firPureAbstractElement.getAnonymousFunction()) == null) {
                    return;
                }
                FirPureAbstractElement firstArgumentAnonymousFunction = firPureAbstractElement;
                if (Intrinsics.areEqual(closestAnonymousFunction, firstArgumentAnonymousFunction)) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirJvmErrors.INSTANCE.getSUSPENSION_POINT_INSIDE_CRITICAL_SECTION(), (Object)symbol2, (DiagnosticContext)context2, null, 16, null);
                }
                return;
            }
            if (!Intrinsics.areEqual(callableSymbol.getCallableId(), withLockCallableId)) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirJvmErrors.INSTANCE.getSUSPENSION_POINT_INSIDE_CRITICAL_SECTION(), (Object)symbol2, (DiagnosticContext)context2, null, 16, null);
            return;
        }
    }

    static {
        FqName fqName2 = new FqName("kotlin");
        Name name2 = Name.identifier("synchronized");
        Intrinsics.checkNotNullExpressionValue(name2, "identifier(...)");
        synchronizedCallableId = new CallableId(fqName2, name2);
        FqName fqName3 = new FqName("kotlin.concurrent");
        Name name3 = Name.identifier("withLock");
        Intrinsics.checkNotNullExpressionValue(name3, "identifier(...)");
        withLockCallableId = new CallableId(fqName3, name3);
    }
}

