/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.jvm.checkers.expression;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import ksp.com.intellij.openapi.vfs.VirtualFile;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.KtSourceFile;
import ksp.org.jetbrains.kotlin.KtVirtualFileSourceFile;
import ksp.org.jetbrains.kotlin.descriptors.SourceElement;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.ClassMembersKt;
import ksp.org.jetbrains.kotlin.fir.FirElement;
import ksp.org.jetbrains.kotlin.fir.UtilsKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.jvm.FirJvmErrors;
import ksp.org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import ksp.org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.ReferenceUtilsKt;
import ksp.org.jetbrains.kotlin.fir.java.VirtualFileBasedSourceElement;
import ksp.org.jetbrains.kotlin.fir.modules.FirJavaModuleResolverProviderKt;
import ksp.org.jetbrains.kotlin.fir.references.FirReference;
import ksp.org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import ksp.org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import ksp.org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirFileSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import ksp.org.jetbrains.kotlin.fir.types.ConeClassLikeLookupTag;
import ksp.org.jetbrains.kotlin.load.kotlin.JvmPackagePartSource;
import ksp.org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import ksp.org.jetbrains.kotlin.load.kotlin.KotlinJvmBinarySourceElement;
import ksp.org.jetbrains.kotlin.load.kotlin.VirtualFileKotlinClass;
import ksp.org.jetbrains.kotlin.name.FqName;
import ksp.org.jetbrains.kotlin.resolve.jvm.modules.JavaModuleResolver;
import ksp.org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedContainerSource;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ;\u0010\u000e\u001a\u00020\u00072\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0000R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u0013\u0010\u0014J?\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\u0012H\u0000R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001c"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/jvm/checkers/expression/FirJvmModuleAccessibilityQualifiedAccessChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lksp/org/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirQualifiedAccessExpressionChecker;", "<init>", "()V", "check", "", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "expression", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;)V", "checkClassAccess", "symbol", "Lksp/org/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;", "element", "Lksp/org/jetbrains/kotlin/fir/FirElement;", "checkClassAccess$checkers_jvm", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;Lorg/jetbrains/kotlin/fir/FirElement;)V", "checkPackageAccess", "fileFromPackage", "Lksp/com/intellij/openapi/vfs/VirtualFile;", "referencedPackageFqName", "Lksp/org/jetbrains/kotlin/name/FqName;", "checkPackageAccess$checkers_jvm", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lcom/intellij/openapi/vfs/VirtualFile;Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/fir/FirElement;)V", "checkers.jvm"})
public final class FirJvmModuleAccessibilityQualifiedAccessChecker
extends FirExpressionChecker<FirQualifiedAccessExpression> {
    @NotNull
    public static final FirJvmModuleAccessibilityQualifiedAccessChecker INSTANCE = new FirJvmModuleAccessibilityQualifiedAccessChecker();

    private FirJvmModuleAccessibilityQualifiedAccessChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirQualifiedAccessExpression expression2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        FirCallableSymbol firCallableSymbol = FirReferenceUtilsKt.toResolvedCallableSymbol$default(expression2.getCalleeReference(), false, 1, null);
        if (firCallableSymbol == null) {
            return;
        }
        FirCallableSymbol callableSymbol = firCallableSymbol;
        if (callableSymbol.getOrigin().getFromSource()) {
            return;
        }
        ConeClassLikeLookupTag containingClass = ClassMembersKt.containingClassLookupTag(callableSymbol);
        if (containingClass != null) {
            FirRegularClassSymbol firRegularClassSymbol = ToSymbolUtilsKt.toRegularClassSymbol(containingClass, context2.getSession());
            if (firRegularClassSymbol == null) {
                return;
            }
            FirRegularClassSymbol containingClassSymbol = firRegularClassSymbol;
            this.checkClassAccess$checkers_jvm(context2, reporter, containingClassSymbol, expression2);
        } else {
            DeserializedContainerSource deserializedContainerSource = callableSymbol.getContainerSource();
            JvmPackagePartSource jvmPackagePartSource = deserializedContainerSource instanceof JvmPackagePartSource ? (JvmPackagePartSource)deserializedContainerSource : null;
            if (jvmPackagePartSource == null) {
                return;
            }
            JvmPackagePartSource containerSource = jvmPackagePartSource;
            KotlinJvmBinaryClass kotlinJvmBinaryClass = containerSource.getKnownJvmBinaryClass();
            Object object = kotlinJvmBinaryClass instanceof VirtualFileKotlinClass ? (VirtualFileKotlinClass)kotlinJvmBinaryClass : null;
            if (object == null || (object = ((VirtualFileKotlinClass)object).getFile()) == null) {
                return;
            }
            Object virtualFile = object;
            FqName fqName = containerSource.getClassName().getPackageFqName();
            Intrinsics.checkNotNullExpressionValue((Object)fqName, (String)"getPackageFqName(...)");
            this.checkPackageAccess$checkers_jvm(context2, reporter, (VirtualFile)virtualFile, fqName, expression2);
        }
    }

    public final void checkClassAccess$checkers_jvm(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirClassSymbol<?> symbol, @NotNull FirElement element2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter(symbol, (String)"symbol");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        if (symbol.getOrigin().getFromSource()) {
            return;
        }
        SourceElement sourceElement = DeclarationAttributesKt.getSourceElement((FirClassLikeDeclaration)symbol.getFir());
        SourceElement sourceElement2 = sourceElement;
        if (sourceElement2 instanceof VirtualFileBasedSourceElement) {
            object = ((VirtualFileBasedSourceElement)sourceElement).getVirtualFile();
        } else if (sourceElement2 instanceof KotlinJvmBinarySourceElement) {
            KotlinJvmBinaryClass kotlinJvmBinaryClass = ((KotlinJvmBinarySourceElement)sourceElement).getBinaryClass();
            object = kotlinJvmBinaryClass instanceof VirtualFileKotlinClass ? (VirtualFileKotlinClass)kotlinJvmBinaryClass : null;
            if (object == null || (object = ((VirtualFileKotlinClass)object).getFile()) == null) {
                return;
            }
        } else {
            return;
        }
        VirtualFile virtualFile = object;
        this.checkPackageAccess$checkers_jvm(context2, reporter, virtualFile, UtilsKt.packageFqName((FirBasedSymbol)symbol), element2);
    }

    public final void checkPackageAccess$checkers_jvm(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull VirtualFile fileFromPackage, @NotNull FqName referencedPackageFqName, @NotNull FirElement element2) {
        JavaModuleResolver.AccessError accessError;
        Object source;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)fileFromPackage, (String)"fileFromPackage");
        Intrinsics.checkNotNullParameter((Object)referencedPackageFqName, (String)"referencedPackageFqName");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        FirFileSymbol firFileSymbol = context2.getContainingFileSymbol();
        KtSourceFile ktSourceFile = firFileSymbol != null ? firFileSymbol.getSourceFile() : null;
        KtVirtualFileSourceFile ktVirtualFileSourceFile = ktSourceFile instanceof KtVirtualFileSourceFile ? (KtVirtualFileSourceFile)ktSourceFile : null;
        VirtualFile fileFromOurModule = ktVirtualFileSourceFile != null ? ktVirtualFileSourceFile.getVirtualFile() : null;
        JavaModuleResolver.AccessError accessError2 = FirJavaModuleResolverProviderKt.getJavaModuleResolverProvider(context2.getSession()).getJavaModuleResolver().checkAccessibility(fileFromOurModule, fileFromPackage, referencedPackageFqName);
        if (accessError2 == null) {
            return;
        }
        JavaModuleResolver.AccessError diagnostic = accessError2;
        Object object = ReferenceUtilsKt.toReference(element2, context2.getSession());
        if (object == null || (object = ((FirReference)object).getSource()) == null) {
            object = source = element2.getSource();
        }
        if ((accessError = diagnostic) instanceof JavaModuleResolver.AccessError.ModuleDoesNotExportPackage) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, FirJvmErrors.INSTANCE.getJAVA_MODULE_DOES_NOT_EXPORT_PACKAGE(), (Object)((JavaModuleResolver.AccessError.ModuleDoesNotExportPackage)diagnostic).getDependencyModuleName(), (Object)referencedPackageFqName.asString(), null, 32, null);
        } else if (accessError instanceof JavaModuleResolver.AccessError.ModuleDoesNotReadModule) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, FirJvmErrors.INSTANCE.getJAVA_MODULE_DOES_NOT_DEPEND_ON_MODULE(), (Object)((JavaModuleResolver.AccessError.ModuleDoesNotReadModule)diagnostic).getDependencyModuleName(), null, 16, null);
        } else if (Intrinsics.areEqual((Object)accessError, (Object)JavaModuleResolver.AccessError.ModuleDoesNotReadUnnamedModule.INSTANCE)) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, FirJvmErrors.INSTANCE.getJAVA_MODULE_DOES_NOT_READ_UNNAMED_MODULE(), null, 8, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }
}

