/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jdom;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import ksp.org.jdom.Attribute;
import ksp.org.jdom.Element;
import ksp.org.jdom.IllegalAddException;
import ksp.org.jdom.Namespace;
import ksp.org.jdom.Verifier;
import ksp.org.jdom.internal.ArrayCopy;

final class AttributeList
extends AbstractList<Attribute>
implements RandomAccess {
    private static final int INITIAL_ARRAY_SIZE = 4;
    private Attribute[] attributeData;
    private int size;
    private final Element parent;
    private static final Comparator<Attribute> ATTRIBUTE_NATURAL = new Comparator<Attribute>(){

        @Override
        public int compare(Attribute a1, Attribute a2) {
            int pcomp = a1.getNamespacePrefix().compareTo(a2.getNamespacePrefix());
            if (pcomp != 0) {
                return pcomp;
            }
            return a1.getName().compareTo(a2.getName());
        }
    };

    AttributeList(Element parent2) {
        this.parent = parent2;
    }

    final void uncheckedAddAttribute(Attribute a2) {
        a2.parent = this.parent;
        this.ensureCapacity(this.size + 1);
        this.attributeData[this.size++] = a2;
        ++this.modCount;
    }

    @Override
    public boolean add(Attribute attribute) {
        if (attribute.getParent() != null) {
            throw new IllegalAddException("The attribute already has an existing parent \"" + attribute.getParent().getQualifiedName() + "\"");
        }
        if (Verifier.checkNamespaceCollision(attribute, this.parent) != null) {
            throw new IllegalAddException(this.parent, attribute, Verifier.checkNamespaceCollision(attribute, this.parent));
        }
        int duplicate = this.indexOfDuplicate(attribute);
        if (duplicate < 0) {
            attribute.setParent(this.parent);
            this.ensureCapacity(this.size + 1);
            this.attributeData[this.size++] = attribute;
            ++this.modCount;
        } else {
            Attribute old = this.attributeData[duplicate];
            old.setParent(null);
            this.attributeData[duplicate] = attribute;
            attribute.setParent(this.parent);
        }
        return true;
    }

    @Override
    public void add(int index2, Attribute attribute) {
        if (index2 < 0 || index2 > this.size) {
            throw new IndexOutOfBoundsException("Index: " + index2 + " Size: " + this.size());
        }
        if (attribute.getParent() != null) {
            throw new IllegalAddException("The attribute already has an existing parent \"" + attribute.getParent().getQualifiedName() + "\"");
        }
        int duplicate = this.indexOfDuplicate(attribute);
        if (duplicate >= 0) {
            throw new IllegalAddException("Cannot add duplicate attribute");
        }
        String reason = Verifier.checkNamespaceCollision(attribute, this.parent);
        if (reason != null) {
            throw new IllegalAddException(this.parent, attribute, reason);
        }
        attribute.setParent(this.parent);
        this.ensureCapacity(this.size + 1);
        if (index2 == this.size) {
            this.attributeData[this.size++] = attribute;
        } else {
            System.arraycopy(this.attributeData, index2, this.attributeData, index2 + 1, this.size - index2);
            this.attributeData[index2] = attribute;
            ++this.size;
        }
        ++this.modCount;
    }

    @Override
    public boolean addAll(Collection<? extends Attribute> collection) {
        return this.addAll(this.size(), collection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(int index2, Collection<? extends Attribute> collection) {
        if (index2 < 0 || index2 > this.size) {
            throw new IndexOutOfBoundsException("Index: " + index2 + " Size: " + this.size());
        }
        if (collection == null) {
            throw new NullPointerException("Can not add a null Collection to AttributeList");
        }
        int addcnt = collection.size();
        if (addcnt == 0) {
            return false;
        }
        if (addcnt == 1) {
            this.add(index2, collection.iterator().next());
            return true;
        }
        this.ensureCapacity(this.size() + addcnt);
        int tmpmodcount = this.modCount;
        boolean ok = false;
        int count = 0;
        try {
            for (Attribute attribute : collection) {
                this.add(index2 + count, attribute);
                ++count;
            }
            ok = true;
        }
        finally {
            if (!ok) {
                while (--count >= 0) {
                    this.remove(index2 + count);
                }
                this.modCount = tmpmodcount;
            }
        }
        return true;
    }

    @Override
    public void clear() {
        if (this.attributeData != null) {
            while (this.size > 0) {
                --this.size;
                this.attributeData[this.size].setParent(null);
                this.attributeData[this.size] = null;
            }
        }
        ++this.modCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearAndSet(Collection<? extends Attribute> collection) {
        if (collection == null || collection.isEmpty()) {
            this.clear();
            return;
        }
        Attribute[] old = this.attributeData;
        int oldSize = this.size;
        int oldModCount = this.modCount;
        while (this.size > 0) {
            old[--this.size].setParent(null);
        }
        this.size = 0;
        this.attributeData = null;
        boolean ok = false;
        try {
            this.addAll(0, collection);
            ok = true;
        }
        finally {
            if (!ok) {
                this.attributeData = old;
                while (this.size < oldSize) {
                    this.attributeData[this.size++].setParent(this.parent);
                }
                this.modCount = oldModCount;
            }
        }
    }

    private void ensureCapacity(int minCapacity) {
        if (this.attributeData == null) {
            this.attributeData = new Attribute[Math.max(minCapacity, 4)];
            return;
        }
        if (minCapacity < this.attributeData.length) {
            return;
        }
        this.attributeData = ArrayCopy.copyOf(this.attributeData, minCapacity + 4 >>> 1 << 1);
    }

    @Override
    public Attribute get(int index2) {
        if (index2 < 0 || index2 >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index2 + " Size: " + this.size());
        }
        return this.attributeData[index2];
    }

    Attribute get(String name2, Namespace namespace) {
        int index2 = this.indexOf(name2, namespace);
        if (index2 < 0) {
            return null;
        }
        return this.attributeData[index2];
    }

    int indexOf(String name2, Namespace namespace) {
        if (this.attributeData != null) {
            if (namespace == null) {
                return this.indexOf(name2, Namespace.NO_NAMESPACE);
            }
            String uri = namespace.getURI();
            for (int i2 = 0; i2 < this.size; ++i2) {
                Attribute att = this.attributeData[i2];
                if (!uri.equals(att.getNamespaceURI()) || !name2.equals(att.getName())) continue;
                return i2;
            }
        }
        return -1;
    }

    @Override
    public Attribute remove(int index2) {
        if (index2 < 0 || index2 >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index2 + " Size: " + this.size());
        }
        Attribute old = this.attributeData[index2];
        old.setParent(null);
        System.arraycopy(this.attributeData, index2 + 1, this.attributeData, index2, this.size - index2 - 1);
        this.attributeData[--this.size] = null;
        ++this.modCount;
        return old;
    }

    boolean remove(String name2, Namespace namespace) {
        int index2 = this.indexOf(name2, namespace);
        if (index2 < 0) {
            return false;
        }
        this.remove(index2);
        return true;
    }

    @Override
    public Attribute set(int index2, Attribute attribute) {
        if (index2 < 0 || index2 >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index2 + " Size: " + this.size());
        }
        if (attribute.getParent() != null) {
            throw new IllegalAddException("The attribute already has an existing parent \"" + attribute.getParent().getQualifiedName() + "\"");
        }
        int duplicate = this.indexOfDuplicate(attribute);
        if (duplicate >= 0 && duplicate != index2) {
            throw new IllegalAddException("Cannot set duplicate attribute");
        }
        String reason = Verifier.checkNamespaceCollision(attribute, this.parent, index2);
        if (reason != null) {
            throw new IllegalAddException(this.parent, attribute, reason);
        }
        Attribute old = this.attributeData[index2];
        old.setParent(null);
        this.attributeData[index2] = attribute;
        attribute.setParent(this.parent);
        return old;
    }

    private int indexOfDuplicate(Attribute attribute) {
        return this.indexOf(attribute.getName(), attribute.getNamespace());
    }

    @Override
    public Iterator<Attribute> iterator() {
        return new ALIterator();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public String toString() {
        return super.toString();
    }

    private final int binarySearch(int[] indexes, int len, int val, Comparator<? super Attribute> comp) {
        int left = 0;
        int mid = 0;
        int right = len - 1;
        int cmp = 0;
        Attribute base = this.attributeData[val];
        while (left <= right) {
            mid = left + right >>> 1;
            cmp = comp.compare(base, this.attributeData[indexes[mid]]);
            if (cmp == 0) {
                while (cmp == 0 && mid < right && comp.compare(base, this.attributeData[indexes[mid + 1]]) == 0) {
                    ++mid;
                }
                return mid + 1;
            }
            if (cmp < 0) {
                right = mid - 1;
                continue;
            }
            left = mid + 1;
        }
        return left;
    }

    private void sortInPlace(int[] indexes) {
        int i2;
        int[] unsorted = ArrayCopy.copyOf(indexes, indexes.length);
        Arrays.sort(unsorted);
        Attribute[] usc = new Attribute[unsorted.length];
        for (i2 = 0; i2 < usc.length; ++i2) {
            usc[i2] = this.attributeData[indexes[i2]];
        }
        for (i2 = 0; i2 < indexes.length; ++i2) {
            this.attributeData[unsorted[i2]] = usc[i2];
        }
    }

    @Override
    public void sort(Comparator<? super Attribute> comp) {
        if (comp == null) {
            comp = ATTRIBUTE_NATURAL;
        }
        int sz = this.size;
        int[] indexes = new int[sz];
        int i2 = 0;
        while (i2 < sz) {
            int ip = this.binarySearch(indexes, i2, i2, comp);
            if (ip < i2) {
                System.arraycopy(indexes, ip, indexes, ip + 1, i2 - ip);
            }
            indexes[ip] = i2++;
        }
        this.sortInPlace(indexes);
    }

    private final class ALIterator
    implements Iterator<Attribute> {
        private int expect = -1;
        private int cursor = 0;
        private boolean canremove = false;

        private ALIterator() {
            this.expect = AttributeList.this.modCount;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < AttributeList.this.size;
        }

        @Override
        public Attribute next() {
            if (AttributeList.this.modCount != this.expect) {
                throw new ConcurrentModificationException("ContentList was modified outside of this Iterator");
            }
            if (this.cursor >= AttributeList.this.size) {
                throw new NoSuchElementException("Iterated beyond the end of the ContentList.");
            }
            this.canremove = true;
            return AttributeList.this.attributeData[this.cursor++];
        }

        @Override
        public void remove() {
            if (AttributeList.this.modCount != this.expect) {
                throw new ConcurrentModificationException("ContentList was modified outside of this Iterator");
            }
            if (!this.canremove) {
                throw new IllegalStateException("Can only remove() content after a call to next()");
            }
            AttributeList.this.remove(--this.cursor);
            this.expect = AttributeList.this.modCount;
            this.canremove = false;
        }
    }
}

