/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.checkerframework.checker.i18nformatter.qual;

import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.StringJoiner;
import ksp.org.checkerframework.checker.nullness.qual.Nullable;

public enum I18nConversionCategory {
    UNUSED(null, null),
    GENERAL(null, null),
    DATE(new Class[]{Date.class, Number.class}, new String[]{"date", "time"}),
    NUMBER(new Class[]{Number.class}, new String[]{"number", "choice"});

    public final Class<?> @Nullable [] types;
    public final String @Nullable [] strings;
    private static final I18nConversionCategory[] namedCategories;
    private static final I18nConversionCategory[] conversionCategoriesForIntersect;

    private I18nConversionCategory(Class<?>[] types2, String[] strings2) {
        this.types = types2;
        this.strings = strings2;
    }

    public static I18nConversionCategory stringToI18nConversionCategory(String string) {
        string = string.toLowerCase();
        for (I18nConversionCategory v2 : namedCategories) {
            for (String s2 : v2.strings) {
                if (!s2.equals(string)) continue;
                return v2;
            }
        }
        throw new IllegalArgumentException("Invalid format type " + string);
    }

    private static <E> Set<E> arrayToSet(E[] a2) {
        return new HashSet<E>(Arrays.asList(a2));
    }

    public static boolean isSubsetOf(I18nConversionCategory a2, I18nConversionCategory b2) {
        return I18nConversionCategory.intersect(a2, b2) == a2;
    }

    public static I18nConversionCategory intersect(I18nConversionCategory a2, I18nConversionCategory b2) {
        if (a2 == UNUSED) {
            return b2;
        }
        if (b2 == UNUSED) {
            return a2;
        }
        if (a2 == GENERAL) {
            return b2;
        }
        if (b2 == GENERAL) {
            return a2;
        }
        Set<Class<Class<?>>> as = I18nConversionCategory.arrayToSet(a2.types);
        Set<Class<?>> bs = I18nConversionCategory.arrayToSet(b2.types);
        as.retainAll(bs);
        for (I18nConversionCategory v2 : conversionCategoriesForIntersect) {
            Set<Class<?>> vs = I18nConversionCategory.arrayToSet(v2.types);
            if (!vs.equals(as)) continue;
            return v2;
        }
        throw new RuntimeException();
    }

    public static I18nConversionCategory union(I18nConversionCategory a2, I18nConversionCategory b2) {
        if (a2 == UNUSED || b2 == UNUSED) {
            return UNUSED;
        }
        if (a2 == GENERAL || b2 == GENERAL) {
            return GENERAL;
        }
        if (a2 == DATE || b2 == DATE) {
            return DATE;
        }
        return NUMBER;
    }

    public boolean isAssignableFrom(Class<?> argType) {
        if (this.types == null) {
            return true;
        }
        if (argType == Void.TYPE) {
            return true;
        }
        for (Class<?> c2 : this.types) {
            if (!c2.isAssignableFrom(argType)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.name());
        if (this.types == null) {
            sb.append(" conversion category (all types)");
        } else {
            StringJoiner sj = new StringJoiner(", ", " conversion category (one of: ", ")");
            for (Class<?> cls : this.types) {
                sj.add(cls.getCanonicalName());
            }
            sb.append(sj);
        }
        return sb.toString();
    }

    static {
        namedCategories = new I18nConversionCategory[]{DATE, NUMBER};
        conversionCategoriesForIntersect = new I18nConversionCategory[]{DATE, NUMBER};
    }
}

