/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.KtFakeSourceElementKind;
import ksp.org.jetbrains.kotlin.KtSourceElement;
import ksp.org.jetbrains.kotlin.KtSourceElementKind;
import ksp.org.jetbrains.kotlin.config.LanguageFeature;
import ksp.org.jetbrains.kotlin.diagnostics.AbstractSourceElementPositioningStrategy;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.diagnostics.SourceElementPositioningStrategies;
import ksp.org.jetbrains.kotlin.fir.FirElement;
import ksp.org.jetbrains.kotlin.fir.FirExpectActualMatchingContext;
import ksp.org.jetbrains.kotlin.fir.FirExpectActualMatchingContextKt;
import ksp.org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import ksp.org.jetbrains.kotlin.fir.FirModuleData;
import ksp.org.jetbrains.kotlin.fir.FirSession;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirKeywordUtilsKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirModifierList;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.DeclarationUtilsKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirExpectActualDeclarationCheckerKt;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.declarations.ExpectActualAttributesKt;
import ksp.org.jetbrains.kotlin.fir.declarations.FirBackingField;
import ksp.org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import ksp.org.jetbrains.kotlin.fir.declarations.FirFunction;
import ksp.org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirProperty;
import ksp.org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import ksp.org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import ksp.org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import ksp.org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import ksp.org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import ksp.org.jetbrains.kotlin.lexer.KtTokens;
import ksp.org.jetbrains.kotlin.mpp.CallableSymbolMarker;
import ksp.org.jetbrains.kotlin.mpp.ClassLikeSymbolMarker;
import ksp.org.jetbrains.kotlin.mpp.RegularClassSymbolMarker;
import ksp.org.jetbrains.kotlin.resolve.calls.mpp.AbstractExpectActualChecker;
import ksp.org.jetbrains.kotlin.resolve.multiplatform.ExpectActualIncompatibility;
import ksp.org.jetbrains.kotlin.resolve.multiplatform.ExpectActualMatchingCompatibility;
import ksp.org.jetbrains.kotlin.resolve.multiplatform.MemberIncompatibility;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u0010H\u0002J-\u0010\u0011\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0010H\u0002R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0012J-\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0016J-\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\u001aJ-\u0010\u001b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0010H\u0002R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0012JO\u0010\u001c\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00102 \u0010\u001d\u001a\u001c\u0012\u0004\u0012\u00020\u001f\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030!0 0\u001ej\u0002`\"H\u0002R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010#J]\u0010$\u001a\u00020\u00072\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00020!2\f\u0010&\u001a\b\u0012\u0002\b\u0003\u0018\u00010!2\u0010\u0010'\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030!0(2\b\u0010)\u001a\u0004\u0018\u00010*H\u0002R\u00020\nR\u00020\bj\u0006\u0010\u000b\u001a\u00020\nj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010+J\"\u0010,\u001a\u00020\u000f*\u0006\u0012\u0002\b\u00030!2\b\u0010-\u001a\u0004\u0018\u00010.2\u0006\u0010/\u001a\u000200H\u0002J]\u00101\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030!020 2\n\u00103\u001a\u0006\u0012\u0002\b\u00030!2\n\u00104\u001a\u0006\u0012\u0002\b\u00030!2\b\u00105\u001a\u0004\u0018\u00010.2\b\u0010-\u001a\u0004\u0018\u00010.2\u0006\u0010/\u001a\u000200H\u0002R\u00020\bj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u00106J[\u00107\u001a\u00020\u00072\n\u00108\u001a\u0006\u0012\u0002\b\u00030!2\u001c\u00109\u001a\u0018\u0012\u0004\u0012\u00020\u001f\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030!0 0\u001e2\n\u0010%\u001a\u0006\u0012\u0002\b\u00030!H\u0002R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010:J$\u0010;\u001a\u00020\u000f2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030!2\u0006\u00105\u001a\u00020.2\u0006\u0010<\u001a\u00020=H\u0002J\f\u0010>\u001a\u00020\u000f*\u00020?H\u0002J$\u0010@\u001a\u00020\u000f2\n\u0010%\u001a\u0006\u0012\u0002\b\u00030!2\u0006\u00105\u001a\u00020.2\u0006\u0010<\u001a\u00020=H\u0002\u00a8\u0006A"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirExpectActualDeclarationChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lksp/org/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "<init>", "()V", "check", "", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;)V", "containsExpectOrActualModifier", "", "Lksp/org/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "checkExpectDeclarationModifiers", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;)V", "checkExpectPropertyAccessorsModifiers", "property", "Lksp/org/jetbrains/kotlin/fir/declarations/FirProperty;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirProperty;)V", "checkExpectPropertyAccessorModifiers", "accessor", "Lksp/org/jetbrains/kotlin/fir/declarations/FirPropertyAccessor;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirPropertyAccessor;)V", "checkExpectDeclarationHasNoExternalModifier", "checkActualDeclarationHasExpected", "matchingCompatibilityToMembersMap", "", "Lksp/org/jetbrains/kotlin/resolve/multiplatform/ExpectActualMatchingCompatibility;", "", "Lksp/org/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "Lksp/org/jetbrains/kotlin/fir/declarations/ExpectForActualMatchingData;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;Ljava/util/Map;)V", "reportClassScopesIncompatibility", "symbol", "expectedSingleCandidate", "checkingCompatibility", "Lksp/org/jetbrains/kotlin/resolve/multiplatform/ExpectActualIncompatibility$ClassScopes;", "source", "Lksp/org/jetbrains/kotlin/KtSourceElement;", "(Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;Lorg/jetbrains/kotlin/resolve/multiplatform/ExpectActualIncompatibility$ClassScopes;Lorg/jetbrains/kotlin/KtSourceElement;)V", "isFakeOverride", "expectContainingClass", "Lksp/org/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "expectActualMatchingContext", "Lksp/org/jetbrains/kotlin/fir/FirExpectActualMatchingContext;", "getCheckingCompatibility", "Lksp/org/jetbrains/kotlin/resolve/multiplatform/ExpectActualIncompatibility;", "actualSymbol", "expectSymbol", "actualContainingClass", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;Lorg/jetbrains/kotlin/fir/FirExpectActualMatchingContext;)Ljava/util/List;", "checkAmbiguousExpects", "actualDeclaration", "compatibility", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;Ljava/util/Map;Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;)V", "requireActualModifier", "platformSession", "Lksp/org/jetbrains/kotlin/fir/FirSession;", "hasActualModifier", "Lksp/org/jetbrains/kotlin/fir/FirElement;", "isUnderlyingPropertyOfInlineClass", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirExpectActualDeclarationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirExpectActualDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirExpectActualDeclarationChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n*L\n1#1,400:1\n36#2:401\n35#2:402\n36#2:403\n53#2:404\n54#2:405\n36#2:406\n75#3,14:407\n2746#4,3:421\n827#4:424\n855#4,2:425\n3301#4,10:427\n1563#4:437\n1634#4,3:438\n1563#4:442\n1634#4,3:443\n1056#4:446\n1#5:441\n59#6:447\n53#6,4:448\n*S KotlinDebug\n*F\n+ 1 FirExpectActualDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirExpectActualDeclarationChecker\n*L\n39#1:401\n39#1:402\n59#1:403\n85#1:404\n120#1:405\n155#1:406\n182#1:407,14\n200#1:421,3\n227#1:424\n227#1:425,2\n231#1:427,10\n235#1:437\n235#1:438,3\n314#1:442\n314#1:443,3\n315#1:446\n363#1:447\n363#1:448,4\n*E\n"})
public final class FirExpectActualDeclarationChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirExpectActualDeclarationChecker INSTANCE = new FirExpectActualDeclarationChecker();

    private FirExpectActualDeclarationChecker() {
        super(MppCheckerKind.Platform);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirDeclaration declaration2) {
        Map matchingCompatibilityToMembersMap;
        Map map;
        block10: {
            block12: {
                block11: {
                    Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                    Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
                    Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                    if (!(declaration2 instanceof FirMemberDeclaration)) {
                        return;
                    }
                    if (FirLanguageSettingsComponentKt.getLanguageVersionSettings(context2.getSession()).supportsFeature(LanguageFeature.MultiPlatformProjects)) break block10;
                    FirMemberDeclaration $this$isExpect$iv = (FirMemberDeclaration)declaration2;
                    boolean $i$f$isExpect = false;
                    if ($this$isExpect$iv.getStatus().isExpect()) break block11;
                    FirMemberDeclaration $this$isActual$iv = (FirMemberDeclaration)declaration2;
                    boolean $i$f$isActual = false;
                    if (!$this$isActual$iv.getStatus().isActual()) break block12;
                }
                if (this.containsExpectOrActualModifier((FirMemberDeclaration)declaration2)) {
                    Object object = ((FirMemberDeclaration)declaration2).getSource();
                    boolean bl2 = object != null && (object = ((KtSourceElement)object).getKind()) != null ? !((KtSourceElementKind)object).getShouldSkipErrorTypeReporting() : false;
                    if (bl2) {
                        KtDiagnosticReportHelpersKt.reportOn((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)((FirMemberDeclaration)declaration2).getSource(), FirErrors.INSTANCE.getNOT_A_MULTIPLATFORM_COMPILATION(), (AbstractSourceElementPositioningStrategy)SourceElementPositioningStrategies.INSTANCE.getEXPECT_ACTUAL_MODIFIER());
                    }
                }
            }
            return;
        }
        if (declaration2 instanceof FirBackingField || declaration2 instanceof FirPropertyAccessor || declaration2 instanceof FirValueParameter) {
            return;
        }
        FirMemberDeclaration $this$isExpect$iv = (FirMemberDeclaration)declaration2;
        boolean $i$f$isExpect = false;
        if ($this$isExpect$iv.getStatus().isExpect()) {
            this.checkExpectDeclarationModifiers(context2, reporter, (FirMemberDeclaration)declaration2);
        }
        if ((map = ExpectActualAttributesKt.getExpectForActual(((FirMemberDeclaration)declaration2).getSymbol())) == null) {
            map = MapsKt.emptyMap();
        }
        if (((matchingCompatibilityToMembersMap = map).containsKey(ExpectActualMatchingCompatibility.MatchedSuccessfully.INSTANCE) || this.hasActualModifier(declaration2)) && !DeclarationUtilsKt.isLocalMember(declaration2)) {
            this.checkActualDeclarationHasExpected(context2, reporter, (FirMemberDeclaration)declaration2, matchingCompatibilityToMembersMap);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean containsExpectOrActualModifier(FirMemberDeclaration declaration2) {
        FirModifierList firModifierList = FirKeywordUtilsKt.getModifierList(declaration2.getSource());
        if (firModifierList == null) return false;
        FirModifierList modifiers2 = firModifierList;
        boolean bl2 = false;
        KtModifierKeywordToken ktModifierKeywordToken = KtTokens.EXPECT_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken, (String)"EXPECT_KEYWORD");
        if (modifiers2.contains(ktModifierKeywordToken)) return true;
        KtModifierKeywordToken ktModifierKeywordToken2 = KtTokens.ACTUAL_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken2, (String)"ACTUAL_KEYWORD");
        if (!modifiers2.contains(ktModifierKeywordToken2)) return false;
        return true;
    }

    private final void checkExpectDeclarationModifiers(CheckerContext context2, DiagnosticReporter reporter, FirMemberDeclaration declaration2) {
        this.checkExpectDeclarationHasNoExternalModifier(context2, reporter, declaration2);
        if (declaration2 instanceof FirProperty) {
            this.checkExpectPropertyAccessorsModifiers(context2, reporter, (FirProperty)declaration2);
        }
        if (context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.MultiplatformRestrictions) && declaration2 instanceof FirFunction) {
            FirMemberDeclaration $this$isTailRec$iv = declaration2;
            boolean $i$f$isTailRec = false;
            if ($this$isTailRec$iv.getStatus().isTailRec()) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)((FirFunction)declaration2).getSource(), FirErrors.INSTANCE.getEXPECTED_TAILREC_FUNCTION(), null, 8, null);
            }
        }
    }

    private final void checkExpectPropertyAccessorsModifiers(CheckerContext context2, DiagnosticReporter reporter, FirProperty property2) {
        Object[] objectArray = new FirPropertyAccessor[]{property2.getGetter(), property2.getSetter()};
        for (FirPropertyAccessor accessor : CollectionsKt.listOfNotNull((Object[])objectArray)) {
            this.checkExpectPropertyAccessorModifiers(context2, reporter, accessor);
        }
    }

    private final void checkExpectPropertyAccessorModifiers(CheckerContext context2, DiagnosticReporter reporter, FirPropertyAccessor accessor) {
        if (!FirExpectActualDeclarationChecker.checkExpectPropertyAccessorModifiers$isDefault(accessor)) {
            this.checkExpectDeclarationHasNoExternalModifier(context2, reporter, accessor);
        }
    }

    private final void checkExpectDeclarationHasNoExternalModifier(CheckerContext context2, DiagnosticReporter reporter, FirMemberDeclaration declaration2) {
        if (context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.MultiplatformRestrictions)) {
            FirMemberDeclaration $this$isExternal$iv = declaration2;
            boolean $i$f$isExternal = false;
            if ($this$isExternal$iv.getStatus().isExternal()) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)declaration2.getSource(), FirErrors.INSTANCE.getEXPECTED_EXTERNAL_DECLARATION(), null, 8, null);
            }
        }
    }

    private final void checkActualDeclarationHasExpected(CheckerContext context2, DiagnosticReporter reporter, FirMemberDeclaration declaration2, Map<ExpectActualMatchingCompatibility, ? extends List<? extends FirBasedSymbol<?>>> matchingCompatibilityToMembersMap) {
        boolean bl2;
        List classScopesIncompatibilities;
        KtSourceElement source;
        FirBasedSymbol expectedSingleCandidate;
        FirBasedSymbol<FirDeclaration> symbol;
        block13: {
            FirRegularClassSymbol actualContainingClass;
            symbol = declaration2.getSymbol();
            List<? extends FirBasedSymbol<?>> list = matchingCompatibilityToMembersMap.get(ExpectActualMatchingCompatibility.MatchedSuccessfully.INSTANCE);
            expectedSingleCandidate = list != null ? (FirBasedSymbol)CollectionsKt.singleOrNull(list) : null;
            FirExpectActualMatchingContext expectActualMatchingContext = FirExpectActualMatchingContextKt.getExpectActualMatchingContextFactory(context2.getSession()).create(context2.getSession(), context2.getScopeSession(), true);
            Object object = CollectionsKt.lastOrNull(context2.getContainingDeclarations());
            FirRegularClassSymbol firRegularClassSymbol = actualContainingClass = object instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)object : null;
            FirBasedSymbol<?> firBasedSymbol = firRegularClassSymbol != null ? ExpectActualAttributesKt.getSingleMatchedExpectForActualOrNull(firRegularClassSymbol) : null;
            FirRegularClassSymbol expectContainingClass = firBasedSymbol instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)firBasedSymbol : null;
            List<ExpectActualIncompatibility<FirBasedSymbol<?>>> checkingIncompatibilities = expectedSingleCandidate != null ? this.getCheckingCompatibility(context2, symbol, expectedSingleCandidate, actualContainingClass, expectContainingClass, expectActualMatchingContext) : CollectionsKt.emptyList();
            this.checkAmbiguousExpects(context2, reporter, symbol, matchingCompatibilityToMembersMap, symbol);
            source = declaration2.getSource();
            if (!this.hasActualModifier(declaration2)) {
                FirMemberDeclaration $this$isExpect$iv = declaration2;
                boolean $i$f$isExpect = false;
                if (!$this$isExpect$iv.getStatus().isExpect() && matchingCompatibilityToMembersMap.containsKey(ExpectActualMatchingCompatibility.MatchedSuccessfully.INSTANCE) && (actualContainingClass == null || this.requireActualModifier(symbol, actualContainingClass, context2.getSession())) && expectedSingleCandidate != null && !this.isFakeOverride(expectedSingleCandidate, expectContainingClass, expectActualMatchingContext)) {
                    KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getACTUAL_MISSING(), null, 8, null);
                    return;
                }
            }
            if (!matchingCompatibilityToMembersMap.containsKey(ExpectActualMatchingCompatibility.MatchedSuccessfully.INSTANCE) || expectedSingleCandidate != null && this.hasActualModifier(declaration2) && this.isFakeOverride(expectedSingleCandidate, expectContainingClass, expectActualMatchingContext)) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getACTUAL_WITHOUT_EXPECT(), symbol, matchingCompatibilityToMembersMap, null, 32, null);
                return;
            }
            Iterable $this$partitionIsInstance$iv = checkingIncompatibilities;
            boolean $i$f$partitionIsInstance = false;
            Iterable $this$partitionNotNull$iv$iv = $this$partitionIsInstance$iv;
            boolean $i$f$partitionNotNull = false;
            ArrayList<ExpectActualIncompatibility.ClassScopes> first$iv$iv = new ArrayList<ExpectActualIncompatibility.ClassScopes>();
            ArrayList second$iv$iv = new ArrayList();
            Iterator iterator2 = $this$partitionNotNull$iv$iv.iterator();
            while (iterator2.hasNext()) {
                ExpectActualIncompatibility.ClassScopes result$iv$iv;
                Object element$iv$iv;
                Object it$iv = element$iv$iv = iterator2.next();
                boolean bl3 = false;
                Object t2 = it$iv;
                if (!(t2 instanceof ExpectActualIncompatibility.ClassScopes)) {
                    t2 = null;
                }
                boolean bl4 = (result$iv$iv = (ExpectActualIncompatibility.ClassScopes)t2) != null ? first$iv$iv.add(result$iv$iv) : second$iv$iv.add(element$iv$iv);
            }
            Pair pair = new Pair(first$iv$iv, second$iv$iv);
            classScopesIncompatibilities = (List)pair.component1();
            List normalIncompatibilities = (List)pair.component2();
            for (ExpectActualIncompatibility incompatibility : normalIncompatibilities) {
                if (!(expectedSingleCandidate != null)) {
                    throw new IllegalStateException("Check failed.");
                }
                if (declaration2 instanceof FirFunction && Intrinsics.areEqual((Object)incompatibility, (Object)ExpectActualIncompatibility.ActualFunctionWithOptionalParameters.INSTANCE)) {
                    KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)((FirFunction)declaration2).getSource(), FirErrors.INSTANCE.getACTUAL_FUNCTION_WITH_DEFAULT_ARGUMENTS(), null, 8, null);
                    continue;
                }
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, FirExpectActualDeclarationCheckerKt.access$toDiagnostic(incompatibility), (Object)expectedSingleCandidate, symbol, (Object)incompatibility.getReason(), null, 64, null);
            }
            Iterable $this$none$iv = normalIncompatibilities;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl2 = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    ExpectActualIncompatibility it = (ExpectActualIncompatibility)element$iv;
                    boolean bl5 = false;
                    if (!(it instanceof ExpectActualIncompatibility.ClassKind || it instanceof ExpectActualIncompatibility.Modality)) continue;
                    bl2 = false;
                    break block13;
                }
                bl2 = true;
            }
        }
        if (bl2) {
            for (ExpectActualIncompatibility.ClassScopes incompatibility : classScopesIncompatibilities) {
                this.reportClassScopesIncompatibility(reporter, context2, symbol, expectedSingleCandidate, incompatibility, source);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void reportClassScopesIncompatibility(DiagnosticReporter reporter, CheckerContext context2, FirBasedSymbol<? extends FirDeclaration> symbol, FirBasedSymbol<?> expectedSingleCandidate, ExpectActualIncompatibility.ClassScopes<FirBasedSymbol<?>> checkingCompatibility, KtSourceElement source) {
        void $this$filterNotTo$iv$iv;
        if (!((symbol instanceof FirRegularClassSymbol || symbol instanceof FirTypeAliasSymbol) && expectedSingleCandidate instanceof FirRegularClassSymbol)) {
            boolean $i$a$-require-FirExpectActualDeclarationChecker$reportClassScopesIncompatibility$22 = false;
            String $i$a$-require-FirExpectActualDeclarationChecker$reportClassScopesIncompatibility$22 = "Incompatible.ClassScopes is only possible for a class or a typealias: " + symbol + ' ' + expectedSingleCandidate;
            throw new IllegalArgumentException($i$a$-require-FirExpectActualDeclarationChecker$reportClassScopesIncompatibility$22.toString());
        }
        Iterable $this$filterNot$iv = checkingCompatibility.getIncompatibleMembers();
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            MemberIncompatibility p0 = (MemberIncompatibility)element$iv$iv;
            boolean bl2 = false;
            if (FirExpectActualDeclarationChecker.reportClassScopesIncompatibility$hasSingleActualSuspect(p0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List nonTrivialIncompatibleMembers = (List)destination$iv$iv;
        if (!((Collection)nonTrivialIncompatibleMembers).isEmpty()) {
            Iterable $this$partition$iv = nonTrivialIncompatibleMembers;
            boolean $i$f$partition = false;
            ArrayList first$iv = new ArrayList();
            Iterable<Object> second$iv = new ArrayList();
            for (Object element$iv : $this$partition$iv) {
                MemberIncompatibility it = (MemberIncompatibility)element$iv;
                boolean bl3 = false;
                boolean bl4 = Intrinsics.areEqual(it.getIncompatibility(), (Object)ExpectActualIncompatibility.ParametersWithDefaultValuesInExpectActualizedByFakeOverride.INSTANCE) ? first$iv.add(element$iv) : second$iv.add(element$iv);
            }
            Pair pair = new Pair(first$iv, second$iv);
            List defaultArgsIncompatibleMembers = (List)pair.component1();
            List otherIncompatibleMembers = (List)pair.component2();
            if (!((Collection)defaultArgsIncompatibleMembers).isEmpty()) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Object element$iv;
                second$iv = defaultArgsIncompatibleMembers;
                boolean $i$f$map = false;
                element$iv = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    MemberIncompatibility memberIncompatibility = (MemberIncompatibility)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl5 = false;
                    Object d2 = it.getExpect();
                    FirNamedFunctionSymbol firNamedFunctionSymbol = d2 instanceof FirNamedFunctionSymbol ? (FirNamedFunctionSymbol)d2 : null;
                    if (firNamedFunctionSymbol == null) {
                        throw new IllegalStateException((ExpectActualIncompatibility.ParametersWithDefaultValuesInExpectActualizedByFakeOverride.INSTANCE + " can be reported only for " + Reflection.getOrCreateKotlinClass(FirNamedFunctionSymbol.class)).toString());
                    }
                    collection.add(firNamedFunctionSymbol);
                }
                List problematicExpectMembers = (List)destination$iv$iv2;
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getDEFAULT_ARGUMENTS_IN_EXPECT_ACTUALIZED_BY_FAKE_OVERRIDE(), expectedSingleCandidate, (Object)problematicExpectMembers, null, 32, null);
            }
            if (!((Collection)otherIncompatibleMembers).isEmpty()) {
                for (MemberIncompatibility member : otherIncompatibleMembers) {
                    KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getEXPECT_ACTUAL_INCOMPATIBLE_CLASS_SCOPE(), symbol, member.getExpect(), member.getActual(), (Object)member.getIncompatibility().getReason(), null, 128, null);
                }
            }
        }
        if (!((Collection)checkingCompatibility.getMismatchedMembers()).isEmpty()) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getNO_ACTUAL_CLASS_MEMBER_FOR_EXPECTED_CLASS(), symbol, checkingCompatibility.getMismatchedMembers(), null, 32, null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isFakeOverride(FirBasedSymbol<?> $this$isFakeOverride, FirRegularClassSymbol expectContainingClass, FirExpectActualMatchingContext expectActualMatchingContext) {
        if (expectContainingClass == null) return false;
        if (!($this$isFakeOverride instanceof FirCallableSymbol)) return false;
        FirExpectActualMatchingContext $this$isFakeOverride_u24lambda_u246 = expectActualMatchingContext;
        boolean bl2 = false;
        if (!$this$isFakeOverride_u24lambda_u246.isFakeOverride((CallableSymbolMarker)((Object)$this$isFakeOverride), expectContainingClass)) return false;
        return true;
    }

    private final List<ExpectActualIncompatibility<FirBasedSymbol<?>>> getCheckingCompatibility(CheckerContext context2, FirBasedSymbol<?> actualSymbol, FirBasedSymbol<?> expectSymbol, FirRegularClassSymbol actualContainingClass, FirRegularClassSymbol expectContainingClass, FirExpectActualMatchingContext expectActualMatchingContext) {
        List<ExpectActualIncompatibility<FirBasedSymbol<?>>> list;
        if (actualSymbol instanceof FirCallableSymbol && expectSymbol instanceof FirCallableSymbol) {
            list = AbstractExpectActualChecker.INSTANCE.getCallablesCompatibility((CallableSymbolMarker)((Object)expectSymbol), (CallableSymbolMarker)((Object)actualSymbol), expectContainingClass, actualContainingClass, expectActualMatchingContext, context2.getLanguageVersionSettings());
        } else if (actualSymbol instanceof FirClassLikeSymbol && expectSymbol instanceof RegularClassSymbolMarker) {
            list = AbstractExpectActualChecker.INSTANCE.getClassifiersCompatibility((RegularClassSymbolMarker)((Object)expectSymbol), (ClassLikeSymbolMarker)((Object)actualSymbol), expectActualMatchingContext, context2.getLanguageVersionSettings());
        } else {
            throw new IllegalStateException("These expect/actual shouldn't have been matched by FirExpectActualResolver".toString());
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final void checkAmbiguousExpects(CheckerContext context2, DiagnosticReporter reporter, FirBasedSymbol<?> actualDeclaration, Map<ExpectActualMatchingCompatibility, ? extends List<? extends FirBasedSymbol<?>>> compatibility, FirBasedSymbol<?> symbol) {
        void $this$sortedBy$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        List list = compatibility.get(ExpectActualMatchingCompatibility.MatchedSuccessfully.INSTANCE);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        Iterable iterable = list;
        boolean $i$f$map = false;
        void var9_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FirBasedSymbol firBasedSymbol = (FirBasedSymbol)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(it.getModuleData());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        List filesWithMatchedExpects = CollectionsKt.toList((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a2, T b2) {
                FirModuleData it = (FirModuleData)a2;
                boolean bl2 = false;
                Comparable comparable = (Comparable)((Object)it.getName().asString());
                it = (FirModuleData)b2;
                Comparable comparable2 = comparable;
                bl2 = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName().asString())));
            }
        }));
        if (filesWithMatchedExpects.size() > 1) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)actualDeclaration.getSource(), FirErrors.INSTANCE.getAMBIGUOUS_EXPECTS(), symbol, (Object)filesWithMatchedExpects, null, 32, null);
        }
    }

    private final boolean requireActualModifier(FirBasedSymbol<?> declaration2, FirRegularClassSymbol actualContainingClass, FirSession platformSession) {
        KtSourceElement source = declaration2.getSource();
        if (!(source != null)) {
            boolean bl2 = false;
            String string = "expect-actual matching is only possible for code with sources";
            throw new IllegalStateException(string.toString());
        }
        return !Intrinsics.areEqual((Object)source.getKind(), (Object)KtFakeSourceElementKind.ImplicitConstructor.INSTANCE) && !Intrinsics.areEqual((Object)declaration2.getOrigin(), (Object)FirDeclarationOrigin.Synthetic.DataClassMember.INSTANCE) && !ksp.org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt.isAnnotationConstructor(declaration2, platformSession) && !ksp.org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt.isPrimaryConstructorOfInlineOrValueClass(declaration2, platformSession) && !this.isUnderlyingPropertyOfInlineClass(declaration2, actualContainingClass, platformSession);
    }

    private final boolean hasActualModifier(FirElement $this$hasActualModifier) {
        boolean bl2;
        KtSourceElementKind ktSourceElementKind;
        KtSourceElement ktSourceElement = $this$hasActualModifier.getSource();
        KtSourceElementKind ktSourceElementKind2 = ktSourceElementKind = ktSourceElement != null ? ktSourceElement.getKind() : null;
        if (ktSourceElementKind == null) {
            bl2 = false;
        } else if (Intrinsics.areEqual((Object)ktSourceElementKind, (Object)KtFakeSourceElementKind.DataClassGeneratedMembers.INSTANCE)) {
            bl2 = false;
        } else if (Intrinsics.areEqual((Object)ktSourceElementKind, (Object)KtFakeSourceElementKind.EnumGeneratedDeclaration.INSTANCE)) {
            bl2 = false;
        } else if (Intrinsics.areEqual((Object)ktSourceElementKind, (Object)KtFakeSourceElementKind.ImplicitConstructor.INSTANCE)) {
            bl2 = false;
        } else {
            KtModifierKeywordToken ktModifierKeywordToken = KtTokens.ACTUAL_KEYWORD;
            Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken, (String)"ACTUAL_KEYWORD");
            bl2 = FirKeywordUtilsKt.hasModifier($this$hasActualModifier, ktModifierKeywordToken);
        }
        return bl2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isUnderlyingPropertyOfInlineClass(FirBasedSymbol<?> symbol, FirRegularClassSymbol actualContainingClass, FirSession platformSession) {
        FirClassLikeSymbol $this$isInlineOrValue$iv = actualContainingClass;
        boolean $i$f$isInlineOrValue = false;
        FirClassLikeSymbol $this$isInline$iv$iv = $this$isInlineOrValue$iv;
        boolean $i$f$isInline = false;
        if (!$this$isInline$iv$iv.getRawStatus().isInline()) {
            FirClassLikeSymbol $this$isValue$iv$iv = $this$isInlineOrValue$iv;
            boolean $i$f$isValue = false;
            if (!$this$isValue$iv$iv.getRawStatus().isValue()) return false;
        }
        boolean bl2 = true;
        if (!bl2) return false;
        if (!(symbol instanceof FirPropertySymbol)) return false;
        Object object = ksp.org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt.primaryConstructorIfAny(actualContainingClass, platformSession);
        if (!Intrinsics.areEqual((Object)(object != null && (object = ((FirFunctionSymbol)object).getValueParameterSymbols()) != null ? (FirValueParameterSymbol)CollectionsKt.singleOrNull((List)object) : null), (Object)DeclarationAttributesKt.getCorrespondingValueParameterFromPrimaryConstructor((FirPropertySymbol)symbol))) return false;
        return true;
    }

    private static final boolean checkExpectPropertyAccessorModifiers$isDefault(FirPropertyAccessor $this$checkExpectPropertyAccessorModifiers_u24isDefault) {
        KtSourceElement source = $this$checkExpectPropertyAccessorModifiers_u24isDefault.getSource();
        if (!(source != null)) {
            boolean bl2 = false;
            String string = "expect-actual matching is only possible for code with sources";
            throw new IllegalStateException(string.toString());
        }
        return Intrinsics.areEqual((Object)source.getKind(), (Object)KtFakeSourceElementKind.DefaultAccessor.INSTANCE);
    }

    private static final boolean reportClassScopesIncompatibility$hasSingleActualSuspect(MemberIncompatibility<? extends FirBasedSymbol<?>> incompatibility) {
        Map<ExpectActualMatchingCompatibility, List<FirBasedSymbol<?>>> map = ExpectActualAttributesKt.getExpectForActual(incompatibility.getActual().getFir());
        return Intrinsics.areEqual(map != null && (map = map.values()) != null && (map = (List)CollectionsKt.singleOrNull((Iterable)((Iterable)((Object)map)))) != null ? (FirBasedSymbol)CollectionsKt.singleOrNull((List)((Object)map)) : null, incompatibility.getExpect());
    }
}

