/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.backend.jvm.lower;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.backend.common.FileLoweringPass;
import ksp.org.jetbrains.kotlin.backend.common.phaser.PhaseDescription;
import ksp.org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import ksp.org.jetbrains.kotlin.backend.jvm.JvmIrAttributesKt;
import ksp.org.jetbrains.kotlin.backend.jvm.MultifileFacadesKt;
import ksp.org.jetbrains.kotlin.backend.jvm.ir.JvmIrInlineUtilsKt;
import ksp.org.jetbrains.kotlin.ir.IrElement;
import ksp.org.jetbrains.kotlin.ir.declarations.IrFile;
import ksp.org.jetbrains.kotlin.ir.declarations.IrFunction;
import ksp.org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import ksp.org.jetbrains.kotlin.ir.expressions.IrCall;
import ksp.org.jetbrains.kotlin.ir.expressions.IrExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.IrTypeOperator;
import ksp.org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import ksp.org.jetbrains.kotlin.ir.types.IrSimpleType;
import ksp.org.jetbrains.kotlin.ir.util.IrFakeOverrideUtilsKt;
import ksp.org.jetbrains.kotlin.ir.util.IrUtilsKt;
import ksp.org.jetbrains.kotlin.ir.visitors.IrVisitorVoid;

@PhaseDescription(name="ResolveInlineCalls")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u000e\u0010\u0013\u001a\u0004\u0018\u00010\u0014*\u00020\u0015H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0016"}, d2={"Lksp/org/jetbrains/kotlin/backend/jvm/lower/ResolveInlineCalls;", "Lksp/org/jetbrains/kotlin/ir/visitors/IrVisitorVoid;", "Lksp/org/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lksp/org/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "lower", "", "irFile", "Lksp/org/jetbrains/kotlin/ir/declarations/IrFile;", "visitElement", "element", "Lksp/org/jetbrains/kotlin/ir/IrElement;", "visitCall", "expression", "Lksp/org/jetbrains/kotlin/ir/expressions/IrCall;", "resolveMultiFileFacadeMember", "Lksp/org/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "Lksp/org/jetbrains/kotlin/ir/declarations/IrFunction;", "backend.jvm.lower"})
public final class ResolveInlineCalls
extends IrVisitorVoid
implements FileLoweringPass {
    @NotNull
    private final JvmBackendContext context;

    public ResolveInlineCalls(@NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        irFile.acceptChildren(this, null);
    }

    @Override
    public void visitElement(@NotNull IrElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        element2.acceptChildren(this, null);
    }

    @Override
    public void visitCall(@NotNull IrCall expression2) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            expression2.acceptChildren(this, null);
            if (!JvmIrInlineUtilsKt.isInlineFunctionCall(expression2.getSymbol().getOwner(), this.context)) {
                return;
            }
            IrSimpleFunction maybeFakeOverrideOfMultiFileBridge = (IrSimpleFunction)expression2.getSymbol().getOwner();
            IrSimpleFunction irSimpleFunction = this.resolveMultiFileFacadeMember(maybeFakeOverrideOfMultiFileBridge);
            if (irSimpleFunction == null && (irSimpleFunction = (IrSimpleFunction)IrFakeOverrideUtilsKt.resolveFakeOverride$default(maybeFakeOverrideOfMultiFileBridge, null, 1, null)) == null) {
                return;
            }
            IrSimpleFunction resolved = irSimpleFunction;
            expression2.setSymbol(resolved.getSymbol());
            IrExpression irExpression = expression2.getDispatchReceiver();
            if (irExpression == null) break block2;
            IrExpression receiver = irExpression;
            boolean bl2 = false;
            IrSimpleType receiverType = IrUtilsKt.getDefaultType(IrUtilsKt.getParentAsClass(resolved));
            expression2.setDispatchReceiver(BuildersKt.IrTypeOperatorCallImpl(receiver.getStartOffset(), receiver.getEndOffset(), receiverType, IrTypeOperator.IMPLICIT_CAST, receiverType, receiver));
        }
    }

    private final IrSimpleFunction resolveMultiFileFacadeMember(IrFunction $this$resolveMultiFileFacadeMember) {
        return MultifileFacadesKt.isMultifileBridge($this$resolveMultiFileFacadeMember) && $this$resolveMultiFileFacadeMember instanceof IrSimpleFunction ? JvmIrAttributesKt.getMultifileFacadePartMember((IrSimpleFunction)$this$resolveMultiFileFacadeMember) : null;
    }
}

