/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.psi.presentation.java;

import javax.swing.Icon;
import ksp.com.intellij.core.JavaPsiBundle;
import ksp.com.intellij.navigation.ColoredItemPresentation;
import ksp.com.intellij.navigation.ItemPresentation;
import ksp.com.intellij.navigation.ItemPresentationProvider;
import ksp.com.intellij.openapi.editor.colors.CodeInsightColors;
import ksp.com.intellij.openapi.editor.colors.TextAttributesKey;
import ksp.com.intellij.openapi.project.IndexNotReadyException;
import ksp.com.intellij.pom.java.LanguageLevel;
import ksp.com.intellij.psi.PsiClass;
import ksp.com.intellij.psi.PsiClassOwner;
import ksp.com.intellij.psi.PsiFile;
import ksp.com.intellij.psi.presentation.java.ClassPresentationUtil;
import ksp.com.intellij.psi.util.JavaMultiReleaseUtil;
import ksp.com.intellij.ui.NewUiValue;
import ksp.org.jetbrains.annotations.NotNull;

public final class ClassPresentationProvider
implements ItemPresentationProvider<PsiClass> {
    @Override
    public ItemPresentation getPresentation(final @NotNull PsiClass psiClass) {
        if (psiClass == null) {
            ClassPresentationProvider.$$$reportNull$$$0(0);
        }
        return new ColoredItemPresentation(){

            @Override
            public String getPresentableText() {
                return ClassPresentationUtil.getNameForClass(psiClass, false);
            }

            @Override
            public String getLocationString() {
                PsiFile file = psiClass.getContainingFile();
                if (file instanceof PsiClassOwner) {
                    PsiClassOwner classOwner = (PsiClassOwner)file;
                    String packageName2 = classOwner.getPackageName();
                    if (packageName2.isEmpty()) {
                        return null;
                    }
                    LanguageLevel version = JavaMultiReleaseUtil.getVersion(file);
                    if (version != null) {
                        packageName2 = packageName2 + "/" + JavaPsiBundle.message("class.file.version", version.feature());
                    }
                    return NewUiValue.isEnabled() ? JavaPsiBundle.message("aux.context.display", packageName2) : "(" + packageName2 + ")";
                }
                return null;
            }

            @Override
            public TextAttributesKey getTextAttributesKey() {
                try {
                    if (psiClass.isDeprecated()) {
                        return CodeInsightColors.DEPRECATED_ATTRIBUTES;
                    }
                }
                catch (IndexNotReadyException indexNotReadyException) {
                    // empty catch block
                }
                return null;
            }

            @Override
            public Icon getIcon(boolean open) {
                return psiClass.getIcon(3);
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "ksp/com/intellij/psi/presentation/java/ClassPresentationProvider", "getPresentation"));
    }
}

