/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.ir.util;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.descriptors.InlineClassRepresentation;
import ksp.org.jetbrains.kotlin.ir.declarations.IrClass;
import ksp.org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import ksp.org.jetbrains.kotlin.ir.declarations.IrDeclarationsKt;
import ksp.org.jetbrains.kotlin.ir.declarations.IrField;
import ksp.org.jetbrains.kotlin.ir.declarations.IrProperty;
import ksp.org.jetbrains.kotlin.ir.types.IrSimpleType;
import ksp.org.jetbrains.kotlin.ir.util.IrUtilsKt;
import ksp.org.jetbrains.kotlin.ir.util.RenderIrElementKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\u0006"}, d2={"getInlineClassUnderlyingType", "Lksp/org/jetbrains/kotlin/ir/types/IrSimpleType;", "irClass", "Lksp/org/jetbrains/kotlin/ir/declarations/IrClass;", "getInlineClassBackingField", "Lksp/org/jetbrains/kotlin/ir/declarations/IrField;", "ir.tree"})
public final class InlineClassesKt {
    @NotNull
    public static final IrSimpleType getInlineClassUnderlyingType(@NotNull IrClass irClass) {
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        InlineClassRepresentation<IrSimpleType> inlineClassRepresentation = IrDeclarationsKt.getInlineClassRepresentation(irClass);
        if (inlineClassRepresentation == null) {
            throw new IllegalStateException(("Not an inline class: " + RenderIrElementKt.render$default(irClass, null, 1, null)).toString());
        }
        InlineClassRepresentation<IrSimpleType> representation = inlineClassRepresentation;
        return representation.getUnderlyingType();
    }

    @NotNull
    public static final IrField getInlineClassBackingField(@NotNull IrClass irClass) {
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        for (IrDeclaration declaration2 : irClass.getDeclarations()) {
            IrField backingField;
            if (declaration2 instanceof IrField && !((IrField)declaration2).isStatic()) {
                return (IrField)declaration2;
            }
            if (!(declaration2 instanceof IrProperty) || (backingField = ((IrProperty)declaration2).getBackingField()) == null || backingField.isStatic()) continue;
            return backingField;
        }
        throw new IllegalStateException(("Inline class has no field: " + IrUtilsKt.getFqNameWhenAvailable(irClass)).toString());
    }
}

