/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.resolve.calls.stages;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import ksp.org.jetbrains.kotlin.fir.expressions.FirExpression;
import ksp.org.jetbrains.kotlin.fir.resolve.calls.LowerPriorityForDynamic;
import ksp.org.jetbrains.kotlin.fir.resolve.calls.ResolutionContext;
import ksp.org.jetbrains.kotlin.fir.resolve.calls.candidate.Candidate;
import ksp.org.jetbrains.kotlin.fir.resolve.calls.candidate.CheckerSink;
import ksp.org.jetbrains.kotlin.fir.resolve.calls.stages.ResolutionStage;
import ksp.org.jetbrains.kotlin.fir.types.ConeDynamicType;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0096@R\u00020\u0006R\u00020\bj\u0006\u0010\u0007\u001a\u00020\u0006j\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\f\u00a8\u0006\r"}, d2={"Lksp/org/jetbrains/kotlin/fir/resolve/calls/stages/LowerPriorityIfDynamic;", "Lksp/org/jetbrains/kotlin/fir/resolve/calls/stages/ResolutionStage;", "<init>", "()V", "check", "", "Lksp/org/jetbrains/kotlin/fir/resolve/calls/candidate/CheckerSink;", "sink", "Lksp/org/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;", "context", "candidate", "Lksp/org/jetbrains/kotlin/fir/resolve/calls/candidate/Candidate;", "(Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/CheckerSink;Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/Candidate;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "resolve"})
public final class LowerPriorityIfDynamic
extends ResolutionStage {
    @NotNull
    public static final LowerPriorityIfDynamic INSTANCE = new LowerPriorityIfDynamic();

    private LowerPriorityIfDynamic() {
    }

    @Override
    @Nullable
    public Object check(@NotNull CheckerSink sink, @NotNull ResolutionContext context2, @NotNull Candidate candidate, @NotNull Continuation<? super Unit> $completion) {
        if (candidate.getSymbol().getOrigin() instanceof FirDeclarationOrigin.DynamicScope) {
            candidate.addDiagnostic(LowerPriorityForDynamic.INSTANCE);
        } else if (candidate.getCallInfo().isImplicitInvoke()) {
            FirExpression firExpression = candidate.getCallInfo().getExplicitReceiver();
            if ((firExpression != null ? FirTypeUtilsKt.getResolvedType(firExpression) : null) instanceof ConeDynamicType) {
                candidate.addDiagnostic(LowerPriorityForDynamic.INSTANCE);
            }
        }
        return Unit.INSTANCE;
    }
}

