/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.wasm.checkers;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.fir.declarations.FirProperty;
import ksp.org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import ksp.org.jetbrains.kotlin.fir.expressions.FirBlock;
import ksp.org.jetbrains.kotlin.fir.expressions.FirExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import ksp.org.jetbrains.kotlin.fir.expressions.FirReturnExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirStatement;
import ksp.org.jetbrains.kotlin.fir.expressions.impl.FirSingleExpressionBlock;
import ksp.org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import ksp.org.jetbrains.kotlin.name.WebCommonStandardClassIds;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0003\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0004\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0005\u001a\f\u0010\u0006\u001a\u00020\u0001*\u00020\u0007H\u0002\u001a\f\u0010\b\u001a\u00020\u0001*\u00020\tH\u0002\u00a8\u0006\n"}, d2={"hasValidJsCodeBody", "", "Lksp/org/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "Lksp/org/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "Lksp/org/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "Lksp/org/jetbrains/kotlin/fir/declarations/FirProperty;", "isValidJsCodeBody", "Lksp/org/jetbrains/kotlin/fir/expressions/FirBlock;", "isJsCodeCall", "Lksp/org/jetbrains/kotlin/fir/expressions/FirExpression;", "checkers.wasm"})
public final class FirWasmJsCodeHelpersKt {
    public static final boolean hasValidJsCodeBody(@NotNull FirNamedFunctionSymbol $this$hasValidJsCodeBody) {
        Intrinsics.checkNotNullParameter((Object)$this$hasValidJsCodeBody, (String)"<this>");
        return FirWasmJsCodeHelpersKt.hasValidJsCodeBody((FirSimpleFunction)$this$hasValidJsCodeBody.getFir());
    }

    public static final boolean hasValidJsCodeBody(@NotNull FirSimpleFunction $this$hasValidJsCodeBody) {
        Intrinsics.checkNotNullParameter((Object)$this$hasValidJsCodeBody, (String)"<this>");
        FirBlock firBlock = $this$hasValidJsCodeBody.getBody();
        return firBlock != null ? FirWasmJsCodeHelpersKt.isValidJsCodeBody(firBlock) : false;
    }

    public static final boolean hasValidJsCodeBody(@NotNull FirPropertySymbol $this$hasValidJsCodeBody) {
        Intrinsics.checkNotNullParameter((Object)$this$hasValidJsCodeBody, (String)"<this>");
        return FirWasmJsCodeHelpersKt.hasValidJsCodeBody((FirProperty)$this$hasValidJsCodeBody.getFir());
    }

    public static final boolean hasValidJsCodeBody(@NotNull FirProperty $this$hasValidJsCodeBody) {
        Intrinsics.checkNotNullParameter((Object)$this$hasValidJsCodeBody, (String)"<this>");
        FirExpression firExpression = $this$hasValidJsCodeBody.getInitializer();
        return firExpression != null ? FirWasmJsCodeHelpersKt.isJsCodeCall(firExpression) : false;
    }

    private static final boolean isValidJsCodeBody(FirBlock $this$isValidJsCodeBody) {
        FirStatement firStatement = (FirStatement)CollectionsKt.singleOrNull($this$isValidJsCodeBody.getStatements());
        if (firStatement == null) {
            return false;
        }
        FirStatement singleStatement = firStatement;
        return singleStatement instanceof FirFunctionCall ? FirWasmJsCodeHelpersKt.isJsCodeCall((FirExpression)singleStatement) : (singleStatement instanceof FirReturnExpression && $this$isValidJsCodeBody instanceof FirSingleExpressionBlock ? FirWasmJsCodeHelpersKt.isJsCodeCall(((FirReturnExpression)singleStatement).getResult()) : false);
    }

    private static final boolean isJsCodeCall(FirExpression $this$isJsCodeCall) {
        if (!($this$isJsCodeCall instanceof FirFunctionCall)) {
            return false;
        }
        FirCallableSymbol firCallableSymbol = FirReferenceUtilsKt.toResolvedCallableSymbol$default(((FirFunctionCall)$this$isJsCodeCall).getCalleeReference(), false, 1, null);
        if (firCallableSymbol == null) {
            return false;
        }
        FirCallableSymbol symbol = firCallableSymbol;
        return Intrinsics.areEqual((Object)symbol.getCallableId(), (Object)WebCommonStandardClassIds.Callables.Js);
    }
}

