/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.FirModuleData;
import ksp.org.jetbrains.kotlin.fir.FirPackageDirective;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import ksp.org.jetbrains.kotlin.fir.declarations.FirFile;
import ksp.org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderKt;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import ksp.org.jetbrains.kotlin.name.ClassId;
import ksp.org.jetbrains.kotlin.name.FqName;
import ksp.org.jetbrains.kotlin.name.FqNamesUtilKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002J\u0012\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014*\u00020\u0015H\u0002\u00a8\u0006\u0016"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirPackageConflictsWithClassifierChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lksp/org/jetbrains/kotlin/fir/declarations/FirFile;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirFileChecker;", "<init>", "()V", "check", "", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirFile;)V", "areDependentMultiplatformModules", "", "module1", "Lksp/org/jetbrains/kotlin/fir/FirModuleData;", "module2", "parentsIncludingSelf", "Lkotlin/sequences/Sequence;", "Lksp/org/jetbrains/kotlin/name/FqName;", "checkers"})
public final class FirPackageConflictsWithClassifierChecker
extends FirDeclarationChecker<FirFile> {
    @NotNull
    public static final FirPackageConflictsWithClassifierChecker INSTANCE = new FirPackageConflictsWithClassifierChecker();

    private FirPackageConflictsWithClassifierChecker() {
        super(MppCheckerKind.Platform);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirFile declaration2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        FirPackageDirective packageDirective = declaration2.getPackageDirective();
        FqName filePackageFqName = packageDirective.getPackageFqName();
        for (FqName currentPackageFqName : this.parentsIncludingSelf(filePackageFqName)) {
            FirClassLikeSymbol<?> symbol;
            if (currentPackageFqName.isRoot()) continue;
            ClassId classId = new ClassId(currentPackageFqName.parent(), currentPackageFqName.shortName());
            if (FirSymbolProviderKt.getSymbolProvider(context2.getSession()).getClassLikeSymbolByClassId(classId) == null || !(symbol.getOrigin() instanceof FirDeclarationOrigin.Source) || !Intrinsics.areEqual((Object)symbol.getModuleData(), (Object)declaration2.getModuleData()) && !this.areDependentMultiplatformModules(symbol.getModuleData(), declaration2.getModuleData())) continue;
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)packageDirective.getSource(), FirErrors.INSTANCE.getPACKAGE_CONFLICTS_WITH_CLASSIFIER(), (Object)classId, null, 16, null);
        }
    }

    private final boolean areDependentMultiplatformModules(FirModuleData module1, FirModuleData module2) {
        return module2.getAllDependsOnDependencies().contains(module1) || module1.getAllDependsOnDependencies().contains(module2);
    }

    private final Sequence<FqName> parentsIncludingSelf(FqName $this$parentsIncludingSelf) {
        return SequencesKt.generateSequence((Object)$this$parentsIncludingSelf, FirPackageConflictsWithClassifierChecker::parentsIncludingSelf$lambda$0);
    }

    private static final FqName parentsIncludingSelf$lambda$0(FqName it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return FqNamesUtilKt.parentOrNull(it);
    }
}

