/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.psi.search;

import java.util.Set;
import ksp.com.intellij.openapi.module.Module;
import ksp.com.intellij.openapi.project.Project;
import ksp.com.intellij.openapi.roots.PackageIndex;
import ksp.com.intellij.openapi.vfs.VfsUtilCore;
import ksp.com.intellij.openapi.vfs.VirtualFile;
import ksp.com.intellij.psi.JavaPsiFacade;
import ksp.com.intellij.psi.PsiClassOwner;
import ksp.com.intellij.psi.PsiFile;
import ksp.com.intellij.psi.PsiPackage;
import ksp.com.intellij.psi.search.GlobalSearchScope;
import ksp.com.intellij.util.Query;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

public class PackageScope
extends GlobalSearchScope {
    private final Set<VirtualFile> myDirs;
    private final PsiPackage myPackage;
    private final boolean myIncludeSubpackages;
    private final boolean myIncludeLibraries;
    private final boolean myPartOfPackagePrefix;
    private final String myPackageQualifiedName;
    private final String myPackageQNamePrefix;

    public PackageScope(@NotNull PsiPackage aPackage, boolean includeSubpackages, boolean includeLibraries) {
        if (aPackage == null) {
            PackageScope.$$$reportNull$$$0(0);
        }
        this(aPackage, includeSubpackages, includeLibraries, null);
    }

    private PackageScope(@NotNull PsiPackage aPackage, boolean includeSubpackages, boolean includeLibraries, @Nullable GlobalSearchScope packageScope) {
        if (aPackage == null) {
            PackageScope.$$$reportNull$$$0(1);
        }
        super(aPackage.getProject());
        this.myPackage = aPackage;
        this.myIncludeSubpackages = includeSubpackages;
        Project project = this.myPackage.getProject();
        this.myPackageQualifiedName = this.myPackage.getQualifiedName();
        PackageIndex packageIndex = PackageIndex.getInstance(project);
        Query<VirtualFile> dirs = packageScope != null ? packageIndex.getDirsByPackageName(this.myPackageQualifiedName, packageScope) : packageIndex.getDirsByPackageName(this.myPackageQualifiedName, true);
        this.myDirs = VfsUtilCore.createCompactVirtualFileSet();
        dirs.forEach(e2 -> {
            this.myDirs.add((VirtualFile)e2);
            return true;
        });
        this.myIncludeLibraries = includeLibraries;
        this.myPartOfPackagePrefix = JavaPsiFacade.getInstance(project).isPartOfPackagePrefix(this.myPackageQualifiedName);
        this.myPackageQNamePrefix = this.myPackageQualifiedName + ".";
    }

    @Override
    public boolean contains(@NotNull VirtualFile file) {
        String packageName2;
        PsiFile psiFile;
        VirtualFile dir;
        if (file == null) {
            PackageScope.$$$reportNull$$$0(2);
        }
        VirtualFile virtualFile = dir = file.isDirectory() ? file : file.getParent();
        if (!this.myIncludeSubpackages) {
            if (this.myDirs.contains(dir)) {
                return true;
            }
        } else {
            while (dir != null) {
                if (this.myDirs.contains(dir)) {
                    return true;
                }
                dir = dir.getParent();
            }
        }
        return this.myPartOfPackagePrefix && this.myIncludeSubpackages && (psiFile = this.myPackage.getManager().findFile(file)) instanceof PsiClassOwner && (this.myPackageQualifiedName.equals(packageName2 = ((PsiClassOwner)psiFile).getPackageName()) || packageName2.startsWith(this.myPackageQNamePrefix));
    }

    @Override
    public boolean isSearchInModuleContent(@NotNull Module aModule) {
        if (aModule == null) {
            PackageScope.$$$reportNull$$$0(3);
        }
        return true;
    }

    @Override
    public boolean isSearchInLibraries() {
        return this.myIncludeLibraries;
    }

    public String toString() {
        return "package scope: " + this.myPackage + ", includeSubpackages = " + this.myIncludeSubpackages;
    }

    @NotNull
    public static GlobalSearchScope packageScope(@NotNull PsiPackage aPackage, boolean includeSubpackages) {
        if (aPackage == null) {
            PackageScope.$$$reportNull$$$0(4);
        }
        return new PackageScope(aPackage, includeSubpackages, true);
    }

    @NotNull
    public static GlobalSearchScope packageScope(@NotNull PsiPackage aPackage, boolean includeSubpackages, @NotNull GlobalSearchScope packageScope) {
        if (aPackage == null) {
            PackageScope.$$$reportNull$$$0(5);
        }
        if (packageScope == null) {
            PackageScope.$$$reportNull$$$0(6);
        }
        return new PackageScope(aPackage, includeSubpackages, true, packageScope);
    }

    @NotNull
    public static GlobalSearchScope packageScopeWithoutLibraries(@NotNull PsiPackage aPackage, boolean includeSubpackages) {
        if (aPackage == null) {
            PackageScope.$$$reportNull$$$0(7);
        }
        return new PackageScope(aPackage, includeSubpackages, false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aPackage";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aModule";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageScope";
                break;
            }
        }
        objectArray2[1] = "ksp/com/intellij/psi/search/PackageScope";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "contains";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isSearchInModuleContent";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "packageScope";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "packageScopeWithoutLibraries";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

